/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.hooks;

import com.google.common.collect.Iterables;
import graphmodel.IdentifiableElement;
import info.scce.dime.api.DIMEPostCreateHook;
import info.scce.dime.data.data.Inheritance;
import info.scce.dime.data.data.InheritorType;
import info.scce.dime.data.data.Type;
import info.scce.dime.process.process.CreateSIB;
import info.scce.dime.process.process.CreateUserSIB;
import info.scce.dime.process.process.DataFlowTarget;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.PrimitiveType;
import info.scce.dime.process.process.RetrieveOfTypeSIB;
import info.scce.dime.process.process.SIB;
import info.scce.dime.process.process.TransientCreateSIB;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.jooq.lambda.Seq;

@SuppressWarnings("all")
public abstract class AbstractAttributePortHook<T extends IdentifiableElement> extends DIMEPostCreateHook<T> {
  public EList<Input> getInputs(final SIB sib) {
    return ((DataFlowTarget) sib).getInputs();
  }
  
  public Type getType(final SIB sib) {
    Type _switchResult = null;
    final SIB it = sib;
    boolean _matched = false;
    if (it instanceof CreateSIB) {
      _matched=true;
      _switchResult = ((CreateSIB)it).getCreatedType();
    }
    if (!_matched) {
      if (it instanceof TransientCreateSIB) {
        _matched=true;
        _switchResult = ((TransientCreateSIB)it).getCreatedType();
      }
    }
    if (!_matched) {
      if (it instanceof CreateUserSIB) {
        _matched=true;
        _switchResult = ((CreateUserSIB)it).getCreatedType();
      }
    }
    if (!_matched) {
      if (it instanceof RetrieveOfTypeSIB) {
        _matched=true;
        _switchResult = ((RetrieveOfTypeSIB)it).getRetrievedType();
      }
    }
    return _switchResult;
  }
  
  public Iterable<Type> getTypeHierarchy(final SIB sib) {
    Iterable<Type> _xblockexpression = null;
    {
      final Type type = this.getType(sib);
      Iterable<Type> _xifexpression = null;
      boolean _notEquals = this._gUIExtension.operator_notEquals(type, null);
      if (_notEquals) {
        Seq<Type> _superTypes = this._dataExtension.getSuperTypes(type);
        _xifexpression = Iterables.<Type>concat(Collections.<Type>unmodifiableList(CollectionLiterals.<Type>newArrayList(type)), _superTypes);
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  public Iterable<Type> getSuperTypes(final Type type, final Set<Type> collection) {
    Iterable<Type> _switchResult = null;
    final Type it = type;
    boolean _matched = false;
    if (it instanceof InheritorType) {
      _matched=true;
      final Function1<Type, Iterable<Type>> _function = new Function1<Type, Iterable<Type>>() {
        @Override
        public Iterable<Type> apply(final Type it) {
          Seq<Type> _superTypes = AbstractAttributePortHook.this._dataExtension.getSuperTypes(it);
          return Iterables.<Type>concat(Collections.<Type>unmodifiableList(CollectionLiterals.<Type>newArrayList(it)), _superTypes);
        }
      };
      _switchResult = Iterables.<Type>concat(IterableExtensions.<Type, Iterable<Type>>map(Iterables.<Type>filter(this._gUIExtension.<Inheritance>findTargetsOf(it, Inheritance.class), Type.class), _function));
    }
    if (!_matched) {
      _switchResult = Collections.<Type>unmodifiableList(CollectionLiterals.<Type>newArrayList());
    }
    return _switchResult;
  }
  
  public boolean isTypeSIB(final SIB sib) {
    boolean _switchResult = false;
    final SIB it = sib;
    boolean _matched = false;
    if (it instanceof CreateSIB) {
      _matched=true;
    }
    if (!_matched) {
      if (it instanceof TransientCreateSIB) {
        _matched=true;
      }
    }
    if (!_matched) {
      if (it instanceof CreateUserSIB) {
        _matched=true;
      }
    }
    if (!_matched) {
      if (it instanceof RetrieveOfTypeSIB) {
        _matched=true;
      }
    }
    if (_matched) {
      _switchResult = true;
    }
    if (!_matched) {
      _switchResult = false;
    }
    return _switchResult;
  }
  
  public PrimitiveType toProcessPrimitive(final info.scce.dime.data.data.PrimitiveType type) {
    PrimitiveType _switchResult = null;
    if (type != null) {
      switch (type) {
        case BOOLEAN:
          _switchResult = PrimitiveType.BOOLEAN;
          break;
        case INTEGER:
          _switchResult = PrimitiveType.INTEGER;
          break;
        case REAL:
          _switchResult = PrimitiveType.REAL;
          break;
        case TEXT:
          _switchResult = PrimitiveType.TEXT;
          break;
        case TIMESTAMP:
          _switchResult = PrimitiveType.TIMESTAMP;
          break;
        case FILE:
          _switchResult = PrimitiveType.FILE;
          break;
        default:
          throw new IllegalStateException("Reached else/default case in exhaustive if/switch. Please fix the code.");
      }
    } else {
      throw new IllegalStateException("Reached else/default case in exhaustive if/switch. Please fix the code.");
    }
    return _switchResult;
  }
  
  public void showError(final String title, final String body) {
    this._workbenchExtension.showErrorDialog(title, body);
  }
}
