/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.helper;

import info.scce.dime.dad.dad.ProcessComponent;
import info.scce.dime.dad.dad.ProcessEntryPointComponent;
import info.scce.dime.dad.dad.URLProcess;
import info.scce.dime.process.process.AtomicSIB;
import info.scce.dime.process.process.ContainsSIB;
import info.scce.dime.process.process.CreateSIB;
import info.scce.dime.process.process.CreateUserSIB;
import info.scce.dime.process.process.EntryPointProcessSIB;
import info.scce.dime.process.process.EnumSwitchSIB;
import info.scce.dime.process.process.GUISIB;
import info.scce.dime.process.process.GenericSIB;
import info.scce.dime.process.process.GuardProcessSIB;
import info.scce.dime.process.process.GuardedProcessSIB;
import info.scce.dime.process.process.IterateSIB;
import info.scce.dime.process.process.LinkProcessSIB;
import info.scce.dime.process.process.NativeFrontendSIBReference;
import info.scce.dime.process.process.ProcessSIB;
import info.scce.dime.process.process.PutComplexToContextSIB;
import info.scce.dime.process.process.RetrieveEnumLiteralSIB;
import info.scce.dime.process.process.RetrieveOfTypeSIB;
import info.scce.dime.process.process.SIB;
import info.scce.dime.process.process.SetAttributeValueSIB;
import info.scce.dime.process.process.TransientCreateSIB;
import info.scce.dime.process.process.UnsetAttributeValueSIB;
import org.eclipse.emf.ecore.EObject;

@SuppressWarnings("all")
public class SIBUtils {
  public static info.scce.dime.process.process.Process model(final URLProcess it) {
    info.scce.dime.process.process.Process _switchResult = null;
    boolean _matched = false;
    if (it instanceof ProcessComponent) {
      _matched=true;
      _switchResult = ((ProcessComponent)it).getModel();
    }
    if (!_matched) {
      if (it instanceof ProcessEntryPointComponent) {
        _matched=true;
        _switchResult = ((ProcessEntryPointComponent)it).getEntryPoint().getRootElement();
      }
    }
    return _switchResult;
  }
  
  public static EObject getReferencedComponent(final SIB it) {
    EObject _switchResult = null;
    boolean _matched = false;
    if (it instanceof AtomicSIB) {
      _matched=true;
      _switchResult = ((AtomicSIB)it).getSib();
    }
    if (!_matched) {
      if (it instanceof EntryPointProcessSIB) {
        _matched=true;
        _switchResult = ((EntryPointProcessSIB)it).getProMod();
      }
    }
    if (!_matched) {
      if (it instanceof LinkProcessSIB) {
        _matched=true;
        URLProcess _proMod = ((LinkProcessSIB)it).getProMod();
        _switchResult = SIBUtils.model(((URLProcess) _proMod));
      }
    }
    if (!_matched) {
      if (it instanceof ProcessSIB) {
        _matched=true;
        _switchResult = ((ProcessSIB)it).getProMod();
      }
    }
    if (!_matched) {
      if (it instanceof GuardedProcessSIB) {
        _matched=true;
        _switchResult = ((GuardedProcessSIB)it).getProMod();
      }
    }
    if (!_matched) {
      if (it instanceof GuardProcessSIB) {
        _matched=true;
        _switchResult = ((GuardProcessSIB)it).getSecurityProcess();
      }
    }
    if (!_matched) {
      if (it instanceof CreateSIB) {
        _matched=true;
        _switchResult = ((CreateSIB)it).getCreatedType();
      }
    }
    if (!_matched) {
      if (it instanceof TransientCreateSIB) {
        _matched=true;
        _switchResult = ((TransientCreateSIB)it).getCreatedType();
      }
    }
    if (!_matched) {
      if (it instanceof CreateUserSIB) {
        _matched=true;
        _switchResult = ((CreateUserSIB)it).getCreatedType();
      }
    }
    if (!_matched) {
      if (it instanceof SetAttributeValueSIB) {
        _matched=true;
        _switchResult = ((SetAttributeValueSIB)it).getAttribute();
      }
    }
    if (!_matched) {
      if (it instanceof UnsetAttributeValueSIB) {
        _matched=true;
        _switchResult = ((UnsetAttributeValueSIB)it).getAttribute();
      }
    }
    if (!_matched) {
      if (it instanceof ContainsSIB) {
        _matched=true;
        _switchResult = ((ContainsSIB)it).getListType();
      }
    }
    if (!_matched) {
      if (it instanceof IterateSIB) {
        _matched=true;
        _switchResult = ((IterateSIB)it).getIteratedType();
      }
    }
    if (!_matched) {
      if (it instanceof PutComplexToContextSIB) {
        _matched=true;
        _switchResult = ((PutComplexToContextSIB)it).getPutType();
      }
    }
    if (!_matched) {
      if (it instanceof RetrieveOfTypeSIB) {
        _matched=true;
        _switchResult = ((RetrieveOfTypeSIB)it).getRetrievedType();
      }
    }
    if (!_matched) {
      if (it instanceof EnumSwitchSIB) {
        _matched=true;
        _switchResult = ((EnumSwitchSIB)it).getSwitchedType();
      }
    }
    if (!_matched) {
      if (it instanceof RetrieveEnumLiteralSIB) {
        _matched=true;
        _switchResult = ((RetrieveEnumLiteralSIB)it).getRetrievedLiteral();
      }
    }
    if (!_matched) {
      if (it instanceof NativeFrontendSIBReference) {
        _matched=true;
        _switchResult = ((NativeFrontendSIBReference)it).getReferencedSib();
      }
    }
    if (!_matched) {
      if (it instanceof GUISIB) {
        _matched=true;
        _switchResult = ((GUISIB)it).getGui();
      }
    }
    if (!_matched) {
      if (it instanceof GenericSIB) {
        _matched=true;
        _switchResult = ((GenericSIB)it).getReferencedObject();
      }
    }
    return _switchResult;
  }
}
