/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.helper;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.runtime.active.Memoizable;
import de.jabc.cinco.meta.runtime.xapi.CollectionExtension;
import de.jabc.cinco.meta.runtime.xapi.GraphModelExtension;
import graphmodel.Container;
import graphmodel.GraphModel;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElementContainer;
import graphmodel.Node;
import info.scce.dime.dad.dad.DataComponent;
import info.scce.dime.dad.dad.FindLoginUserComponent;
import info.scce.dime.dad.dad.LoginComponent;
import info.scce.dime.dad.dad.ProcessComponent;
import info.scce.dime.data.data.Type;
import info.scce.dime.data.helper.DataExtension;
import info.scce.dime.gui.gui.GuardSIB;
import info.scce.dime.gui.gui.SecuritySIB;
import info.scce.dime.process.process.AbstractBranch;
import info.scce.dime.process.process.AbstractIterateSIB;
import info.scce.dime.process.process.Attribute;
import info.scce.dime.process.process.BooleanInputStatic;
import info.scce.dime.process.process.BranchConnector;
import info.scce.dime.process.process.ComplexAttribute;
import info.scce.dime.process.process.ComplexAttributeConnector;
import info.scce.dime.process.process.ComplexDirectDataFlow;
import info.scce.dime.process.process.ComplexExtensionAttribute;
import info.scce.dime.process.process.ComplexInputPort;
import info.scce.dime.process.process.ComplexListAttribute;
import info.scce.dime.process.process.ComplexOutputPort;
import info.scce.dime.process.process.ComplexVariable;
import info.scce.dime.process.process.DataContext;
import info.scce.dime.process.process.DataFlow;
import info.scce.dime.process.process.DataFlowTarget;
import info.scce.dime.process.process.DirectDataFlow;
import info.scce.dime.process.process.EndSIB;
import info.scce.dime.process.process.EntryPointProcessSIB;
import info.scce.dime.process.process.EventListener;
import info.scce.dime.process.process.ExtensionAttribute;
import info.scce.dime.process.process.GUIBlueprintSIB;
import info.scce.dime.process.process.GUISIB;
import info.scce.dime.process.process.GUISIBOptions;
import info.scce.dime.process.process.GenericSIB;
import info.scce.dime.process.process.GuardContainer;
import info.scce.dime.process.process.GuardProcessSIB;
import info.scce.dime.process.process.GuardedProcessSIB;
import info.scce.dime.process.process.IgnoreBranch;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.InputPort;
import info.scce.dime.process.process.InputStatic;
import info.scce.dime.process.process.IntegerInputStatic;
import info.scce.dime.process.process.JavaNativeInputPort;
import info.scce.dime.process.process.JavaNativeOutputPort;
import info.scce.dime.process.process.JavaNativeVariable;
import info.scce.dime.process.process.OutputPort;
import info.scce.dime.process.process.PrimitiveAttribute;
import info.scce.dime.process.process.PrimitiveDirectDataFlow;
import info.scce.dime.process.process.PrimitiveExtensionAttribute;
import info.scce.dime.process.process.PrimitiveInputPort;
import info.scce.dime.process.process.PrimitiveListAttribute;
import info.scce.dime.process.process.PrimitiveOutputPort;
import info.scce.dime.process.process.PrimitiveType;
import info.scce.dime.process.process.PrimitiveVariable;
import info.scce.dime.process.process.ProcessInputStatic;
import info.scce.dime.process.process.ProcessPlaceholderSIB;
import info.scce.dime.process.process.ProcessSIB;
import info.scce.dime.process.process.ProcessType;
import info.scce.dime.process.process.Read;
import info.scce.dime.process.process.RealInputStatic;
import info.scce.dime.process.process.SIB;
import info.scce.dime.process.process.StartSIB;
import info.scce.dime.process.process.TextInputStatic;
import info.scce.dime.process.process.TimestampInputStatic;
import info.scce.dime.process.process.Update;
import info.scce.dime.process.process.Variable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function0;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class ProcessExtension {
  public static class SwitchException extends IllegalStateException {
    public SwitchException() {
      super("Default case in exhaustive switch; implementation broken?");
    }
    
    public SwitchException(final Object obj) {
      super(new Function0<String>() {
        @Override
        public String apply() {
          Class<?> _class = null;
          if (obj!=null) {
            _class=obj.getClass();
          }
          String _simpleName = null;
          if (_class!=null) {
            _simpleName=_class.getSimpleName();
          }
          String _plus = ("Default case in exhaustive switch for " + _simpleName);
          String _plus_1 = (_plus + "; implementation broken?");
          return _plus_1;
        }
      }.apply());
    }
  }
  
  @Extension
  private CollectionExtension _collectionExtension = new CollectionExtension();
  
  @Extension
  private DataExtension _dataExtension = DataExtension.getInstance();
  
  public static final HashMap<PrimitiveType, info.scce.dime.data.data.PrimitiveType> DATA_PRIMITIVE_TYPE = CollectionLiterals.<PrimitiveType, info.scce.dime.data.data.PrimitiveType>newHashMap(
    Pair.<PrimitiveType, info.scce.dime.data.data.PrimitiveType>of(PrimitiveType.BOOLEAN, info.scce.dime.data.data.PrimitiveType.BOOLEAN), 
    Pair.<PrimitiveType, info.scce.dime.data.data.PrimitiveType>of(PrimitiveType.FILE, info.scce.dime.data.data.PrimitiveType.FILE), 
    Pair.<PrimitiveType, info.scce.dime.data.data.PrimitiveType>of(PrimitiveType.INTEGER, info.scce.dime.data.data.PrimitiveType.INTEGER), 
    Pair.<PrimitiveType, info.scce.dime.data.data.PrimitiveType>of(PrimitiveType.REAL, info.scce.dime.data.data.PrimitiveType.REAL), 
    Pair.<PrimitiveType, info.scce.dime.data.data.PrimitiveType>of(PrimitiveType.TEXT, info.scce.dime.data.data.PrimitiveType.TEXT), 
    Pair.<PrimitiveType, info.scce.dime.data.data.PrimitiveType>of(PrimitiveType.TIMESTAMP, info.scce.dime.data.data.PrimitiveType.TIMESTAMP));
  
  private final Function1<IdentifiableElement, GraphModel> followPrimeRefs = new Function1<IdentifiableElement, GraphModel>() {
    @Override
    public GraphModel apply(final IdentifiableElement elm) {
      GraphModel _switchResult = null;
      final IdentifiableElement it = elm;
      boolean _matched = false;
      if (it instanceof GUISIB) {
        _matched=true;
        _switchResult = ((GUISIB)it).getGui();
      }
      if (!_matched) {
        if (it instanceof ProcessSIB) {
          _matched=true;
          _switchResult = ((ProcessSIB)it).getProMod();
        }
      }
      if (!_matched) {
        if (it instanceof GuardedProcessSIB) {
          _matched=true;
          _switchResult = ((GuardedProcessSIB)it).getProMod();
        }
      }
      if (!_matched) {
        if (it instanceof GuardProcessSIB) {
          _matched=true;
          _switchResult = ((GuardProcessSIB)it).getSecurityProcess();
        }
      }
      if (!_matched) {
        if (it instanceof info.scce.dime.gui.gui.GUISIB) {
          _matched=true;
          _switchResult = ((info.scce.dime.gui.gui.GUISIB)it).getGui();
        }
      }
      if (!_matched) {
        if (it instanceof info.scce.dime.gui.gui.ProcessSIB) {
          _matched=true;
          info.scce.dime.process.process.Process _proMod = ((info.scce.dime.gui.gui.ProcessSIB)it).getProMod();
          _switchResult = ((info.scce.dime.process.process.Process) _proMod);
        }
      }
      if (!_matched) {
        if (it instanceof SecuritySIB) {
          _matched=true;
          info.scce.dime.process.process.Process _proMod = ((SecuritySIB)it).getProMod();
          _switchResult = ((info.scce.dime.process.process.Process) _proMod);
        }
      }
      if (!_matched) {
        if (it instanceof GuardSIB) {
          _matched=true;
          info.scce.dime.process.process.Process _process = ((GuardSIB)it).getProcess();
          _switchResult = ((info.scce.dime.process.process.Process) _process);
        }
      }
      if (!_matched) {
        if (it instanceof ProcessComponent) {
          _matched=true;
          _switchResult = ((ProcessComponent)it).getModel();
        }
      }
      if (!_matched) {
        if (it instanceof LoginComponent) {
          _matched=true;
          _switchResult = ((LoginComponent)it).getModel();
        }
      }
      if (!_matched) {
        if (it instanceof FindLoginUserComponent) {
          _matched=true;
          _switchResult = ((FindLoginUserComponent)it).getModel();
        }
      }
      if (!_matched) {
        if (it instanceof DataComponent) {
          _matched=true;
          _switchResult = ((DataComponent)it).getModel();
        }
      }
      return _switchResult;
    }
  };
  
  public boolean isIgnoredBranch(final SIB sib, final String branchName) {
    final Function1<IgnoreBranch, String> _function = new Function1<IgnoreBranch, String>() {
      @Override
      public String apply(final IgnoreBranch it) {
        return it.getName();
      }
    };
    return ListExtensions.<IgnoreBranch, String>map(sib.getIgnoredBranch(), _function).contains(branchName);
  }
  
  @Memoizable
  public List<Input> getProcessInputs(final ProcessSIB it) {
    final Object cacheKey = it;
    final List<Input> result;
    if (!cache0_getProcessInputs.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final List<Input> cacheValue = getProcessInputs_init(it);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache0_getProcessInputs.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache0_getProcessInputs.get(cacheKey);
    }
    // for non-lazy return types, return the cached value.
    return result;
  }
  
  @Memoizable
  public List<Input> getProcessInputs(final GuardProcessSIB it) {
    final Object cacheKey = it;
    final List<Input> result;
    if (!cache1_getProcessInputs.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final List<Input> cacheValue = getProcessInputs_init(it);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache1_getProcessInputs.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache1_getProcessInputs.get(cacheKey);
    }
    // for non-lazy return types, return the cached value.
    return result;
  }
  
  @Memoizable
  public List<Input> getProcessInputs(final GuardedProcessSIB it) {
    final Object cacheKey = it;
    final List<Input> result;
    if (!cache2_getProcessInputs.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final List<Input> cacheValue = getProcessInputs_init(it);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache2_getProcessInputs.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache2_getProcessInputs.get(cacheKey);
    }
    // for non-lazy return types, return the cached value.
    return result;
  }
  
  @Memoizable
  public Type getConcreteUserType(final info.scce.dime.process.process.Process it) {
    final Object cacheKey = it;
    final Type result;
    if (!cache3_getConcreteUserType.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final Type cacheValue = getConcreteUserType_init(it);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache3_getConcreteUserType.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache3_getConcreteUserType.get(cacheKey);
    }
    // for non-lazy return types, return the cached value.
    return result;
  }
  
  @Memoizable
  public Iterable<Container> getProcessAllInputs(final info.scce.dime.process.process.Process it) {
    final Object cacheKey = it;
    final Iterable<Container> result;
    if (!cache4_getProcessAllInputs.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final Iterable<Container> cacheValue = getProcessAllInputs_init(it);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache4_getProcessAllInputs.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache4_getProcessAllInputs.get(cacheKey);
    }
    if (!(result instanceof java.util.stream.Stream)) {
    	// for non-lazy return types, return the cached value.
    	return result;
    }
    else {
    	// for lazy iterations use the duplicate feature of Jooq.
    	final org.jooq.lambda.tuple.Tuple2<
    		org.jooq.lambda.Seq<Container>, 
    		org.jooq.lambda.Seq<Container>
    	> cacheValueDupe = 
    		org.jooq.lambda.Seq.seq(result).duplicate();
    	cache4_getProcessAllInputs.put(cacheKey, cacheValueDupe.v1);
    	return cacheValueDupe.v2;
    }
  }
  
  @Memoizable
  public Iterable<Container> getProcessEntryPointAllInputs(final EntryPointProcessSIB it) {
    final Object cacheKey = it;
    final Iterable<Container> result;
    if (!cache5_getProcessEntryPointAllInputs.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final Iterable<Container> cacheValue = getProcessEntryPointAllInputs_init(it);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache5_getProcessEntryPointAllInputs.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache5_getProcessEntryPointAllInputs.get(cacheKey);
    }
    if (!(result instanceof java.util.stream.Stream)) {
    	// for non-lazy return types, return the cached value.
    	return result;
    }
    else {
    	// for lazy iterations use the duplicate feature of Jooq.
    	final org.jooq.lambda.tuple.Tuple2<
    		org.jooq.lambda.Seq<Container>, 
    		org.jooq.lambda.Seq<Container>
    	> cacheValueDupe = 
    		org.jooq.lambda.Seq.seq(result).duplicate();
    	cache5_getProcessEntryPointAllInputs.put(cacheKey, cacheValueDupe.v1);
    	return cacheValueDupe.v2;
    }
  }
  
  @Memoizable
  public List<ProcessPlaceholderSIB> getProcessInputStatics(final info.scce.dime.process.process.Process it) {
    final Object cacheKey = it;
    final List<ProcessPlaceholderSIB> result;
    if (!cache6_getProcessInputStatics.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final List<ProcessPlaceholderSIB> cacheValue = getProcessInputStatics_init(it);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache6_getProcessInputStatics.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache6_getProcessInputStatics.get(cacheKey);
    }
    // for non-lazy return types, return the cached value.
    return result;
  }
  
  @Memoizable
  public List<OutputPort> getProcessInputs(final info.scce.dime.process.process.Process it) {
    final Object cacheKey = it;
    final List<OutputPort> result;
    if (!cache7_getProcessInputs.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final List<OutputPort> cacheValue = getProcessInputs_init(it);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache7_getProcessInputs.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache7_getProcessInputs.get(cacheKey);
    }
    // for non-lazy return types, return the cached value.
    return result;
  }
  
  @Memoizable
  public Iterable<OutputPort> getProcessInputsInUse(final info.scce.dime.process.process.Process process) {
    final Object cacheKey = process;
    final Iterable<OutputPort> result;
    if (!cache8_getProcessInputsInUse.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final Iterable<OutputPort> cacheValue = getProcessInputsInUse_init(process);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache8_getProcessInputsInUse.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache8_getProcessInputsInUse.get(cacheKey);
    }
    if (!(result instanceof java.util.stream.Stream)) {
    	// for non-lazy return types, return the cached value.
    	return result;
    }
    else {
    	// for lazy iterations use the duplicate feature of Jooq.
    	final org.jooq.lambda.tuple.Tuple2<
    		org.jooq.lambda.Seq<OutputPort>, 
    		org.jooq.lambda.Seq<OutputPort>
    	> cacheValueDupe = 
    		org.jooq.lambda.Seq.seq(result).duplicate();
    	cache8_getProcessInputsInUse.put(cacheKey, cacheValueDupe.v1);
    	return cacheValueDupe.v2;
    }
  }
  
  @Memoizable
  public StartSIB getStartSIB(final info.scce.dime.process.process.Process process) {
    final Object cacheKey = process;
    final StartSIB result;
    if (!cache9_getStartSIB.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final StartSIB cacheValue = getStartSIB_init(process);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache9_getStartSIB.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache9_getStartSIB.get(cacheKey);
    }
    // for non-lazy return types, return the cached value.
    return result;
  }
  
  @Memoizable
  public Iterable<DataFlow> getOutgoingDataFlows(final Iterable<OutputPort> outputPorts) {
    final Object cacheKey = outputPorts;
    final Iterable<DataFlow> result;
    if (!cache10_getOutgoingDataFlows.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final Iterable<DataFlow> cacheValue = getOutgoingDataFlows_init(outputPorts);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache10_getOutgoingDataFlows.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache10_getOutgoingDataFlows.get(cacheKey);
    }
    if (!(result instanceof java.util.stream.Stream)) {
    	// for non-lazy return types, return the cached value.
    	return result;
    }
    else {
    	// for lazy iterations use the duplicate feature of Jooq.
    	final org.jooq.lambda.tuple.Tuple2<
    		org.jooq.lambda.Seq<DataFlow>, 
    		org.jooq.lambda.Seq<DataFlow>
    	> cacheValueDupe = 
    		org.jooq.lambda.Seq.seq(result).duplicate();
    	cache10_getOutgoingDataFlows.put(cacheKey, cacheValueDupe.v1);
    	return cacheValueDupe.v2;
    }
  }
  
  @Memoizable
  public Iterable<DataFlowTarget> getDataFlowTargets(final info.scce.dime.process.process.Process process) {
    final Object cacheKey = process;
    final Iterable<DataFlowTarget> result;
    if (!cache11_getDataFlowTargets.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final Iterable<DataFlowTarget> cacheValue = getDataFlowTargets_init(process);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache11_getDataFlowTargets.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache11_getDataFlowTargets.get(cacheKey);
    }
    if (!(result instanceof java.util.stream.Stream)) {
    	// for non-lazy return types, return the cached value.
    	return result;
    }
    else {
    	// for lazy iterations use the duplicate feature of Jooq.
    	final org.jooq.lambda.tuple.Tuple2<
    		org.jooq.lambda.Seq<DataFlowTarget>, 
    		org.jooq.lambda.Seq<DataFlowTarget>
    	> cacheValueDupe = 
    		org.jooq.lambda.Seq.seq(result).duplicate();
    	cache11_getDataFlowTargets.put(cacheKey, cacheValueDupe.v1);
    	return cacheValueDupe.v2;
    }
  }
  
  @Memoizable
  public List<info.scce.dime.process.process.Process> getSubProcesses(final info.scce.dime.process.process.Process process) {
    final Object cacheKey = process;
    final List<info.scce.dime.process.process.Process> result;
    if (!cache12_getSubProcesses.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final List<info.scce.dime.process.process.Process> cacheValue = getSubProcesses_init(process);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache12_getSubProcesses.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache12_getSubProcesses.get(cacheKey);
    }
    // for non-lazy return types, return the cached value.
    return result;
  }
  
  @Memoizable
  public ComplexVariable getComplexVariablePredecessor(final ComplexVariable cv) {
    final Object cacheKey = cv;
    final ComplexVariable result;
    if (!cache13_getComplexVariablePredecessor.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final ComplexVariable cacheValue = getComplexVariablePredecessor_init(cv);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache13_getComplexVariablePredecessor.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache13_getComplexVariablePredecessor.get(cacheKey);
    }
    // for non-lazy return types, return the cached value.
    return result;
  }
  
  @Memoizable
  public Iterable<Variable> getVariables(final info.scce.dime.process.process.Process process) {
    final Object cacheKey = process;
    final Iterable<Variable> result;
    if (!cache14_getVariables.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final Iterable<Variable> cacheValue = getVariables_init(process);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache14_getVariables.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache14_getVariables.get(cacheKey);
    }
    if (!(result instanceof java.util.stream.Stream)) {
    	// for non-lazy return types, return the cached value.
    	return result;
    }
    else {
    	// for lazy iterations use the duplicate feature of Jooq.
    	final org.jooq.lambda.tuple.Tuple2<
    		org.jooq.lambda.Seq<Variable>, 
    		org.jooq.lambda.Seq<Variable>
    	> cacheValueDupe = 
    		org.jooq.lambda.Seq.seq(result).duplicate();
    	cache14_getVariables.put(cacheKey, cacheValueDupe.v1);
    	return cacheValueDupe.v2;
    }
  }
  
  /**
   * Identifies the order in which write operations related to data flow edges must
   * be executed. In the resulting sequence, all edges appear *before* any edge that
   * may depend on them. Moreover, Update edges appear before DirectDataFlow edges.
   */
  @Memoizable
  public List<DataFlow> sortTopologically(final Iterable<DataFlow> dataFlows) {
    final Object cacheKey = dataFlows;
    final List<DataFlow> result;
    if (!cache15_sortTopologically.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final List<DataFlow> cacheValue = sortTopologically_init(dataFlows);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache15_sortTopologically.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache15_sortTopologically.get(cacheKey);
    }
    // for non-lazy return types, return the cached value.
    return result;
  }
  
  private Iterable<ComplexVariable> getTargetVarPathToRoot(final DataFlow dataFlow) {
    Iterable<ComplexVariable> _switchResult = null;
    Node _targetElement = dataFlow.getTargetElement();
    final Node v = _targetElement;
    boolean _matched = false;
    if (v instanceof PrimitiveAttribute) {
      _matched=true;
      _switchResult = this.getPathToRootVariable(((Attribute)v));
    }
    if (!_matched) {
      if (v instanceof ComplexAttribute) {
        _matched=true;
        _switchResult = this.getPathToRootVariable(((Attribute)v));
      }
    }
    if (!_matched) {
      if (v instanceof ComplexVariable) {
        _matched=true;
        _switchResult = this.getPathToRootVariable(((ComplexVariable)v));
      }
    }
    if (!_matched) {
      _switchResult = Collections.<ComplexVariable>unmodifiableList(CollectionLiterals.<ComplexVariable>newArrayList());
    }
    return _switchResult;
  }
  
  private Iterable<ComplexVariable> getPathToRootVariable(final Attribute ca) {
    ModelElementContainer _container = ca.getContainer();
    return this.getPathToRootVariable(((ComplexVariable) _container));
  }
  
  @Memoizable
  public Iterable<ComplexVariable> getPathToRootVariable(final ComplexVariable cv) {
    final Object cacheKey = cv;
    final Iterable<ComplexVariable> result;
    if (!cache16_getPathToRootVariable.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final Iterable<ComplexVariable> cacheValue = getPathToRootVariable_init(cv);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache16_getPathToRootVariable.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache16_getPathToRootVariable.get(cacheKey);
    }
    if (!(result instanceof java.util.stream.Stream)) {
    	// for non-lazy return types, return the cached value.
    	return result;
    }
    else {
    	// for lazy iterations use the duplicate feature of Jooq.
    	final org.jooq.lambda.tuple.Tuple2<
    		org.jooq.lambda.Seq<ComplexVariable>, 
    		org.jooq.lambda.Seq<ComplexVariable>
    	> cacheValueDupe = 
    		org.jooq.lambda.Seq.seq(result).duplicate();
    	cache16_getPathToRootVariable.put(cacheKey, cacheValueDupe.v1);
    	return cacheValueDupe.v2;
    }
  }
  
  @Memoizable
  public Set<OutputPort> getUniqueSources(final Iterable<DirectDataFlow> ddfs) {
    final Object cacheKey = ddfs;
    final Set<OutputPort> result;
    if (!cache17_getUniqueSources.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final Set<OutputPort> cacheValue = getUniqueSources_init(ddfs);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache17_getUniqueSources.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache17_getUniqueSources.get(cacheKey);
    }
    // for non-lazy return types, return the cached value.
    return result;
  }
  
  @Memoizable
  public Boolean passesGUISIB(final DirectDataFlow ddf) {
    final Object cacheKey = ddf;
    final Boolean result;
    if (!cache18_passesGUISIB.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final Boolean cacheValue = passesGUISIB_init(ddf);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache18_passesGUISIB.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache18_passesGUISIB.get(cacheKey);
    }
    // for non-lazy return types, return the cached value.
    return result;
  }
  
  @Memoizable
  public Boolean existsPathWithGUISIB(final Node source, final Node targetNode) {
    final Object cacheKey = java.util.Arrays.asList(source,targetNode);
    ;
    final Boolean result;
    if (!cache19_existsPathWithGUISIB.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final Boolean cacheValue = existsPathWithGUISIB_init(source,targetNode);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache19_existsPathWithGUISIB.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache19_existsPathWithGUISIB.get(cacheKey);
    }
    // for non-lazy return types, return the cached value.
    return result;
  }
  
  public Set<Node> findNodesViaControlFlowTo(final Node source, final Node target) {
    return this.findNodesViaControlFlowTo(source, target, CollectionLiterals.<Node>newHashSet());
  }
  
  @Memoizable
  public Set<Node> findNodesViaControlFlowTo(final Node source, final Node target, final Set<Node> seen) {
    final Object cacheKey = java.util.Arrays.asList(source,target,seen);
    ;
    final Set<Node> result;
    if (!cache20_findNodesViaControlFlowTo.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final Set<Node> cacheValue = findNodesViaControlFlowTo_init(source,target,seen);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache20_findNodesViaControlFlowTo.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache20_findNodesViaControlFlowTo.get(cacheKey);
    }
    // for non-lazy return types, return the cached value.
    return result;
  }
  
  @Memoizable
  public Boolean isOrContainsGUISIB(final Node node) {
    final Object cacheKey = node;
    final Boolean result;
    if (!cache21_isOrContainsGUISIB.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final Boolean cacheValue = isOrContainsGUISIB_init(node);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache21_isOrContainsGUISIB.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache21_isOrContainsGUISIB.get(cacheKey);
    }
    // for non-lazy return types, return the cached value.
    return result;
  }
  
  @Memoizable
  public Boolean isUsedBeforeAndAfterGUI(final Variable variable) {
    final Object cacheKey = variable;
    final Boolean result;
    if (!cache22_isUsedBeforeAndAfterGUI.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final Boolean cacheValue = isUsedBeforeAndAfterGUI_init(variable);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache22_isUsedBeforeAndAfterGUI.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache22_isUsedBeforeAndAfterGUI.get(cacheKey);
    }
    // for non-lazy return types, return the cached value.
    return result;
  }
  
  public OutputPort getSource(final DirectDataFlow ddf) {
    Node _sourceElement = ddf.getSourceElement();
    return ((OutputPort) _sourceElement);
  }
  
  @Memoizable
  public AbstractBranch getBranchByName(final SIB sib, final String name) {
    final Object cacheKey = java.util.Arrays.asList(sib,name);
    ;
    final AbstractBranch result;
    if (!cache23_getBranchByName.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final AbstractBranch cacheValue = getBranchByName_init(sib,name);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache23_getBranchByName.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache23_getBranchByName.get(cacheKey);
    }
    // for non-lazy return types, return the cached value.
    return result;
  }
  
  @Memoizable
  public Iterable<AbstractBranch> getBranches(final DataFlowTarget sib) {
    final Object cacheKey = sib;
    final Iterable<AbstractBranch> result;
    if (!cache24_getBranches.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final Iterable<AbstractBranch> cacheValue = getBranches_init(sib);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache24_getBranches.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache24_getBranches.get(cacheKey);
    }
    if (!(result instanceof java.util.stream.Stream)) {
    	// for non-lazy return types, return the cached value.
    	return result;
    }
    else {
    	// for lazy iterations use the duplicate feature of Jooq.
    	final org.jooq.lambda.tuple.Tuple2<
    		org.jooq.lambda.Seq<AbstractBranch>, 
    		org.jooq.lambda.Seq<AbstractBranch>
    	> cacheValueDupe = 
    		org.jooq.lambda.Seq.seq(result).duplicate();
    	cache24_getBranches.put(cacheKey, cacheValueDupe.v1);
    	return cacheValueDupe.v2;
    }
  }
  
  @Memoizable
  public DataFlow getDataEdge(final InputPort inputPort) {
    final Object cacheKey = inputPort;
    final DataFlow result;
    if (!cache25_getDataEdge.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final DataFlow cacheValue = getDataEdge_init(inputPort);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache25_getDataEdge.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache25_getDataEdge.get(cacheKey);
    }
    // for non-lazy return types, return the cached value.
    return result;
  }
  
  @Memoizable
  public Iterable<OutputPort> getOutputsInUse(final AbstractBranch branch) {
    final Object cacheKey = branch;
    final Iterable<OutputPort> result;
    if (!cache26_getOutputsInUse.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final Iterable<OutputPort> cacheValue = getOutputsInUse_init(branch);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache26_getOutputsInUse.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache26_getOutputsInUse.get(cacheKey);
    }
    if (!(result instanceof java.util.stream.Stream)) {
    	// for non-lazy return types, return the cached value.
    	return result;
    }
    else {
    	// for lazy iterations use the duplicate feature of Jooq.
    	final org.jooq.lambda.tuple.Tuple2<
    		org.jooq.lambda.Seq<OutputPort>, 
    		org.jooq.lambda.Seq<OutputPort>
    	> cacheValueDupe = 
    		org.jooq.lambda.Seq.seq(result).duplicate();
    	cache26_getOutputsInUse.put(cacheKey, cacheValueDupe.v1);
    	return cacheValueDupe.v2;
    }
  }
  
  @Memoizable
  public Iterable<InputStatic> getStaticModelBranchOutputs(final EndSIB endSIB) {
    final Object cacheKey = endSIB;
    final Iterable<InputStatic> result;
    if (!cache27_getStaticModelBranchOutputs.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final Iterable<InputStatic> cacheValue = getStaticModelBranchOutputs_init(endSIB);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache27_getStaticModelBranchOutputs.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache27_getStaticModelBranchOutputs.get(cacheKey);
    }
    if (!(result instanceof java.util.stream.Stream)) {
    	// for non-lazy return types, return the cached value.
    	return result;
    }
    else {
    	// for lazy iterations use the duplicate feature of Jooq.
    	final org.jooq.lambda.tuple.Tuple2<
    		org.jooq.lambda.Seq<InputStatic>, 
    		org.jooq.lambda.Seq<InputStatic>
    	> cacheValueDupe = 
    		org.jooq.lambda.Seq.seq(result).duplicate();
    	cache27_getStaticModelBranchOutputs.put(cacheKey, cacheValueDupe.v1);
    	return cacheValueDupe.v2;
    }
  }
  
  @Memoizable
  public Iterable<InputPort> getInputsInUse(final SIB it) {
    final Object cacheKey = it;
    final Iterable<InputPort> result;
    if (!cache28_getInputsInUse.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final Iterable<InputPort> cacheValue = getInputsInUse_init(it);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache28_getInputsInUse.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache28_getInputsInUse.get(cacheKey);
    }
    if (!(result instanceof java.util.stream.Stream)) {
    	// for non-lazy return types, return the cached value.
    	return result;
    }
    else {
    	// for lazy iterations use the duplicate feature of Jooq.
    	final org.jooq.lambda.tuple.Tuple2<
    		org.jooq.lambda.Seq<InputPort>, 
    		org.jooq.lambda.Seq<InputPort>
    	> cacheValueDupe = 
    		org.jooq.lambda.Seq.seq(result).duplicate();
    	cache28_getInputsInUse.put(cacheKey, cacheValueDupe.v1);
    	return cacheValueDupe.v2;
    }
  }
  
  @Memoizable
  public Iterable<PrimitiveInputPort> getPrimitiveInputsInUse(final SIB sib) {
    final Object cacheKey = sib;
    final Iterable<PrimitiveInputPort> result;
    if (!cache29_getPrimitiveInputsInUse.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final Iterable<PrimitiveInputPort> cacheValue = getPrimitiveInputsInUse_init(sib);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache29_getPrimitiveInputsInUse.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache29_getPrimitiveInputsInUse.get(cacheKey);
    }
    if (!(result instanceof java.util.stream.Stream)) {
    	// for non-lazy return types, return the cached value.
    	return result;
    }
    else {
    	// for lazy iterations use the duplicate feature of Jooq.
    	final org.jooq.lambda.tuple.Tuple2<
    		org.jooq.lambda.Seq<PrimitiveInputPort>, 
    		org.jooq.lambda.Seq<PrimitiveInputPort>
    	> cacheValueDupe = 
    		org.jooq.lambda.Seq.seq(result).duplicate();
    	cache29_getPrimitiveInputsInUse.put(cacheKey, cacheValueDupe.v1);
    	return cacheValueDupe.v2;
    }
  }
  
  @Memoizable
  public Iterable<JavaNativeInputPort> getJavaNativeInputsInUse(final SIB sib) {
    final Object cacheKey = sib;
    final Iterable<JavaNativeInputPort> result;
    if (!cache30_getJavaNativeInputsInUse.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final Iterable<JavaNativeInputPort> cacheValue = getJavaNativeInputsInUse_init(sib);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache30_getJavaNativeInputsInUse.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache30_getJavaNativeInputsInUse.get(cacheKey);
    }
    if (!(result instanceof java.util.stream.Stream)) {
    	// for non-lazy return types, return the cached value.
    	return result;
    }
    else {
    	// for lazy iterations use the duplicate feature of Jooq.
    	final org.jooq.lambda.tuple.Tuple2<
    		org.jooq.lambda.Seq<JavaNativeInputPort>, 
    		org.jooq.lambda.Seq<JavaNativeInputPort>
    	> cacheValueDupe = 
    		org.jooq.lambda.Seq.seq(result).duplicate();
    	cache30_getJavaNativeInputsInUse.put(cacheKey, cacheValueDupe.v1);
    	return cacheValueDupe.v2;
    }
  }
  
  @Memoizable
  public Iterable<ComplexInputPort> getComplexInputsInUse(final SIB sib) {
    final Object cacheKey = sib;
    final Iterable<ComplexInputPort> result;
    if (!cache31_getComplexInputsInUse.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final Iterable<ComplexInputPort> cacheValue = getComplexInputsInUse_init(sib);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache31_getComplexInputsInUse.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache31_getComplexInputsInUse.get(cacheKey);
    }
    if (!(result instanceof java.util.stream.Stream)) {
    	// for non-lazy return types, return the cached value.
    	return result;
    }
    else {
    	// for lazy iterations use the duplicate feature of Jooq.
    	final org.jooq.lambda.tuple.Tuple2<
    		org.jooq.lambda.Seq<ComplexInputPort>, 
    		org.jooq.lambda.Seq<ComplexInputPort>
    	> cacheValueDupe = 
    		org.jooq.lambda.Seq.seq(result).duplicate();
    	cache31_getComplexInputsInUse.put(cacheKey, cacheValueDupe.v1);
    	return cacheValueDupe.v2;
    }
  }
  
  @Memoizable
  public Iterable<AbstractIterateSIB> getIterateSIBsInUse(final info.scce.dime.process.process.Process process) {
    final Object cacheKey = process;
    final Iterable<AbstractIterateSIB> result;
    if (!cache32_getIterateSIBsInUse.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final Iterable<AbstractIterateSIB> cacheValue = getIterateSIBsInUse_init(process);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache32_getIterateSIBsInUse.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache32_getIterateSIBsInUse.get(cacheKey);
    }
    if (!(result instanceof java.util.stream.Stream)) {
    	// for non-lazy return types, return the cached value.
    	return result;
    }
    else {
    	// for lazy iterations use the duplicate feature of Jooq.
    	final org.jooq.lambda.tuple.Tuple2<
    		org.jooq.lambda.Seq<AbstractIterateSIB>, 
    		org.jooq.lambda.Seq<AbstractIterateSIB>
    	> cacheValueDupe = 
    		org.jooq.lambda.Seq.seq(result).duplicate();
    	cache32_getIterateSIBsInUse.put(cacheKey, cacheValueDupe.v1);
    	return cacheValueDupe.v2;
    }
  }
  
  public PrimitiveType getDataType(final InputStatic input) {
    PrimitiveType _switchResult = null;
    boolean _matched = false;
    if (input instanceof BooleanInputStatic) {
      _matched=true;
      _switchResult = PrimitiveType.BOOLEAN;
    }
    if (!_matched) {
      if (input instanceof IntegerInputStatic) {
        _matched=true;
        _switchResult = PrimitiveType.INTEGER;
      }
    }
    if (!_matched) {
      if (input instanceof RealInputStatic) {
        _matched=true;
        _switchResult = PrimitiveType.REAL;
      }
    }
    if (!_matched) {
      if (input instanceof TextInputStatic) {
        _matched=true;
        _switchResult = PrimitiveType.TEXT;
      }
    }
    if (!_matched) {
      if (input instanceof TimestampInputStatic) {
        _matched=true;
        _switchResult = PrimitiveType.TIMESTAMP;
      }
    }
    return _switchResult;
  }
  
  @Memoizable
  public Iterable<DirectDataFlow> getDirectDataFlows(final info.scce.dime.process.process.Process process) {
    final Object cacheKey = process;
    final Iterable<DirectDataFlow> result;
    if (!cache33_getDirectDataFlows.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final Iterable<DirectDataFlow> cacheValue = getDirectDataFlows_init(process);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache33_getDirectDataFlows.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache33_getDirectDataFlows.get(cacheKey);
    }
    if (!(result instanceof java.util.stream.Stream)) {
    	// for non-lazy return types, return the cached value.
    	return result;
    }
    else {
    	// for lazy iterations use the duplicate feature of Jooq.
    	final org.jooq.lambda.tuple.Tuple2<
    		org.jooq.lambda.Seq<DirectDataFlow>, 
    		org.jooq.lambda.Seq<DirectDataFlow>
    	> cacheValueDupe = 
    		org.jooq.lambda.Seq.seq(result).duplicate();
    	cache33_getDirectDataFlows.put(cacheKey, cacheValueDupe.v1);
    	return cacheValueDupe.v2;
    }
  }
  
  @Memoizable
  public Iterable<InputPort> getModelBranchOutputsInUse(final EndSIB endSIB) {
    final Object cacheKey = endSIB;
    final Iterable<InputPort> result;
    if (!cache34_getModelBranchOutputsInUse.containsKey(cacheKey)) {
    	// we have a cache miss. hence we call the initializer method...
    	// [do the heavy work outside the critical section.]
    	final Iterable<InputPort> cacheValue = getModelBranchOutputsInUse_init(endSIB);
    	
    	// ... and store the result for future calls, iff it has not been set, concurrently.
    	result = cache34_getModelBranchOutputsInUse.computeIfAbsent(cacheKey, (k) -> cacheValue);
    }
    else {
    	// we have a cache hit.
    	result = cache34_getModelBranchOutputsInUse.get(cacheKey);
    }
    if (!(result instanceof java.util.stream.Stream)) {
    	// for non-lazy return types, return the cached value.
    	return result;
    }
    else {
    	// for lazy iterations use the duplicate feature of Jooq.
    	final org.jooq.lambda.tuple.Tuple2<
    		org.jooq.lambda.Seq<InputPort>, 
    		org.jooq.lambda.Seq<InputPort>
    	> cacheValueDupe = 
    		org.jooq.lambda.Seq.seq(result).duplicate();
    	cache34_getModelBranchOutputsInUse.put(cacheKey, cacheValueDupe.v1);
    	return cacheValueDupe.v2;
    }
  }
  
  public AbstractBranch getMajorBranch(final SIB it) {
    AbstractBranch _switchResult = null;
    boolean _matched = false;
    if (it instanceof GUISIB) {
      _matched=true;
      _switchResult = ((GUISIB)it).getMajorBranch();
    }
    if (!_matched) {
      if (it instanceof GUIBlueprintSIB) {
        _matched=true;
        _switchResult = ((GUIBlueprintSIB)it).getMajorBranch();
      }
    }
    if (!_matched) {
      if (it instanceof GenericSIB) {
        _matched=true;
        _switchResult = ((GenericSIB)it).getGuiOptions().getMajorBranch();
      }
    }
    return _switchResult;
  }
  
  public boolean isOfType(final info.scce.dime.process.process.Process process, final ProcessType type) {
    ProcessType _processType = null;
    if (process!=null) {
      _processType=process.getProcessType();
    }
    return Objects.equal(_processType, type);
  }
  
  public info.scce.dime.data.data.PrimitiveType getPrimitiveType(final Node it) {
    info.scce.dime.data.data.PrimitiveType _switchResult = null;
    boolean _matched = false;
    if (it instanceof PrimitiveAttribute) {
      _matched=true;
      _switchResult = ((PrimitiveAttribute)it).getAttribute().getDataType();
    }
    if (!_matched) {
      if (it instanceof PrimitiveListAttribute) {
        _matched=true;
        _switchResult = ProcessExtension.DATA_PRIMITIVE_TYPE.get(((PrimitiveListAttribute)it).getPrimitiveType());
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveVariable) {
        _matched=true;
        _switchResult = ProcessExtension.DATA_PRIMITIVE_TYPE.get(((PrimitiveVariable)it).getDataType());
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveInputPort) {
        _matched=true;
        _switchResult = ProcessExtension.DATA_PRIMITIVE_TYPE.get(((PrimitiveInputPort)it).getDataType());
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveOutputPort) {
        _matched=true;
        _switchResult = ProcessExtension.DATA_PRIMITIVE_TYPE.get(((PrimitiveOutputPort)it).getDataType());
      }
    }
    if (!_matched) {
      if (it instanceof InputStatic) {
        _matched=true;
        _switchResult = this.getPrimitiveType(((InputStatic) it));
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveExtensionAttribute) {
        _matched=true;
        _switchResult = this.getPrimitiveType(((PrimitiveExtensionAttribute) it).getAttribute().getDataType());
      }
    }
    if (!_matched) {
      throw new ProcessExtension.SwitchException();
    }
    return _switchResult;
  }
  
  public info.scce.dime.data.data.PrimitiveType getPrimitiveType(final InputStatic input) {
    info.scce.dime.data.data.PrimitiveType _switchResult = null;
    boolean _matched = false;
    if (input instanceof BooleanInputStatic) {
      _matched=true;
      _switchResult = info.scce.dime.data.data.PrimitiveType.BOOLEAN;
    }
    if (!_matched) {
      if (input instanceof TextInputStatic) {
        _matched=true;
        _switchResult = info.scce.dime.data.data.PrimitiveType.TEXT;
      }
    }
    if (!_matched) {
      if (input instanceof IntegerInputStatic) {
        _matched=true;
        _switchResult = info.scce.dime.data.data.PrimitiveType.INTEGER;
      }
    }
    if (!_matched) {
      if (input instanceof RealInputStatic) {
        _matched=true;
        _switchResult = info.scce.dime.data.data.PrimitiveType.REAL;
      }
    }
    if (!_matched) {
      if (input instanceof TimestampInputStatic) {
        _matched=true;
        _switchResult = info.scce.dime.data.data.PrimitiveType.TIMESTAMP;
      }
    }
    if (!_matched) {
      throw new ProcessExtension.SwitchException();
    }
    return _switchResult;
  }
  
  public info.scce.dime.data.data.PrimitiveType getPrimitiveType(final String input) {
    info.scce.dime.data.data.PrimitiveType _switchResult = null;
    boolean _matched = false;
    if (Objects.equal(input, "Boolean")) {
      _matched=true;
      _switchResult = info.scce.dime.data.data.PrimitiveType.BOOLEAN;
    }
    if (!_matched) {
      if (Objects.equal(input, "Text")) {
        _matched=true;
        _switchResult = info.scce.dime.data.data.PrimitiveType.TEXT;
      }
    }
    if (!_matched) {
      if (Objects.equal(input, "Integer")) {
        _matched=true;
        _switchResult = info.scce.dime.data.data.PrimitiveType.INTEGER;
      }
    }
    if (!_matched) {
      if (Objects.equal(input, "Real")) {
        _matched=true;
        _switchResult = info.scce.dime.data.data.PrimitiveType.REAL;
      }
    }
    if (!_matched) {
      if (Objects.equal(input, "Timestamp")) {
        _matched=true;
        _switchResult = info.scce.dime.data.data.PrimitiveType.TIMESTAMP;
      }
    }
    if (!_matched) {
      if (Objects.equal(input, "File")) {
        _matched=true;
        _switchResult = info.scce.dime.data.data.PrimitiveType.FILE;
      }
    }
    if (!_matched) {
      throw new ProcessExtension.SwitchException();
    }
    return _switchResult;
  }
  
  public Type getComplexType(final Node it) {
    Type _switchResult = null;
    boolean _matched = false;
    if (it instanceof ComplexAttribute) {
      _matched=true;
      Type _xifexpression = null;
      info.scce.dime.data.data.ComplexAttribute _attribute = ((ComplexAttribute)it).getAttribute();
      boolean _tripleNotEquals = (_attribute != null);
      if (_tripleNotEquals) {
        _xifexpression = ((ComplexAttribute)it).getAttribute().getDataType();
      }
      _switchResult = _xifexpression;
    }
    if (!_matched) {
      if (it instanceof ComplexListAttribute) {
        _matched=true;
        _switchResult = ((ComplexListAttribute)it).getListType();
      }
    }
    if (!_matched) {
      if (it instanceof ComplexVariable) {
        _matched=true;
        _switchResult = ((ComplexVariable)it).getDataType();
      }
    }
    if (!_matched) {
      if (it instanceof ComplexInputPort) {
        _matched=true;
        _switchResult = ((ComplexInputPort)it).getDataType();
      }
    }
    if (!_matched) {
      if (it instanceof ComplexOutputPort) {
        _matched=true;
        _switchResult = ((ComplexOutputPort)it).getDataType();
      }
    }
    if (!_matched) {
      if (it instanceof ComplexExtensionAttribute) {
        _matched=true;
        _switchResult = this._dataExtension.getComplexExtensionAttributeType(((ComplexExtensionAttribute)it).getAttribute());
      }
    }
    if (!_matched) {
      throw new ProcessExtension.SwitchException();
    }
    return _switchResult;
  }
  
  public info.scce.dime.siblibrary.Type getNativeType(final Node it) {
    EObject _switchResult = null;
    boolean _matched = false;
    if (it instanceof JavaNativeVariable) {
      _matched=true;
      _switchResult = ((JavaNativeVariable)it).getDataType();
    }
    if (!_matched) {
      if (it instanceof JavaNativeInputPort) {
        _matched=true;
        _switchResult = ((JavaNativeInputPort)it).getDataType();
      }
    }
    if (!_matched) {
      if (it instanceof JavaNativeOutputPort) {
        _matched=true;
        _switchResult = ((JavaNativeOutputPort)it).getDataType();
      }
    }
    if (!_matched) {
      throw new ProcessExtension.SwitchException();
    }
    return ((info.scce.dime.siblibrary.Type) _switchResult);
  }
  
  public boolean isListType(final Node it) {
    boolean _switchResult = false;
    boolean _matched = false;
    if (it instanceof InputPort) {
      _matched=true;
      _switchResult = ((InputPort)it).isIsList();
    }
    if (!_matched) {
      if (it instanceof OutputPort) {
        _matched=true;
        _switchResult = ((OutputPort)it).isIsList();
      }
    }
    if (!_matched) {
      if (it instanceof Variable) {
        _matched=true;
        _switchResult = ((Variable)it).isIsList();
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveAttribute) {
        _matched=true;
        boolean _xifexpression = false;
        info.scce.dime.data.data.PrimitiveAttribute _attribute = ((PrimitiveAttribute)it).getAttribute();
        boolean _tripleNotEquals = (_attribute != null);
        if (_tripleNotEquals) {
          _xifexpression = ((PrimitiveAttribute)it).getAttribute().isIsList();
        }
        _switchResult = _xifexpression;
      }
    }
    if (!_matched) {
      if (it instanceof ComplexAttribute) {
        _matched=true;
        boolean _xifexpression = false;
        info.scce.dime.data.data.ComplexAttribute _attribute = ((ComplexAttribute)it).getAttribute();
        boolean _tripleNotEquals = (_attribute != null);
        if (_tripleNotEquals) {
          _xifexpression = ((ComplexAttribute)it).getAttribute().isIsList();
        }
        _switchResult = _xifexpression;
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveListAttribute) {
        _matched=true;
        _switchResult = false;
      }
    }
    if (!_matched) {
      if (it instanceof ComplexListAttribute) {
        _matched=true;
        _switchResult = false;
      }
    }
    if (!_matched) {
      if (it instanceof InputStatic) {
        _matched=true;
        _switchResult = false;
      }
    }
    if (!_matched) {
      if (it instanceof ExtensionAttribute) {
        _matched=true;
        _switchResult = ((ExtensionAttribute)it).getAttribute().isIsList();
      }
    }
    if (!_matched) {
      throw new ProcessExtension.SwitchException();
    }
    return _switchResult;
  }
  
  public boolean isMajor(final SIB it) {
    boolean _switchResult = false;
    boolean _matched = false;
    if (it instanceof GUISIB) {
      _matched=true;
      _switchResult = ((GUISIB)it).isMajorPage();
    }
    if (!_matched) {
      if (it instanceof GUIBlueprintSIB) {
        _matched=true;
        _switchResult = ((GUIBlueprintSIB)it).isMajorPage();
      }
    }
    if (!_matched) {
      _switchResult = false;
    }
    return _switchResult;
  }
  
  public boolean isMinor(final SIB it) {
    boolean _switchResult = false;
    boolean _matched = false;
    if (it instanceof GUISIB) {
      _matched=true;
      boolean _isMajorPage = ((GUISIB)it).isMajorPage();
      _switchResult = (!_isMajorPage);
    }
    if (!_matched) {
      if (it instanceof GUIBlueprintSIB) {
        _matched=true;
        boolean _isMajorPage = ((GUIBlueprintSIB)it).isMajorPage();
        _switchResult = (!_isMajorPage);
      }
    }
    if (!_matched) {
      if (it instanceof GenericSIB) {
        _matched=true;
        boolean _xblockexpression = false;
        {
          GUISIBOptions _guiOptions = ((GenericSIB)it).getGuiOptions();
          boolean _tripleNotEquals = (_guiOptions != null);
          if (_tripleNotEquals) {
            boolean _isMajorPage = ((GenericSIB)it).getGuiOptions().isMajorPage();
            /* (!_isMajorPage); */
          }
          _xblockexpression = false;
        }
        _switchResult = _xblockexpression;
      }
    }
    if (!_matched) {
      _switchResult = false;
    }
    return _switchResult;
  }
  
  public boolean hasDefaultContent(final SIB sib, final SIB contentSib) {
    boolean _switchResult = false;
    final SIB it = sib;
    boolean _matched = false;
    if (it instanceof GUISIB) {
      _matched=true;
      SIB _defaultContent = ((GUISIB)it).getDefaultContent();
      _switchResult = Objects.equal(_defaultContent, contentSib);
    }
    if (!_matched) {
      if (it instanceof GUIBlueprintSIB) {
        _matched=true;
        SIB _defaultContent = ((GUIBlueprintSIB)it).getDefaultContent();
        _switchResult = Objects.equal(_defaultContent, contentSib);
      }
    }
    return _switchResult;
  }
  
  public void setDefaultContent(final SIB sib, final SIB contentSib) {
    final SIB it = sib;
    boolean _matched = false;
    if (it instanceof GUISIB) {
      _matched=true;
      ((GUISIB)it).setDefaultContent(contentSib);
    }
    if (!_matched) {
      if (it instanceof GUIBlueprintSIB) {
        _matched=true;
        ((GUIBlueprintSIB)it).setDefaultContent(contentSib);
      }
    }
    if (!_matched) {
      Class<? extends SIB> _class = null;
      if (sib!=null) {
        _class=sib.getClass();
      }
      String _plus = ("Failed to set default content for " + _class);
      throw new IllegalArgumentException(_plus);
    }
  }
  
  public boolean hasMajorBranch(final SIB sib, final AbstractBranch branch) {
    boolean _switchResult = false;
    final SIB it = sib;
    boolean _matched = false;
    if (it instanceof GUISIB) {
      _matched=true;
      AbstractBranch _majorBranch = ((GUISIB)it).getMajorBranch();
      _switchResult = Objects.equal(_majorBranch, branch);
    }
    if (!_matched) {
      if (it instanceof GUIBlueprintSIB) {
        _matched=true;
        AbstractBranch _majorBranch = ((GUIBlueprintSIB)it).getMajorBranch();
        _switchResult = Objects.equal(_majorBranch, branch);
      }
    }
    return _switchResult;
  }
  
  public void setMajorBranch(final SIB sib, final AbstractBranch branch) {
    final SIB it = sib;
    boolean _matched = false;
    if (it instanceof GUISIB) {
      _matched=true;
      ((GUISIB)it).setMajorBranch(branch);
    }
    if (!_matched) {
      if (it instanceof GUIBlueprintSIB) {
        _matched=true;
        ((GUIBlueprintSIB)it).setMajorBranch(branch);
      }
    }
    if (!_matched) {
      Class<? extends SIB> _class = null;
      if (sib!=null) {
        _class=sib.getClass();
      }
      String _plus = ("Failed to set major branch for " + _class);
      throw new IllegalArgumentException(_plus);
    }
  }
  
  private final Map<Object, List<Input>> cache0_getProcessInputs = new ConcurrentHashMap<Object, List<Input>>((int)(666*1.5))
    ;
  
  private List<Input> getProcessInputs_init(final ProcessSIB it) {
    final Function1<Input, String> _function = new Function1<Input, String>() {
      @Override
      public String apply(final Input it) {
        return it.getName();
      }
    };
    return IterableExtensions.<Input, String>sortBy(it.getInputs(), _function);
  }
  
  private final Map<Object, List<Input>> cache1_getProcessInputs = new ConcurrentHashMap<Object, List<Input>>((int)(666*1.5))
    ;
  
  private List<Input> getProcessInputs_init(final GuardProcessSIB it) {
    final Function1<Input, String> _function = new Function1<Input, String>() {
      @Override
      public String apply(final Input it) {
        return it.getName();
      }
    };
    return IterableExtensions.<Input, String>sortBy(it.getInputs(), _function);
  }
  
  private final Map<Object, List<Input>> cache2_getProcessInputs = new ConcurrentHashMap<Object, List<Input>>((int)(666*1.5))
    ;
  
  private List<Input> getProcessInputs_init(final GuardedProcessSIB it) {
    final Function1<Input, String> _function = new Function1<Input, String>() {
      @Override
      public String apply(final Input it) {
        return it.getName();
      }
    };
    return IterableExtensions.<Input, String>sortBy(it.getInputs(), _function);
  }
  
  private final Map<Object, Type> cache3_getConcreteUserType = new ConcurrentHashMap<Object, Type>((int)(666*1.5))
    ;
  
  private Type getConcreteUserType_init(final info.scce.dime.process.process.Process it) {
    final Function1<OutputPort, Boolean> _function = new Function1<OutputPort, Boolean>() {
      @Override
      public Boolean apply(final OutputPort it) {
        return Boolean.valueOf(it.getName().equals("currentUser"));
      }
    };
    OutputPort _findFirst = IterableExtensions.<OutputPort>findFirst(this.getProcessInputs(it), _function);
    Type _dataType = null;
    if (((ComplexOutputPort) _findFirst)!=null) {
      _dataType=((ComplexOutputPort) _findFirst).getDataType();
    }
    return _dataType;
  }
  
  private final Map<Object, Iterable<Container>> cache4_getProcessAllInputs = new ConcurrentHashMap<Object, Iterable<Container>>((int)(666*1.5))
    ;
  
  private Iterable<Container> getProcessAllInputs_init(final info.scce.dime.process.process.Process it) {
    List<OutputPort> _processInputs = this.getProcessInputs(it);
    List<ProcessPlaceholderSIB> _processInputStatics = this.getProcessInputStatics(it);
    final Function1<Container, String> _function = new Function1<Container, String>() {
      @Override
      public String apply(final Container it) {
        String _switchResult = null;
        boolean _matched = false;
        if (it instanceof OutputPort) {
          _matched=true;
          _switchResult = ((OutputPort)it).getName();
        }
        if (!_matched) {
          if (it instanceof ProcessPlaceholderSIB) {
            _matched=true;
            _switchResult = ((ProcessPlaceholderSIB)it).getLabel();
          }
        }
        return _switchResult;
      }
    };
    return IterableExtensions.<Container, String>sortBy(Iterables.<Container>filter((Iterables.<Container>concat(_processInputs, _processInputStatics)), Container.class), _function);
  }
  
  private final Map<Object, Iterable<Container>> cache5_getProcessEntryPointAllInputs = new ConcurrentHashMap<Object, Iterable<Container>>((int)(666*1.5))
    ;
  
  private Iterable<Container> getProcessEntryPointAllInputs_init(final EntryPointProcessSIB it) {
    List<Input> _processInputs = this.getProcessInputs(it);
    EList<ProcessInputStatic> _processInputStatics = it.getProcessInputStatics();
    final Function1<Container, String> _function = new Function1<Container, String>() {
      @Override
      public String apply(final Container it) {
        String _switchResult = null;
        boolean _matched = false;
        if (it instanceof InputPort) {
          _matched=true;
          _switchResult = ((InputPort)it).getName();
        }
        return _switchResult;
      }
    };
    return IterableExtensions.<Container, String>sortBy(Iterables.<Container>filter((Iterables.<Input>concat(_processInputs, _processInputStatics)), Container.class), _function);
  }
  
  private final Map<Object, List<ProcessPlaceholderSIB>> cache6_getProcessInputStatics = new ConcurrentHashMap<Object, List<ProcessPlaceholderSIB>>((int)(666*1.5))
    ;
  
  private List<ProcessPlaceholderSIB> getProcessInputStatics_init(final info.scce.dime.process.process.Process it) {
    final Function1<ProcessPlaceholderSIB, String> _function = new Function1<ProcessPlaceholderSIB, String>() {
      @Override
      public String apply(final ProcessPlaceholderSIB it) {
        return it.getLabel();
      }
    };
    final Function1<ProcessPlaceholderSIB, String> _function_1 = new Function1<ProcessPlaceholderSIB, String>() {
      @Override
      public String apply(final ProcessPlaceholderSIB it) {
        return it.getLabel();
      }
    };
    return IterableExtensions.<ProcessPlaceholderSIB, String>sortBy(this._collectionExtension.<ProcessPlaceholderSIB, String>distinctByKey(it.getProcessPlaceholderSIBs(), _function), _function_1);
  }
  
  private final Map<Object, List<OutputPort>> cache7_getProcessInputs = new ConcurrentHashMap<Object, List<OutputPort>>((int)(666*1.5))
    ;
  
  private List<OutputPort> getProcessInputs_init(final info.scce.dime.process.process.Process it) {
    final Function1<OutputPort, String> _function = new Function1<OutputPort, String>() {
      @Override
      public String apply(final OutputPort it) {
        return it.getName();
      }
    };
    return IterableExtensions.<OutputPort, String>sortBy(this.getStartSIB(it).getOutputPorts(), _function);
  }
  
  private final Map<Object, Iterable<OutputPort>> cache8_getProcessInputsInUse = new ConcurrentHashMap<Object, Iterable<OutputPort>>((int)(666*1.5))
    ;
  
  private Iterable<OutputPort> getProcessInputsInUse_init(final info.scce.dime.process.process.Process process) {
    final Function1<OutputPort, Boolean> _function = new Function1<OutputPort, Boolean>() {
      @Override
      public Boolean apply(final OutputPort it) {
        boolean _isEmpty = it.getOutgoingDataFlows().isEmpty();
        return Boolean.valueOf((!_isEmpty));
      }
    };
    return IterableExtensions.<OutputPort>filter(this.getProcessInputs(process), _function);
  }
  
  private final Map<Object, StartSIB> cache9_getStartSIB = new ConcurrentHashMap<Object, StartSIB>((int)(666*1.5))
    ;
  
  private StartSIB getStartSIB_init(final info.scce.dime.process.process.Process process) {
    return IterableExtensions.<StartSIB>head(process.getStartSIBs());
  }
  
  private final Map<Object, Iterable<DataFlow>> cache10_getOutgoingDataFlows = new ConcurrentHashMap<Object, Iterable<DataFlow>>((int)(666*1.5))
    ;
  
  private Iterable<DataFlow> getOutgoingDataFlows_init(final Iterable<OutputPort> outputPorts) {
    final Function1<OutputPort, Iterable<DataFlow>> _function = new Function1<OutputPort, Iterable<DataFlow>>() {
      @Override
      public Iterable<DataFlow> apply(final OutputPort it) {
        return it.getOutgoingDataFlows();
      }
    };
    return IterableExtensions.<OutputPort, DataFlow>flatMap(outputPorts, _function);
  }
  
  private final Map<Object, Iterable<DataFlowTarget>> cache11_getDataFlowTargets = new ConcurrentHashMap<Object, Iterable<DataFlowTarget>>((int)(666*1.5))
    ;
  
  private Iterable<DataFlowTarget> getDataFlowTargets_init(final info.scce.dime.process.process.Process process) {
    return Iterables.<DataFlowTarget>filter(process.getAllNodes(), DataFlowTarget.class);
  }
  
  private final Map<Object, List<info.scce.dime.process.process.Process>> cache12_getSubProcesses = new ConcurrentHashMap<Object, List<info.scce.dime.process.process.Process>>((int)(666*1.5))
    ;
  
  private List<info.scce.dime.process.process.Process> getSubProcesses_init(final info.scce.dime.process.process.Process process) {
    final Function1<ProcessSIB, info.scce.dime.process.process.Process> _function = new Function1<ProcessSIB, info.scce.dime.process.process.Process>() {
      @Override
      public info.scce.dime.process.process.Process apply(final ProcessSIB it) {
        return it.getProMod();
      }
    };
    return ListExtensions.<ProcessSIB, info.scce.dime.process.process.Process>map(process.getProcessSIBs(), _function);
  }
  
  private final Map<Object, ComplexVariable> cache13_getComplexVariablePredecessor = new ConcurrentHashMap<Object, ComplexVariable>((int)(666*1.5))
    ;
  
  private ComplexVariable getComplexVariablePredecessor_init(final ComplexVariable cv) {
    return IterableExtensions.<ComplexVariable>head(cv.getComplexVariablePredecessors());
  }
  
  private final Map<Object, Iterable<Variable>> cache14_getVariables = new ConcurrentHashMap<Object, Iterable<Variable>>((int)(666*1.5))
    ;
  
  private Iterable<Variable> getVariables_init(final info.scce.dime.process.process.Process process) {
    final Function1<DataContext, EList<Variable>> _function = new Function1<DataContext, EList<Variable>>() {
      @Override
      public EList<Variable> apply(final DataContext it) {
        return it.getVariables();
      }
    };
    final Function1<Variable, Boolean> _function_1 = new Function1<Variable, Boolean>() {
      @Override
      public Boolean apply(final Variable v) {
        return Boolean.valueOf(((!(v instanceof ComplexVariable)) || (ProcessExtension.this.getComplexVariablePredecessor(((ComplexVariable) v)) == null)));
      }
    };
    return IterableExtensions.<Variable>filter(Iterables.<Variable>concat(ListExtensions.<DataContext, EList<Variable>>map(process.getDataContexts(), _function)), _function_1);
  }
  
  private final Map<Object, List<DataFlow>> cache15_sortTopologically = new ConcurrentHashMap<Object, List<DataFlow>>((int)(666*1.5))
    ;
  
  private List<DataFlow> sortTopologically_init(final Iterable<DataFlow> dataFlows) {
    final Comparator<DataFlow> _function = new Comparator<DataFlow>() {
      @Override
      public int compare(final DataFlow a, final DataFlow b) {
        int _xifexpression = (int) 0;
        boolean _equals = Objects.equal(a, b);
        if (_equals) {
          _xifexpression = 0;
        } else {
          int _xifexpression_1 = (int) 0;
          Node _targetElement = a.getTargetElement();
          Node _targetElement_1 = b.getTargetElement();
          boolean _equals_1 = Objects.equal(_targetElement, _targetElement_1);
          if (_equals_1) {
            _xifexpression_1 = 0;
          } else {
            int _xifexpression_2 = (int) 0;
            if ((a instanceof Update)) {
              int _xifexpression_3 = (int) 0;
              if ((b instanceof Update)) {
                int _xifexpression_4 = (int) 0;
                final Function1<ComplexVariable, Boolean> _function = new Function1<ComplexVariable, Boolean>() {
                  @Override
                  public Boolean apply(final ComplexVariable it) {
                    String _id = null;
                    if (it!=null) {
                      _id=it.getId();
                    }
                    Node _targetElement = ((Update)a).getTargetElement();
                    String _id_1 = null;
                    if (_targetElement!=null) {
                      _id_1=_targetElement.getId();
                    }
                    return Boolean.valueOf(Objects.equal(_id, _id_1));
                  }
                };
                boolean _exists = IterableExtensions.<ComplexVariable>exists(ProcessExtension.this.getTargetVarPathToRoot(b), _function);
                if (_exists) {
                  _xifexpression_4 = (-1);
                } else {
                  int _xifexpression_5 = (int) 0;
                  final Function1<ComplexVariable, Boolean> _function_1 = new Function1<ComplexVariable, Boolean>() {
                    @Override
                    public Boolean apply(final ComplexVariable it) {
                      String _id = null;
                      if (it!=null) {
                        _id=it.getId();
                      }
                      Node _targetElement = ((Update)b).getTargetElement();
                      String _id_1 = null;
                      if (_targetElement!=null) {
                        _id_1=_targetElement.getId();
                      }
                      return Boolean.valueOf(Objects.equal(_id, _id_1));
                    }
                  };
                  boolean _exists_1 = IterableExtensions.<ComplexVariable>exists(ProcessExtension.this.getTargetVarPathToRoot(a), _function_1);
                  if (_exists_1) {
                    _xifexpression_5 = 1;
                  }
                  _xifexpression_4 = _xifexpression_5;
                }
                _xifexpression_3 = _xifexpression_4;
              } else {
                _xifexpression_3 = (-1);
              }
              _xifexpression_2 = _xifexpression_3;
            } else {
              int _xifexpression_6 = (int) 0;
              if ((b instanceof Update)) {
                _xifexpression_6 = 1;
              } else {
                _xifexpression_6 = 0;
              }
              _xifexpression_2 = _xifexpression_6;
            }
            _xifexpression_1 = _xifexpression_2;
          }
          _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
      }
    };
    return IterableExtensions.<DataFlow>sortWith(dataFlows, _function);
  }
  
  private final Map<Object, Iterable<ComplexVariable>> cache16_getPathToRootVariable = new ConcurrentHashMap<Object, Iterable<ComplexVariable>>((int)(666*1.5))
    ;
  
  private Iterable<ComplexVariable> getPathToRootVariable_init(final ComplexVariable cv) {
    Iterable<ComplexVariable> _elvis = null;
    ComplexVariable _complexVariablePredecessor = this.getComplexVariablePredecessor(cv);
    Iterable<ComplexVariable> _pathToRootVariable = null;
    if (_complexVariablePredecessor!=null) {
      _pathToRootVariable=this.getPathToRootVariable(_complexVariablePredecessor);
    }
    if (_pathToRootVariable != null) {
      _elvis = _pathToRootVariable;
    } else {
      _elvis = Collections.<ComplexVariable>unmodifiableList(CollectionLiterals.<ComplexVariable>newArrayList());
    }
    return Iterables.<ComplexVariable>concat(Collections.<ComplexVariable>unmodifiableList(CollectionLiterals.<ComplexVariable>newArrayList(cv)), _elvis);
  }
  
  private final Map<Object, Set<OutputPort>> cache17_getUniqueSources = new ConcurrentHashMap<Object, Set<OutputPort>>((int)(666*1.5))
    ;
  
  private Set<OutputPort> getUniqueSources_init(final Iterable<DirectDataFlow> ddfs) {
    final Function1<DirectDataFlow, OutputPort> _function = new Function1<DirectDataFlow, OutputPort>() {
      @Override
      public OutputPort apply(final DirectDataFlow it) {
        return ProcessExtension.this.getSource(it);
      }
    };
    return IterableExtensions.<OutputPort>toSet(IterableExtensions.<DirectDataFlow, OutputPort>map(ddfs, _function));
  }
  
  private final Map<Object, Boolean> cache18_passesGUISIB = new ConcurrentHashMap<Object, Boolean>((int)(666*1.5))
    ;
  
  private Boolean passesGUISIB_init(final DirectDataFlow ddf) {
    Boolean _xblockexpression = null;
    {
      ModelElementContainer _container = ddf.getSourceElement().getContainer();
      final Node sourceBranch = ((Node) _container);
      ModelElementContainer _container_1 = ddf.getTargetElement().getContainer();
      final Node targetSIB = ((Node) _container_1);
      _xblockexpression = this.existsPathWithGUISIB(sourceBranch, targetSIB);
    }
    return _xblockexpression;
  }
  
  private final Map<Object, Boolean> cache19_existsPathWithGUISIB = new ConcurrentHashMap<Object, Boolean>((int)(666*1.5))
    ;
  
  private Boolean existsPathWithGUISIB_init(final Node source, final Node targetNode) {
    @Extension
    final GraphModelExtension GraphModelExtension = new de.jabc.cinco.meta.runtime.xapi.GraphModelExtension();
    Node _xifexpression = null;
    if ((targetNode instanceof EventListener)) {
      _xifexpression = IterableExtensions.<GUISIB>head(((EventListener)targetNode).getGUISIBPredecessors());
    } else {
      _xifexpression = targetNode;
    }
    Node target = _xifexpression;
    if ((target instanceof GUISIB)) {
      if ((((((GUISIB)target).getDefaultContent() != null) || (!((GUISIB)target).getIgnoredBranch().isEmpty())) || (!GraphModelExtension.findPathsTo(target, target).isEmpty()))) {
        return Boolean.valueOf(true);
      }
    }
    Iterable<DataFlowTarget> _findParents = GraphModelExtension.<DataFlowTarget>findParents(target, DataFlowTarget.class);
    final List<Node> targetNodes = IterableExtensions.<Node>toList(Iterables.<Node>concat(Collections.<Node>unmodifiableList(CollectionLiterals.<Node>newArrayList(target)), _findParents));
    final Function1<Node, Iterable<Node>> _function = new Function1<Node, Iterable<Node>>() {
      @Override
      public Iterable<Node> apply(final Node it) {
        Set<Node> _findNodesViaControlFlowTo = ProcessExtension.this.findNodesViaControlFlowTo(source, it);
        Set<Node> _findNodesViaControlFlowTo_1 = ProcessExtension.this.findNodesViaControlFlowTo(it, it);
        return Iterables.<Node>concat(_findNodesViaControlFlowTo, _findNodesViaControlFlowTo_1);
      }
    };
    final Iterable<Node> sibs = IterableExtensions.<Node, Node>flatMap(targetNodes, _function);
    Set<SIB> _set = IterableExtensions.<SIB>toSet(Iterables.<SIB>filter(sibs, SIB.class));
    final Procedure1<Set<SIB>> _function_1 = new Procedure1<Set<SIB>>() {
      @Override
      public void apply(final Set<SIB> it) {
        it.removeAll(targetNodes);
      }
    };
    final Set<SIB> sibsOnPaths = ObjectExtensions.<Set<SIB>>operator_doubleArrow(_set, _function_1);
    final Function1<SIB, Boolean> _function_2 = new Function1<SIB, Boolean>() {
      @Override
      public Boolean apply(final SIB it) {
        return ProcessExtension.this.isOrContainsGUISIB(it);
      }
    };
    return Boolean.valueOf(IterableExtensions.<SIB>exists(sibsOnPaths, _function_2));
  }
  
  private final Map<Object, Set<Node>> cache20_findNodesViaControlFlowTo = new ConcurrentHashMap<Object, Set<Node>>((int)(666*1.5))
    ;
  
  private Set<Node> findNodesViaControlFlowTo_init(final Node source, final Node target, final Set<Node> seen) {
    Set<Node> _xblockexpression = null;
    {
      @Extension
      final GraphModelExtension GraphModelExtension = new de.jabc.cinco.meta.runtime.xapi.GraphModelExtension();
      final Set<Node> nodes1 = IterableExtensions.<Node>toSet(Iterables.<Node>concat(GraphModelExtension.findPathsTo(source, target)));
      Collection<Node> _xifexpression = null;
      final Function1<Node, Boolean> _function = new Function1<Node, Boolean>() {
        @Override
        public Boolean apply(final Node it) {
          return Boolean.valueOf((it instanceof EventListener));
        }
      };
      boolean _exists = IterableExtensions.<Node>exists(source.getRootElement().<Node>getNodes(), _function);
      if (_exists) {
        final Function1<List<Node>, Iterable<Node>> _function_1 = new Function1<List<Node>, Iterable<Node>>() {
          @Override
          public Iterable<Node> apply(final List<Node> path) {
            Iterable<Node> _xblockexpression = null;
            {
              Node _last = IterableExtensions.<Node>last(path);
              final EventListener evt = ((EventListener) _last);
              final GUISIB guiSib = IterableExtensions.<GUISIB>head(evt.getGUISIBPredecessors());
              Iterable<Node> _xifexpression = null;
              boolean _add = seen.add(guiSib);
              if (_add) {
                Set<Node> _findNodesViaControlFlowTo = ProcessExtension.this.findNodesViaControlFlowTo(guiSib, target, seen);
                final Procedure1<Set<Node>> _function = new Procedure1<Set<Node>>() {
                  @Override
                  public void apply(final Set<Node> it) {
                    it.add(guiSib);
                    it.addAll(path);
                  }
                };
                _xifexpression = ObjectExtensions.<Set<Node>>operator_doubleArrow(_findNodesViaControlFlowTo, _function);
              } else {
                _xifexpression = Iterables.<Node>concat(Collections.<GUISIB>unmodifiableList(CollectionLiterals.<GUISIB>newArrayList(guiSib)), path);
              }
              _xblockexpression = _xifexpression;
            }
            return _xblockexpression;
          }
        };
        _xifexpression = IterableExtensions.<Node>toSet(IterableExtensions.<List<Node>, Node>flatMap(GraphModelExtension.<EventListener>findPathsTo(source, EventListener.class), _function_1));
      } else {
        _xifexpression = Collections.<Node>unmodifiableList(CollectionLiterals.<Node>newArrayList());
      }
      final Collection<Node> nodes2 = _xifexpression;
      final Procedure1<Set<Node>> _function_2 = new Procedure1<Set<Node>>() {
        @Override
        public void apply(final Set<Node> it) {
          it.addAll(nodes2);
        }
      };
      _xblockexpression = ObjectExtensions.<Set<Node>>operator_doubleArrow(nodes1, _function_2);
    }
    return _xblockexpression;
  }
  
  private final Map<Object, Boolean> cache21_isOrContainsGUISIB = new ConcurrentHashMap<Object, Boolean>((int)(666*1.5))
    ;
  
  private Boolean isOrContainsGUISIB_init(final Node node) {
    boolean _xblockexpression = false;
    {
      @Extension
      final GraphModelExtension GraphModelExtension = new de.jabc.cinco.meta.runtime.xapi.GraphModelExtension();
      boolean _switchResult = false;
      boolean _matched = false;
      if (node instanceof GUISIB) {
        _matched=true;
        _switchResult = true;
      }
      if (!_matched) {
        if (node instanceof ProcessSIB) {
          _matched=true;
        }
        if (!_matched) {
          if (node instanceof GuardedProcessSIB) {
            _matched=true;
          }
        }
        if (_matched) {
          boolean _isEmpty = IterableExtensions.isEmpty(GraphModelExtension.<GUISIB>findDeeply(((ModelElementContainer)node), GUISIB.class, this.followPrimeRefs));
          _switchResult = (!_isEmpty);
        }
      }
      if (!_matched) {
        if (node instanceof GuardContainer) {
          _matched=true;
          final Function1<GuardedProcessSIB, Boolean> _function = new Function1<GuardedProcessSIB, Boolean>() {
            @Override
            public Boolean apply(final GuardedProcessSIB it) {
              return ProcessExtension.this.isOrContainsGUISIB(it);
            }
          };
          _switchResult = IterableExtensions.<GuardedProcessSIB>exists(((GuardContainer)node).getGuardedProcessSIBs(), _function);
        }
      }
      if (!_matched) {
        _switchResult = false;
      }
      _xblockexpression = _switchResult;
    }
    return Boolean.valueOf(_xblockexpression);
  }
  
  private final Map<Object, Boolean> cache22_isUsedBeforeAndAfterGUI = new ConcurrentHashMap<Object, Boolean>((int)(666*1.5))
    ;
  
  private Boolean isUsedBeforeAndAfterGUI_init(final Variable variable) {
    boolean _xblockexpression = false;
    {
      @Extension
      final GraphModelExtension GraphModelExtension = new de.jabc.cinco.meta.runtime.xapi.GraphModelExtension();
      Set<Node> _findSuccessorsVia = GraphModelExtension.findSuccessorsVia(variable, ComplexAttributeConnector.class);
      final Function1<Variable, Iterable<Node>> _function = new Function1<Variable, Iterable<Node>>() {
        @Override
        public Iterable<Node> apply(final Variable it) {
          Iterable<Attribute> _find = GraphModelExtension.<Attribute>find(it, Attribute.class);
          return Iterables.<Node>concat(Collections.<Variable>unmodifiableList(CollectionLiterals.<Variable>newArrayList(it)), _find);
        }
      };
      final Function1<Node, Iterable<Node>> _function_1 = new Function1<Node, Iterable<Node>>() {
        @Override
        public Iterable<Node> apply(final Node it) {
          Set<Node> _findSuccessorsVia = GraphModelExtension.findSuccessorsVia(it, DataFlow.class);
          Set<Node> _findPredecessorsVia = GraphModelExtension.findPredecessorsVia(it, DataFlow.class);
          return Iterables.<Node>concat(_findSuccessorsVia, _findPredecessorsVia);
        }
      };
      final Function1<Node, Node> _function_2 = new Function1<Node, Node>() {
        @Override
        public Node apply(final Node it) {
          ModelElementContainer _container = it.getContainer();
          return ((Node) _container);
        }
      };
      final Set<Node> usingSIBs = IterableExtensions.<Node>toSet(IterableExtensions.<Node, Node>map(IterableExtensions.<Node, Node>flatMap(IterableExtensions.<Variable, Node>flatMap(Iterables.<Variable>filter((Iterables.<Node>concat(Collections.<Variable>unmodifiableList(CollectionLiterals.<Variable>newArrayList(variable)), _findSuccessorsVia)), Variable.class), _function), _function_1), _function_2));
      final Function1<Node, Boolean> _function_3 = new Function1<Node, Boolean>() {
        @Override
        public Boolean apply(final Node usingSIB) {
          final Function1<Node, Boolean> _function = new Function1<Node, Boolean>() {
            @Override
            public Boolean apply(final Node otherUsingSIB) {
              return Boolean.valueOf(((ProcessExtension.this.existsPathWithGUISIB(otherUsingSIB, usingSIB)).booleanValue() || (ProcessExtension.this.existsPathWithGUISIB(usingSIB, otherUsingSIB)).booleanValue()));
            }
          };
          return Boolean.valueOf(IterableExtensions.<Node>exists(usingSIBs, _function));
        }
      };
      _xblockexpression = IterableExtensions.<Node>exists(usingSIBs, _function_3);
    }
    return Boolean.valueOf(_xblockexpression);
  }
  
  private final Map<Object, AbstractBranch> cache23_getBranchByName = new ConcurrentHashMap<Object, AbstractBranch>((int)(666*1.5))
    ;
  
  private AbstractBranch getBranchByName_init(final SIB sib, final String name) {
    final Function1<AbstractBranch, Boolean> _function = new Function1<AbstractBranch, Boolean>() {
      @Override
      public Boolean apply(final AbstractBranch b) {
        String _name = b.getName();
        return Boolean.valueOf(Objects.equal(_name, name));
      }
    };
    return IterableExtensions.<AbstractBranch>head(IterableExtensions.<AbstractBranch>filter(this.getBranches(sib), _function));
  }
  
  private final Map<Object, Iterable<AbstractBranch>> cache24_getBranches = new ConcurrentHashMap<Object, Iterable<AbstractBranch>>((int)(666*1.5))
    ;
  
  private Iterable<AbstractBranch> getBranches_init(final DataFlowTarget sib) {
    final Function1<BranchConnector, AbstractBranch> _function = new Function1<BranchConnector, AbstractBranch>() {
      @Override
      public AbstractBranch apply(final BranchConnector it) {
        return it.getTargetElement();
      }
    };
    return Iterables.<AbstractBranch>filter(ListExtensions.<BranchConnector, AbstractBranch>map(sib.<BranchConnector>getOutgoing(BranchConnector.class), _function), AbstractBranch.class);
  }
  
  private final Map<Object, DataFlow> cache25_getDataEdge = new ConcurrentHashMap<Object, DataFlow>((int)(666*1.5))
    ;
  
  private DataFlow getDataEdge_init(final InputPort inputPort) {
    final Function1<DataFlow, Boolean> _function = new Function1<DataFlow, Boolean>() {
      @Override
      public Boolean apply(final DataFlow x) {
        return Boolean.valueOf(((x instanceof Read) || (x instanceof DirectDataFlow)));
      }
    };
    return IterableExtensions.<DataFlow>head(IterableExtensions.<DataFlow>filter(Iterables.<DataFlow>filter(inputPort.getIncoming(), DataFlow.class), _function));
  }
  
  private final Map<Object, Iterable<OutputPort>> cache26_getOutputsInUse = new ConcurrentHashMap<Object, Iterable<OutputPort>>((int)(666*1.5))
    ;
  
  private Iterable<OutputPort> getOutputsInUse_init(final AbstractBranch branch) {
    final Function1<OutputPort, Boolean> _function = new Function1<OutputPort, Boolean>() {
      @Override
      public Boolean apply(final OutputPort it) {
        boolean _isEmpty = it.getOutgoingDataFlows().isEmpty();
        return Boolean.valueOf((!_isEmpty));
      }
    };
    return IterableExtensions.<OutputPort>filter(branch.getOutputPorts(), _function);
  }
  
  private final Map<Object, Iterable<InputStatic>> cache27_getStaticModelBranchOutputs = new ConcurrentHashMap<Object, Iterable<InputStatic>>((int)(666*1.5))
    ;
  
  private Iterable<InputStatic> getStaticModelBranchOutputs_init(final EndSIB endSIB) {
    return Iterables.<InputStatic>filter(endSIB.getInputs(), InputStatic.class);
  }
  
  private final Map<Object, Iterable<InputPort>> cache28_getInputsInUse = new ConcurrentHashMap<Object, Iterable<InputPort>>((int)(666*1.5))
    ;
  
  private Iterable<InputPort> getInputsInUse_init(final SIB it) {
    Iterable<ComplexInputPort> _complexInputsInUse = this.getComplexInputsInUse(it);
    Iterable<PrimitiveInputPort> _primitiveInputsInUse = this.getPrimitiveInputsInUse(it);
    Iterable<InputPort> _plus = Iterables.<InputPort>concat(_complexInputsInUse, _primitiveInputsInUse);
    Iterable<JavaNativeInputPort> _javaNativeInputsInUse = this.getJavaNativeInputsInUse(it);
    return Iterables.<InputPort>concat(_plus, _javaNativeInputsInUse);
  }
  
  private final Map<Object, Iterable<PrimitiveInputPort>> cache29_getPrimitiveInputsInUse = new ConcurrentHashMap<Object, Iterable<PrimitiveInputPort>>((int)(666*1.5))
    ;
  
  private Iterable<PrimitiveInputPort> getPrimitiveInputsInUse_init(final SIB sib) {
    final Function1<PrimitiveInputPort, Boolean> _function = new Function1<PrimitiveInputPort, Boolean>() {
      @Override
      public Boolean apply(final PrimitiveInputPort it) {
        DataFlow _dataEdge = ProcessExtension.this.getDataEdge(it);
        return Boolean.valueOf((_dataEdge != null));
      }
    };
    return IterableExtensions.<PrimitiveInputPort>filter(sib.getPrimitiveInputPorts(), _function);
  }
  
  private final Map<Object, Iterable<JavaNativeInputPort>> cache30_getJavaNativeInputsInUse = new ConcurrentHashMap<Object, Iterable<JavaNativeInputPort>>((int)(666*1.5))
    ;
  
  private Iterable<JavaNativeInputPort> getJavaNativeInputsInUse_init(final SIB sib) {
    final Function1<JavaNativeInputPort, Boolean> _function = new Function1<JavaNativeInputPort, Boolean>() {
      @Override
      public Boolean apply(final JavaNativeInputPort it) {
        DataFlow _dataEdge = ProcessExtension.this.getDataEdge(it);
        return Boolean.valueOf((_dataEdge != null));
      }
    };
    return IterableExtensions.<JavaNativeInputPort>filter(sib.getJavaNativeInputPorts(), _function);
  }
  
  private final Map<Object, Iterable<ComplexInputPort>> cache31_getComplexInputsInUse = new ConcurrentHashMap<Object, Iterable<ComplexInputPort>>((int)(666*1.5))
    ;
  
  private Iterable<ComplexInputPort> getComplexInputsInUse_init(final SIB sib) {
    final Function1<ComplexInputPort, Boolean> _function = new Function1<ComplexInputPort, Boolean>() {
      @Override
      public Boolean apply(final ComplexInputPort it) {
        DataFlow _dataEdge = ProcessExtension.this.getDataEdge(it);
        return Boolean.valueOf((_dataEdge != null));
      }
    };
    return IterableExtensions.<ComplexInputPort>filter(sib.getComplexInputPorts(), _function);
  }
  
  private final Map<Object, Iterable<AbstractIterateSIB>> cache32_getIterateSIBsInUse = new ConcurrentHashMap<Object, Iterable<AbstractIterateSIB>>((int)(666*1.5))
    ;
  
  private Iterable<AbstractIterateSIB> getIterateSIBsInUse_init(final info.scce.dime.process.process.Process process) {
    final Function1<AbstractIterateSIB, Boolean> _function = new Function1<AbstractIterateSIB, Boolean>() {
      @Override
      public Boolean apply(final AbstractIterateSIB it) {
        int _size = IterableExtensions.size(ProcessExtension.this.getInputsInUse(it));
        return Boolean.valueOf((_size > 0));
      }
    };
    return IterableExtensions.<AbstractIterateSIB>filter(process.getAbstractIterateSIBs(), _function);
  }
  
  private final Map<Object, Iterable<DirectDataFlow>> cache33_getDirectDataFlows = new ConcurrentHashMap<Object, Iterable<DirectDataFlow>>((int)(666*1.5))
    ;
  
  private Iterable<DirectDataFlow> getDirectDataFlows_init(final info.scce.dime.process.process.Process process) {
    EList<PrimitiveDirectDataFlow> _modelElements = process.<PrimitiveDirectDataFlow>getModelElements(PrimitiveDirectDataFlow.class);
    EList<ComplexDirectDataFlow> _modelElements_1 = process.<ComplexDirectDataFlow>getModelElements(ComplexDirectDataFlow.class);
    return IterableExtensions.<DirectDataFlow>toSet(Iterables.<DirectDataFlow>concat(_modelElements, _modelElements_1));
  }
  
  private final Map<Object, Iterable<InputPort>> cache34_getModelBranchOutputsInUse = new ConcurrentHashMap<Object, Iterable<InputPort>>((int)(666*1.5))
    ;
  
  private Iterable<InputPort> getModelBranchOutputsInUse_init(final EndSIB endSIB) {
    final Function1<InputPort, Boolean> _function = new Function1<InputPort, Boolean>() {
      @Override
      public Boolean apply(final InputPort it) {
        DataFlow _dataEdge = ProcessExtension.this.getDataEdge(it);
        return Boolean.valueOf((_dataEdge != null));
      }
    };
    return IterableExtensions.<InputPort>filter(endSIB.getInputPorts(), _function);
  }
}
