/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.helper;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import graphmodel.Container;
import graphmodel.ModelElement;
import graphmodel.ModelElementContainer;
import graphmodel.Node;
import info.scce.dime.data.data.ComplexAttribute;
import info.scce.dime.data.data.PrimitiveAttribute;
import info.scce.dime.data.data.Type;
import info.scce.dime.data.helper.DataExtension;
import info.scce.dime.gUIPlugin.ComplexInputParameter;
import info.scce.dime.gUIPlugin.ComplexParameter;
import info.scce.dime.gUIPlugin.PrimitiveParameter;
import info.scce.dime.gui.gui.AddComplexToSubmission;
import info.scce.dime.gui.gui.AddPrimitiveToSubmission;
import info.scce.dime.gui.gui.ComplexVariable;
import info.scce.dime.gui.gui.PrimitiveVariable;
import info.scce.dime.gui.gui.Variable;
import info.scce.dime.gui.helper.ComplexGUIBranchPort;
import info.scce.dime.gui.helper.GUIBranchPort;
import info.scce.dime.gui.helper.GUIExtension;
import info.scce.dime.gui.helper.PrimitiveGUIBranchPort;
import info.scce.dime.process.process.BooleanInputStatic;
import info.scce.dime.process.process.ComplexInputPort;
import info.scce.dime.process.process.ComplexOutputPort;
import info.scce.dime.process.process.DataFlow;
import info.scce.dime.process.process.DataFlowSource;
import info.scce.dime.process.process.DataFlowTarget;
import info.scce.dime.process.process.EventListener;
import info.scce.dime.process.process.IO;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.InputPort;
import info.scce.dime.process.process.InputStatic;
import info.scce.dime.process.process.IntegerInputStatic;
import info.scce.dime.process.process.JavaNativeInputPort;
import info.scce.dime.process.process.JavaNativeOutputPort;
import info.scce.dime.process.process.Output;
import info.scce.dime.process.process.OutputPort;
import info.scce.dime.process.process.PrimitiveInputPort;
import info.scce.dime.process.process.PrimitiveOutputPort;
import info.scce.dime.process.process.PrimitiveType;
import info.scce.dime.process.process.ProcessFactory;
import info.scce.dime.process.process.ProcessInputStatic;
import info.scce.dime.process.process.ProcessPlaceholderSIB;
import info.scce.dime.process.process.RealInputStatic;
import info.scce.dime.process.process.TextInputStatic;
import info.scce.dime.process.process.TimestampInputStatic;
import info.scce.dime.search.search.ComplexOutputParameter;
import info.scce.dime.search.search.PrimitiveInputParameter;
import info.scce.dime.siblibrary.DataTypePort;
import info.scce.dime.siblibrary.JavaType;
import info.scce.dime.siblibrary.JavaTypePort;
import info.scce.dime.siblibrary.Port;
import info.scce.dime.siblibrary.PrimitivePort;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function0;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.Functions.Function2;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure2;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class PortUtils {
  public static class Sync<Item extends Object, Reference extends Object> {
    public Function2<? super Item, ? super Reference, ? extends Boolean> equals = new Function2<Item, Reference, Boolean>() {
      @Override
      public Boolean apply(final Item $0, final Reference $1) {
        return Boolean.valueOf(false);
      }
    };
    
    public Procedure1<? super Reference> add = new Procedure1<Reference>() {
      @Override
      public void apply(final Reference it) {
      }
    };
    
    public Procedure2<? super Item, ? super Reference> update = new Procedure2<Item, Reference>() {
      @Override
      public void apply(final Item $0, final Reference $1) {
      }
    };
    
    public Procedure1<? super Item> delete = new Procedure1<Item>() {
      @Override
      public void apply(final Item it) {
      }
    };
    
    public void apply(final Iterable<Item> items, final Iterable<Reference> refs) {
      final ArrayList<Item> _items = this.<Item>toNewList(items);
      final ArrayList<Reference> _refs = this.<Reference>toNewList(refs);
      for (final Reference ref : _refs) {
        {
          final Function1<Item, Boolean> _function = new Function1<Item, Boolean>() {
            @Override
            public Boolean apply(final Item it) {
              return Sync.this.equals.apply(it, ref);
            }
          };
          final Item item = IterableExtensions.<Item>findFirst(_items, _function);
          if ((item != null)) {
            _items.remove(item);
            this.update.apply(item, ref);
          } else {
            this.add.apply(ref);
          }
        }
      }
      IterableExtensions.<Item>forEach(_items, this.delete);
    }
    
    public <X extends Object> ArrayList<X> toNewList(final Iterable<X> list) {
      final ArrayList<X> newList = CollectionLiterals.<X>newArrayList();
      if ((list != null)) {
        Iterables.<X>addAll(newList, list);
      }
      return newList;
    }
  }
  
  public static class SwitchException extends IllegalStateException {
    public SwitchException() {
      super("Default case in exhaustive switch; implementation broken?");
    }
    
    public SwitchException(final Object obj) {
      super(new Function0<String>() {
        @Override
        public String apply() {
          Class<?> _class = null;
          if (obj!=null) {
            _class=obj.getClass();
          }
          String _simpleName = null;
          if (_class!=null) {
            _simpleName=_class.getSimpleName();
          }
          String _plus = ("Default case in exhaustive switch for " + _simpleName);
          String _plus_1 = (_plus + "; implementation broken?");
          return _plus_1;
        }
      }.apply());
    }
  }
  
  @Extension
  private GUIExtension _guix = new GUIExtension();
  
  @Extension
  private DataExtension _datax = DataExtension.getInstance();
  
  private static final HashMap<?, PrimitiveType> PRIMITIVE_TYPE = CollectionLiterals.<Serializable, PrimitiveType>newHashMap(
    Pair.<Class<BooleanInputStatic>, PrimitiveType>of(BooleanInputStatic.class, PrimitiveType.BOOLEAN), 
    Pair.<Class<TextInputStatic>, PrimitiveType>of(TextInputStatic.class, PrimitiveType.TEXT), 
    Pair.<Class<IntegerInputStatic>, PrimitiveType>of(IntegerInputStatic.class, PrimitiveType.INTEGER), 
    Pair.<Class<RealInputStatic>, PrimitiveType>of(RealInputStatic.class, PrimitiveType.REAL), 
    Pair.<Class<TimestampInputStatic>, PrimitiveType>of(TimestampInputStatic.class, PrimitiveType.TIMESTAMP), 
    Pair.<info.scce.dime.siblibrary.PrimitiveType, PrimitiveType>of(info.scce.dime.siblibrary.PrimitiveType.BOOLEAN, PrimitiveType.BOOLEAN), 
    Pair.<info.scce.dime.siblibrary.PrimitiveType, PrimitiveType>of(info.scce.dime.siblibrary.PrimitiveType.TEXT, PrimitiveType.TEXT), 
    Pair.<info.scce.dime.siblibrary.PrimitiveType, PrimitiveType>of(info.scce.dime.siblibrary.PrimitiveType.INTEGER, PrimitiveType.INTEGER), 
    Pair.<info.scce.dime.siblibrary.PrimitiveType, PrimitiveType>of(info.scce.dime.siblibrary.PrimitiveType.REAL, PrimitiveType.REAL), 
    Pair.<info.scce.dime.siblibrary.PrimitiveType, PrimitiveType>of(info.scce.dime.siblibrary.PrimitiveType.TIMESTAMP, PrimitiveType.TIMESTAMP), 
    Pair.<info.scce.dime.siblibrary.PrimitiveType, PrimitiveType>of(info.scce.dime.siblibrary.PrimitiveType.FILE, PrimitiveType.FILE), 
    Pair.<info.scce.dime.gui.gui.PrimitiveType, PrimitiveType>of(info.scce.dime.gui.gui.PrimitiveType.BOOLEAN, PrimitiveType.BOOLEAN), 
    Pair.<info.scce.dime.gui.gui.PrimitiveType, PrimitiveType>of(info.scce.dime.gui.gui.PrimitiveType.TEXT, PrimitiveType.TEXT), 
    Pair.<info.scce.dime.gui.gui.PrimitiveType, PrimitiveType>of(info.scce.dime.gui.gui.PrimitiveType.INTEGER, PrimitiveType.INTEGER), 
    Pair.<info.scce.dime.gui.gui.PrimitiveType, PrimitiveType>of(info.scce.dime.gui.gui.PrimitiveType.REAL, PrimitiveType.REAL), 
    Pair.<info.scce.dime.gui.gui.PrimitiveType, PrimitiveType>of(info.scce.dime.gui.gui.PrimitiveType.TIMESTAMP, PrimitiveType.TIMESTAMP), 
    Pair.<info.scce.dime.gui.gui.PrimitiveType, PrimitiveType>of(info.scce.dime.gui.gui.PrimitiveType.FILE, PrimitiveType.FILE), 
    Pair.<info.scce.dime.data.data.PrimitiveType, PrimitiveType>of(info.scce.dime.data.data.PrimitiveType.BOOLEAN, PrimitiveType.BOOLEAN), 
    Pair.<info.scce.dime.data.data.PrimitiveType, PrimitiveType>of(info.scce.dime.data.data.PrimitiveType.TEXT, PrimitiveType.TEXT), 
    Pair.<info.scce.dime.data.data.PrimitiveType, PrimitiveType>of(info.scce.dime.data.data.PrimitiveType.INTEGER, PrimitiveType.INTEGER), 
    Pair.<info.scce.dime.data.data.PrimitiveType, PrimitiveType>of(info.scce.dime.data.data.PrimitiveType.REAL, PrimitiveType.REAL), 
    Pair.<info.scce.dime.data.data.PrimitiveType, PrimitiveType>of(info.scce.dime.data.data.PrimitiveType.TIMESTAMP, PrimitiveType.TIMESTAMP), 
    Pair.<info.scce.dime.data.data.PrimitiveType, PrimitiveType>of(info.scce.dime.data.data.PrimitiveType.FILE, PrimitiveType.FILE), 
    Pair.<PrimitiveType, PrimitiveType>of(PrimitiveType.BOOLEAN, PrimitiveType.BOOLEAN), 
    Pair.<PrimitiveType, PrimitiveType>of(PrimitiveType.TEXT, PrimitiveType.TEXT), 
    Pair.<PrimitiveType, PrimitiveType>of(PrimitiveType.INTEGER, PrimitiveType.INTEGER), 
    Pair.<PrimitiveType, PrimitiveType>of(PrimitiveType.REAL, PrimitiveType.REAL), 
    Pair.<PrimitiveType, PrimitiveType>of(PrimitiveType.TIMESTAMP, PrimitiveType.TIMESTAMP), 
    Pair.<PrimitiveType, PrimitiveType>of(PrimitiveType.FILE, PrimitiveType.FILE), 
    Pair.<info.scce.dime.search.search.PrimitiveType, PrimitiveType>of(info.scce.dime.search.search.PrimitiveType.BOOLEAN, PrimitiveType.BOOLEAN), 
    Pair.<info.scce.dime.search.search.PrimitiveType, PrimitiveType>of(info.scce.dime.search.search.PrimitiveType.TEXT, PrimitiveType.TEXT), 
    Pair.<info.scce.dime.search.search.PrimitiveType, PrimitiveType>of(info.scce.dime.search.search.PrimitiveType.INTEGER, PrimitiveType.INTEGER), 
    Pair.<info.scce.dime.search.search.PrimitiveType, PrimitiveType>of(info.scce.dime.search.search.PrimitiveType.REAL, PrimitiveType.REAL), 
    Pair.<info.scce.dime.search.search.PrimitiveType, PrimitiveType>of(info.scce.dime.search.search.PrimitiveType.TIMESTAMP, PrimitiveType.TIMESTAMP), 
    Pair.<info.scce.dime.gUIPlugin.PrimitiveType, PrimitiveType>of(info.scce.dime.gUIPlugin.PrimitiveType.BOOLEAN, PrimitiveType.BOOLEAN), 
    Pair.<info.scce.dime.gUIPlugin.PrimitiveType, PrimitiveType>of(info.scce.dime.gUIPlugin.PrimitiveType.TEXT, PrimitiveType.TEXT), 
    Pair.<info.scce.dime.gUIPlugin.PrimitiveType, PrimitiveType>of(info.scce.dime.gUIPlugin.PrimitiveType.INTEGER, PrimitiveType.INTEGER), 
    Pair.<info.scce.dime.gUIPlugin.PrimitiveType, PrimitiveType>of(info.scce.dime.gUIPlugin.PrimitiveType.REAL, PrimitiveType.REAL), 
    Pair.<info.scce.dime.gUIPlugin.PrimitiveType, PrimitiveType>of(info.scce.dime.gUIPlugin.PrimitiveType.TIMESTAMP, PrimitiveType.TIMESTAMP));
  
  private static final HashMap<PrimitiveType, Class<? extends InputStatic>> STATIC_INPUT_TYPE = CollectionLiterals.<PrimitiveType, Class<? extends InputStatic>>newHashMap(
    Pair.<PrimitiveType, Class<? extends InputStatic>>of(PrimitiveType.BOOLEAN, BooleanInputStatic.class), 
    Pair.<PrimitiveType, Class<? extends InputStatic>>of(PrimitiveType.TEXT, TextInputStatic.class), 
    Pair.<PrimitiveType, Class<? extends InputStatic>>of(PrimitiveType.INTEGER, IntegerInputStatic.class), 
    Pair.<PrimitiveType, Class<? extends InputStatic>>of(PrimitiveType.REAL, RealInputStatic.class), 
    Pair.<PrimitiveType, Class<? extends InputStatic>>of(PrimitiveType.TIMESTAMP, TimestampInputStatic.class));
  
  public static PrimitiveType toPrimitiveType(final IO type) {
    PrimitiveType _xblockexpression = null;
    {
      final Function1<Class, Boolean> _function = new Function1<Class, Boolean>() {
        @Override
        public Boolean apply(final Class clazz) {
          return Boolean.valueOf(clazz.isInstance(type));
        }
      };
      final Class key = IterableExtensions.<Class>findFirst(Iterables.<Class>filter(PortUtils.PRIMITIVE_TYPE.keySet(), Class.class), _function);
      Object _elvis = null;
      if (key != null) {
        _elvis = key;
      } else {
        Class<? extends IO> _class = type.getClass();
        _elvis = _class;
      }
      _xblockexpression = PortUtils.PRIMITIVE_TYPE.get(_elvis);
    }
    return _xblockexpression;
  }
  
  public static PrimitiveType toPrimitiveType(final Enumerator type) {
    return PortUtils.PRIMITIVE_TYPE.get(type);
  }
  
  public static Class<? extends InputStatic> toStaticInputType(final PrimitiveType type) {
    return PortUtils.STATIC_INPUT_TYPE.get(type);
  }
  
  protected static IO _addInput(final DataFlowTarget dft, final Object portReference) {
    Input _switchResult = null;
    boolean _matched = false;
    if (portReference instanceof ComplexOutputPort) {
      _matched=true;
      ComplexInputPort _newComplexInputPort = dft.newComplexInputPort(((ComplexOutputPort)portReference).getDataType(), 0, 0);
      final Procedure1<ComplexInputPort> _function = new Procedure1<ComplexInputPort>() {
        @Override
        public void apply(final ComplexInputPort it) {
          it.setName(((ComplexOutputPort)portReference).getName());
          it.setIsList(((ComplexOutputPort)portReference).isIsList());
        }
      };
      _switchResult = ObjectExtensions.<ComplexInputPort>operator_doubleArrow(_newComplexInputPort, _function);
    }
    if (!_matched) {
      if (portReference instanceof PrimitiveOutputPort) {
        _matched=true;
        PrimitiveInputPort _newPrimitiveInputPort = dft.newPrimitiveInputPort(0, 0);
        final Procedure1<PrimitiveInputPort> _function = new Procedure1<PrimitiveInputPort>() {
          @Override
          public void apply(final PrimitiveInputPort it) {
            it.setName(((PrimitiveOutputPort)portReference).getName());
            it.setIsList(((PrimitiveOutputPort)portReference).isIsList());
            it.setDataType(((PrimitiveOutputPort)portReference).getDataType());
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveInputPort>operator_doubleArrow(_newPrimitiveInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof JavaNativeOutputPort) {
        _matched=true;
        JavaNativeInputPort _newJavaNativeInputPort = dft.newJavaNativeInputPort(((JavaNativeOutputPort)portReference).getDataType(), 0, 0);
        final Procedure1<JavaNativeInputPort> _function = new Procedure1<JavaNativeInputPort>() {
          @Override
          public void apply(final JavaNativeInputPort it) {
            it.setName(((JavaNativeOutputPort)portReference).getName());
            it.setIsList(((JavaNativeOutputPort)portReference).isIsList());
          }
        };
        _switchResult = ObjectExtensions.<JavaNativeInputPort>operator_doubleArrow(_newJavaNativeInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof ComplexInputPort) {
        _matched=true;
        ComplexInputPort _newComplexInputPort = dft.newComplexInputPort(((ComplexInputPort)portReference).getDataType(), 0, 0);
        final Procedure1<ComplexInputPort> _function = new Procedure1<ComplexInputPort>() {
          @Override
          public void apply(final ComplexInputPort it) {
            it.setName(((ComplexInputPort)portReference).getName());
            it.setIsList(((ComplexInputPort)portReference).isIsList());
          }
        };
        _switchResult = ObjectExtensions.<ComplexInputPort>operator_doubleArrow(_newComplexInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof PrimitiveInputPort) {
        _matched=true;
        PrimitiveInputPort _newPrimitiveInputPort = dft.newPrimitiveInputPort(0, 0);
        final Procedure1<PrimitiveInputPort> _function = new Procedure1<PrimitiveInputPort>() {
          @Override
          public void apply(final PrimitiveInputPort it) {
            it.setName(((PrimitiveInputPort)portReference).getName());
            it.setIsList(((PrimitiveInputPort)portReference).isIsList());
            it.setDataType(((PrimitiveInputPort)portReference).getDataType());
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveInputPort>operator_doubleArrow(_newPrimitiveInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof InputStatic) {
        _matched=true;
        PrimitiveInputPort _newPrimitiveInputPort = dft.newPrimitiveInputPort(0, 0);
        final Procedure1<PrimitiveInputPort> _function = new Procedure1<PrimitiveInputPort>() {
          @Override
          public void apply(final PrimitiveInputPort it) {
            it.setName(((InputStatic)portReference).getName());
            it.setIsList(false);
            it.setDataType(PortUtils.toPrimitiveType(((IO)portReference)));
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveInputPort>operator_doubleArrow(_newPrimitiveInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof JavaNativeInputPort) {
        _matched=true;
        JavaNativeInputPort _newJavaNativeInputPort = dft.newJavaNativeInputPort(((JavaNativeInputPort)portReference).getDataType(), 0, 0);
        final Procedure1<JavaNativeInputPort> _function = new Procedure1<JavaNativeInputPort>() {
          @Override
          public void apply(final JavaNativeInputPort it) {
            it.setName(((JavaNativeInputPort)portReference).getName());
            it.setIsList(((JavaNativeInputPort)portReference).isIsList());
          }
        };
        _switchResult = ObjectExtensions.<JavaNativeInputPort>operator_doubleArrow(_newJavaNativeInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof ComplexVariable) {
        _matched=true;
        ComplexInputPort _newComplexInputPort = dft.newComplexInputPort(((ComplexVariable)portReference).getDataType(), 0, 0);
        final Procedure1<ComplexInputPort> _function = new Procedure1<ComplexInputPort>() {
          @Override
          public void apply(final ComplexInputPort it) {
            it.setName(((ComplexVariable)portReference).getName());
            it.setIsList(((ComplexVariable)portReference).isIsList());
          }
        };
        _switchResult = ObjectExtensions.<ComplexInputPort>operator_doubleArrow(_newComplexInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof PrimitiveVariable) {
        _matched=true;
        PrimitiveInputPort _newPrimitiveInputPort = dft.newPrimitiveInputPort(0, 0);
        final Procedure1<PrimitiveInputPort> _function = new Procedure1<PrimitiveInputPort>() {
          @Override
          public void apply(final PrimitiveInputPort it) {
            it.setName(((PrimitiveVariable)portReference).getName());
            it.setIsList(((PrimitiveVariable)portReference).isIsList());
            it.setDataType(PortUtils.toPrimitiveType(((PrimitiveVariable)portReference).getDataType()));
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveInputPort>operator_doubleArrow(_newPrimitiveInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof Type) {
        _matched=true;
        ComplexInputPort _newComplexInputPort = dft.newComplexInputPort(((EObject)portReference), 0, 0);
        final Procedure1<ComplexInputPort> _function = new Procedure1<ComplexInputPort>() {
          @Override
          public void apply(final ComplexInputPort it) {
            String _elvis = null;
            String _name = ((Type)portReference).getName();
            String _replace = null;
            if (_name!=null) {
              _replace=_name.replace(" ", "");
            }
            String _firstLower = StringExtensions.toFirstLower(_replace.trim());
            if (_firstLower != null) {
              _elvis = _firstLower;
            } else {
              _elvis = "";
            }
            it.setName(_elvis);
            it.setIsList(false);
          }
        };
        _switchResult = ObjectExtensions.<ComplexInputPort>operator_doubleArrow(_newComplexInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof PrimitiveType) {
        _matched=true;
        PrimitiveInputPort _newPrimitiveInputPort = dft.newPrimitiveInputPort(0, 0);
        final Procedure1<PrimitiveInputPort> _function = new Procedure1<PrimitiveInputPort>() {
          @Override
          public void apply(final PrimitiveInputPort it) {
            String _elvis = null;
            String _name = ((PrimitiveType)portReference).getName();
            String _replace = null;
            if (_name!=null) {
              _replace=_name.replace(" ", "");
            }
            String _firstLower = StringExtensions.toFirstLower(_replace.trim());
            if (_firstLower != null) {
              _elvis = _firstLower;
            } else {
              _elvis = "";
            }
            it.setName(_elvis);
            it.setIsList(false);
            it.setDataType(((PrimitiveType)portReference));
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveInputPort>operator_doubleArrow(_newPrimitiveInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof PrimitivePort) {
        _matched=true;
        PrimitiveInputPort _newPrimitiveInputPort = dft.newPrimitiveInputPort(0, 0);
        final Procedure1<PrimitiveInputPort> _function = new Procedure1<PrimitiveInputPort>() {
          @Override
          public void apply(final PrimitiveInputPort it) {
            it.setName(((PrimitivePort)portReference).getName());
            it.setIsList(((PrimitivePort)portReference).isIsList());
            it.setDataType(PortUtils.toPrimitiveType(((PrimitivePort)portReference).getType()));
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveInputPort>operator_doubleArrow(_newPrimitiveInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof JavaTypePort) {
        _matched=true;
        JavaNativeInputPort _newJavaNativeInputPort = dft.newJavaNativeInputPort(((JavaTypePort)portReference).getType(), 0, 0);
        final Procedure1<JavaNativeInputPort> _function = new Procedure1<JavaNativeInputPort>() {
          @Override
          public void apply(final JavaNativeInputPort it) {
            it.setName(((JavaTypePort)portReference).getName());
            it.setIsList(((JavaTypePort)portReference).isIsList());
          }
        };
        _switchResult = ObjectExtensions.<JavaNativeInputPort>operator_doubleArrow(_newJavaNativeInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof DataTypePort) {
        _matched=true;
        ComplexInputPort _newComplexInputPort = dft.newComplexInputPort(((DataTypePort)portReference).getType(), 0, 0);
        final Procedure1<ComplexInputPort> _function = new Procedure1<ComplexInputPort>() {
          @Override
          public void apply(final ComplexInputPort it) {
            it.setName(((DataTypePort)portReference).getName());
            it.setIsList(((DataTypePort)portReference).isIsList());
          }
        };
        _switchResult = ObjectExtensions.<ComplexInputPort>operator_doubleArrow(_newComplexInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof PrimitiveInputParameter) {
        _matched=true;
        PrimitiveInputPort _newPrimitiveInputPort = dft.newPrimitiveInputPort(0, 0);
        final Procedure1<PrimitiveInputPort> _function = new Procedure1<PrimitiveInputPort>() {
          @Override
          public void apply(final PrimitiveInputPort it) {
            it.setName(((PrimitiveInputParameter)portReference).getName());
            it.setIsList(false);
            it.setDataType(PortUtils.toPrimitiveType(((PrimitiveInputParameter)portReference).getDataType()));
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveInputPort>operator_doubleArrow(_newPrimitiveInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof ProcessPlaceholderSIB) {
        _matched=true;
        ProcessInputStatic _newProcessInputStatic = dft.newProcessInputStatic(((ProcessPlaceholderSIB)portReference).getProMod(), 0, 0);
        final Procedure1<ProcessInputStatic> _function = new Procedure1<ProcessInputStatic>() {
          @Override
          public void apply(final ProcessInputStatic it) {
            it.setName(((ProcessPlaceholderSIB)portReference).getLabel());
          }
        };
        _switchResult = ObjectExtensions.<ProcessInputStatic>operator_doubleArrow(_newProcessInputStatic, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof ComplexAttribute) {
        _matched=true;
        ComplexInputPort _newComplexInputPort = dft.newComplexInputPort(((ComplexAttribute)portReference).getDataType(), 0, 0);
        final Procedure1<ComplexInputPort> _function = new Procedure1<ComplexInputPort>() {
          @Override
          public void apply(final ComplexInputPort it) {
            it.setName(((ComplexAttribute)portReference).getName());
            it.setIsList(((ComplexAttribute)portReference).isIsList());
          }
        };
        _switchResult = ObjectExtensions.<ComplexInputPort>operator_doubleArrow(_newComplexInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof PrimitiveAttribute) {
        _matched=true;
        PrimitiveInputPort _newPrimitiveInputPort = dft.newPrimitiveInputPort(0, 0);
        final Procedure1<PrimitiveInputPort> _function = new Procedure1<PrimitiveInputPort>() {
          @Override
          public void apply(final PrimitiveInputPort it) {
            it.setName(((PrimitiveAttribute)portReference).getName());
            it.setIsList(((PrimitiveAttribute)portReference).isIsList());
            it.setDataType(PortUtils.toPrimitiveType(((PrimitiveAttribute)portReference).getDataType()));
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveInputPort>operator_doubleArrow(_newPrimitiveInputPort, _function);
      }
    }
    if (!_matched) {
      throw new PortUtils.SwitchException();
    }
    return _switchResult;
  }
  
  protected static IO _addInput(final EventListener dft, final Object portReference) {
    IO _switchResult = null;
    boolean _matched = false;
    if (portReference instanceof ComplexOutputPort) {
      _matched=true;
      ComplexInputPort _newComplexInputPort = dft.newComplexInputPort(((ComplexOutputPort)portReference).getDataType(), 0, 0);
      final Procedure1<ComplexInputPort> _function = new Procedure1<ComplexInputPort>() {
        @Override
        public void apply(final ComplexInputPort it) {
          it.setName(((ComplexOutputPort)portReference).getName());
          it.setIsList(((ComplexOutputPort)portReference).isIsList());
        }
      };
      _switchResult = ObjectExtensions.<ComplexInputPort>operator_doubleArrow(_newComplexInputPort, _function);
    }
    if (!_matched) {
      if (portReference instanceof PrimitiveOutputPort) {
        _matched=true;
        PrimitiveInputPort _newPrimitiveInputPort = dft.newPrimitiveInputPort(0, 0);
        final Procedure1<PrimitiveInputPort> _function = new Procedure1<PrimitiveInputPort>() {
          @Override
          public void apply(final PrimitiveInputPort it) {
            it.setName(((PrimitiveOutputPort)portReference).getName());
            it.setIsList(((PrimitiveOutputPort)portReference).isIsList());
            it.setDataType(((PrimitiveOutputPort)portReference).getDataType());
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveInputPort>operator_doubleArrow(_newPrimitiveInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof JavaNativeOutputPort) {
        _matched=true;
        JavaNativeInputPort _newJavaNativeInputPort = dft.newJavaNativeInputPort(((JavaNativeOutputPort)portReference).getDataType(), 0, 0);
        final Procedure1<JavaNativeInputPort> _function = new Procedure1<JavaNativeInputPort>() {
          @Override
          public void apply(final JavaNativeInputPort it) {
            it.setName(((JavaNativeOutputPort)portReference).getName());
            it.setIsList(((JavaNativeOutputPort)portReference).isIsList());
          }
        };
        _switchResult = ObjectExtensions.<JavaNativeInputPort>operator_doubleArrow(_newJavaNativeInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof ComplexInputPort) {
        _matched=true;
        ComplexInputPort _newComplexInputPort = dft.newComplexInputPort(((ComplexInputPort)portReference).getDataType(), 0, 0);
        final Procedure1<ComplexInputPort> _function = new Procedure1<ComplexInputPort>() {
          @Override
          public void apply(final ComplexInputPort it) {
            it.setName(((ComplexInputPort)portReference).getName());
            it.setIsList(((ComplexInputPort)portReference).isIsList());
          }
        };
        _switchResult = ObjectExtensions.<ComplexInputPort>operator_doubleArrow(_newComplexInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof PrimitiveInputPort) {
        _matched=true;
        PrimitiveInputPort _newPrimitiveInputPort = dft.newPrimitiveInputPort(0, 0);
        final Procedure1<PrimitiveInputPort> _function = new Procedure1<PrimitiveInputPort>() {
          @Override
          public void apply(final PrimitiveInputPort it) {
            it.setName(((PrimitiveInputPort)portReference).getName());
            it.setIsList(((PrimitiveInputPort)portReference).isIsList());
            it.setDataType(((PrimitiveInputPort)portReference).getDataType());
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveInputPort>operator_doubleArrow(_newPrimitiveInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof InputStatic) {
        _matched=true;
        PrimitiveInputPort _newPrimitiveInputPort = dft.newPrimitiveInputPort(0, 0);
        final Procedure1<PrimitiveInputPort> _function = new Procedure1<PrimitiveInputPort>() {
          @Override
          public void apply(final PrimitiveInputPort it) {
            it.setName(((InputStatic)portReference).getName());
            it.setIsList(false);
            it.setDataType(PortUtils.toPrimitiveType(((IO)portReference)));
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveInputPort>operator_doubleArrow(_newPrimitiveInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof JavaNativeInputPort) {
        _matched=true;
        JavaNativeInputPort _newJavaNativeInputPort = dft.newJavaNativeInputPort(((JavaNativeInputPort)portReference).getDataType(), 0, 0);
        final Procedure1<JavaNativeInputPort> _function = new Procedure1<JavaNativeInputPort>() {
          @Override
          public void apply(final JavaNativeInputPort it) {
            it.setName(((JavaNativeInputPort)portReference).getName());
            it.setIsList(((JavaNativeInputPort)portReference).isIsList());
          }
        };
        _switchResult = ObjectExtensions.<JavaNativeInputPort>operator_doubleArrow(_newJavaNativeInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof ComplexVariable) {
        _matched=true;
        ComplexInputPort _newComplexInputPort = dft.newComplexInputPort(((ComplexVariable)portReference).getDataType(), 0, 0);
        final Procedure1<ComplexInputPort> _function = new Procedure1<ComplexInputPort>() {
          @Override
          public void apply(final ComplexInputPort it) {
            it.setName(((ComplexVariable)portReference).getName());
            it.setIsList(((ComplexVariable)portReference).isIsList());
          }
        };
        _switchResult = ObjectExtensions.<ComplexInputPort>operator_doubleArrow(_newComplexInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof PrimitiveVariable) {
        _matched=true;
        PrimitiveInputPort _newPrimitiveInputPort = dft.newPrimitiveInputPort(0, 0);
        final Procedure1<PrimitiveInputPort> _function = new Procedure1<PrimitiveInputPort>() {
          @Override
          public void apply(final PrimitiveInputPort it) {
            it.setName(((PrimitiveVariable)portReference).getName());
            it.setIsList(((PrimitiveVariable)portReference).isIsList());
            it.setDataType(PortUtils.toPrimitiveType(((PrimitiveVariable)portReference).getDataType()));
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveInputPort>operator_doubleArrow(_newPrimitiveInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof Type) {
        _matched=true;
        ComplexInputPort _newComplexInputPort = dft.newComplexInputPort(((EObject)portReference), 0, 0);
        final Procedure1<ComplexInputPort> _function = new Procedure1<ComplexInputPort>() {
          @Override
          public void apply(final ComplexInputPort it) {
            String _elvis = null;
            String _name = ((Type)portReference).getName();
            String _replace = null;
            if (_name!=null) {
              _replace=_name.replace(" ", "");
            }
            String _firstLower = StringExtensions.toFirstLower(_replace.trim());
            if (_firstLower != null) {
              _elvis = _firstLower;
            } else {
              _elvis = "";
            }
            it.setName(_elvis);
            it.setIsList(false);
          }
        };
        _switchResult = ObjectExtensions.<ComplexInputPort>operator_doubleArrow(_newComplexInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof PrimitiveType) {
        _matched=true;
        PrimitiveInputPort _newPrimitiveInputPort = dft.newPrimitiveInputPort(0, 0);
        final Procedure1<PrimitiveInputPort> _function = new Procedure1<PrimitiveInputPort>() {
          @Override
          public void apply(final PrimitiveInputPort it) {
            String _elvis = null;
            String _name = ((PrimitiveType)portReference).getName();
            String _replace = null;
            if (_name!=null) {
              _replace=_name.replace(" ", "");
            }
            String _firstLower = StringExtensions.toFirstLower(_replace.trim());
            if (_firstLower != null) {
              _elvis = _firstLower;
            } else {
              _elvis = "";
            }
            it.setName(_elvis);
            it.setIsList(false);
            it.setDataType(((PrimitiveType)portReference));
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveInputPort>operator_doubleArrow(_newPrimitiveInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof PrimitivePort) {
        _matched=true;
        PrimitiveInputPort _newPrimitiveInputPort = dft.newPrimitiveInputPort(0, 0);
        final Procedure1<PrimitiveInputPort> _function = new Procedure1<PrimitiveInputPort>() {
          @Override
          public void apply(final PrimitiveInputPort it) {
            it.setName(((PrimitivePort)portReference).getName());
            it.setIsList(((PrimitivePort)portReference).isIsList());
            it.setDataType(PortUtils.toPrimitiveType(((PrimitivePort)portReference).getType()));
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveInputPort>operator_doubleArrow(_newPrimitiveInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof JavaTypePort) {
        _matched=true;
        JavaNativeInputPort _newJavaNativeInputPort = dft.newJavaNativeInputPort(((JavaTypePort)portReference).getType(), 0, 0);
        final Procedure1<JavaNativeInputPort> _function = new Procedure1<JavaNativeInputPort>() {
          @Override
          public void apply(final JavaNativeInputPort it) {
            it.setName(((JavaTypePort)portReference).getName());
            it.setIsList(((JavaTypePort)portReference).isIsList());
          }
        };
        _switchResult = ObjectExtensions.<JavaNativeInputPort>operator_doubleArrow(_newJavaNativeInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof PrimitiveInputParameter) {
        _matched=true;
        PrimitiveInputPort _newPrimitiveInputPort = dft.newPrimitiveInputPort(0, 0);
        final Procedure1<PrimitiveInputPort> _function = new Procedure1<PrimitiveInputPort>() {
          @Override
          public void apply(final PrimitiveInputPort it) {
            it.setName(((PrimitiveInputParameter)portReference).getName());
            it.setIsList(false);
            it.setDataType(PortUtils.toPrimitiveType(((PrimitiveInputParameter)portReference).getDataType()));
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveInputPort>operator_doubleArrow(_newPrimitiveInputPort, _function);
      }
    }
    if (!_matched) {
      if (portReference instanceof ModelElement) {
        _matched=true;
        _switchResult = PortUtils.addInput(dft, portReference);
      }
    }
    if (!_matched) {
      throw new PortUtils.SwitchException();
    }
    return _switchResult;
  }
  
  protected static Input _clonePort(final DataFlowTarget dft, final Input port) {
    Input _switchResult = null;
    boolean _matched = false;
    if (port instanceof PrimitiveInputPort) {
      _matched=true;
      PrimitiveInputPort _newPrimitiveInputPort = dft.newPrimitiveInputPort(((PrimitiveInputPort)port).getX(), ((PrimitiveInputPort)port).getY());
      final Procedure1<PrimitiveInputPort> _function = new Procedure1<PrimitiveInputPort>() {
        @Override
        public void apply(final PrimitiveInputPort it) {
          it.setName(((PrimitiveInputPort)port).getName());
          it.setIsList(((PrimitiveInputPort)port).isIsList());
          it.setDataType(((PrimitiveInputPort)port).getDataType());
        }
      };
      _switchResult = ObjectExtensions.<PrimitiveInputPort>operator_doubleArrow(_newPrimitiveInputPort, _function);
    }
    if (!_matched) {
      if (port instanceof ComplexInputPort) {
        _matched=true;
        ComplexInputPort _newComplexInputPort = dft.newComplexInputPort(
          ((ComplexInputPort) port).getDataType(), ((ComplexInputPort)port).getX(), ((ComplexInputPort)port).getY());
        final Procedure1<ComplexInputPort> _function = new Procedure1<ComplexInputPort>() {
          @Override
          public void apply(final ComplexInputPort it) {
            it.setName(((ComplexInputPort)port).getName());
            it.setIsList(((ComplexInputPort)port).isIsList());
          }
        };
        _switchResult = ObjectExtensions.<ComplexInputPort>operator_doubleArrow(_newComplexInputPort, _function);
      }
    }
    if (!_matched) {
      if (port instanceof JavaNativeInputPort) {
        _matched=true;
        JavaNativeInputPort _newJavaNativeInputPort = dft.newJavaNativeInputPort(
          ((JavaNativeInputPort) port).getDataType(), ((JavaNativeInputPort)port).getX(), ((JavaNativeInputPort)port).getY());
        final Procedure1<JavaNativeInputPort> _function = new Procedure1<JavaNativeInputPort>() {
          @Override
          public void apply(final JavaNativeInputPort it) {
            it.setName(((JavaNativeInputPort)port).getName());
            it.setIsList(((JavaNativeInputPort)port).isIsList());
          }
        };
        _switchResult = ObjectExtensions.<JavaNativeInputPort>operator_doubleArrow(_newJavaNativeInputPort, _function);
      }
    }
    if (!_matched) {
      if (port instanceof BooleanInputStatic) {
        _matched=true;
        BooleanInputStatic _newBooleanInputStatic = dft.newBooleanInputStatic(((BooleanInputStatic)port).getX(), ((BooleanInputStatic)port).getY());
        final Procedure1<BooleanInputStatic> _function = new Procedure1<BooleanInputStatic>() {
          @Override
          public void apply(final BooleanInputStatic it) {
            it.setName(((BooleanInputStatic)port).getName());
            it.setValue(((BooleanInputStatic)port).isValue());
          }
        };
        _switchResult = ObjectExtensions.<BooleanInputStatic>operator_doubleArrow(_newBooleanInputStatic, _function);
      }
    }
    if (!_matched) {
      if (port instanceof IntegerInputStatic) {
        _matched=true;
        IntegerInputStatic _newIntegerInputStatic = dft.newIntegerInputStatic(((IntegerInputStatic)port).getX(), ((IntegerInputStatic)port).getY());
        final Procedure1<IntegerInputStatic> _function = new Procedure1<IntegerInputStatic>() {
          @Override
          public void apply(final IntegerInputStatic it) {
            it.setName(((IntegerInputStatic)port).getName());
            it.setValue(((IntegerInputStatic)port).getValue());
          }
        };
        _switchResult = ObjectExtensions.<IntegerInputStatic>operator_doubleArrow(_newIntegerInputStatic, _function);
      }
    }
    if (!_matched) {
      if (port instanceof RealInputStatic) {
        _matched=true;
        RealInputStatic _newRealInputStatic = dft.newRealInputStatic(((RealInputStatic)port).getX(), ((RealInputStatic)port).getY());
        final Procedure1<RealInputStatic> _function = new Procedure1<RealInputStatic>() {
          @Override
          public void apply(final RealInputStatic it) {
            it.setName(((RealInputStatic)port).getName());
            it.setValue(((RealInputStatic)port).getValue());
          }
        };
        _switchResult = ObjectExtensions.<RealInputStatic>operator_doubleArrow(_newRealInputStatic, _function);
      }
    }
    if (!_matched) {
      if (port instanceof TextInputStatic) {
        _matched=true;
        TextInputStatic _newTextInputStatic = dft.newTextInputStatic(((TextInputStatic)port).getX(), ((TextInputStatic)port).getY());
        final Procedure1<TextInputStatic> _function = new Procedure1<TextInputStatic>() {
          @Override
          public void apply(final TextInputStatic it) {
            it.setName(((TextInputStatic)port).getName());
            it.setValue(((TextInputStatic)port).getValue());
          }
        };
        _switchResult = ObjectExtensions.<TextInputStatic>operator_doubleArrow(_newTextInputStatic, _function);
      }
    }
    if (!_matched) {
      if (port instanceof TimestampInputStatic) {
        _matched=true;
        TimestampInputStatic _newTimestampInputStatic = dft.newTimestampInputStatic(((TimestampInputStatic)port).getX(), ((TimestampInputStatic)port).getY());
        final Procedure1<TimestampInputStatic> _function = new Procedure1<TimestampInputStatic>() {
          @Override
          public void apply(final TimestampInputStatic it) {
            it.setName(((TimestampInputStatic)port).getName());
            it.setValue(((TimestampInputStatic)port).getValue());
          }
        };
        _switchResult = ObjectExtensions.<TimestampInputStatic>operator_doubleArrow(_newTimestampInputStatic, _function);
      }
    }
    if (!_matched) {
      throw new PortUtils.SwitchException();
    }
    return _switchResult;
  }
  
  protected static Input _clonePort(final EventListener dft, final Input port) {
    Input _switchResult = null;
    boolean _matched = false;
    if (port instanceof PrimitiveInputPort) {
      _matched=true;
      PrimitiveInputPort _newPrimitiveInputPort = dft.newPrimitiveInputPort(((PrimitiveInputPort)port).getX(), ((PrimitiveInputPort)port).getY());
      final Procedure1<PrimitiveInputPort> _function = new Procedure1<PrimitiveInputPort>() {
        @Override
        public void apply(final PrimitiveInputPort it) {
          it.setName(((PrimitiveInputPort)port).getName());
          it.setIsList(((PrimitiveInputPort)port).isIsList());
          it.setDataType(((PrimitiveInputPort)port).getDataType());
        }
      };
      _switchResult = ObjectExtensions.<PrimitiveInputPort>operator_doubleArrow(_newPrimitiveInputPort, _function);
    }
    if (!_matched) {
      if (port instanceof ComplexInputPort) {
        _matched=true;
        ComplexInputPort _newComplexInputPort = dft.newComplexInputPort(
          ((ComplexInputPort) port).getDataType(), ((ComplexInputPort)port).getX(), ((ComplexInputPort)port).getY());
        final Procedure1<ComplexInputPort> _function = new Procedure1<ComplexInputPort>() {
          @Override
          public void apply(final ComplexInputPort it) {
            it.setName(((ComplexInputPort)port).getName());
            it.setIsList(((ComplexInputPort)port).isIsList());
          }
        };
        _switchResult = ObjectExtensions.<ComplexInputPort>operator_doubleArrow(_newComplexInputPort, _function);
      }
    }
    if (!_matched) {
      if (port instanceof JavaNativeInputPort) {
        _matched=true;
        JavaNativeInputPort _newJavaNativeInputPort = dft.newJavaNativeInputPort(
          ((JavaNativeInputPort) port).getDataType(), ((JavaNativeInputPort)port).getX(), ((JavaNativeInputPort)port).getY());
        final Procedure1<JavaNativeInputPort> _function = new Procedure1<JavaNativeInputPort>() {
          @Override
          public void apply(final JavaNativeInputPort it) {
            it.setName(((JavaNativeInputPort)port).getName());
            it.setIsList(((JavaNativeInputPort)port).isIsList());
          }
        };
        _switchResult = ObjectExtensions.<JavaNativeInputPort>operator_doubleArrow(_newJavaNativeInputPort, _function);
      }
    }
    if (!_matched) {
      if (port instanceof BooleanInputStatic) {
        _matched=true;
        BooleanInputStatic _newBooleanInputStatic = dft.newBooleanInputStatic(((BooleanInputStatic)port).getX(), ((BooleanInputStatic)port).getY());
        final Procedure1<BooleanInputStatic> _function = new Procedure1<BooleanInputStatic>() {
          @Override
          public void apply(final BooleanInputStatic it) {
            it.setName(((BooleanInputStatic)port).getName());
            it.setValue(((BooleanInputStatic)port).isValue());
          }
        };
        _switchResult = ObjectExtensions.<BooleanInputStatic>operator_doubleArrow(_newBooleanInputStatic, _function);
      }
    }
    if (!_matched) {
      if (port instanceof IntegerInputStatic) {
        _matched=true;
        IntegerInputStatic _newIntegerInputStatic = dft.newIntegerInputStatic(((IntegerInputStatic)port).getX(), ((IntegerInputStatic)port).getY());
        final Procedure1<IntegerInputStatic> _function = new Procedure1<IntegerInputStatic>() {
          @Override
          public void apply(final IntegerInputStatic it) {
            it.setName(((IntegerInputStatic)port).getName());
            it.setValue(((IntegerInputStatic)port).getValue());
          }
        };
        _switchResult = ObjectExtensions.<IntegerInputStatic>operator_doubleArrow(_newIntegerInputStatic, _function);
      }
    }
    if (!_matched) {
      if (port instanceof RealInputStatic) {
        _matched=true;
        RealInputStatic _newRealInputStatic = dft.newRealInputStatic(((RealInputStatic)port).getX(), ((RealInputStatic)port).getY());
        final Procedure1<RealInputStatic> _function = new Procedure1<RealInputStatic>() {
          @Override
          public void apply(final RealInputStatic it) {
            it.setName(((RealInputStatic)port).getName());
            it.setValue(((RealInputStatic)port).getValue());
          }
        };
        _switchResult = ObjectExtensions.<RealInputStatic>operator_doubleArrow(_newRealInputStatic, _function);
      }
    }
    if (!_matched) {
      if (port instanceof TextInputStatic) {
        _matched=true;
        TextInputStatic _newTextInputStatic = dft.newTextInputStatic(((TextInputStatic)port).getX(), ((TextInputStatic)port).getY());
        final Procedure1<TextInputStatic> _function = new Procedure1<TextInputStatic>() {
          @Override
          public void apply(final TextInputStatic it) {
            it.setName(((TextInputStatic)port).getName());
            it.setValue(((TextInputStatic)port).getValue());
          }
        };
        _switchResult = ObjectExtensions.<TextInputStatic>operator_doubleArrow(_newTextInputStatic, _function);
      }
    }
    if (!_matched) {
      if (port instanceof TimestampInputStatic) {
        _matched=true;
        TimestampInputStatic _newTimestampInputStatic = dft.newTimestampInputStatic(((TimestampInputStatic)port).getX(), ((TimestampInputStatic)port).getY());
        final Procedure1<TimestampInputStatic> _function = new Procedure1<TimestampInputStatic>() {
          @Override
          public void apply(final TimestampInputStatic it) {
            it.setName(((TimestampInputStatic)port).getName());
            it.setValue(((TimestampInputStatic)port).getValue());
          }
        };
        _switchResult = ObjectExtensions.<TimestampInputStatic>operator_doubleArrow(_newTimestampInputStatic, _function);
      }
    }
    if (!_matched) {
      throw new PortUtils.SwitchException();
    }
    return _switchResult;
  }
  
  protected static InputStatic _addStaticPort(final DataFlowTarget dft, final PrimitiveInputPort archetype) {
    InputStatic _switchResult = null;
    PrimitiveType _dataType = archetype.getDataType();
    if (_dataType != null) {
      switch (_dataType) {
        case BOOLEAN:
          _switchResult = dft.newBooleanInputStatic(archetype.getX(), archetype.getY());
          break;
        case INTEGER:
          _switchResult = dft.newIntegerInputStatic(archetype.getX(), archetype.getY());
          break;
        case REAL:
          _switchResult = dft.newRealInputStatic(archetype.getX(), archetype.getY());
          break;
        case TEXT:
          _switchResult = dft.newTextInputStatic(archetype.getX(), archetype.getY());
          break;
        case TIMESTAMP:
          _switchResult = dft.newTimestampInputStatic(archetype.getX(), archetype.getY());
          break;
        default:
          throw new PortUtils.SwitchException();
      }
    } else {
      throw new PortUtils.SwitchException();
    }
    final Procedure1<InputStatic> _function = new Procedure1<InputStatic>() {
      @Override
      public void apply(final InputStatic it) {
        it.setName(archetype.getName());
      }
    };
    return ObjectExtensions.<InputStatic>operator_doubleArrow(_switchResult, _function);
  }
  
  protected static InputStatic _addStaticPort(final DataFlowTarget dft, final InputStatic archetype) {
    InputStatic _switchResult = null;
    boolean _matched = false;
    if (archetype instanceof BooleanInputStatic) {
      _matched=true;
      BooleanInputStatic _newBooleanInputStatic = dft.newBooleanInputStatic(((BooleanInputStatic)archetype).getX(), ((BooleanInputStatic)archetype).getY());
      final Procedure1<BooleanInputStatic> _function = new Procedure1<BooleanInputStatic>() {
        @Override
        public void apply(final BooleanInputStatic it) {
          it.setValue(((BooleanInputStatic)archetype).isValue());
        }
      };
      _switchResult = ObjectExtensions.<BooleanInputStatic>operator_doubleArrow(_newBooleanInputStatic, _function);
    }
    if (!_matched) {
      if (archetype instanceof IntegerInputStatic) {
        _matched=true;
        IntegerInputStatic _newIntegerInputStatic = dft.newIntegerInputStatic(((IntegerInputStatic)archetype).getX(), ((IntegerInputStatic)archetype).getY());
        final Procedure1<IntegerInputStatic> _function = new Procedure1<IntegerInputStatic>() {
          @Override
          public void apply(final IntegerInputStatic it) {
            it.setValue(((IntegerInputStatic)archetype).getValue());
          }
        };
        _switchResult = ObjectExtensions.<IntegerInputStatic>operator_doubleArrow(_newIntegerInputStatic, _function);
      }
    }
    if (!_matched) {
      if (archetype instanceof RealInputStatic) {
        _matched=true;
        RealInputStatic _newRealInputStatic = dft.newRealInputStatic(((RealInputStatic)archetype).getX(), ((RealInputStatic)archetype).getY());
        final Procedure1<RealInputStatic> _function = new Procedure1<RealInputStatic>() {
          @Override
          public void apply(final RealInputStatic it) {
            it.setValue(((RealInputStatic)archetype).getValue());
          }
        };
        _switchResult = ObjectExtensions.<RealInputStatic>operator_doubleArrow(_newRealInputStatic, _function);
      }
    }
    if (!_matched) {
      if (archetype instanceof TextInputStatic) {
        _matched=true;
        TextInputStatic _newTextInputStatic = dft.newTextInputStatic(((TextInputStatic)archetype).getX(), ((TextInputStatic)archetype).getY());
        final Procedure1<TextInputStatic> _function = new Procedure1<TextInputStatic>() {
          @Override
          public void apply(final TextInputStatic it) {
            it.setValue(((TextInputStatic)archetype).getValue());
          }
        };
        _switchResult = ObjectExtensions.<TextInputStatic>operator_doubleArrow(_newTextInputStatic, _function);
      }
    }
    if (!_matched) {
      if (archetype instanceof TimestampInputStatic) {
        _matched=true;
        TimestampInputStatic _newTimestampInputStatic = dft.newTimestampInputStatic(((TimestampInputStatic)archetype).getX(), ((TimestampInputStatic)archetype).getY());
        final Procedure1<TimestampInputStatic> _function = new Procedure1<TimestampInputStatic>() {
          @Override
          public void apply(final TimestampInputStatic it) {
            it.setValue(((TimestampInputStatic)archetype).getValue());
          }
        };
        _switchResult = ObjectExtensions.<TimestampInputStatic>operator_doubleArrow(_newTimestampInputStatic, _function);
      }
    }
    if (!_matched) {
      throw new PortUtils.SwitchException();
    }
    final Procedure1<InputStatic> _function = new Procedure1<InputStatic>() {
      @Override
      public void apply(final InputStatic it) {
        it.setName(archetype.getName());
      }
    };
    return ObjectExtensions.<InputStatic>operator_doubleArrow(_switchResult, _function);
  }
  
  protected static InputStatic _addStaticPort(final EventListener dft, final PrimitiveInputPort archetype) {
    InputStatic _switchResult = null;
    PrimitiveType _dataType = archetype.getDataType();
    if (_dataType != null) {
      switch (_dataType) {
        case BOOLEAN:
          _switchResult = dft.newBooleanInputStatic(archetype.getX(), archetype.getY());
          break;
        case INTEGER:
          _switchResult = dft.newIntegerInputStatic(archetype.getX(), archetype.getY());
          break;
        case REAL:
          _switchResult = dft.newRealInputStatic(archetype.getX(), archetype.getY());
          break;
        case TEXT:
          _switchResult = dft.newTextInputStatic(archetype.getX(), archetype.getY());
          break;
        case TIMESTAMP:
          _switchResult = dft.newTimestampInputStatic(archetype.getX(), archetype.getY());
          break;
        default:
          throw new PortUtils.SwitchException();
      }
    } else {
      throw new PortUtils.SwitchException();
    }
    final Procedure1<InputStatic> _function = new Procedure1<InputStatic>() {
      @Override
      public void apply(final InputStatic it) {
        it.setName(archetype.getName());
      }
    };
    return ObjectExtensions.<InputStatic>operator_doubleArrow(_switchResult, _function);
  }
  
  public static InputStatic cloneStaticPort(final InputStatic port) {
    ModelElementContainer _container = port.getContainer();
    return PortUtils.cloneStaticPort(((DataFlowTarget) _container), port);
  }
  
  public static InputStatic cloneStaticPort(final DataFlowTarget dft, final InputStatic port) {
    InputStatic _switchResult = null;
    boolean _matched = false;
    if (port instanceof BooleanInputStatic) {
      _matched=true;
      BooleanInputStatic _newBooleanInputStatic = dft.newBooleanInputStatic(((BooleanInputStatic)port).getX(), ((BooleanInputStatic)port).getY());
      final Procedure1<BooleanInputStatic> _function = new Procedure1<BooleanInputStatic>() {
        @Override
        public void apply(final BooleanInputStatic it) {
          it.setName(((BooleanInputStatic)port).getName());
          it.setValue(((BooleanInputStatic)port).isValue());
        }
      };
      _switchResult = ObjectExtensions.<BooleanInputStatic>operator_doubleArrow(_newBooleanInputStatic, _function);
    }
    if (!_matched) {
      if (port instanceof IntegerInputStatic) {
        _matched=true;
        IntegerInputStatic _newIntegerInputStatic = dft.newIntegerInputStatic(((IntegerInputStatic)port).getX(), ((IntegerInputStatic)port).getY());
        final Procedure1<IntegerInputStatic> _function = new Procedure1<IntegerInputStatic>() {
          @Override
          public void apply(final IntegerInputStatic it) {
            it.setName(((IntegerInputStatic)port).getName());
            it.setValue(((IntegerInputStatic)port).getValue());
          }
        };
        _switchResult = ObjectExtensions.<IntegerInputStatic>operator_doubleArrow(_newIntegerInputStatic, _function);
      }
    }
    if (!_matched) {
      if (port instanceof RealInputStatic) {
        _matched=true;
        RealInputStatic _newRealInputStatic = dft.newRealInputStatic(((RealInputStatic)port).getX(), ((RealInputStatic)port).getY());
        final Procedure1<RealInputStatic> _function = new Procedure1<RealInputStatic>() {
          @Override
          public void apply(final RealInputStatic it) {
            it.setName(((RealInputStatic)port).getName());
            it.setValue(((RealInputStatic)port).getValue());
          }
        };
        _switchResult = ObjectExtensions.<RealInputStatic>operator_doubleArrow(_newRealInputStatic, _function);
      }
    }
    if (!_matched) {
      if (port instanceof TextInputStatic) {
        _matched=true;
        TextInputStatic _newTextInputStatic = dft.newTextInputStatic(((TextInputStatic)port).getX(), ((TextInputStatic)port).getY());
        final Procedure1<TextInputStatic> _function = new Procedure1<TextInputStatic>() {
          @Override
          public void apply(final TextInputStatic it) {
            it.setName(((TextInputStatic)port).getName());
            it.setValue(((TextInputStatic)port).getValue());
          }
        };
        _switchResult = ObjectExtensions.<TextInputStatic>operator_doubleArrow(_newTextInputStatic, _function);
      }
    }
    if (!_matched) {
      if (port instanceof TimestampInputStatic) {
        _matched=true;
        TimestampInputStatic _newTimestampInputStatic = dft.newTimestampInputStatic(((TimestampInputStatic)port).getX(), ((TimestampInputStatic)port).getY());
        final Procedure1<TimestampInputStatic> _function = new Procedure1<TimestampInputStatic>() {
          @Override
          public void apply(final TimestampInputStatic it) {
            it.setName(((TimestampInputStatic)port).getName());
            it.setValue(((TimestampInputStatic)port).getValue());
          }
        };
        _switchResult = ObjectExtensions.<TimestampInputStatic>operator_doubleArrow(_newTimestampInputStatic, _function);
      }
    }
    if (!_matched) {
      if (port instanceof ProcessInputStatic) {
        _matched=true;
        ProcessInputStatic _newProcessInputStatic = dft.newProcessInputStatic(((ProcessInputStatic) port).getValue(), ((ProcessInputStatic)port).getX(), ((ProcessInputStatic)port).getY());
        final Procedure1<ProcessInputStatic> _function = new Procedure1<ProcessInputStatic>() {
          @Override
          public void apply(final ProcessInputStatic it) {
            it.setName(((ProcessInputStatic)port).getName());
          }
        };
        _switchResult = ObjectExtensions.<ProcessInputStatic>operator_doubleArrow(_newProcessInputStatic, _function);
      }
    }
    if (!_matched) {
      throw new PortUtils.SwitchException();
    }
    return _switchResult;
  }
  
  public OutputPort addOutput(final DataFlowSource branch, final Object ref) {
    OutputPort _switchResult = null;
    boolean _matched = false;
    if (ref instanceof ComplexInputPort) {
      _matched=true;
      ComplexOutputPort _newComplexOutputPort = branch.newComplexOutputPort(((ComplexInputPort)ref).getDataType(), 0, 0);
      final Procedure1<ComplexOutputPort> _function = new Procedure1<ComplexOutputPort>() {
        @Override
        public void apply(final ComplexOutputPort it) {
          it.setName(((ComplexInputPort)ref).getName());
          it.setIsList(((ComplexInputPort)ref).isIsList());
        }
      };
      _switchResult = ObjectExtensions.<ComplexOutputPort>operator_doubleArrow(_newComplexOutputPort, _function);
    }
    if (!_matched) {
      if (ref instanceof PrimitiveInputPort) {
        _matched=true;
        PrimitiveOutputPort _newPrimitiveOutputPort = branch.newPrimitiveOutputPort(0, 0);
        final Procedure1<PrimitiveOutputPort> _function = new Procedure1<PrimitiveOutputPort>() {
          @Override
          public void apply(final PrimitiveOutputPort it) {
            it.setName(((PrimitiveInputPort)ref).getName());
            it.setIsList(((PrimitiveInputPort)ref).isIsList());
            it.setDataType(((PrimitiveInputPort)ref).getDataType());
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveOutputPort>operator_doubleArrow(_newPrimitiveOutputPort, _function);
      }
    }
    if (!_matched) {
      if (ref instanceof JavaNativeInputPort) {
        _matched=true;
        JavaNativeOutputPort _newJavaNativeOutputPort = branch.newJavaNativeOutputPort(((JavaNativeInputPort)ref).getDataType(), 0, 0);
        final Procedure1<JavaNativeOutputPort> _function = new Procedure1<JavaNativeOutputPort>() {
          @Override
          public void apply(final JavaNativeOutputPort it) {
            it.setName(((JavaNativeInputPort)ref).getName());
            it.setIsList(((JavaNativeInputPort)ref).isIsList());
          }
        };
        _switchResult = ObjectExtensions.<JavaNativeOutputPort>operator_doubleArrow(_newJavaNativeOutputPort, _function);
      }
    }
    if (!_matched) {
      if (ref instanceof PrimitiveOutputPort) {
        _matched=true;
        PrimitiveOutputPort _newPrimitiveOutputPort = branch.newPrimitiveOutputPort(0, 0);
        final Procedure1<PrimitiveOutputPort> _function = new Procedure1<PrimitiveOutputPort>() {
          @Override
          public void apply(final PrimitiveOutputPort it) {
            it.setName(((PrimitiveOutputPort)ref).getName());
            it.setIsList(((PrimitiveOutputPort)ref).isIsList());
            it.setDataType(((PrimitiveOutputPort)ref).getDataType());
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveOutputPort>operator_doubleArrow(_newPrimitiveOutputPort, _function);
      }
    }
    if (!_matched) {
      if (ref instanceof JavaNativeOutputPort) {
        _matched=true;
        JavaNativeOutputPort _newJavaNativeOutputPort = branch.newJavaNativeOutputPort(((JavaNativeOutputPort)ref).getDataType(), 0, 0);
        final Procedure1<JavaNativeOutputPort> _function = new Procedure1<JavaNativeOutputPort>() {
          @Override
          public void apply(final JavaNativeOutputPort it) {
            it.setName(((JavaNativeOutputPort)ref).getName());
            it.setIsList(((JavaNativeOutputPort)ref).isIsList());
          }
        };
        _switchResult = ObjectExtensions.<JavaNativeOutputPort>operator_doubleArrow(_newJavaNativeOutputPort, _function);
      }
    }
    if (!_matched) {
      if (ref instanceof info.scce.dime.gui.gui.PrimitiveOutputPort) {
        _matched=true;
        PrimitiveOutputPort _newPrimitiveOutputPort = branch.newPrimitiveOutputPort(0, 0);
        final Procedure1<PrimitiveOutputPort> _function = new Procedure1<PrimitiveOutputPort>() {
          @Override
          public void apply(final PrimitiveOutputPort it) {
            it.setName(((info.scce.dime.gui.gui.PrimitiveOutputPort)ref).getName());
            it.setIsList(((info.scce.dime.gui.gui.PrimitiveOutputPort)ref).isIsList());
            it.setDataType(PortUtils.this._guix.toProcess(PortUtils.this._datax.toData(((info.scce.dime.gui.gui.PrimitiveOutputPort)ref).getDataType())));
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveOutputPort>operator_doubleArrow(_newPrimitiveOutputPort, _function);
      }
    }
    if (!_matched) {
      if (ref instanceof InputStatic) {
        _matched=true;
        PrimitiveOutputPort _newPrimitiveOutputPort = branch.newPrimitiveOutputPort(0, 0);
        final Procedure1<PrimitiveOutputPort> _function = new Procedure1<PrimitiveOutputPort>() {
          @Override
          public void apply(final PrimitiveOutputPort it) {
            it.setName(((InputStatic)ref).getName());
            it.setIsList(false);
            it.setDataType(PortUtils.toPrimitiveType(((IO)ref)));
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveOutputPort>operator_doubleArrow(_newPrimitiveOutputPort, _function);
      }
    }
    if (!_matched) {
      if (ref instanceof Type) {
        _matched=true;
        ComplexOutputPort _newComplexOutputPort = branch.newComplexOutputPort(((EObject)ref), 0, 0);
        final Procedure1<ComplexOutputPort> _function = new Procedure1<ComplexOutputPort>() {
          @Override
          public void apply(final ComplexOutputPort it) {
            String _elvis = null;
            String _name = ((Type)ref).getName();
            String _replace = null;
            if (_name!=null) {
              _replace=_name.replace(" ", "");
            }
            String _firstLower = StringExtensions.toFirstLower(_replace.trim());
            if (_firstLower != null) {
              _elvis = _firstLower;
            } else {
              _elvis = "";
            }
            it.setName(_elvis);
            it.setIsList(false);
          }
        };
        _switchResult = ObjectExtensions.<ComplexOutputPort>operator_doubleArrow(_newComplexOutputPort, _function);
      }
    }
    if (!_matched) {
      if (ref instanceof PrimitiveType) {
        _matched=true;
        PrimitiveOutputPort _newPrimitiveOutputPort = branch.newPrimitiveOutputPort(0, 0);
        final Procedure1<PrimitiveOutputPort> _function = new Procedure1<PrimitiveOutputPort>() {
          @Override
          public void apply(final PrimitiveOutputPort it) {
            String _elvis = null;
            String _name = ((PrimitiveType)ref).getName();
            String _replace = null;
            if (_name!=null) {
              _replace=_name.replace(" ", "");
            }
            String _firstLower = StringExtensions.toFirstLower(_replace.trim());
            if (_firstLower != null) {
              _elvis = _firstLower;
            } else {
              _elvis = "";
            }
            it.setName(_elvis);
            it.setIsList(false);
            it.setDataType(((PrimitiveType)ref));
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveOutputPort>operator_doubleArrow(_newPrimitiveOutputPort, _function);
      }
    }
    if (!_matched) {
      if (ref instanceof ComplexVariable) {
        _matched=true;
        ComplexOutputPort _newComplexOutputPort = branch.newComplexOutputPort(((ComplexVariable)ref).getDataType(), 0, 0);
        final Procedure1<ComplexOutputPort> _function = new Procedure1<ComplexOutputPort>() {
          @Override
          public void apply(final ComplexOutputPort it) {
            it.setName(((ComplexVariable)ref).getName());
            it.setIsList(((ComplexVariable)ref).isIsList());
          }
        };
        _switchResult = ObjectExtensions.<ComplexOutputPort>operator_doubleArrow(_newComplexOutputPort, _function);
      }
    }
    if (!_matched) {
      if (ref instanceof PrimitiveVariable) {
        _matched=true;
        PrimitiveOutputPort _newPrimitiveOutputPort = branch.newPrimitiveOutputPort(0, 0);
        final Procedure1<PrimitiveOutputPort> _function = new Procedure1<PrimitiveOutputPort>() {
          @Override
          public void apply(final PrimitiveOutputPort it) {
            it.setName(((PrimitiveVariable)ref).getName());
            it.setIsList(((PrimitiveVariable)ref).isIsList());
            it.setDataType(PortUtils.toPrimitiveType(((PrimitiveVariable)ref).getDataType()));
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveOutputPort>operator_doubleArrow(_newPrimitiveOutputPort, _function);
      }
    }
    if (!_matched) {
      if (ref instanceof info.scce.dime.gui.gui.PrimitiveAttribute) {
        _matched=true;
        PrimitiveOutputPort _newPrimitiveOutputPort = branch.newPrimitiveOutputPort(0, 0);
        final Procedure1<PrimitiveOutputPort> _function = new Procedure1<PrimitiveOutputPort>() {
          @Override
          public void apply(final PrimitiveOutputPort it) {
            it.setName(((info.scce.dime.gui.gui.PrimitiveAttribute)ref).getAttribute().getName());
            it.setIsList(((info.scce.dime.gui.gui.PrimitiveAttribute)ref).getAttribute().isIsList());
            it.setDataType(PortUtils.toPrimitiveType(((info.scce.dime.gui.gui.PrimitiveAttribute)ref).getAttribute().getDataType()));
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveOutputPort>operator_doubleArrow(_newPrimitiveOutputPort, _function);
      }
    }
    if (!_matched) {
      if (ref instanceof info.scce.dime.gUIPlugin.PrimitiveInputParameter) {
        _matched=true;
        PrimitiveOutputPort _newPrimitiveOutputPort = branch.newPrimitiveOutputPort(0, 0);
        final Procedure1<PrimitiveOutputPort> _function = new Procedure1<PrimitiveOutputPort>() {
          @Override
          public void apply(final PrimitiveOutputPort it) {
            it.setName(((info.scce.dime.gUIPlugin.PrimitiveInputParameter)ref).getName());
            it.setIsList(((info.scce.dime.gUIPlugin.PrimitiveInputParameter)ref).isIsList());
            it.setDataType(PortUtils.this._guix.toProcess(PortUtils.this._datax.toData(PortUtils.this._guix.toPrimitiveType(((info.scce.dime.gUIPlugin.PrimitiveInputParameter)ref).getParameter().getType()))));
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveOutputPort>operator_doubleArrow(_newPrimitiveOutputPort, _function);
      }
    }
    if (!_matched) {
      if (ref instanceof AddPrimitiveToSubmission) {
        _matched=true;
        PrimitiveOutputPort _newPrimitiveOutputPort = branch.newPrimitiveOutputPort(0, 0);
        final Procedure1<PrimitiveOutputPort> _function = new Procedure1<PrimitiveOutputPort>() {
          @Override
          public void apply(final PrimitiveOutputPort it) {
            it.setName(GUIBranchPort.getPortName(((EObject)ref)));
            it.setIsList(GUIBranchPort.isList(((EObject)ref)));
            it.setDataType(PortUtils.this._guix.toProcess(GUIBranchPort.getPrimitiveType(((EObject)ref))));
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveOutputPort>operator_doubleArrow(_newPrimitiveOutputPort, _function);
      }
    }
    if (!_matched) {
      if (ref instanceof AddComplexToSubmission) {
        _matched=true;
        ComplexOutputPort _newComplexOutputPort = branch.newComplexOutputPort(GUIBranchPort.getComplexType(((EObject)ref)), 0, 0);
        final Procedure1<ComplexOutputPort> _function = new Procedure1<ComplexOutputPort>() {
          @Override
          public void apply(final ComplexOutputPort it) {
            it.setName(GUIBranchPort.getPortName(((EObject)ref)));
            it.setIsList(GUIBranchPort.isList(((EObject)ref)));
          }
        };
        _switchResult = ObjectExtensions.<ComplexOutputPort>operator_doubleArrow(_newComplexOutputPort, _function);
      }
    }
    if (!_matched) {
      if (ref instanceof PrimitiveParameter) {
        _matched=true;
        PrimitiveOutputPort _newPrimitiveOutputPort = branch.newPrimitiveOutputPort(0, 0);
        final Procedure1<PrimitiveOutputPort> _function = new Procedure1<PrimitiveOutputPort>() {
          @Override
          public void apply(final PrimitiveOutputPort it) {
            it.setName(((PrimitiveParameter)ref).getName());
            it.setIsList(((PrimitiveParameter)ref).isIsList());
            it.setDataType(PortUtils.this._guix.toProcess(PortUtils.this._datax.toData(PortUtils.this._guix.toPrimitiveType(((PrimitiveParameter)ref).getType()))));
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveOutputPort>operator_doubleArrow(_newPrimitiveOutputPort, _function);
      }
    }
    if (!_matched) {
      if (ref instanceof ComplexParameter) {
        _matched=true;
        ComplexOutputPort _newComplexOutputPort = branch.newComplexOutputPort(this._guix.toComplexType(((ComplexParameter)ref)), 0, 0);
        final Procedure1<ComplexOutputPort> _function = new Procedure1<ComplexOutputPort>() {
          @Override
          public void apply(final ComplexOutputPort it) {
            it.setName(((ComplexParameter)ref).getName());
            it.setIsList(((ComplexParameter)ref).isIsList());
          }
        };
        _switchResult = ObjectExtensions.<ComplexOutputPort>operator_doubleArrow(_newComplexOutputPort, _function);
      }
    }
    if (!_matched) {
      if (ref instanceof ComplexInputParameter) {
        _matched=true;
        ComplexOutputPort _newComplexOutputPort = branch.newComplexOutputPort(this._guix.toComplexType(((ComplexInputParameter)ref).getParameter()), 0, 0);
        final Procedure1<ComplexOutputPort> _function = new Procedure1<ComplexOutputPort>() {
          @Override
          public void apply(final ComplexOutputPort it) {
            it.setName(((ComplexInputParameter)ref).getName());
            it.setIsList(((ComplexInputParameter)ref).isIsList());
          }
        };
        _switchResult = ObjectExtensions.<ComplexOutputPort>operator_doubleArrow(_newComplexOutputPort, _function);
      }
    }
    if (!_matched) {
      if (ref instanceof PrimitivePort) {
        _matched=true;
        PrimitiveOutputPort _newPrimitiveOutputPort = branch.newPrimitiveOutputPort(0, 0);
        final Procedure1<PrimitiveOutputPort> _function = new Procedure1<PrimitiveOutputPort>() {
          @Override
          public void apply(final PrimitiveOutputPort it) {
            it.setName(((PrimitivePort)ref).getName());
            it.setIsList(((PrimitivePort)ref).isIsList());
            it.setDataType(PortUtils.toPrimitiveType(((PrimitivePort)ref).getType()));
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveOutputPort>operator_doubleArrow(_newPrimitiveOutputPort, _function);
      }
    }
    if (!_matched) {
      if (ref instanceof JavaTypePort) {
        _matched=true;
        JavaNativeOutputPort _newJavaNativeOutputPort = branch.newJavaNativeOutputPort(((JavaTypePort)ref).getType(), 0, 0);
        final Procedure1<JavaNativeOutputPort> _function = new Procedure1<JavaNativeOutputPort>() {
          @Override
          public void apply(final JavaNativeOutputPort it) {
            it.setName(((JavaTypePort)ref).getName());
            it.setIsList(((JavaTypePort)ref).isIsList());
          }
        };
        _switchResult = ObjectExtensions.<JavaNativeOutputPort>operator_doubleArrow(_newJavaNativeOutputPort, _function);
      }
    }
    if (!_matched) {
      if (ref instanceof ComplexOutputParameter) {
        _matched=true;
        ComplexOutputPort _newComplexOutputPort = branch.newComplexOutputPort(((ComplexOutputParameter)ref).getDataType(), 0, 0);
        final Procedure1<ComplexOutputPort> _function = new Procedure1<ComplexOutputPort>() {
          @Override
          public void apply(final ComplexOutputPort it) {
            it.setName(((ComplexOutputParameter)ref).getName());
            it.setIsList(true);
          }
        };
        _switchResult = ObjectExtensions.<ComplexOutputPort>operator_doubleArrow(_newComplexOutputPort, _function);
      }
    }
    if (!_matched) {
      if (ref instanceof DataTypePort) {
        _matched=true;
        ComplexOutputPort _newComplexOutputPort = branch.newComplexOutputPort(((DataTypePort)ref).getType(), 0, 0);
        final Procedure1<ComplexOutputPort> _function = new Procedure1<ComplexOutputPort>() {
          @Override
          public void apply(final ComplexOutputPort it) {
            it.setName(((DataTypePort)ref).getName());
            it.setIsList(((DataTypePort)ref).isIsList());
          }
        };
        _switchResult = ObjectExtensions.<ComplexOutputPort>operator_doubleArrow(_newComplexOutputPort, _function);
      }
    }
    if (!_matched) {
      if (ref instanceof ComplexOutputPort) {
        _matched=true;
        ComplexOutputPort _newComplexOutputPort = branch.newComplexOutputPort(((ComplexOutputPort)ref).getDataType(), 0, 0);
        final Procedure1<ComplexOutputPort> _function = new Procedure1<ComplexOutputPort>() {
          @Override
          public void apply(final ComplexOutputPort it) {
            it.setName(((ComplexOutputPort)ref).getName());
            it.setIsList(((ComplexOutputPort)ref).isIsList());
          }
        };
        _switchResult = ObjectExtensions.<ComplexOutputPort>operator_doubleArrow(_newComplexOutputPort, _function);
      }
    }
    if (!_matched) {
      if (ref instanceof info.scce.dime.gui.gui.ComplexOutputPort) {
        _matched=true;
        ComplexOutputPort _newComplexOutputPort = branch.newComplexOutputPort(((info.scce.dime.gui.gui.ComplexOutputPort)ref).getDataType(), 0, 0);
        final Procedure1<ComplexOutputPort> _function = new Procedure1<ComplexOutputPort>() {
          @Override
          public void apply(final ComplexOutputPort it) {
            it.setName(((info.scce.dime.gui.gui.ComplexOutputPort)ref).getName());
            it.setIsList(((info.scce.dime.gui.gui.ComplexOutputPort)ref).isIsList());
          }
        };
        _switchResult = ObjectExtensions.<ComplexOutputPort>operator_doubleArrow(_newComplexOutputPort, _function);
      }
    }
    if (!_matched) {
      if (ref instanceof ComplexGUIBranchPort) {
        _matched=true;
        ComplexOutputPort _newComplexOutputPort = branch.newComplexOutputPort(((ComplexGUIBranchPort)ref).getType(), 0, 0);
        final Procedure1<ComplexOutputPort> _function = new Procedure1<ComplexOutputPort>() {
          @Override
          public void apply(final ComplexOutputPort it) {
            it.setName(((ComplexGUIBranchPort)ref).getName());
            it.setIsList(((ComplexGUIBranchPort)ref).isList());
          }
        };
        _switchResult = ObjectExtensions.<ComplexOutputPort>operator_doubleArrow(_newComplexOutputPort, _function);
      }
    }
    if (!_matched) {
      if (ref instanceof PrimitiveGUIBranchPort) {
        _matched=true;
        PrimitiveOutputPort _newPrimitiveOutputPort = branch.newPrimitiveOutputPort(0, 0);
        final Procedure1<PrimitiveOutputPort> _function = new Procedure1<PrimitiveOutputPort>() {
          @Override
          public void apply(final PrimitiveOutputPort it) {
            it.setName(((PrimitiveGUIBranchPort)ref).getName());
            it.setIsList(((PrimitiveGUIBranchPort)ref).isList());
            it.setDataType(PortUtils.toPrimitiveType(((PrimitiveGUIBranchPort)ref).getType()));
          }
        };
        _switchResult = ObjectExtensions.<PrimitiveOutputPort>operator_doubleArrow(_newPrimitiveOutputPort, _function);
      }
    }
    if (!_matched) {
      throw new PortUtils.SwitchException(ref);
    }
    return _switchResult;
  }
  
  public static void reconnect(final DataFlow edge, final Output source, final Input target) {
    edge.reconnectSource(source);
    edge.reconnectTarget(target);
  }
  
  public static void reconnectIncoming(final Input oldTarget, final Input newTarget) {
    EList<? extends DataFlow> _incoming = oldTarget.getIncoming();
    ArrayList<DataFlow> _arrayList = new ArrayList<DataFlow>(_incoming);
    for (final DataFlow edge : _arrayList) {
      ((DataFlow) edge).reconnectTarget(newTarget);
    }
  }
  
  public static void reconnectOutgoing(final Output oldSource, final Output newSource) {
    EList<? extends DataFlow> _outgoing = oldSource.getOutgoing();
    ArrayList<DataFlow> _arrayList = new ArrayList<DataFlow>(_outgoing);
    for (final DataFlow edge : _arrayList) {
      ((DataFlow) edge).reconnectSource(newSource);
    }
  }
  
  public static InputPort toProcessInputPort(final Port port) {
    InputPort _switchResult = null;
    boolean _matched = false;
    if (port instanceof PrimitivePort) {
      _matched=true;
      PrimitiveInputPort _createPrimitiveInputPort = ProcessFactory.eINSTANCE.createPrimitiveInputPort();
      final Procedure1<PrimitiveInputPort> _function = new Procedure1<PrimitiveInputPort>() {
        @Override
        public void apply(final PrimitiveInputPort it) {
          it.setName(((PrimitivePort)port).getName());
          it.setIsList(((PrimitivePort)port).isIsList());
          it.setDataType(PortUtils.toPrimitiveType(((PrimitivePort)port).getType()));
        }
      };
      _switchResult = ObjectExtensions.<PrimitiveInputPort>operator_doubleArrow(_createPrimitiveInputPort, _function);
    }
    if (!_matched) {
      if (port instanceof JavaTypePort) {
        _matched=true;
        JavaNativeInputPort _createJavaNativeInputPort = ProcessFactory.eINSTANCE.createJavaNativeInputPort();
        final Procedure1<JavaNativeInputPort> _function = new Procedure1<JavaNativeInputPort>() {
          @Override
          public void apply(final JavaNativeInputPort it) {
            it.setName(((JavaTypePort)port).getName());
            it.setIsList(((JavaTypePort)port).isIsList());
            JavaType _type = ((JavaTypePort)port).getType();
            String _fqn = null;
            if (((JavaType) _type)!=null) {
              _fqn=((JavaType) _type).getFqn();
            }
            it.setLibraryComponentUID(_fqn);
          }
        };
        _switchResult = ObjectExtensions.<JavaNativeInputPort>operator_doubleArrow(_createJavaNativeInputPort, _function);
      }
    }
    return _switchResult;
  }
  
  public static OutputPort toProcessOutputPort(final Port port) {
    OutputPort _switchResult = null;
    boolean _matched = false;
    if (port instanceof PrimitivePort) {
      _matched=true;
      PrimitiveOutputPort _createPrimitiveOutputPort = ProcessFactory.eINSTANCE.createPrimitiveOutputPort();
      final Procedure1<PrimitiveOutputPort> _function = new Procedure1<PrimitiveOutputPort>() {
        @Override
        public void apply(final PrimitiveOutputPort it) {
          it.setName(((PrimitivePort)port).getName());
          it.setIsList(((PrimitivePort)port).isIsList());
          it.setDataType(PortUtils.toPrimitiveType(((PrimitivePort)port).getType()));
        }
      };
      _switchResult = ObjectExtensions.<PrimitiveOutputPort>operator_doubleArrow(_createPrimitiveOutputPort, _function);
    }
    if (!_matched) {
      if (port instanceof JavaTypePort) {
        _matched=true;
        JavaNativeOutputPort _createJavaNativeOutputPort = ProcessFactory.eINSTANCE.createJavaNativeOutputPort();
        final Procedure1<JavaNativeOutputPort> _function = new Procedure1<JavaNativeOutputPort>() {
          @Override
          public void apply(final JavaNativeOutputPort it) {
            it.setName(((JavaTypePort)port).getName());
            it.setIsList(((JavaTypePort)port).isIsList());
            JavaType _type = ((JavaTypePort)port).getType();
            String _fqn = null;
            if (((JavaType) _type)!=null) {
              _fqn=((JavaType) _type).getFqn();
            }
            it.setLibraryComponentUID(_fqn);
          }
        };
        _switchResult = ObjectExtensions.<JavaNativeOutputPort>operator_doubleArrow(_createJavaNativeOutputPort, _function);
      }
    }
    return _switchResult;
  }
  
  public static boolean hasPrimitiveType(final ModelElement it) {
    PrimitiveType _primitiveType = PortUtils.getPrimitiveType(it);
    return (_primitiveType != null);
  }
  
  public static PrimitiveType getPrimitiveType(final IO it) {
    PrimitiveType _switchResult = null;
    boolean _matched = false;
    if (it instanceof PrimitiveInputPort) {
      _matched=true;
      _switchResult = ((PrimitiveInputPort)it).getDataType();
    }
    if (!_matched) {
      if (it instanceof PrimitiveOutputPort) {
        _matched=true;
        _switchResult = ((PrimitiveOutputPort)it).getDataType();
      }
    }
    if (!_matched) {
      if (it instanceof InputStatic) {
        _matched=true;
        _switchResult = PortUtils.toPrimitiveType(it);
      }
    }
    return _switchResult;
  }
  
  public static PrimitiveType getPrimitiveType(final Variable it) {
    PrimitiveType _switchResult = null;
    boolean _matched = false;
    if (it instanceof PrimitiveVariable) {
      _matched=true;
      _switchResult = PortUtils.toPrimitiveType(((PrimitiveVariable)it).getDataType());
    }
    return _switchResult;
  }
  
  public static PrimitiveType getPrimitiveType(final ModelElement it) {
    PrimitiveType _switchResult = null;
    boolean _matched = false;
    if (it instanceof IO) {
      _matched=true;
      _switchResult = PortUtils.getPrimitiveType(((IO)it));
    }
    if (!_matched) {
      if (it instanceof Variable) {
        _matched=true;
        _switchResult = PortUtils.getPrimitiveType(((Variable)it));
      }
    }
    return _switchResult;
  }
  
  public static PrimitiveType getPrimitiveType(final Port it) {
    PrimitiveType _switchResult = null;
    boolean _matched = false;
    if (it instanceof PrimitivePort) {
      _matched=true;
      _switchResult = PortUtils.toPrimitiveType(((PrimitivePort)it).getType());
    }
    return _switchResult;
  }
  
  public static String calcName(final Input port) {
    String _switchResult = null;
    boolean _matched = false;
    if (port instanceof PrimitiveInputPort) {
      _matched=true;
      _switchResult = ((PrimitiveInputPort)port).getDataType().getName();
    }
    if (!_matched) {
      if (port instanceof ComplexInputPort) {
        _matched=true;
        _switchResult = ((ComplexInputPort)port).getDataType().getName();
      }
    }
    if (!_matched) {
      if (port instanceof JavaNativeInputPort) {
        _matched=true;
        EObject _dataType = ((JavaNativeInputPort)port).getDataType();
        _switchResult = ((info.scce.dime.siblibrary.Type) _dataType).getName();
      }
    }
    if (!_matched) {
      _switchResult = "input";
    }
    final String typeName = _switchResult;
    String name = typeName.substring(Math.max(0, PortUtils.getLastUpperCaseLetterIndex(typeName))).toLowerCase();
    final ModelElementContainer sib = port.getContainer();
    boolean _inputWithNameExists = PortUtils.inputWithNameExists(sib, name);
    boolean _not = (!_inputWithNameExists);
    if (_not) {
      return name;
    } else {
      ExclusiveRange _doubleDotLessThan = new ExclusiveRange(2, Integer.MAX_VALUE, true);
      for (final Integer num : _doubleDotLessThan) {
        boolean _inputWithNameExists_1 = PortUtils.inputWithNameExists(sib, (name + num));
        boolean _not_1 = (!_inputWithNameExists_1);
        if (_not_1) {
          return (name + num);
        }
      }
    }
    return "input";
  }
  
  public static String calcName(final Output port) {
    String _switchResult = null;
    boolean _matched = false;
    if (port instanceof PrimitiveOutputPort) {
      _matched=true;
      _switchResult = ((PrimitiveOutputPort)port).getDataType().getName();
    }
    if (!_matched) {
      if (port instanceof ComplexOutputPort) {
        _matched=true;
        _switchResult = ((ComplexOutputPort)port).getDataType().getName();
      }
    }
    if (!_matched) {
      if (port instanceof JavaNativeOutputPort) {
        _matched=true;
        EObject _dataType = ((JavaNativeOutputPort)port).getDataType();
        _switchResult = ((info.scce.dime.siblibrary.Type) _dataType).getName();
      }
    }
    if (!_matched) {
      _switchResult = "output";
    }
    final String typeName = _switchResult;
    String name = typeName.substring(Math.max(0, PortUtils.getLastUpperCaseLetterIndex(typeName))).toLowerCase();
    final DataFlowSource branch = port.getContainer();
    boolean _outputWithNameExists = PortUtils.outputWithNameExists(branch, name);
    boolean _not = (!_outputWithNameExists);
    if (_not) {
      return name;
    } else {
      ExclusiveRange _doubleDotLessThan = new ExclusiveRange(2, Integer.MAX_VALUE, true);
      for (final Integer num : _doubleDotLessThan) {
        boolean _outputWithNameExists_1 = PortUtils.outputWithNameExists(branch, (name + num));
        boolean _not_1 = (!_outputWithNameExists_1);
        if (_not_1) {
          return (name + num);
        }
      }
    }
    return "output";
  }
  
  public static int getLastUpperCaseLetterIndex(final String str) {
    int index = (-1);
    final int size = str.length();
    ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, size, true);
    for (final Integer i : _doubleDotLessThan) {
      boolean _isUpperCase = Character.isUpperCase(str.charAt((i).intValue()));
      if (_isUpperCase) {
        index = (i).intValue();
      }
    }
    return index;
  }
  
  public static boolean inputWithNameExists(final ModelElementContainer sib, final String name) {
    final Function1<Input, Boolean> _function = new Function1<Input, Boolean>() {
      @Override
      public Boolean apply(final Input it) {
        String _name = it.getName();
        return Boolean.valueOf(Objects.equal(_name, name));
      }
    };
    return IterableExtensions.<Input>exists(Iterables.<Input>filter(sib.<Node>getNodes(), Input.class), _function);
  }
  
  public static boolean outputWithNameExists(final DataFlowSource branch, final String name) {
    final Function1<Output, Boolean> _function = new Function1<Output, Boolean>() {
      @Override
      public Boolean apply(final Output it) {
        String _name = it.getName();
        return Boolean.valueOf(Objects.equal(_name, name));
      }
    };
    return IterableExtensions.<Output>exists(branch.getOutputs(), _function);
  }
  
  public static IO addInput(final Container dft, final Object portReference) {
    if (dft instanceof DataFlowTarget) {
      return _addInput((DataFlowTarget)dft, portReference);
    } else if (dft instanceof EventListener) {
      return _addInput((EventListener)dft, portReference);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(dft, portReference).toString());
    }
  }
  
  public static Input clonePort(final Container dft, final Input port) {
    if (dft instanceof DataFlowTarget) {
      return _clonePort((DataFlowTarget)dft, port);
    } else if (dft instanceof EventListener) {
      return _clonePort((EventListener)dft, port);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(dft, port).toString());
    }
  }
  
  public static InputStatic addStaticPort(final Container dft, final Input archetype) {
    if (dft instanceof DataFlowTarget
         && archetype instanceof PrimitiveInputPort) {
      return _addStaticPort((DataFlowTarget)dft, (PrimitiveInputPort)archetype);
    } else if (dft instanceof EventListener
         && archetype instanceof PrimitiveInputPort) {
      return _addStaticPort((EventListener)dft, (PrimitiveInputPort)archetype);
    } else if (dft instanceof DataFlowTarget
         && archetype instanceof InputStatic) {
      return _addStaticPort((DataFlowTarget)dft, (InputStatic)archetype);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(dft, archetype).toString());
    }
  }
}
