/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.helper;

import com.google.common.base.Objects;
import info.scce.dime.process.build.PrimeSIBBuild;
import info.scce.dime.process.process.Branch;
import info.scce.dime.process.process.SIB;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class BranchUtils {
  public static EObject getReferencedComponent(final Branch branch) {
    EObject _xblockexpression = null;
    {
      EList<SIB> _predecessors = branch.<SIB>getPredecessors(SIB.class);
      SIB _head = null;
      if (_predecessors!=null) {
        _head=IterableExtensions.<SIB>head(_predecessors);
      }
      final SIB sib = _head;
      final PrimeSIBBuild build = PrimeSIBBuild.<SIB>getBuild(sib);
      EObject _xifexpression = null;
      boolean _notEquals = (!Objects.equal(build, null));
      if (_notEquals) {
        final Function1<Object, Boolean> _function = new Function1<Object, Boolean>() {
          @Override
          public Boolean apply(final Object it) {
            return Boolean.valueOf(build.isBranchReference(branch, it));
          }
        };
        Object _head_1 = IterableExtensions.<Object>head(IterableExtensions.<Object>filter(build.getBranchReferences(sib), _function));
        Object _value = null;
        if (((Map.Entry) _head_1)!=null) {
          _value=((Map.Entry) _head_1).getValue();
        }
        Object _head_2 = null;
        if (((List) _value)!=null) {
          final Function1<Object, Boolean> _function_1 = new Function1<Object, Boolean>() {
            @Override
            public Boolean apply(final Object it) {
              return Boolean.valueOf(build.isBranchReference(branch, it));
            }
          };
          Object _head_3 = IterableExtensions.<Object>head(IterableExtensions.<Object>filter(build.getBranchReferences(sib), _function));
          Object _value_1 = null;
          if (((Map.Entry) _head_1)!=null) {
            _value_1=((Map.Entry) _head_1).getValue();
          }
          _head_2=IterableExtensions.<Object>head(((List) _value_1));
        }
        _xifexpression = ((EObject) _head_2);
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  public static Object getBranchReference(final SIB sib, final Branch branch) {
    Object _xblockexpression = null;
    {
      final PrimeSIBBuild build = PrimeSIBBuild.<SIB>getBuild(sib);
      Object _xifexpression = null;
      boolean _notEquals = (!Objects.equal(build, null));
      if (_notEquals) {
        final Function1<Object, Boolean> _function = new Function1<Object, Boolean>() {
          @Override
          public Boolean apply(final Object it) {
            return Boolean.valueOf(build.isBranchReference(branch, it));
          }
        };
        _xifexpression = IterableExtensions.<Object>head(IterableExtensions.<Object>filter(build.getBranchReferences(sib), _function));
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
}
