package info.scce.dime.process.factory;

import de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension;
import graphmodel.GraphModel;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElement;
import graphmodel.Type;
import graphmodel.internal.InternalEdge;
import graphmodel.internal.InternalGraphModel;
import graphmodel.internal.InternalIdentifiableElement;
import graphmodel.internal.InternalModelElement;
import graphmodel.internal.InternalModelElementContainer;
import graphmodel.internal.InternalNode;
import graphmodel.internal.InternalType;
import info.scce.dime.process.adapter.AtomicSIBEContentAdapter;
import info.scce.dime.process.adapter.BooleanInputStaticEContentAdapter;
import info.scce.dime.process.adapter.BranchBlueprintEContentAdapter;
import info.scce.dime.process.adapter.BranchConnectorEContentAdapter;
import info.scce.dime.process.adapter.BranchEContentAdapter;
import info.scce.dime.process.adapter.ComplexAttributeConnectorEContentAdapter;
import info.scce.dime.process.adapter.ComplexAttributeEContentAdapter;
import info.scce.dime.process.adapter.ComplexAttributePortEContentAdapter;
import info.scce.dime.process.adapter.ComplexDirectDataFlowEContentAdapter;
import info.scce.dime.process.adapter.ComplexExtensionAttributeEContentAdapter;
import info.scce.dime.process.adapter.ComplexInputPortEContentAdapter;
import info.scce.dime.process.adapter.ComplexListAttributeConnectorEContentAdapter;
import info.scce.dime.process.adapter.ComplexListAttributeEContentAdapter;
import info.scce.dime.process.adapter.ComplexOutputPortEContentAdapter;
import info.scce.dime.process.adapter.ComplexReadEContentAdapter;
import info.scce.dime.process.adapter.ComplexUpdateEContentAdapter;
import info.scce.dime.process.adapter.ComplexVariableEContentAdapter;
import info.scce.dime.process.adapter.ContainsJavaNativeSIBEContentAdapter;
import info.scce.dime.process.adapter.ContainsPrimitiveSIBEContentAdapter;
import info.scce.dime.process.adapter.ContainsSIBEContentAdapter;
import info.scce.dime.process.adapter.ControlFlowEContentAdapter;
import info.scce.dime.process.adapter.CreateSIBEContentAdapter;
import info.scce.dime.process.adapter.CreateUserSIBEContentAdapter;
import info.scce.dime.process.adapter.DataContextEContentAdapter;
import info.scce.dime.process.adapter.DeleteSIBEContentAdapter;
import info.scce.dime.process.adapter.DocumentationEContentAdapter;
import info.scce.dime.process.adapter.EndSIBEContentAdapter;
import info.scce.dime.process.adapter.EntryPointProcessSIBEContentAdapter;
import info.scce.dime.process.adapter.EnumSwitchSIBEContentAdapter;
import info.scce.dime.process.adapter.EventConnectorEContentAdapter;
import info.scce.dime.process.adapter.EventListenerEContentAdapter;
import info.scce.dime.process.adapter.ExtensionAttributeEContentAdapter;
import info.scce.dime.process.adapter.GUIBlueprintSIBEContentAdapter;
import info.scce.dime.process.adapter.GUISIBEContentAdapter;
import info.scce.dime.process.adapter.GUISIBOptionsEContentAdapter;
import info.scce.dime.process.adapter.GenericSIBEContentAdapter;
import info.scce.dime.process.adapter.GetOriginalUserSIBEContentAdapter;
import info.scce.dime.process.adapter.GuardContainerEContentAdapter;
import info.scce.dime.process.adapter.GuardProcessSIBEContentAdapter;
import info.scce.dime.process.adapter.GuardedProcessSIBEContentAdapter;
import info.scce.dime.process.adapter.IgnoreBranchEContentAdapter;
import info.scce.dime.process.adapter.IntegerInputStaticEContentAdapter;
import info.scce.dime.process.adapter.IsOfTypeSIBEContentAdapter;
import info.scce.dime.process.adapter.IterateJavaNativeSIBEContentAdapter;
import info.scce.dime.process.adapter.IteratePrimitiveSIBEContentAdapter;
import info.scce.dime.process.adapter.IterateSIBEContentAdapter;
import info.scce.dime.process.adapter.JavaNativeDirectDataFlowEContentAdapter;
import info.scce.dime.process.adapter.JavaNativeInputPortEContentAdapter;
import info.scce.dime.process.adapter.JavaNativeOutputPortEContentAdapter;
import info.scce.dime.process.adapter.JavaNativeReadEContentAdapter;
import info.scce.dime.process.adapter.JavaNativeUpdateEContentAdapter;
import info.scce.dime.process.adapter.JavaNativeVariableEContentAdapter;
import info.scce.dime.process.adapter.LinkProcessSIBEContentAdapter;
import info.scce.dime.process.adapter.LongRunningProcessEContentAdapter;
import info.scce.dime.process.adapter.NativeFrontendBranchEContentAdapter;
import info.scce.dime.process.adapter.NativeFrontendSIBLibraryEContentAdapter;
import info.scce.dime.process.adapter.NativeFrontendSIBReferenceEContentAdapter;
import info.scce.dime.process.adapter.PrimitiveAttributeEContentAdapter;
import info.scce.dime.process.adapter.PrimitiveAttributePortEContentAdapter;
import info.scce.dime.process.adapter.PrimitiveDirectDataFlowEContentAdapter;
import info.scce.dime.process.adapter.PrimitiveExtensionAttributeEContentAdapter;
import info.scce.dime.process.adapter.PrimitiveInputPortEContentAdapter;
import info.scce.dime.process.adapter.PrimitiveListAttributeEContentAdapter;
import info.scce.dime.process.adapter.PrimitiveOutputPortEContentAdapter;
import info.scce.dime.process.adapter.PrimitiveReadEContentAdapter;
import info.scce.dime.process.adapter.PrimitiveUpdateEContentAdapter;
import info.scce.dime.process.adapter.PrimitiveVariableEContentAdapter;
import info.scce.dime.process.adapter.ProcessBlueprintSIBEContentAdapter;
import info.scce.dime.process.adapter.ProcessEContentAdapter;
import info.scce.dime.process.adapter.ProcessInputStaticEContentAdapter;
import info.scce.dime.process.adapter.ProcessPlaceholderSIBEContentAdapter;
import info.scce.dime.process.adapter.ProcessSIBEContentAdapter;
import info.scce.dime.process.adapter.PutComplexToContextSIBEContentAdapter;
import info.scce.dime.process.adapter.PutPrimitiveToContextSIBEContentAdapter;
import info.scce.dime.process.adapter.PutToContextSIBEContentAdapter;
import info.scce.dime.process.adapter.RealInputStaticEContentAdapter;
import info.scce.dime.process.adapter.RegistrationEContentAdapter;
import info.scce.dime.process.adapter.RemoveFromListSIBEContentAdapter;
import info.scce.dime.process.adapter.RetrieveCurrentUserSIBEContentAdapter;
import info.scce.dime.process.adapter.RetrieveEnumLiteralSIBEContentAdapter;
import info.scce.dime.process.adapter.RetrieveOfTypeSIBEContentAdapter;
import info.scce.dime.process.adapter.SearchSIBEContentAdapter;
import info.scce.dime.process.adapter.SetAttributeValueSIBEContentAdapter;
import info.scce.dime.process.adapter.StartSIBEContentAdapter;
import info.scce.dime.process.adapter.SwitchToOriginalUserSIBEContentAdapter;
import info.scce.dime.process.adapter.SwitchToUserSIBEContentAdapter;
import info.scce.dime.process.adapter.TextInputStaticEContentAdapter;
import info.scce.dime.process.adapter.TimestampInputStaticEContentAdapter;
import info.scce.dime.process.adapter.TransientCreateSIBEContentAdapter;
import info.scce.dime.process.adapter.TriggerEventSIBEContentAdapter;
import info.scce.dime.process.adapter.UnsetAttributeValueSIBEContentAdapter;
import info.scce.dime.process.hooks.AtomicSIBHook;
import info.scce.dime.process.hooks.ComplexAttributePortHook;
import info.scce.dime.process.hooks.ComplexVariablePostCreate;
import info.scce.dime.process.hooks.ContainsJavaNativeSIBHook;
import info.scce.dime.process.hooks.ContainsPrimitiveSIBHook;
import info.scce.dime.process.hooks.ContainsSIBHook;
import info.scce.dime.process.hooks.CreateNativeFrontendSIBReference;
import info.scce.dime.process.hooks.CreateSIBHook;
import info.scce.dime.process.hooks.CreateUserSIBHook;
import info.scce.dime.process.hooks.DeleteSIBHook;
import info.scce.dime.process.hooks.DirectDataFlowPostCreate;
import info.scce.dime.process.hooks.EnumSwitchSIBHook;
import info.scce.dime.process.hooks.GUISIBHook;
import info.scce.dime.process.hooks.GenericSIBHook;
import info.scce.dime.process.hooks.GetOriginalUserSIBHook;
import info.scce.dime.process.hooks.GuardProcessSIBHook;
import info.scce.dime.process.hooks.GuardedProcessSIBHook;
import info.scce.dime.process.hooks.InputHook;
import info.scce.dime.process.hooks.IsOfTypeSIBHook;
import info.scce.dime.process.hooks.IterateJavaNativeSIBHook;
import info.scce.dime.process.hooks.IteratePrimitiveSIBHook;
import info.scce.dime.process.hooks.IterateSIBHook;
import info.scce.dime.process.hooks.LinkProcessSIBHook;
import info.scce.dime.process.hooks.OutputPortHook;
import info.scce.dime.process.hooks.PrimitiveAttributePortHook;
import info.scce.dime.process.hooks.ProcessInit;
import info.scce.dime.process.hooks.ProcessInputStaticHook;
import info.scce.dime.process.hooks.ProcessNodePostCreate;
import info.scce.dime.process.hooks.ProcessSIBHook;
import info.scce.dime.process.hooks.PutComplexToContextSIBHook;
import info.scce.dime.process.hooks.PutPrimitiveToContextSIBHook;
import info.scce.dime.process.hooks.PutToContextSIBHook;
import info.scce.dime.process.hooks.RemoveFromListSIBHook;
import info.scce.dime.process.hooks.RetrieveCurrentUserSIBHook;
import info.scce.dime.process.hooks.RetrieveEnumLiteralSIBHook;
import info.scce.dime.process.hooks.RetrieveOfTypeSIBHook;
import info.scce.dime.process.hooks.SearchSIBHook;
import info.scce.dime.process.hooks.SetAttributeValueSIBHook;
import info.scce.dime.process.hooks.SwitchToOriginalUserSIBHook;
import info.scce.dime.process.hooks.SwitchToUserSIBHook;
import info.scce.dime.process.hooks.TransientCreateSIBHook;
import info.scce.dime.process.hooks.TriggerEventSIBHook;
import info.scce.dime.process.hooks.UnsetAttributeValueSIBHook;
import info.scce.dime.process.hooks.Variable_PostCreate;
import info.scce.dime.process.process.AtomicSIB;
import info.scce.dime.process.process.BooleanInputStatic;
import info.scce.dime.process.process.Branch;
import info.scce.dime.process.process.BranchBlueprint;
import info.scce.dime.process.process.BranchConnector;
import info.scce.dime.process.process.ComplexAttribute;
import info.scce.dime.process.process.ComplexAttributeConnector;
import info.scce.dime.process.process.ComplexAttributePort;
import info.scce.dime.process.process.ComplexDirectDataFlow;
import info.scce.dime.process.process.ComplexExtensionAttribute;
import info.scce.dime.process.process.ComplexInputPort;
import info.scce.dime.process.process.ComplexListAttribute;
import info.scce.dime.process.process.ComplexListAttributeConnector;
import info.scce.dime.process.process.ComplexOutputPort;
import info.scce.dime.process.process.ComplexRead;
import info.scce.dime.process.process.ComplexUpdate;
import info.scce.dime.process.process.ComplexVariable;
import info.scce.dime.process.process.ContainsJavaNativeSIB;
import info.scce.dime.process.process.ContainsPrimitiveSIB;
import info.scce.dime.process.process.ContainsSIB;
import info.scce.dime.process.process.ControlFlow;
import info.scce.dime.process.process.CreateSIB;
import info.scce.dime.process.process.CreateUserSIB;
import info.scce.dime.process.process.DataContext;
import info.scce.dime.process.process.DeleteSIB;
import info.scce.dime.process.process.Documentation;
import info.scce.dime.process.process.EndSIB;
import info.scce.dime.process.process.EntryPointProcessSIB;
import info.scce.dime.process.process.EnumSwitchSIB;
import info.scce.dime.process.process.EventConnector;
import info.scce.dime.process.process.EventListener;
import info.scce.dime.process.process.ExtensionAttribute;
import info.scce.dime.process.process.GUIBlueprintSIB;
import info.scce.dime.process.process.GUISIB;
import info.scce.dime.process.process.GUISIBOptions;
import info.scce.dime.process.process.GenericSIB;
import info.scce.dime.process.process.GetOriginalUserSIB;
import info.scce.dime.process.process.GuardContainer;
import info.scce.dime.process.process.GuardProcessSIB;
import info.scce.dime.process.process.GuardedProcessSIB;
import info.scce.dime.process.process.IgnoreBranch;
import info.scce.dime.process.process.IntegerInputStatic;
import info.scce.dime.process.process.IsOfTypeSIB;
import info.scce.dime.process.process.IterateJavaNativeSIB;
import info.scce.dime.process.process.IteratePrimitiveSIB;
import info.scce.dime.process.process.IterateSIB;
import info.scce.dime.process.process.JavaNativeDirectDataFlow;
import info.scce.dime.process.process.JavaNativeInputPort;
import info.scce.dime.process.process.JavaNativeOutputPort;
import info.scce.dime.process.process.JavaNativeRead;
import info.scce.dime.process.process.JavaNativeUpdate;
import info.scce.dime.process.process.JavaNativeVariable;
import info.scce.dime.process.process.LinkProcessSIB;
import info.scce.dime.process.process.LongRunningProcess;
import info.scce.dime.process.process.NativeFrontendBranch;
import info.scce.dime.process.process.NativeFrontendSIBLibrary;
import info.scce.dime.process.process.NativeFrontendSIBReference;
import info.scce.dime.process.process.PrimitiveAttribute;
import info.scce.dime.process.process.PrimitiveAttributePort;
import info.scce.dime.process.process.PrimitiveDirectDataFlow;
import info.scce.dime.process.process.PrimitiveExtensionAttribute;
import info.scce.dime.process.process.PrimitiveInputPort;
import info.scce.dime.process.process.PrimitiveListAttribute;
import info.scce.dime.process.process.PrimitiveOutputPort;
import info.scce.dime.process.process.PrimitiveRead;
import info.scce.dime.process.process.PrimitiveUpdate;
import info.scce.dime.process.process.PrimitiveVariable;
import info.scce.dime.process.process.ProcessBlueprintSIB;
import info.scce.dime.process.process.ProcessInputStatic;
import info.scce.dime.process.process.ProcessPackage;
import info.scce.dime.process.process.ProcessPlaceholderSIB;
import info.scce.dime.process.process.ProcessSIB;
import info.scce.dime.process.process.PutComplexToContextSIB;
import info.scce.dime.process.process.PutPrimitiveToContextSIB;
import info.scce.dime.process.process.PutToContextSIB;
import info.scce.dime.process.process.RealInputStatic;
import info.scce.dime.process.process.Registration;
import info.scce.dime.process.process.RemoveFromListSIB;
import info.scce.dime.process.process.RetrieveCurrentUserSIB;
import info.scce.dime.process.process.RetrieveEnumLiteralSIB;
import info.scce.dime.process.process.RetrieveOfTypeSIB;
import info.scce.dime.process.process.SearchSIB;
import info.scce.dime.process.process.SetAttributeValueSIB;
import info.scce.dime.process.process.StartSIB;
import info.scce.dime.process.process.SwitchToOriginalUserSIB;
import info.scce.dime.process.process.SwitchToUserSIB;
import info.scce.dime.process.process.TextInputStatic;
import info.scce.dime.process.process.TimestampInputStatic;
import info.scce.dime.process.process.TransientCreateSIB;
import info.scce.dime.process.process.TriggerEventSIB;
import info.scce.dime.process.process.UnsetAttributeValueSIB;
import info.scce.dime.process.process.impl.ProcessFactoryImpl;
import info.scce.dime.process.process.internal.InternalAtomicSIB;
import info.scce.dime.process.process.internal.InternalBooleanInputStatic;
import info.scce.dime.process.process.internal.InternalBranch;
import info.scce.dime.process.process.internal.InternalBranchBlueprint;
import info.scce.dime.process.process.internal.InternalBranchConnector;
import info.scce.dime.process.process.internal.InternalComplexAttribute;
import info.scce.dime.process.process.internal.InternalComplexAttributeConnector;
import info.scce.dime.process.process.internal.InternalComplexAttributePort;
import info.scce.dime.process.process.internal.InternalComplexDirectDataFlow;
import info.scce.dime.process.process.internal.InternalComplexExtensionAttribute;
import info.scce.dime.process.process.internal.InternalComplexInputPort;
import info.scce.dime.process.process.internal.InternalComplexListAttribute;
import info.scce.dime.process.process.internal.InternalComplexListAttributeConnector;
import info.scce.dime.process.process.internal.InternalComplexOutputPort;
import info.scce.dime.process.process.internal.InternalComplexRead;
import info.scce.dime.process.process.internal.InternalComplexUpdate;
import info.scce.dime.process.process.internal.InternalComplexVariable;
import info.scce.dime.process.process.internal.InternalContainsJavaNativeSIB;
import info.scce.dime.process.process.internal.InternalContainsPrimitiveSIB;
import info.scce.dime.process.process.internal.InternalContainsSIB;
import info.scce.dime.process.process.internal.InternalControlFlow;
import info.scce.dime.process.process.internal.InternalCreateSIB;
import info.scce.dime.process.process.internal.InternalCreateUserSIB;
import info.scce.dime.process.process.internal.InternalDataContext;
import info.scce.dime.process.process.internal.InternalDeleteSIB;
import info.scce.dime.process.process.internal.InternalDocumentation;
import info.scce.dime.process.process.internal.InternalEndSIB;
import info.scce.dime.process.process.internal.InternalEntryPointProcessSIB;
import info.scce.dime.process.process.internal.InternalEnumSwitchSIB;
import info.scce.dime.process.process.internal.InternalEventConnector;
import info.scce.dime.process.process.internal.InternalEventListener;
import info.scce.dime.process.process.internal.InternalExtensionAttribute;
import info.scce.dime.process.process.internal.InternalFactory;
import info.scce.dime.process.process.internal.InternalGUIBlueprintSIB;
import info.scce.dime.process.process.internal.InternalGUISIB;
import info.scce.dime.process.process.internal.InternalGUISIBOptions;
import info.scce.dime.process.process.internal.InternalGenericSIB;
import info.scce.dime.process.process.internal.InternalGetOriginalUserSIB;
import info.scce.dime.process.process.internal.InternalGuardContainer;
import info.scce.dime.process.process.internal.InternalGuardProcessSIB;
import info.scce.dime.process.process.internal.InternalGuardedProcessSIB;
import info.scce.dime.process.process.internal.InternalIgnoreBranch;
import info.scce.dime.process.process.internal.InternalIntegerInputStatic;
import info.scce.dime.process.process.internal.InternalIsOfTypeSIB;
import info.scce.dime.process.process.internal.InternalIterateJavaNativeSIB;
import info.scce.dime.process.process.internal.InternalIteratePrimitiveSIB;
import info.scce.dime.process.process.internal.InternalIterateSIB;
import info.scce.dime.process.process.internal.InternalJavaNativeDirectDataFlow;
import info.scce.dime.process.process.internal.InternalJavaNativeInputPort;
import info.scce.dime.process.process.internal.InternalJavaNativeOutputPort;
import info.scce.dime.process.process.internal.InternalJavaNativeRead;
import info.scce.dime.process.process.internal.InternalJavaNativeUpdate;
import info.scce.dime.process.process.internal.InternalJavaNativeVariable;
import info.scce.dime.process.process.internal.InternalLinkProcessSIB;
import info.scce.dime.process.process.internal.InternalLongRunningProcess;
import info.scce.dime.process.process.internal.InternalNativeFrontendBranch;
import info.scce.dime.process.process.internal.InternalNativeFrontendSIBLibrary;
import info.scce.dime.process.process.internal.InternalNativeFrontendSIBReference;
import info.scce.dime.process.process.internal.InternalPrimitiveAttribute;
import info.scce.dime.process.process.internal.InternalPrimitiveAttributePort;
import info.scce.dime.process.process.internal.InternalPrimitiveDirectDataFlow;
import info.scce.dime.process.process.internal.InternalPrimitiveExtensionAttribute;
import info.scce.dime.process.process.internal.InternalPrimitiveInputPort;
import info.scce.dime.process.process.internal.InternalPrimitiveListAttribute;
import info.scce.dime.process.process.internal.InternalPrimitiveOutputPort;
import info.scce.dime.process.process.internal.InternalPrimitiveRead;
import info.scce.dime.process.process.internal.InternalPrimitiveUpdate;
import info.scce.dime.process.process.internal.InternalPrimitiveVariable;
import info.scce.dime.process.process.internal.InternalProcess;
import info.scce.dime.process.process.internal.InternalProcessBlueprintSIB;
import info.scce.dime.process.process.internal.InternalProcessInputStatic;
import info.scce.dime.process.process.internal.InternalProcessPlaceholderSIB;
import info.scce.dime.process.process.internal.InternalProcessSIB;
import info.scce.dime.process.process.internal.InternalPutComplexToContextSIB;
import info.scce.dime.process.process.internal.InternalPutPrimitiveToContextSIB;
import info.scce.dime.process.process.internal.InternalPutToContextSIB;
import info.scce.dime.process.process.internal.InternalRealInputStatic;
import info.scce.dime.process.process.internal.InternalRegistration;
import info.scce.dime.process.process.internal.InternalRemoveFromListSIB;
import info.scce.dime.process.process.internal.InternalRetrieveCurrentUserSIB;
import info.scce.dime.process.process.internal.InternalRetrieveEnumLiteralSIB;
import info.scce.dime.process.process.internal.InternalRetrieveOfTypeSIB;
import info.scce.dime.process.process.internal.InternalSearchSIB;
import info.scce.dime.process.process.internal.InternalSetAttributeValueSIB;
import info.scce.dime.process.process.internal.InternalStartSIB;
import info.scce.dime.process.process.internal.InternalSwitchToOriginalUserSIB;
import info.scce.dime.process.process.internal.InternalSwitchToUserSIB;
import info.scce.dime.process.process.internal.InternalTextInputStatic;
import info.scce.dime.process.process.internal.InternalTimestampInputStatic;
import info.scce.dime.process.process.internal.InternalTransientCreateSIB;
import info.scce.dime.process.process.internal.InternalTriggerEventSIB;
import info.scce.dime.process.process.internal.InternalUnsetAttributeValueSIB;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class ProcessFactory extends ProcessFactoryImpl {
  @Extension
  private final InternalFactory _internalFactory = InternalFactory.eINSTANCE;
  
  public static ProcessFactory eINSTANCE = ProcessFactory.init();
  
  @Extension
  private WorkbenchExtension _workbenchExtension = new WorkbenchExtension();
  
  public static ProcessFactory init() {
    ProcessFactory _xblockexpression = null;
    {
      try {
        EFactory _eFactory = EPackage.Registry.INSTANCE.getEFactory(ProcessPackage.eNS_URI);
        final ProcessFactory fct = ((ProcessFactory) _eFactory);
        if ((fct != null)) {
          return ((ProcessFactory) fct);
        }
      } catch (final Throwable _t) {
        if (_t instanceof Exception) {
          final Exception exception = (Exception)_t;
          EcorePlugin.INSTANCE.log(exception);
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
      _xblockexpression = new ProcessFactory();
    }
    return _xblockexpression;
  }
  
  /**
   * This method creates an GuardedProcessSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public GuardedProcessSIB createGuardedProcessSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    GuardedProcessSIB _createGuardedProcessSIB = super.createGuardedProcessSIB();
    final Procedure1<GuardedProcessSIB> _function = new Procedure1<GuardedProcessSIB>() {
      @Override
      public void apply(final GuardedProcessSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalGuardedProcessSIB _createInternalGuardedProcessSIB = ProcessFactory.this._internalFactory.createInternalGuardedProcessSIB();
          _elvis = _createInternalGuardedProcessSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            GuardedProcessSIBEContentAdapter _guardedProcessSIBEContentAdapter = new GuardedProcessSIBEContentAdapter();
            _eAdapters.add(_guardedProcessSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<GuardedProcessSIB>operator_doubleArrow(_createGuardedProcessSIB, _function);
  }
  
  /**
   * This method creates an GuardedProcessSIB with the given id. Post create hook won't be triggered.
   */
  public GuardedProcessSIB createGuardedProcessSIB(final String ID) {
    return this.createGuardedProcessSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an GuardedProcessSIB with the given id. Post create hook will be triggered.
   */
  public GuardedProcessSIB createGuardedProcessSIB(final InternalModelElementContainer parent) {
    return this.createGuardedProcessSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an GuardedProcessSIB with the given id. Post create hook will be triggered.
   */
  public GuardedProcessSIB createGuardedProcessSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createGuardedProcessSIB(ID, null, parent, true);
  }
  
  public GuardedProcessSIB createGuardedProcessSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createGuardedProcessSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an GuardedProcessSIB with the given id. Post create hook won't be triggered.
   */
  public GuardedProcessSIB createGuardedProcessSIB(final InternalModelElement ime) {
    return this.createGuardedProcessSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public GuardedProcessSIB createGuardedProcessSIB() {
    return this.createGuardedProcessSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an RetrieveCurrentUserSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public RetrieveCurrentUserSIB createRetrieveCurrentUserSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    RetrieveCurrentUserSIB _createRetrieveCurrentUserSIB = super.createRetrieveCurrentUserSIB();
    final Procedure1<RetrieveCurrentUserSIB> _function = new Procedure1<RetrieveCurrentUserSIB>() {
      @Override
      public void apply(final RetrieveCurrentUserSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalRetrieveCurrentUserSIB _createInternalRetrieveCurrentUserSIB = ProcessFactory.this._internalFactory.createInternalRetrieveCurrentUserSIB();
          _elvis = _createInternalRetrieveCurrentUserSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            RetrieveCurrentUserSIBEContentAdapter _retrieveCurrentUserSIBEContentAdapter = new RetrieveCurrentUserSIBEContentAdapter();
            _eAdapters.add(_retrieveCurrentUserSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<RetrieveCurrentUserSIB>operator_doubleArrow(_createRetrieveCurrentUserSIB, _function);
  }
  
  /**
   * This method creates an RetrieveCurrentUserSIB with the given id. Post create hook won't be triggered.
   */
  public RetrieveCurrentUserSIB createRetrieveCurrentUserSIB(final String ID) {
    return this.createRetrieveCurrentUserSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an RetrieveCurrentUserSIB with the given id. Post create hook will be triggered.
   */
  public RetrieveCurrentUserSIB createRetrieveCurrentUserSIB(final InternalModelElementContainer parent) {
    return this.createRetrieveCurrentUserSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an RetrieveCurrentUserSIB with the given id. Post create hook will be triggered.
   */
  public RetrieveCurrentUserSIB createRetrieveCurrentUserSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createRetrieveCurrentUserSIB(ID, null, parent, true);
  }
  
  public RetrieveCurrentUserSIB createRetrieveCurrentUserSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createRetrieveCurrentUserSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an RetrieveCurrentUserSIB with the given id. Post create hook won't be triggered.
   */
  public RetrieveCurrentUserSIB createRetrieveCurrentUserSIB(final InternalModelElement ime) {
    return this.createRetrieveCurrentUserSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public RetrieveCurrentUserSIB createRetrieveCurrentUserSIB() {
    return this.createRetrieveCurrentUserSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an RetrieveEnumLiteralSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public RetrieveEnumLiteralSIB createRetrieveEnumLiteralSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    RetrieveEnumLiteralSIB _createRetrieveEnumLiteralSIB = super.createRetrieveEnumLiteralSIB();
    final Procedure1<RetrieveEnumLiteralSIB> _function = new Procedure1<RetrieveEnumLiteralSIB>() {
      @Override
      public void apply(final RetrieveEnumLiteralSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalRetrieveEnumLiteralSIB _createInternalRetrieveEnumLiteralSIB = ProcessFactory.this._internalFactory.createInternalRetrieveEnumLiteralSIB();
          _elvis = _createInternalRetrieveEnumLiteralSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            RetrieveEnumLiteralSIBEContentAdapter _retrieveEnumLiteralSIBEContentAdapter = new RetrieveEnumLiteralSIBEContentAdapter();
            _eAdapters.add(_retrieveEnumLiteralSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<RetrieveEnumLiteralSIB>operator_doubleArrow(_createRetrieveEnumLiteralSIB, _function);
  }
  
  /**
   * This method creates an RetrieveEnumLiteralSIB with the given id. Post create hook won't be triggered.
   */
  public RetrieveEnumLiteralSIB createRetrieveEnumLiteralSIB(final String ID) {
    return this.createRetrieveEnumLiteralSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an RetrieveEnumLiteralSIB with the given id. Post create hook will be triggered.
   */
  public RetrieveEnumLiteralSIB createRetrieveEnumLiteralSIB(final InternalModelElementContainer parent) {
    return this.createRetrieveEnumLiteralSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an RetrieveEnumLiteralSIB with the given id. Post create hook will be triggered.
   */
  public RetrieveEnumLiteralSIB createRetrieveEnumLiteralSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createRetrieveEnumLiteralSIB(ID, null, parent, true);
  }
  
  public RetrieveEnumLiteralSIB createRetrieveEnumLiteralSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createRetrieveEnumLiteralSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an RetrieveEnumLiteralSIB with the given id. Post create hook won't be triggered.
   */
  public RetrieveEnumLiteralSIB createRetrieveEnumLiteralSIB(final InternalModelElement ime) {
    return this.createRetrieveEnumLiteralSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public RetrieveEnumLiteralSIB createRetrieveEnumLiteralSIB() {
    return this.createRetrieveEnumLiteralSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an DeleteSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public DeleteSIB createDeleteSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    DeleteSIB _createDeleteSIB = super.createDeleteSIB();
    final Procedure1<DeleteSIB> _function = new Procedure1<DeleteSIB>() {
      @Override
      public void apply(final DeleteSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalDeleteSIB _createInternalDeleteSIB = ProcessFactory.this._internalFactory.createInternalDeleteSIB();
          _elvis = _createInternalDeleteSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            DeleteSIBEContentAdapter _deleteSIBEContentAdapter = new DeleteSIBEContentAdapter();
            _eAdapters.add(_deleteSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<DeleteSIB>operator_doubleArrow(_createDeleteSIB, _function);
  }
  
  /**
   * This method creates an DeleteSIB with the given id. Post create hook won't be triggered.
   */
  public DeleteSIB createDeleteSIB(final String ID) {
    return this.createDeleteSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an DeleteSIB with the given id. Post create hook will be triggered.
   */
  public DeleteSIB createDeleteSIB(final InternalModelElementContainer parent) {
    return this.createDeleteSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an DeleteSIB with the given id. Post create hook will be triggered.
   */
  public DeleteSIB createDeleteSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createDeleteSIB(ID, null, parent, true);
  }
  
  public DeleteSIB createDeleteSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createDeleteSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an DeleteSIB with the given id. Post create hook won't be triggered.
   */
  public DeleteSIB createDeleteSIB(final InternalModelElement ime) {
    return this.createDeleteSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public DeleteSIB createDeleteSIB() {
    return this.createDeleteSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ContainsSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ContainsSIB createContainsSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ContainsSIB _createContainsSIB = super.createContainsSIB();
    final Procedure1<ContainsSIB> _function = new Procedure1<ContainsSIB>() {
      @Override
      public void apply(final ContainsSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalContainsSIB _createInternalContainsSIB = ProcessFactory.this._internalFactory.createInternalContainsSIB();
          _elvis = _createInternalContainsSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ContainsSIBEContentAdapter _containsSIBEContentAdapter = new ContainsSIBEContentAdapter();
            _eAdapters.add(_containsSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ContainsSIB>operator_doubleArrow(_createContainsSIB, _function);
  }
  
  /**
   * This method creates an ContainsSIB with the given id. Post create hook won't be triggered.
   */
  public ContainsSIB createContainsSIB(final String ID) {
    return this.createContainsSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an ContainsSIB with the given id. Post create hook will be triggered.
   */
  public ContainsSIB createContainsSIB(final InternalModelElementContainer parent) {
    return this.createContainsSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ContainsSIB with the given id. Post create hook will be triggered.
   */
  public ContainsSIB createContainsSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createContainsSIB(ID, null, parent, true);
  }
  
  public ContainsSIB createContainsSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createContainsSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ContainsSIB with the given id. Post create hook won't be triggered.
   */
  public ContainsSIB createContainsSIB(final InternalModelElement ime) {
    return this.createContainsSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ContainsSIB createContainsSIB() {
    return this.createContainsSIB(EcoreUtil.generateUUID());
  }
  
  public ComplexListAttributeConnector createComplexListAttributeConnector(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    ComplexListAttributeConnector _createComplexListAttributeConnector = super.createComplexListAttributeConnector();
    final Procedure1<ComplexListAttributeConnector> _function = new Procedure1<ComplexListAttributeConnector>() {
      @Override
      public void apply(final ComplexListAttributeConnector it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalComplexListAttributeConnector _createInternalComplexListAttributeConnector = ProcessFactory.this._internalFactory.createInternalComplexListAttributeConnector();
          _elvis = _createInternalComplexListAttributeConnector;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            ComplexListAttributeConnectorEContentAdapter _complexListAttributeConnectorEContentAdapter = new ComplexListAttributeConnectorEContentAdapter();
            _eAdapters.add(_complexListAttributeConnectorEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ComplexListAttributeConnector>operator_doubleArrow(_createComplexListAttributeConnector, _function);
  }
  
  /**
   * This method creates an ComplexListAttributeConnector with the given id. Post create hook will be triggered.
   */
  public ComplexListAttributeConnector createComplexListAttributeConnector(final String ID, final InternalNode source, final InternalNode target) {
    return this.createComplexListAttributeConnector(ID, null, source, target, true);
  }
  
  /**
   * This method creates an ComplexListAttributeConnector with generated id. Post create hook will be triggered.
   */
  public ComplexListAttributeConnector createComplexListAttributeConnector(final InternalNode source, final InternalNode target) {
    return this.createComplexListAttributeConnector(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an ComplexListAttributeConnector with the given id. Post create hook won't be triggered.
   */
  public ComplexListAttributeConnector createComplexListAttributeConnector(final String ID) {
    return this.createComplexListAttributeConnector(ID, null, null, null, false);
  }
  
  /**
   * This method creates an ComplexListAttributeConnector with a generated id. Post create hook won't be triggered.
   */
  @Override
  public ComplexListAttributeConnector createComplexListAttributeConnector() {
    return this.createComplexListAttributeConnector(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an BranchBlueprint with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public BranchBlueprint createBranchBlueprint(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    BranchBlueprint _createBranchBlueprint = super.createBranchBlueprint();
    final Procedure1<BranchBlueprint> _function = new Procedure1<BranchBlueprint>() {
      @Override
      public void apply(final BranchBlueprint it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalBranchBlueprint _createInternalBranchBlueprint = ProcessFactory.this._internalFactory.createInternalBranchBlueprint();
          _elvis = _createInternalBranchBlueprint;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            BranchBlueprintEContentAdapter _branchBlueprintEContentAdapter = new BranchBlueprintEContentAdapter();
            _eAdapters.add(_branchBlueprintEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<BranchBlueprint>operator_doubleArrow(_createBranchBlueprint, _function);
  }
  
  /**
   * This method creates an BranchBlueprint with the given id. Post create hook won't be triggered.
   */
  public BranchBlueprint createBranchBlueprint(final String ID) {
    return this.createBranchBlueprint(ID, null, null, false);
  }
  
  /**
   * This method creates an BranchBlueprint with the given id. Post create hook will be triggered.
   */
  public BranchBlueprint createBranchBlueprint(final InternalModelElementContainer parent) {
    return this.createBranchBlueprint(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an BranchBlueprint with the given id. Post create hook will be triggered.
   */
  public BranchBlueprint createBranchBlueprint(final String ID, final InternalModelElementContainer parent) {
    return this.createBranchBlueprint(ID, null, parent, true);
  }
  
  public BranchBlueprint createBranchBlueprint(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createBranchBlueprint(ID, ime, parent, true);
  }
  
  /**
   * This method creates an BranchBlueprint with the given id. Post create hook won't be triggered.
   */
  public BranchBlueprint createBranchBlueprint(final InternalModelElement ime) {
    return this.createBranchBlueprint(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public BranchBlueprint createBranchBlueprint() {
    return this.createBranchBlueprint(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an IntegerInputStatic with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public IntegerInputStatic createIntegerInputStatic(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    IntegerInputStatic _createIntegerInputStatic = super.createIntegerInputStatic();
    final Procedure1<IntegerInputStatic> _function = new Procedure1<IntegerInputStatic>() {
      @Override
      public void apply(final IntegerInputStatic it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalIntegerInputStatic _createInternalIntegerInputStatic = ProcessFactory.this._internalFactory.createInternalIntegerInputStatic();
          _elvis = _createInternalIntegerInputStatic;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            IntegerInputStaticEContentAdapter _integerInputStaticEContentAdapter = new IntegerInputStaticEContentAdapter();
            _eAdapters.add(_integerInputStaticEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<IntegerInputStatic>operator_doubleArrow(_createIntegerInputStatic, _function);
  }
  
  /**
   * This method creates an IntegerInputStatic with the given id. Post create hook won't be triggered.
   */
  public IntegerInputStatic createIntegerInputStatic(final String ID) {
    return this.createIntegerInputStatic(ID, null, null, false);
  }
  
  /**
   * This method creates an IntegerInputStatic with the given id. Post create hook will be triggered.
   */
  public IntegerInputStatic createIntegerInputStatic(final InternalModelElementContainer parent) {
    return this.createIntegerInputStatic(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an IntegerInputStatic with the given id. Post create hook will be triggered.
   */
  public IntegerInputStatic createIntegerInputStatic(final String ID, final InternalModelElementContainer parent) {
    return this.createIntegerInputStatic(ID, null, parent, true);
  }
  
  public IntegerInputStatic createIntegerInputStatic(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createIntegerInputStatic(ID, ime, parent, true);
  }
  
  /**
   * This method creates an IntegerInputStatic with the given id. Post create hook won't be triggered.
   */
  public IntegerInputStatic createIntegerInputStatic(final InternalModelElement ime) {
    return this.createIntegerInputStatic(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public IntegerInputStatic createIntegerInputStatic() {
    return this.createIntegerInputStatic(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an StartSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public StartSIB createStartSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    StartSIB _createStartSIB = super.createStartSIB();
    final Procedure1<StartSIB> _function = new Procedure1<StartSIB>() {
      @Override
      public void apply(final StartSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalStartSIB _createInternalStartSIB = ProcessFactory.this._internalFactory.createInternalStartSIB();
          _elvis = _createInternalStartSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            StartSIBEContentAdapter _startSIBEContentAdapter = new StartSIBEContentAdapter();
            _eAdapters.add(_startSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<StartSIB>operator_doubleArrow(_createStartSIB, _function);
  }
  
  /**
   * This method creates an StartSIB with the given id. Post create hook won't be triggered.
   */
  public StartSIB createStartSIB(final String ID) {
    return this.createStartSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an StartSIB with the given id. Post create hook will be triggered.
   */
  public StartSIB createStartSIB(final InternalModelElementContainer parent) {
    return this.createStartSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an StartSIB with the given id. Post create hook will be triggered.
   */
  public StartSIB createStartSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createStartSIB(ID, null, parent, true);
  }
  
  public StartSIB createStartSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createStartSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an StartSIB with the given id. Post create hook won't be triggered.
   */
  public StartSIB createStartSIB(final InternalModelElement ime) {
    return this.createStartSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public StartSIB createStartSIB() {
    return this.createStartSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an TimestampInputStatic with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public TimestampInputStatic createTimestampInputStatic(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    TimestampInputStatic _createTimestampInputStatic = super.createTimestampInputStatic();
    final Procedure1<TimestampInputStatic> _function = new Procedure1<TimestampInputStatic>() {
      @Override
      public void apply(final TimestampInputStatic it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalTimestampInputStatic _createInternalTimestampInputStatic = ProcessFactory.this._internalFactory.createInternalTimestampInputStatic();
          _elvis = _createInternalTimestampInputStatic;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            TimestampInputStaticEContentAdapter _timestampInputStaticEContentAdapter = new TimestampInputStaticEContentAdapter();
            _eAdapters.add(_timestampInputStaticEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<TimestampInputStatic>operator_doubleArrow(_createTimestampInputStatic, _function);
  }
  
  /**
   * This method creates an TimestampInputStatic with the given id. Post create hook won't be triggered.
   */
  public TimestampInputStatic createTimestampInputStatic(final String ID) {
    return this.createTimestampInputStatic(ID, null, null, false);
  }
  
  /**
   * This method creates an TimestampInputStatic with the given id. Post create hook will be triggered.
   */
  public TimestampInputStatic createTimestampInputStatic(final InternalModelElementContainer parent) {
    return this.createTimestampInputStatic(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an TimestampInputStatic with the given id. Post create hook will be triggered.
   */
  public TimestampInputStatic createTimestampInputStatic(final String ID, final InternalModelElementContainer parent) {
    return this.createTimestampInputStatic(ID, null, parent, true);
  }
  
  public TimestampInputStatic createTimestampInputStatic(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createTimestampInputStatic(ID, ime, parent, true);
  }
  
  /**
   * This method creates an TimestampInputStatic with the given id. Post create hook won't be triggered.
   */
  public TimestampInputStatic createTimestampInputStatic(final InternalModelElement ime) {
    return this.createTimestampInputStatic(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public TimestampInputStatic createTimestampInputStatic() {
    return this.createTimestampInputStatic(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an EndSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public EndSIB createEndSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    EndSIB _createEndSIB = super.createEndSIB();
    final Procedure1<EndSIB> _function = new Procedure1<EndSIB>() {
      @Override
      public void apply(final EndSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalEndSIB _createInternalEndSIB = ProcessFactory.this._internalFactory.createInternalEndSIB();
          _elvis = _createInternalEndSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            EndSIBEContentAdapter _endSIBEContentAdapter = new EndSIBEContentAdapter();
            _eAdapters.add(_endSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<EndSIB>operator_doubleArrow(_createEndSIB, _function);
  }
  
  /**
   * This method creates an EndSIB with the given id. Post create hook won't be triggered.
   */
  public EndSIB createEndSIB(final String ID) {
    return this.createEndSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an EndSIB with the given id. Post create hook will be triggered.
   */
  public EndSIB createEndSIB(final InternalModelElementContainer parent) {
    return this.createEndSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an EndSIB with the given id. Post create hook will be triggered.
   */
  public EndSIB createEndSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createEndSIB(ID, null, parent, true);
  }
  
  public EndSIB createEndSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createEndSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an EndSIB with the given id. Post create hook won't be triggered.
   */
  public EndSIB createEndSIB(final InternalModelElement ime) {
    return this.createEndSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public EndSIB createEndSIB() {
    return this.createEndSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an LinkProcessSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public LinkProcessSIB createLinkProcessSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    LinkProcessSIB _createLinkProcessSIB = super.createLinkProcessSIB();
    final Procedure1<LinkProcessSIB> _function = new Procedure1<LinkProcessSIB>() {
      @Override
      public void apply(final LinkProcessSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalLinkProcessSIB _createInternalLinkProcessSIB = ProcessFactory.this._internalFactory.createInternalLinkProcessSIB();
          _elvis = _createInternalLinkProcessSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            LinkProcessSIBEContentAdapter _linkProcessSIBEContentAdapter = new LinkProcessSIBEContentAdapter();
            _eAdapters.add(_linkProcessSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<LinkProcessSIB>operator_doubleArrow(_createLinkProcessSIB, _function);
  }
  
  /**
   * This method creates an LinkProcessSIB with the given id. Post create hook won't be triggered.
   */
  public LinkProcessSIB createLinkProcessSIB(final String ID) {
    return this.createLinkProcessSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an LinkProcessSIB with the given id. Post create hook will be triggered.
   */
  public LinkProcessSIB createLinkProcessSIB(final InternalModelElementContainer parent) {
    return this.createLinkProcessSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an LinkProcessSIB with the given id. Post create hook will be triggered.
   */
  public LinkProcessSIB createLinkProcessSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createLinkProcessSIB(ID, null, parent, true);
  }
  
  public LinkProcessSIB createLinkProcessSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createLinkProcessSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an LinkProcessSIB with the given id. Post create hook won't be triggered.
   */
  public LinkProcessSIB createLinkProcessSIB(final InternalModelElement ime) {
    return this.createLinkProcessSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public LinkProcessSIB createLinkProcessSIB() {
    return this.createLinkProcessSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ComplexExtensionAttribute with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ComplexExtensionAttribute createComplexExtensionAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ComplexExtensionAttribute _createComplexExtensionAttribute = super.createComplexExtensionAttribute();
    final Procedure1<ComplexExtensionAttribute> _function = new Procedure1<ComplexExtensionAttribute>() {
      @Override
      public void apply(final ComplexExtensionAttribute it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalComplexExtensionAttribute _createInternalComplexExtensionAttribute = ProcessFactory.this._internalFactory.createInternalComplexExtensionAttribute();
          _elvis = _createInternalComplexExtensionAttribute;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ComplexExtensionAttributeEContentAdapter _complexExtensionAttributeEContentAdapter = new ComplexExtensionAttributeEContentAdapter();
            _eAdapters.add(_complexExtensionAttributeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ComplexExtensionAttribute>operator_doubleArrow(_createComplexExtensionAttribute, _function);
  }
  
  /**
   * This method creates an ComplexExtensionAttribute with the given id. Post create hook won't be triggered.
   */
  public ComplexExtensionAttribute createComplexExtensionAttribute(final String ID) {
    return this.createComplexExtensionAttribute(ID, null, null, false);
  }
  
  /**
   * This method creates an ComplexExtensionAttribute with the given id. Post create hook will be triggered.
   */
  public ComplexExtensionAttribute createComplexExtensionAttribute(final InternalModelElementContainer parent) {
    return this.createComplexExtensionAttribute(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ComplexExtensionAttribute with the given id. Post create hook will be triggered.
   */
  public ComplexExtensionAttribute createComplexExtensionAttribute(final String ID, final InternalModelElementContainer parent) {
    return this.createComplexExtensionAttribute(ID, null, parent, true);
  }
  
  public ComplexExtensionAttribute createComplexExtensionAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createComplexExtensionAttribute(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ComplexExtensionAttribute with the given id. Post create hook won't be triggered.
   */
  public ComplexExtensionAttribute createComplexExtensionAttribute(final InternalModelElement ime) {
    return this.createComplexExtensionAttribute(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ComplexExtensionAttribute createComplexExtensionAttribute() {
    return this.createComplexExtensionAttribute(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ComplexVariable with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ComplexVariable createComplexVariable(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ComplexVariable _createComplexVariable = super.createComplexVariable();
    final Procedure1<ComplexVariable> _function = new Procedure1<ComplexVariable>() {
      @Override
      public void apply(final ComplexVariable it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalComplexVariable _createInternalComplexVariable = ProcessFactory.this._internalFactory.createInternalComplexVariable();
          _elvis = _createInternalComplexVariable;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ComplexVariableEContentAdapter _complexVariableEContentAdapter = new ComplexVariableEContentAdapter();
            _eAdapters.add(_complexVariableEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ComplexVariable>operator_doubleArrow(_createComplexVariable, _function);
  }
  
  /**
   * This method creates an ComplexVariable with the given id. Post create hook won't be triggered.
   */
  public ComplexVariable createComplexVariable(final String ID) {
    return this.createComplexVariable(ID, null, null, false);
  }
  
  /**
   * This method creates an ComplexVariable with the given id. Post create hook will be triggered.
   */
  public ComplexVariable createComplexVariable(final InternalModelElementContainer parent) {
    return this.createComplexVariable(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ComplexVariable with the given id. Post create hook will be triggered.
   */
  public ComplexVariable createComplexVariable(final String ID, final InternalModelElementContainer parent) {
    return this.createComplexVariable(ID, null, parent, true);
  }
  
  public ComplexVariable createComplexVariable(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createComplexVariable(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ComplexVariable with the given id. Post create hook won't be triggered.
   */
  public ComplexVariable createComplexVariable(final InternalModelElement ime) {
    return this.createComplexVariable(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ComplexVariable createComplexVariable() {
    return this.createComplexVariable(EcoreUtil.generateUUID());
  }
  
  public ComplexDirectDataFlow createComplexDirectDataFlow(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    ComplexDirectDataFlow _createComplexDirectDataFlow = super.createComplexDirectDataFlow();
    final Procedure1<ComplexDirectDataFlow> _function = new Procedure1<ComplexDirectDataFlow>() {
      @Override
      public void apply(final ComplexDirectDataFlow it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalComplexDirectDataFlow _createInternalComplexDirectDataFlow = ProcessFactory.this._internalFactory.createInternalComplexDirectDataFlow();
          _elvis = _createInternalComplexDirectDataFlow;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            ComplexDirectDataFlowEContentAdapter _complexDirectDataFlowEContentAdapter = new ComplexDirectDataFlowEContentAdapter();
            _eAdapters.add(_complexDirectDataFlowEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ComplexDirectDataFlow>operator_doubleArrow(_createComplexDirectDataFlow, _function);
  }
  
  /**
   * This method creates an ComplexDirectDataFlow with the given id. Post create hook will be triggered.
   */
  public ComplexDirectDataFlow createComplexDirectDataFlow(final String ID, final InternalNode source, final InternalNode target) {
    return this.createComplexDirectDataFlow(ID, null, source, target, true);
  }
  
  /**
   * This method creates an ComplexDirectDataFlow with generated id. Post create hook will be triggered.
   */
  public ComplexDirectDataFlow createComplexDirectDataFlow(final InternalNode source, final InternalNode target) {
    return this.createComplexDirectDataFlow(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an ComplexDirectDataFlow with the given id. Post create hook won't be triggered.
   */
  public ComplexDirectDataFlow createComplexDirectDataFlow(final String ID) {
    return this.createComplexDirectDataFlow(ID, null, null, null, false);
  }
  
  /**
   * This method creates an ComplexDirectDataFlow with a generated id. Post create hook won't be triggered.
   */
  @Override
  public ComplexDirectDataFlow createComplexDirectDataFlow() {
    return this.createComplexDirectDataFlow(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ComplexListAttribute with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ComplexListAttribute createComplexListAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ComplexListAttribute _createComplexListAttribute = super.createComplexListAttribute();
    final Procedure1<ComplexListAttribute> _function = new Procedure1<ComplexListAttribute>() {
      @Override
      public void apply(final ComplexListAttribute it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalComplexListAttribute _createInternalComplexListAttribute = ProcessFactory.this._internalFactory.createInternalComplexListAttribute();
          _elvis = _createInternalComplexListAttribute;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ComplexListAttributeEContentAdapter _complexListAttributeEContentAdapter = new ComplexListAttributeEContentAdapter();
            _eAdapters.add(_complexListAttributeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ComplexListAttribute>operator_doubleArrow(_createComplexListAttribute, _function);
  }
  
  /**
   * This method creates an ComplexListAttribute with the given id. Post create hook won't be triggered.
   */
  public ComplexListAttribute createComplexListAttribute(final String ID) {
    return this.createComplexListAttribute(ID, null, null, false);
  }
  
  /**
   * This method creates an ComplexListAttribute with the given id. Post create hook will be triggered.
   */
  public ComplexListAttribute createComplexListAttribute(final InternalModelElementContainer parent) {
    return this.createComplexListAttribute(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ComplexListAttribute with the given id. Post create hook will be triggered.
   */
  public ComplexListAttribute createComplexListAttribute(final String ID, final InternalModelElementContainer parent) {
    return this.createComplexListAttribute(ID, null, parent, true);
  }
  
  public ComplexListAttribute createComplexListAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createComplexListAttribute(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ComplexListAttribute with the given id. Post create hook won't be triggered.
   */
  public ComplexListAttribute createComplexListAttribute(final InternalModelElement ime) {
    return this.createComplexListAttribute(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ComplexListAttribute createComplexListAttribute() {
    return this.createComplexListAttribute(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ComplexAttributePort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ComplexAttributePort createComplexAttributePort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ComplexAttributePort _createComplexAttributePort = super.createComplexAttributePort();
    final Procedure1<ComplexAttributePort> _function = new Procedure1<ComplexAttributePort>() {
      @Override
      public void apply(final ComplexAttributePort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalComplexAttributePort _createInternalComplexAttributePort = ProcessFactory.this._internalFactory.createInternalComplexAttributePort();
          _elvis = _createInternalComplexAttributePort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ComplexAttributePortEContentAdapter _complexAttributePortEContentAdapter = new ComplexAttributePortEContentAdapter();
            _eAdapters.add(_complexAttributePortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ComplexAttributePort>operator_doubleArrow(_createComplexAttributePort, _function);
  }
  
  /**
   * This method creates an ComplexAttributePort with the given id. Post create hook won't be triggered.
   */
  public ComplexAttributePort createComplexAttributePort(final String ID) {
    return this.createComplexAttributePort(ID, null, null, false);
  }
  
  /**
   * This method creates an ComplexAttributePort with the given id. Post create hook will be triggered.
   */
  public ComplexAttributePort createComplexAttributePort(final InternalModelElementContainer parent) {
    return this.createComplexAttributePort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ComplexAttributePort with the given id. Post create hook will be triggered.
   */
  public ComplexAttributePort createComplexAttributePort(final String ID, final InternalModelElementContainer parent) {
    return this.createComplexAttributePort(ID, null, parent, true);
  }
  
  public ComplexAttributePort createComplexAttributePort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createComplexAttributePort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ComplexAttributePort with the given id. Post create hook won't be triggered.
   */
  public ComplexAttributePort createComplexAttributePort(final InternalModelElement ime) {
    return this.createComplexAttributePort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ComplexAttributePort createComplexAttributePort() {
    return this.createComplexAttributePort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an GetOriginalUserSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public GetOriginalUserSIB createGetOriginalUserSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    GetOriginalUserSIB _createGetOriginalUserSIB = super.createGetOriginalUserSIB();
    final Procedure1<GetOriginalUserSIB> _function = new Procedure1<GetOriginalUserSIB>() {
      @Override
      public void apply(final GetOriginalUserSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalGetOriginalUserSIB _createInternalGetOriginalUserSIB = ProcessFactory.this._internalFactory.createInternalGetOriginalUserSIB();
          _elvis = _createInternalGetOriginalUserSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            GetOriginalUserSIBEContentAdapter _getOriginalUserSIBEContentAdapter = new GetOriginalUserSIBEContentAdapter();
            _eAdapters.add(_getOriginalUserSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<GetOriginalUserSIB>operator_doubleArrow(_createGetOriginalUserSIB, _function);
  }
  
  /**
   * This method creates an GetOriginalUserSIB with the given id. Post create hook won't be triggered.
   */
  public GetOriginalUserSIB createGetOriginalUserSIB(final String ID) {
    return this.createGetOriginalUserSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an GetOriginalUserSIB with the given id. Post create hook will be triggered.
   */
  public GetOriginalUserSIB createGetOriginalUserSIB(final InternalModelElementContainer parent) {
    return this.createGetOriginalUserSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an GetOriginalUserSIB with the given id. Post create hook will be triggered.
   */
  public GetOriginalUserSIB createGetOriginalUserSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createGetOriginalUserSIB(ID, null, parent, true);
  }
  
  public GetOriginalUserSIB createGetOriginalUserSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createGetOriginalUserSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an GetOriginalUserSIB with the given id. Post create hook won't be triggered.
   */
  public GetOriginalUserSIB createGetOriginalUserSIB(final InternalModelElement ime) {
    return this.createGetOriginalUserSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public GetOriginalUserSIB createGetOriginalUserSIB() {
    return this.createGetOriginalUserSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an IgnoreBranch with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public IgnoreBranch createIgnoreBranch(final String ID, final InternalModelElement ime, final boolean hook) {
    IgnoreBranch _createIgnoreBranch = super.createIgnoreBranch();
    final Procedure1<IgnoreBranch> _function = new Procedure1<IgnoreBranch>() {
      @Override
      public void apply(final IgnoreBranch it) {
        EcoreUtil.setID(it, ID);
        InternalIdentifiableElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalIgnoreBranch _createInternalIgnoreBranch = ProcessFactory.this._internalFactory.createInternalIgnoreBranch();
          _elvis = _createInternalIgnoreBranch;
        }
        final Procedure1<InternalIdentifiableElement> _function = new Procedure1<InternalIdentifiableElement>() {
          @Override
          public void apply(final InternalIdentifiableElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            IgnoreBranchEContentAdapter _ignoreBranchEContentAdapter = new IgnoreBranchEContentAdapter();
            _eAdapters.add(_ignoreBranchEContentAdapter);
          }
        };
        InternalIdentifiableElement _doubleArrow = ObjectExtensions.<InternalIdentifiableElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<IgnoreBranch>operator_doubleArrow(_createIgnoreBranch, _function);
  }
  
  /**
   * This method creates an IgnoreBranch with the given id. Post create hook won't be triggered.
   */
  public IgnoreBranch createIgnoreBranch(final String ID) {
    return this.createIgnoreBranch(ID, null, false);
  }
  
  /**
   * This method creates an IgnoreBranch with the given id. Post create hook won't be triggered.
   */
  public IgnoreBranch createIgnoreBranch(final InternalModelElement ime) {
    return this.createIgnoreBranch(EcoreUtil.generateUUID(), ime, false);
  }
  
  @Override
  public IgnoreBranch createIgnoreBranch() {
    return this.createIgnoreBranch(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an NativeFrontendBranch with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public NativeFrontendBranch createNativeFrontendBranch(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    NativeFrontendBranch _createNativeFrontendBranch = super.createNativeFrontendBranch();
    final Procedure1<NativeFrontendBranch> _function = new Procedure1<NativeFrontendBranch>() {
      @Override
      public void apply(final NativeFrontendBranch it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalNativeFrontendBranch _createInternalNativeFrontendBranch = ProcessFactory.this._internalFactory.createInternalNativeFrontendBranch();
          _elvis = _createInternalNativeFrontendBranch;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            NativeFrontendBranchEContentAdapter _nativeFrontendBranchEContentAdapter = new NativeFrontendBranchEContentAdapter();
            _eAdapters.add(_nativeFrontendBranchEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<NativeFrontendBranch>operator_doubleArrow(_createNativeFrontendBranch, _function);
  }
  
  /**
   * This method creates an NativeFrontendBranch with the given id. Post create hook won't be triggered.
   */
  public NativeFrontendBranch createNativeFrontendBranch(final String ID) {
    return this.createNativeFrontendBranch(ID, null, null, false);
  }
  
  /**
   * This method creates an NativeFrontendBranch with the given id. Post create hook will be triggered.
   */
  public NativeFrontendBranch createNativeFrontendBranch(final InternalModelElementContainer parent) {
    return this.createNativeFrontendBranch(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an NativeFrontendBranch with the given id. Post create hook will be triggered.
   */
  public NativeFrontendBranch createNativeFrontendBranch(final String ID, final InternalModelElementContainer parent) {
    return this.createNativeFrontendBranch(ID, null, parent, true);
  }
  
  public NativeFrontendBranch createNativeFrontendBranch(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createNativeFrontendBranch(ID, ime, parent, true);
  }
  
  /**
   * This method creates an NativeFrontendBranch with the given id. Post create hook won't be triggered.
   */
  public NativeFrontendBranch createNativeFrontendBranch(final InternalModelElement ime) {
    return this.createNativeFrontendBranch(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public NativeFrontendBranch createNativeFrontendBranch() {
    return this.createNativeFrontendBranch(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an IterateSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public IterateSIB createIterateSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    IterateSIB _createIterateSIB = super.createIterateSIB();
    final Procedure1<IterateSIB> _function = new Procedure1<IterateSIB>() {
      @Override
      public void apply(final IterateSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalIterateSIB _createInternalIterateSIB = ProcessFactory.this._internalFactory.createInternalIterateSIB();
          _elvis = _createInternalIterateSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            IterateSIBEContentAdapter _iterateSIBEContentAdapter = new IterateSIBEContentAdapter();
            _eAdapters.add(_iterateSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<IterateSIB>operator_doubleArrow(_createIterateSIB, _function);
  }
  
  /**
   * This method creates an IterateSIB with the given id. Post create hook won't be triggered.
   */
  public IterateSIB createIterateSIB(final String ID) {
    return this.createIterateSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an IterateSIB with the given id. Post create hook will be triggered.
   */
  public IterateSIB createIterateSIB(final InternalModelElementContainer parent) {
    return this.createIterateSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an IterateSIB with the given id. Post create hook will be triggered.
   */
  public IterateSIB createIterateSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createIterateSIB(ID, null, parent, true);
  }
  
  public IterateSIB createIterateSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createIterateSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an IterateSIB with the given id. Post create hook won't be triggered.
   */
  public IterateSIB createIterateSIB(final InternalModelElement ime) {
    return this.createIterateSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public IterateSIB createIterateSIB() {
    return this.createIterateSIB(EcoreUtil.generateUUID());
  }
  
  public JavaNativeRead createJavaNativeRead(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    JavaNativeRead _createJavaNativeRead = super.createJavaNativeRead();
    final Procedure1<JavaNativeRead> _function = new Procedure1<JavaNativeRead>() {
      @Override
      public void apply(final JavaNativeRead it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalJavaNativeRead _createInternalJavaNativeRead = ProcessFactory.this._internalFactory.createInternalJavaNativeRead();
          _elvis = _createInternalJavaNativeRead;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            JavaNativeReadEContentAdapter _javaNativeReadEContentAdapter = new JavaNativeReadEContentAdapter();
            _eAdapters.add(_javaNativeReadEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<JavaNativeRead>operator_doubleArrow(_createJavaNativeRead, _function);
  }
  
  /**
   * This method creates an JavaNativeRead with the given id. Post create hook will be triggered.
   */
  public JavaNativeRead createJavaNativeRead(final String ID, final InternalNode source, final InternalNode target) {
    return this.createJavaNativeRead(ID, null, source, target, true);
  }
  
  /**
   * This method creates an JavaNativeRead with generated id. Post create hook will be triggered.
   */
  public JavaNativeRead createJavaNativeRead(final InternalNode source, final InternalNode target) {
    return this.createJavaNativeRead(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an JavaNativeRead with the given id. Post create hook won't be triggered.
   */
  public JavaNativeRead createJavaNativeRead(final String ID) {
    return this.createJavaNativeRead(ID, null, null, null, false);
  }
  
  /**
   * This method creates an JavaNativeRead with a generated id. Post create hook won't be triggered.
   */
  @Override
  public JavaNativeRead createJavaNativeRead() {
    return this.createJavaNativeRead(EcoreUtil.generateUUID());
  }
  
  public ComplexUpdate createComplexUpdate(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    ComplexUpdate _createComplexUpdate = super.createComplexUpdate();
    final Procedure1<ComplexUpdate> _function = new Procedure1<ComplexUpdate>() {
      @Override
      public void apply(final ComplexUpdate it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalComplexUpdate _createInternalComplexUpdate = ProcessFactory.this._internalFactory.createInternalComplexUpdate();
          _elvis = _createInternalComplexUpdate;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            ComplexUpdateEContentAdapter _complexUpdateEContentAdapter = new ComplexUpdateEContentAdapter();
            _eAdapters.add(_complexUpdateEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ComplexUpdate>operator_doubleArrow(_createComplexUpdate, _function);
  }
  
  /**
   * This method creates an ComplexUpdate with the given id. Post create hook will be triggered.
   */
  public ComplexUpdate createComplexUpdate(final String ID, final InternalNode source, final InternalNode target) {
    return this.createComplexUpdate(ID, null, source, target, true);
  }
  
  /**
   * This method creates an ComplexUpdate with generated id. Post create hook will be triggered.
   */
  public ComplexUpdate createComplexUpdate(final InternalNode source, final InternalNode target) {
    return this.createComplexUpdate(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an ComplexUpdate with the given id. Post create hook won't be triggered.
   */
  public ComplexUpdate createComplexUpdate(final String ID) {
    return this.createComplexUpdate(ID, null, null, null, false);
  }
  
  /**
   * This method creates an ComplexUpdate with a generated id. Post create hook won't be triggered.
   */
  @Override
  public ComplexUpdate createComplexUpdate() {
    return this.createComplexUpdate(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ComplexAttribute with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ComplexAttribute createComplexAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ComplexAttribute _createComplexAttribute = super.createComplexAttribute();
    final Procedure1<ComplexAttribute> _function = new Procedure1<ComplexAttribute>() {
      @Override
      public void apply(final ComplexAttribute it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalComplexAttribute _createInternalComplexAttribute = ProcessFactory.this._internalFactory.createInternalComplexAttribute();
          _elvis = _createInternalComplexAttribute;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ComplexAttributeEContentAdapter _complexAttributeEContentAdapter = new ComplexAttributeEContentAdapter();
            _eAdapters.add(_complexAttributeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ComplexAttribute>operator_doubleArrow(_createComplexAttribute, _function);
  }
  
  /**
   * This method creates an ComplexAttribute with the given id. Post create hook won't be triggered.
   */
  public ComplexAttribute createComplexAttribute(final String ID) {
    return this.createComplexAttribute(ID, null, null, false);
  }
  
  /**
   * This method creates an ComplexAttribute with the given id. Post create hook will be triggered.
   */
  public ComplexAttribute createComplexAttribute(final InternalModelElementContainer parent) {
    return this.createComplexAttribute(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ComplexAttribute with the given id. Post create hook will be triggered.
   */
  public ComplexAttribute createComplexAttribute(final String ID, final InternalModelElementContainer parent) {
    return this.createComplexAttribute(ID, null, parent, true);
  }
  
  public ComplexAttribute createComplexAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createComplexAttribute(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ComplexAttribute with the given id. Post create hook won't be triggered.
   */
  public ComplexAttribute createComplexAttribute(final InternalModelElement ime) {
    return this.createComplexAttribute(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ComplexAttribute createComplexAttribute() {
    return this.createComplexAttribute(EcoreUtil.generateUUID());
  }
  
  public ComplexAttributeConnector createComplexAttributeConnector(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    ComplexAttributeConnector _createComplexAttributeConnector = super.createComplexAttributeConnector();
    final Procedure1<ComplexAttributeConnector> _function = new Procedure1<ComplexAttributeConnector>() {
      @Override
      public void apply(final ComplexAttributeConnector it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalComplexAttributeConnector _createInternalComplexAttributeConnector = ProcessFactory.this._internalFactory.createInternalComplexAttributeConnector();
          _elvis = _createInternalComplexAttributeConnector;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            ComplexAttributeConnectorEContentAdapter _complexAttributeConnectorEContentAdapter = new ComplexAttributeConnectorEContentAdapter();
            _eAdapters.add(_complexAttributeConnectorEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ComplexAttributeConnector>operator_doubleArrow(_createComplexAttributeConnector, _function);
  }
  
  /**
   * This method creates an ComplexAttributeConnector with the given id. Post create hook will be triggered.
   */
  public ComplexAttributeConnector createComplexAttributeConnector(final String ID, final InternalNode source, final InternalNode target) {
    return this.createComplexAttributeConnector(ID, null, source, target, true);
  }
  
  /**
   * This method creates an ComplexAttributeConnector with generated id. Post create hook will be triggered.
   */
  public ComplexAttributeConnector createComplexAttributeConnector(final InternalNode source, final InternalNode target) {
    return this.createComplexAttributeConnector(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an ComplexAttributeConnector with the given id. Post create hook won't be triggered.
   */
  public ComplexAttributeConnector createComplexAttributeConnector(final String ID) {
    return this.createComplexAttributeConnector(ID, null, null, null, false);
  }
  
  /**
   * This method creates an ComplexAttributeConnector with a generated id. Post create hook won't be triggered.
   */
  @Override
  public ComplexAttributeConnector createComplexAttributeConnector() {
    return this.createComplexAttributeConnector(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an GUISIBOptions with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public GUISIBOptions createGUISIBOptions(final String ID, final InternalModelElement ime, final boolean hook) {
    GUISIBOptions _createGUISIBOptions = super.createGUISIBOptions();
    final Procedure1<GUISIBOptions> _function = new Procedure1<GUISIBOptions>() {
      @Override
      public void apply(final GUISIBOptions it) {
        EcoreUtil.setID(it, ID);
        InternalIdentifiableElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalGUISIBOptions _createInternalGUISIBOptions = ProcessFactory.this._internalFactory.createInternalGUISIBOptions();
          _elvis = _createInternalGUISIBOptions;
        }
        final Procedure1<InternalIdentifiableElement> _function = new Procedure1<InternalIdentifiableElement>() {
          @Override
          public void apply(final InternalIdentifiableElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            GUISIBOptionsEContentAdapter _gUISIBOptionsEContentAdapter = new GUISIBOptionsEContentAdapter();
            _eAdapters.add(_gUISIBOptionsEContentAdapter);
          }
        };
        InternalIdentifiableElement _doubleArrow = ObjectExtensions.<InternalIdentifiableElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<GUISIBOptions>operator_doubleArrow(_createGUISIBOptions, _function);
  }
  
  /**
   * This method creates an GUISIBOptions with the given id. Post create hook won't be triggered.
   */
  public GUISIBOptions createGUISIBOptions(final String ID) {
    return this.createGUISIBOptions(ID, null, false);
  }
  
  /**
   * This method creates an GUISIBOptions with the given id. Post create hook won't be triggered.
   */
  public GUISIBOptions createGUISIBOptions(final InternalModelElement ime) {
    return this.createGUISIBOptions(EcoreUtil.generateUUID(), ime, false);
  }
  
  @Override
  public GUISIBOptions createGUISIBOptions() {
    return this.createGUISIBOptions(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an RemoveFromListSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public RemoveFromListSIB createRemoveFromListSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    RemoveFromListSIB _createRemoveFromListSIB = super.createRemoveFromListSIB();
    final Procedure1<RemoveFromListSIB> _function = new Procedure1<RemoveFromListSIB>() {
      @Override
      public void apply(final RemoveFromListSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalRemoveFromListSIB _createInternalRemoveFromListSIB = ProcessFactory.this._internalFactory.createInternalRemoveFromListSIB();
          _elvis = _createInternalRemoveFromListSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            RemoveFromListSIBEContentAdapter _removeFromListSIBEContentAdapter = new RemoveFromListSIBEContentAdapter();
            _eAdapters.add(_removeFromListSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<RemoveFromListSIB>operator_doubleArrow(_createRemoveFromListSIB, _function);
  }
  
  /**
   * This method creates an RemoveFromListSIB with the given id. Post create hook won't be triggered.
   */
  public RemoveFromListSIB createRemoveFromListSIB(final String ID) {
    return this.createRemoveFromListSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an RemoveFromListSIB with the given id. Post create hook will be triggered.
   */
  public RemoveFromListSIB createRemoveFromListSIB(final InternalModelElementContainer parent) {
    return this.createRemoveFromListSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an RemoveFromListSIB with the given id. Post create hook will be triggered.
   */
  public RemoveFromListSIB createRemoveFromListSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createRemoveFromListSIB(ID, null, parent, true);
  }
  
  public RemoveFromListSIB createRemoveFromListSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createRemoveFromListSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an RemoveFromListSIB with the given id. Post create hook won't be triggered.
   */
  public RemoveFromListSIB createRemoveFromListSIB(final InternalModelElement ime) {
    return this.createRemoveFromListSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public RemoveFromListSIB createRemoveFromListSIB() {
    return this.createRemoveFromListSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an NativeFrontendSIBReference with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public NativeFrontendSIBReference createNativeFrontendSIBReference(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    NativeFrontendSIBReference _createNativeFrontendSIBReference = super.createNativeFrontendSIBReference();
    final Procedure1<NativeFrontendSIBReference> _function = new Procedure1<NativeFrontendSIBReference>() {
      @Override
      public void apply(final NativeFrontendSIBReference it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalNativeFrontendSIBReference _createInternalNativeFrontendSIBReference = ProcessFactory.this._internalFactory.createInternalNativeFrontendSIBReference();
          _elvis = _createInternalNativeFrontendSIBReference;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            NativeFrontendSIBReferenceEContentAdapter _nativeFrontendSIBReferenceEContentAdapter = new NativeFrontendSIBReferenceEContentAdapter();
            _eAdapters.add(_nativeFrontendSIBReferenceEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<NativeFrontendSIBReference>operator_doubleArrow(_createNativeFrontendSIBReference, _function);
  }
  
  /**
   * This method creates an NativeFrontendSIBReference with the given id. Post create hook won't be triggered.
   */
  public NativeFrontendSIBReference createNativeFrontendSIBReference(final String ID) {
    return this.createNativeFrontendSIBReference(ID, null, null, false);
  }
  
  /**
   * This method creates an NativeFrontendSIBReference with the given id. Post create hook will be triggered.
   */
  public NativeFrontendSIBReference createNativeFrontendSIBReference(final InternalModelElementContainer parent) {
    return this.createNativeFrontendSIBReference(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an NativeFrontendSIBReference with the given id. Post create hook will be triggered.
   */
  public NativeFrontendSIBReference createNativeFrontendSIBReference(final String ID, final InternalModelElementContainer parent) {
    return this.createNativeFrontendSIBReference(ID, null, parent, true);
  }
  
  public NativeFrontendSIBReference createNativeFrontendSIBReference(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createNativeFrontendSIBReference(ID, ime, parent, true);
  }
  
  /**
   * This method creates an NativeFrontendSIBReference with the given id. Post create hook won't be triggered.
   */
  public NativeFrontendSIBReference createNativeFrontendSIBReference(final InternalModelElement ime) {
    return this.createNativeFrontendSIBReference(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public NativeFrontendSIBReference createNativeFrontendSIBReference() {
    return this.createNativeFrontendSIBReference(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an NativeFrontendSIBLibrary with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public NativeFrontendSIBLibrary createNativeFrontendSIBLibrary(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    NativeFrontendSIBLibrary _createNativeFrontendSIBLibrary = super.createNativeFrontendSIBLibrary();
    final Procedure1<NativeFrontendSIBLibrary> _function = new Procedure1<NativeFrontendSIBLibrary>() {
      @Override
      public void apply(final NativeFrontendSIBLibrary it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalNativeFrontendSIBLibrary _createInternalNativeFrontendSIBLibrary = ProcessFactory.this._internalFactory.createInternalNativeFrontendSIBLibrary();
          _elvis = _createInternalNativeFrontendSIBLibrary;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            NativeFrontendSIBLibraryEContentAdapter _nativeFrontendSIBLibraryEContentAdapter = new NativeFrontendSIBLibraryEContentAdapter();
            _eAdapters.add(_nativeFrontendSIBLibraryEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<NativeFrontendSIBLibrary>operator_doubleArrow(_createNativeFrontendSIBLibrary, _function);
  }
  
  /**
   * This method creates an NativeFrontendSIBLibrary with the given id. Post create hook won't be triggered.
   */
  public NativeFrontendSIBLibrary createNativeFrontendSIBLibrary(final String ID) {
    return this.createNativeFrontendSIBLibrary(ID, null, null, false);
  }
  
  /**
   * This method creates an NativeFrontendSIBLibrary with the given id. Post create hook will be triggered.
   */
  public NativeFrontendSIBLibrary createNativeFrontendSIBLibrary(final InternalModelElementContainer parent) {
    return this.createNativeFrontendSIBLibrary(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an NativeFrontendSIBLibrary with the given id. Post create hook will be triggered.
   */
  public NativeFrontendSIBLibrary createNativeFrontendSIBLibrary(final String ID, final InternalModelElementContainer parent) {
    return this.createNativeFrontendSIBLibrary(ID, null, parent, true);
  }
  
  public NativeFrontendSIBLibrary createNativeFrontendSIBLibrary(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createNativeFrontendSIBLibrary(ID, ime, parent, true);
  }
  
  /**
   * This method creates an NativeFrontendSIBLibrary with the given id. Post create hook won't be triggered.
   */
  public NativeFrontendSIBLibrary createNativeFrontendSIBLibrary(final InternalModelElement ime) {
    return this.createNativeFrontendSIBLibrary(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public NativeFrontendSIBLibrary createNativeFrontendSIBLibrary() {
    return this.createNativeFrontendSIBLibrary(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ComplexInputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ComplexInputPort createComplexInputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ComplexInputPort _createComplexInputPort = super.createComplexInputPort();
    final Procedure1<ComplexInputPort> _function = new Procedure1<ComplexInputPort>() {
      @Override
      public void apply(final ComplexInputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalComplexInputPort _createInternalComplexInputPort = ProcessFactory.this._internalFactory.createInternalComplexInputPort();
          _elvis = _createInternalComplexInputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ComplexInputPortEContentAdapter _complexInputPortEContentAdapter = new ComplexInputPortEContentAdapter();
            _eAdapters.add(_complexInputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ComplexInputPort>operator_doubleArrow(_createComplexInputPort, _function);
  }
  
  /**
   * This method creates an ComplexInputPort with the given id. Post create hook won't be triggered.
   */
  public ComplexInputPort createComplexInputPort(final String ID) {
    return this.createComplexInputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an ComplexInputPort with the given id. Post create hook will be triggered.
   */
  public ComplexInputPort createComplexInputPort(final InternalModelElementContainer parent) {
    return this.createComplexInputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ComplexInputPort with the given id. Post create hook will be triggered.
   */
  public ComplexInputPort createComplexInputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createComplexInputPort(ID, null, parent, true);
  }
  
  public ComplexInputPort createComplexInputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createComplexInputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ComplexInputPort with the given id. Post create hook won't be triggered.
   */
  public ComplexInputPort createComplexInputPort(final InternalModelElement ime) {
    return this.createComplexInputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ComplexInputPort createComplexInputPort() {
    return this.createComplexInputPort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an RealInputStatic with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public RealInputStatic createRealInputStatic(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    RealInputStatic _createRealInputStatic = super.createRealInputStatic();
    final Procedure1<RealInputStatic> _function = new Procedure1<RealInputStatic>() {
      @Override
      public void apply(final RealInputStatic it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalRealInputStatic _createInternalRealInputStatic = ProcessFactory.this._internalFactory.createInternalRealInputStatic();
          _elvis = _createInternalRealInputStatic;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            RealInputStaticEContentAdapter _realInputStaticEContentAdapter = new RealInputStaticEContentAdapter();
            _eAdapters.add(_realInputStaticEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<RealInputStatic>operator_doubleArrow(_createRealInputStatic, _function);
  }
  
  /**
   * This method creates an RealInputStatic with the given id. Post create hook won't be triggered.
   */
  public RealInputStatic createRealInputStatic(final String ID) {
    return this.createRealInputStatic(ID, null, null, false);
  }
  
  /**
   * This method creates an RealInputStatic with the given id. Post create hook will be triggered.
   */
  public RealInputStatic createRealInputStatic(final InternalModelElementContainer parent) {
    return this.createRealInputStatic(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an RealInputStatic with the given id. Post create hook will be triggered.
   */
  public RealInputStatic createRealInputStatic(final String ID, final InternalModelElementContainer parent) {
    return this.createRealInputStatic(ID, null, parent, true);
  }
  
  public RealInputStatic createRealInputStatic(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createRealInputStatic(ID, ime, parent, true);
  }
  
  /**
   * This method creates an RealInputStatic with the given id. Post create hook won't be triggered.
   */
  public RealInputStatic createRealInputStatic(final InternalModelElement ime) {
    return this.createRealInputStatic(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public RealInputStatic createRealInputStatic() {
    return this.createRealInputStatic(EcoreUtil.generateUUID());
  }
  
  public Registration createRegistration(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    Registration _createRegistration = super.createRegistration();
    final Procedure1<Registration> _function = new Procedure1<Registration>() {
      @Override
      public void apply(final Registration it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalRegistration _createInternalRegistration = ProcessFactory.this._internalFactory.createInternalRegistration();
          _elvis = _createInternalRegistration;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            RegistrationEContentAdapter _registrationEContentAdapter = new RegistrationEContentAdapter();
            _eAdapters.add(_registrationEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<Registration>operator_doubleArrow(_createRegistration, _function);
  }
  
  /**
   * This method creates an Registration with the given id. Post create hook will be triggered.
   */
  public Registration createRegistration(final String ID, final InternalNode source, final InternalNode target) {
    return this.createRegistration(ID, null, source, target, true);
  }
  
  /**
   * This method creates an Registration with generated id. Post create hook will be triggered.
   */
  public Registration createRegistration(final InternalNode source, final InternalNode target) {
    return this.createRegistration(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an Registration with the given id. Post create hook won't be triggered.
   */
  public Registration createRegistration(final String ID) {
    return this.createRegistration(ID, null, null, null, false);
  }
  
  /**
   * This method creates an Registration with a generated id. Post create hook won't be triggered.
   */
  @Override
  public Registration createRegistration() {
    return this.createRegistration(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an JavaNativeInputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public JavaNativeInputPort createJavaNativeInputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    JavaNativeInputPort _createJavaNativeInputPort = super.createJavaNativeInputPort();
    final Procedure1<JavaNativeInputPort> _function = new Procedure1<JavaNativeInputPort>() {
      @Override
      public void apply(final JavaNativeInputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalJavaNativeInputPort _createInternalJavaNativeInputPort = ProcessFactory.this._internalFactory.createInternalJavaNativeInputPort();
          _elvis = _createInternalJavaNativeInputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            JavaNativeInputPortEContentAdapter _javaNativeInputPortEContentAdapter = new JavaNativeInputPortEContentAdapter();
            _eAdapters.add(_javaNativeInputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<JavaNativeInputPort>operator_doubleArrow(_createJavaNativeInputPort, _function);
  }
  
  /**
   * This method creates an JavaNativeInputPort with the given id. Post create hook won't be triggered.
   */
  public JavaNativeInputPort createJavaNativeInputPort(final String ID) {
    return this.createJavaNativeInputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an JavaNativeInputPort with the given id. Post create hook will be triggered.
   */
  public JavaNativeInputPort createJavaNativeInputPort(final InternalModelElementContainer parent) {
    return this.createJavaNativeInputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an JavaNativeInputPort with the given id. Post create hook will be triggered.
   */
  public JavaNativeInputPort createJavaNativeInputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createJavaNativeInputPort(ID, null, parent, true);
  }
  
  public JavaNativeInputPort createJavaNativeInputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createJavaNativeInputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an JavaNativeInputPort with the given id. Post create hook won't be triggered.
   */
  public JavaNativeInputPort createJavaNativeInputPort(final InternalModelElement ime) {
    return this.createJavaNativeInputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public JavaNativeInputPort createJavaNativeInputPort() {
    return this.createJavaNativeInputPort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an Branch with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public Branch createBranch(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    Branch _createBranch = super.createBranch();
    final Procedure1<Branch> _function = new Procedure1<Branch>() {
      @Override
      public void apply(final Branch it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalBranch _createInternalBranch = ProcessFactory.this._internalFactory.createInternalBranch();
          _elvis = _createInternalBranch;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            BranchEContentAdapter _branchEContentAdapter = new BranchEContentAdapter();
            _eAdapters.add(_branchEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<Branch>operator_doubleArrow(_createBranch, _function);
  }
  
  /**
   * This method creates an Branch with the given id. Post create hook won't be triggered.
   */
  public Branch createBranch(final String ID) {
    return this.createBranch(ID, null, null, false);
  }
  
  /**
   * This method creates an Branch with the given id. Post create hook will be triggered.
   */
  public Branch createBranch(final InternalModelElementContainer parent) {
    return this.createBranch(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an Branch with the given id. Post create hook will be triggered.
   */
  public Branch createBranch(final String ID, final InternalModelElementContainer parent) {
    return this.createBranch(ID, null, parent, true);
  }
  
  public Branch createBranch(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createBranch(ID, ime, parent, true);
  }
  
  /**
   * This method creates an Branch with the given id. Post create hook won't be triggered.
   */
  public Branch createBranch(final InternalModelElement ime) {
    return this.createBranch(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public Branch createBranch() {
    return this.createBranch(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ProcessPlaceholderSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ProcessPlaceholderSIB createProcessPlaceholderSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ProcessPlaceholderSIB _createProcessPlaceholderSIB = super.createProcessPlaceholderSIB();
    final Procedure1<ProcessPlaceholderSIB> _function = new Procedure1<ProcessPlaceholderSIB>() {
      @Override
      public void apply(final ProcessPlaceholderSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalProcessPlaceholderSIB _createInternalProcessPlaceholderSIB = ProcessFactory.this._internalFactory.createInternalProcessPlaceholderSIB();
          _elvis = _createInternalProcessPlaceholderSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ProcessPlaceholderSIBEContentAdapter _processPlaceholderSIBEContentAdapter = new ProcessPlaceholderSIBEContentAdapter();
            _eAdapters.add(_processPlaceholderSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ProcessPlaceholderSIB>operator_doubleArrow(_createProcessPlaceholderSIB, _function);
  }
  
  /**
   * This method creates an ProcessPlaceholderSIB with the given id. Post create hook won't be triggered.
   */
  public ProcessPlaceholderSIB createProcessPlaceholderSIB(final String ID) {
    return this.createProcessPlaceholderSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an ProcessPlaceholderSIB with the given id. Post create hook will be triggered.
   */
  public ProcessPlaceholderSIB createProcessPlaceholderSIB(final InternalModelElementContainer parent) {
    return this.createProcessPlaceholderSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ProcessPlaceholderSIB with the given id. Post create hook will be triggered.
   */
  public ProcessPlaceholderSIB createProcessPlaceholderSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createProcessPlaceholderSIB(ID, null, parent, true);
  }
  
  public ProcessPlaceholderSIB createProcessPlaceholderSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createProcessPlaceholderSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ProcessPlaceholderSIB with the given id. Post create hook won't be triggered.
   */
  public ProcessPlaceholderSIB createProcessPlaceholderSIB(final InternalModelElement ime) {
    return this.createProcessPlaceholderSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ProcessPlaceholderSIB createProcessPlaceholderSIB() {
    return this.createProcessPlaceholderSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an GUIBlueprintSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public GUIBlueprintSIB createGUIBlueprintSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    GUIBlueprintSIB _createGUIBlueprintSIB = super.createGUIBlueprintSIB();
    final Procedure1<GUIBlueprintSIB> _function = new Procedure1<GUIBlueprintSIB>() {
      @Override
      public void apply(final GUIBlueprintSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalGUIBlueprintSIB _createInternalGUIBlueprintSIB = ProcessFactory.this._internalFactory.createInternalGUIBlueprintSIB();
          _elvis = _createInternalGUIBlueprintSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            GUIBlueprintSIBEContentAdapter _gUIBlueprintSIBEContentAdapter = new GUIBlueprintSIBEContentAdapter();
            _eAdapters.add(_gUIBlueprintSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<GUIBlueprintSIB>operator_doubleArrow(_createGUIBlueprintSIB, _function);
  }
  
  /**
   * This method creates an GUIBlueprintSIB with the given id. Post create hook won't be triggered.
   */
  public GUIBlueprintSIB createGUIBlueprintSIB(final String ID) {
    return this.createGUIBlueprintSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an GUIBlueprintSIB with the given id. Post create hook will be triggered.
   */
  public GUIBlueprintSIB createGUIBlueprintSIB(final InternalModelElementContainer parent) {
    return this.createGUIBlueprintSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an GUIBlueprintSIB with the given id. Post create hook will be triggered.
   */
  public GUIBlueprintSIB createGUIBlueprintSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createGUIBlueprintSIB(ID, null, parent, true);
  }
  
  public GUIBlueprintSIB createGUIBlueprintSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createGUIBlueprintSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an GUIBlueprintSIB with the given id. Post create hook won't be triggered.
   */
  public GUIBlueprintSIB createGUIBlueprintSIB(final InternalModelElement ime) {
    return this.createGUIBlueprintSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public GUIBlueprintSIB createGUIBlueprintSIB() {
    return this.createGUIBlueprintSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ProcessSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ProcessSIB createProcessSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ProcessSIB _createProcessSIB = super.createProcessSIB();
    final Procedure1<ProcessSIB> _function = new Procedure1<ProcessSIB>() {
      @Override
      public void apply(final ProcessSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalProcessSIB _createInternalProcessSIB = ProcessFactory.this._internalFactory.createInternalProcessSIB();
          _elvis = _createInternalProcessSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ProcessSIBEContentAdapter _processSIBEContentAdapter = new ProcessSIBEContentAdapter();
            _eAdapters.add(_processSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ProcessSIB>operator_doubleArrow(_createProcessSIB, _function);
  }
  
  /**
   * This method creates an ProcessSIB with the given id. Post create hook won't be triggered.
   */
  public ProcessSIB createProcessSIB(final String ID) {
    return this.createProcessSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an ProcessSIB with the given id. Post create hook will be triggered.
   */
  public ProcessSIB createProcessSIB(final InternalModelElementContainer parent) {
    return this.createProcessSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ProcessSIB with the given id. Post create hook will be triggered.
   */
  public ProcessSIB createProcessSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createProcessSIB(ID, null, parent, true);
  }
  
  public ProcessSIB createProcessSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createProcessSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ProcessSIB with the given id. Post create hook won't be triggered.
   */
  public ProcessSIB createProcessSIB(final InternalModelElement ime) {
    return this.createProcessSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ProcessSIB createProcessSIB() {
    return this.createProcessSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an PrimitiveInputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public PrimitiveInputPort createPrimitiveInputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    PrimitiveInputPort _createPrimitiveInputPort = super.createPrimitiveInputPort();
    final Procedure1<PrimitiveInputPort> _function = new Procedure1<PrimitiveInputPort>() {
      @Override
      public void apply(final PrimitiveInputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPrimitiveInputPort _createInternalPrimitiveInputPort = ProcessFactory.this._internalFactory.createInternalPrimitiveInputPort();
          _elvis = _createInternalPrimitiveInputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            PrimitiveInputPortEContentAdapter _primitiveInputPortEContentAdapter = new PrimitiveInputPortEContentAdapter();
            _eAdapters.add(_primitiveInputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<PrimitiveInputPort>operator_doubleArrow(_createPrimitiveInputPort, _function);
  }
  
  /**
   * This method creates an PrimitiveInputPort with the given id. Post create hook won't be triggered.
   */
  public PrimitiveInputPort createPrimitiveInputPort(final String ID) {
    return this.createPrimitiveInputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an PrimitiveInputPort with the given id. Post create hook will be triggered.
   */
  public PrimitiveInputPort createPrimitiveInputPort(final InternalModelElementContainer parent) {
    return this.createPrimitiveInputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an PrimitiveInputPort with the given id. Post create hook will be triggered.
   */
  public PrimitiveInputPort createPrimitiveInputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createPrimitiveInputPort(ID, null, parent, true);
  }
  
  public PrimitiveInputPort createPrimitiveInputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createPrimitiveInputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an PrimitiveInputPort with the given id. Post create hook won't be triggered.
   */
  public PrimitiveInputPort createPrimitiveInputPort(final InternalModelElement ime) {
    return this.createPrimitiveInputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public PrimitiveInputPort createPrimitiveInputPort() {
    return this.createPrimitiveInputPort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ComplexOutputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ComplexOutputPort createComplexOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ComplexOutputPort _createComplexOutputPort = super.createComplexOutputPort();
    final Procedure1<ComplexOutputPort> _function = new Procedure1<ComplexOutputPort>() {
      @Override
      public void apply(final ComplexOutputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalComplexOutputPort _createInternalComplexOutputPort = ProcessFactory.this._internalFactory.createInternalComplexOutputPort();
          _elvis = _createInternalComplexOutputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ComplexOutputPortEContentAdapter _complexOutputPortEContentAdapter = new ComplexOutputPortEContentAdapter();
            _eAdapters.add(_complexOutputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ComplexOutputPort>operator_doubleArrow(_createComplexOutputPort, _function);
  }
  
  /**
   * This method creates an ComplexOutputPort with the given id. Post create hook won't be triggered.
   */
  public ComplexOutputPort createComplexOutputPort(final String ID) {
    return this.createComplexOutputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an ComplexOutputPort with the given id. Post create hook will be triggered.
   */
  public ComplexOutputPort createComplexOutputPort(final InternalModelElementContainer parent) {
    return this.createComplexOutputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ComplexOutputPort with the given id. Post create hook will be triggered.
   */
  public ComplexOutputPort createComplexOutputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createComplexOutputPort(ID, null, parent, true);
  }
  
  public ComplexOutputPort createComplexOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createComplexOutputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ComplexOutputPort with the given id. Post create hook won't be triggered.
   */
  public ComplexOutputPort createComplexOutputPort(final InternalModelElement ime) {
    return this.createComplexOutputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ComplexOutputPort createComplexOutputPort() {
    return this.createComplexOutputPort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ProcessBlueprintSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ProcessBlueprintSIB createProcessBlueprintSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ProcessBlueprintSIB _createProcessBlueprintSIB = super.createProcessBlueprintSIB();
    final Procedure1<ProcessBlueprintSIB> _function = new Procedure1<ProcessBlueprintSIB>() {
      @Override
      public void apply(final ProcessBlueprintSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalProcessBlueprintSIB _createInternalProcessBlueprintSIB = ProcessFactory.this._internalFactory.createInternalProcessBlueprintSIB();
          _elvis = _createInternalProcessBlueprintSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ProcessBlueprintSIBEContentAdapter _processBlueprintSIBEContentAdapter = new ProcessBlueprintSIBEContentAdapter();
            _eAdapters.add(_processBlueprintSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ProcessBlueprintSIB>operator_doubleArrow(_createProcessBlueprintSIB, _function);
  }
  
  /**
   * This method creates an ProcessBlueprintSIB with the given id. Post create hook won't be triggered.
   */
  public ProcessBlueprintSIB createProcessBlueprintSIB(final String ID) {
    return this.createProcessBlueprintSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an ProcessBlueprintSIB with the given id. Post create hook will be triggered.
   */
  public ProcessBlueprintSIB createProcessBlueprintSIB(final InternalModelElementContainer parent) {
    return this.createProcessBlueprintSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ProcessBlueprintSIB with the given id. Post create hook will be triggered.
   */
  public ProcessBlueprintSIB createProcessBlueprintSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createProcessBlueprintSIB(ID, null, parent, true);
  }
  
  public ProcessBlueprintSIB createProcessBlueprintSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createProcessBlueprintSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ProcessBlueprintSIB with the given id. Post create hook won't be triggered.
   */
  public ProcessBlueprintSIB createProcessBlueprintSIB(final InternalModelElement ime) {
    return this.createProcessBlueprintSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ProcessBlueprintSIB createProcessBlueprintSIB() {
    return this.createProcessBlueprintSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an PutComplexToContextSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public PutComplexToContextSIB createPutComplexToContextSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    PutComplexToContextSIB _createPutComplexToContextSIB = super.createPutComplexToContextSIB();
    final Procedure1<PutComplexToContextSIB> _function = new Procedure1<PutComplexToContextSIB>() {
      @Override
      public void apply(final PutComplexToContextSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPutComplexToContextSIB _createInternalPutComplexToContextSIB = ProcessFactory.this._internalFactory.createInternalPutComplexToContextSIB();
          _elvis = _createInternalPutComplexToContextSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            PutComplexToContextSIBEContentAdapter _putComplexToContextSIBEContentAdapter = new PutComplexToContextSIBEContentAdapter();
            _eAdapters.add(_putComplexToContextSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<PutComplexToContextSIB>operator_doubleArrow(_createPutComplexToContextSIB, _function);
  }
  
  /**
   * This method creates an PutComplexToContextSIB with the given id. Post create hook won't be triggered.
   */
  public PutComplexToContextSIB createPutComplexToContextSIB(final String ID) {
    return this.createPutComplexToContextSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an PutComplexToContextSIB with the given id. Post create hook will be triggered.
   */
  public PutComplexToContextSIB createPutComplexToContextSIB(final InternalModelElementContainer parent) {
    return this.createPutComplexToContextSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an PutComplexToContextSIB with the given id. Post create hook will be triggered.
   */
  public PutComplexToContextSIB createPutComplexToContextSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createPutComplexToContextSIB(ID, null, parent, true);
  }
  
  public PutComplexToContextSIB createPutComplexToContextSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createPutComplexToContextSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an PutComplexToContextSIB with the given id. Post create hook won't be triggered.
   */
  public PutComplexToContextSIB createPutComplexToContextSIB(final InternalModelElement ime) {
    return this.createPutComplexToContextSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public PutComplexToContextSIB createPutComplexToContextSIB() {
    return this.createPutComplexToContextSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an GenericSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public GenericSIB createGenericSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    GenericSIB _createGenericSIB = super.createGenericSIB();
    final Procedure1<GenericSIB> _function = new Procedure1<GenericSIB>() {
      @Override
      public void apply(final GenericSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalGenericSIB _createInternalGenericSIB = ProcessFactory.this._internalFactory.createInternalGenericSIB();
          _elvis = _createInternalGenericSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            GenericSIBEContentAdapter _genericSIBEContentAdapter = new GenericSIBEContentAdapter();
            _eAdapters.add(_genericSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<GenericSIB>operator_doubleArrow(_createGenericSIB, _function);
  }
  
  /**
   * This method creates an GenericSIB with the given id. Post create hook won't be triggered.
   */
  public GenericSIB createGenericSIB(final String ID) {
    return this.createGenericSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an GenericSIB with the given id. Post create hook will be triggered.
   */
  public GenericSIB createGenericSIB(final InternalModelElementContainer parent) {
    return this.createGenericSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an GenericSIB with the given id. Post create hook will be triggered.
   */
  public GenericSIB createGenericSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createGenericSIB(ID, null, parent, true);
  }
  
  public GenericSIB createGenericSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createGenericSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an GenericSIB with the given id. Post create hook won't be triggered.
   */
  public GenericSIB createGenericSIB(final InternalModelElement ime) {
    return this.createGenericSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public GenericSIB createGenericSIB() {
    return this.createGenericSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an DataContext with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public DataContext createDataContext(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    DataContext _createDataContext = super.createDataContext();
    final Procedure1<DataContext> _function = new Procedure1<DataContext>() {
      @Override
      public void apply(final DataContext it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalDataContext _createInternalDataContext = ProcessFactory.this._internalFactory.createInternalDataContext();
          _elvis = _createInternalDataContext;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            DataContextEContentAdapter _dataContextEContentAdapter = new DataContextEContentAdapter();
            _eAdapters.add(_dataContextEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<DataContext>operator_doubleArrow(_createDataContext, _function);
  }
  
  /**
   * This method creates an DataContext with the given id. Post create hook won't be triggered.
   */
  public DataContext createDataContext(final String ID) {
    return this.createDataContext(ID, null, null, false);
  }
  
  /**
   * This method creates an DataContext with the given id. Post create hook will be triggered.
   */
  public DataContext createDataContext(final InternalModelElementContainer parent) {
    return this.createDataContext(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an DataContext with the given id. Post create hook will be triggered.
   */
  public DataContext createDataContext(final String ID, final InternalModelElementContainer parent) {
    return this.createDataContext(ID, null, parent, true);
  }
  
  public DataContext createDataContext(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createDataContext(ID, ime, parent, true);
  }
  
  /**
   * This method creates an DataContext with the given id. Post create hook won't be triggered.
   */
  public DataContext createDataContext(final InternalModelElement ime) {
    return this.createDataContext(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public DataContext createDataContext() {
    return this.createDataContext(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an Process with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public info.scce.dime.process.process.Process createProcess(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    info.scce.dime.process.process.Process _createProcess = super.createProcess();
    final Procedure1<info.scce.dime.process.process.Process> _function = new Procedure1<info.scce.dime.process.process.Process>() {
      @Override
      public void apply(final info.scce.dime.process.process.Process it) {
        EcoreUtil.setID(it, ID);
        InternalIdentifiableElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalProcess _createInternalProcess = ProcessFactory.this._internalFactory.createInternalProcess();
          _elvis = _createInternalProcess;
        }
        final Procedure1<InternalIdentifiableElement> _function = new Procedure1<InternalIdentifiableElement>() {
          @Override
          public void apply(final InternalIdentifiableElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            ProcessEContentAdapter _processEContentAdapter = new ProcessEContentAdapter();
            _eAdapters.add(_processEContentAdapter);
          }
        };
        InternalIdentifiableElement _doubleArrow = ObjectExtensions.<InternalIdentifiableElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<info.scce.dime.process.process.Process>operator_doubleArrow(_createProcess, _function);
  }
  
  /**
   * This method creates an Process with the given id. Post create hook won't be triggered.
   */
  public info.scce.dime.process.process.Process createProcess(final String ID) {
    return this.createProcess(ID, null, null, false);
  }
  
  /**
   * This method creates an Process with the given id. Post create hook will be triggered.
   */
  public info.scce.dime.process.process.Process createProcess(final InternalModelElementContainer parent) {
    return this.createProcess(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an Process with the given id. Post create hook will be triggered.
   */
  public info.scce.dime.process.process.Process createProcess(final String ID, final InternalModelElementContainer parent) {
    return this.createProcess(ID, null, parent, true);
  }
  
  public info.scce.dime.process.process.Process createProcess(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createProcess(ID, ime, parent, true);
  }
  
  /**
   * This method creates an Process with the given id. Post create hook won't be triggered.
   */
  public info.scce.dime.process.process.Process createProcess(final InternalModelElement ime) {
    return this.createProcess(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public info.scce.dime.process.process.Process createProcess() {
    return this.createProcess(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an SwitchToUserSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public SwitchToUserSIB createSwitchToUserSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    SwitchToUserSIB _createSwitchToUserSIB = super.createSwitchToUserSIB();
    final Procedure1<SwitchToUserSIB> _function = new Procedure1<SwitchToUserSIB>() {
      @Override
      public void apply(final SwitchToUserSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalSwitchToUserSIB _createInternalSwitchToUserSIB = ProcessFactory.this._internalFactory.createInternalSwitchToUserSIB();
          _elvis = _createInternalSwitchToUserSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            SwitchToUserSIBEContentAdapter _switchToUserSIBEContentAdapter = new SwitchToUserSIBEContentAdapter();
            _eAdapters.add(_switchToUserSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<SwitchToUserSIB>operator_doubleArrow(_createSwitchToUserSIB, _function);
  }
  
  /**
   * This method creates an SwitchToUserSIB with the given id. Post create hook won't be triggered.
   */
  public SwitchToUserSIB createSwitchToUserSIB(final String ID) {
    return this.createSwitchToUserSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an SwitchToUserSIB with the given id. Post create hook will be triggered.
   */
  public SwitchToUserSIB createSwitchToUserSIB(final InternalModelElementContainer parent) {
    return this.createSwitchToUserSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an SwitchToUserSIB with the given id. Post create hook will be triggered.
   */
  public SwitchToUserSIB createSwitchToUserSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createSwitchToUserSIB(ID, null, parent, true);
  }
  
  public SwitchToUserSIB createSwitchToUserSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createSwitchToUserSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an SwitchToUserSIB with the given id. Post create hook won't be triggered.
   */
  public SwitchToUserSIB createSwitchToUserSIB(final InternalModelElement ime) {
    return this.createSwitchToUserSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public SwitchToUserSIB createSwitchToUserSIB() {
    return this.createSwitchToUserSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an Documentation with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public Documentation createDocumentation(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    Documentation _createDocumentation = super.createDocumentation();
    final Procedure1<Documentation> _function = new Procedure1<Documentation>() {
      @Override
      public void apply(final Documentation it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalDocumentation _createInternalDocumentation = ProcessFactory.this._internalFactory.createInternalDocumentation();
          _elvis = _createInternalDocumentation;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            DocumentationEContentAdapter _documentationEContentAdapter = new DocumentationEContentAdapter();
            _eAdapters.add(_documentationEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<Documentation>operator_doubleArrow(_createDocumentation, _function);
  }
  
  /**
   * This method creates an Documentation with the given id. Post create hook won't be triggered.
   */
  public Documentation createDocumentation(final String ID) {
    return this.createDocumentation(ID, null, null, false);
  }
  
  /**
   * This method creates an Documentation with the given id. Post create hook will be triggered.
   */
  public Documentation createDocumentation(final InternalModelElementContainer parent) {
    return this.createDocumentation(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an Documentation with the given id. Post create hook will be triggered.
   */
  public Documentation createDocumentation(final String ID, final InternalModelElementContainer parent) {
    return this.createDocumentation(ID, null, parent, true);
  }
  
  public Documentation createDocumentation(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createDocumentation(ID, ime, parent, true);
  }
  
  /**
   * This method creates an Documentation with the given id. Post create hook won't be triggered.
   */
  public Documentation createDocumentation(final InternalModelElement ime) {
    return this.createDocumentation(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public Documentation createDocumentation() {
    return this.createDocumentation(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an SwitchToOriginalUserSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public SwitchToOriginalUserSIB createSwitchToOriginalUserSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    SwitchToOriginalUserSIB _createSwitchToOriginalUserSIB = super.createSwitchToOriginalUserSIB();
    final Procedure1<SwitchToOriginalUserSIB> _function = new Procedure1<SwitchToOriginalUserSIB>() {
      @Override
      public void apply(final SwitchToOriginalUserSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalSwitchToOriginalUserSIB _createInternalSwitchToOriginalUserSIB = ProcessFactory.this._internalFactory.createInternalSwitchToOriginalUserSIB();
          _elvis = _createInternalSwitchToOriginalUserSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            SwitchToOriginalUserSIBEContentAdapter _switchToOriginalUserSIBEContentAdapter = new SwitchToOriginalUserSIBEContentAdapter();
            _eAdapters.add(_switchToOriginalUserSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<SwitchToOriginalUserSIB>operator_doubleArrow(_createSwitchToOriginalUserSIB, _function);
  }
  
  /**
   * This method creates an SwitchToOriginalUserSIB with the given id. Post create hook won't be triggered.
   */
  public SwitchToOriginalUserSIB createSwitchToOriginalUserSIB(final String ID) {
    return this.createSwitchToOriginalUserSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an SwitchToOriginalUserSIB with the given id. Post create hook will be triggered.
   */
  public SwitchToOriginalUserSIB createSwitchToOriginalUserSIB(final InternalModelElementContainer parent) {
    return this.createSwitchToOriginalUserSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an SwitchToOriginalUserSIB with the given id. Post create hook will be triggered.
   */
  public SwitchToOriginalUserSIB createSwitchToOriginalUserSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createSwitchToOriginalUserSIB(ID, null, parent, true);
  }
  
  public SwitchToOriginalUserSIB createSwitchToOriginalUserSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createSwitchToOriginalUserSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an SwitchToOriginalUserSIB with the given id. Post create hook won't be triggered.
   */
  public SwitchToOriginalUserSIB createSwitchToOriginalUserSIB(final InternalModelElement ime) {
    return this.createSwitchToOriginalUserSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public SwitchToOriginalUserSIB createSwitchToOriginalUserSIB() {
    return this.createSwitchToOriginalUserSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an PrimitiveOutputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public PrimitiveOutputPort createPrimitiveOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    PrimitiveOutputPort _createPrimitiveOutputPort = super.createPrimitiveOutputPort();
    final Procedure1<PrimitiveOutputPort> _function = new Procedure1<PrimitiveOutputPort>() {
      @Override
      public void apply(final PrimitiveOutputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPrimitiveOutputPort _createInternalPrimitiveOutputPort = ProcessFactory.this._internalFactory.createInternalPrimitiveOutputPort();
          _elvis = _createInternalPrimitiveOutputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            PrimitiveOutputPortEContentAdapter _primitiveOutputPortEContentAdapter = new PrimitiveOutputPortEContentAdapter();
            _eAdapters.add(_primitiveOutputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<PrimitiveOutputPort>operator_doubleArrow(_createPrimitiveOutputPort, _function);
  }
  
  /**
   * This method creates an PrimitiveOutputPort with the given id. Post create hook won't be triggered.
   */
  public PrimitiveOutputPort createPrimitiveOutputPort(final String ID) {
    return this.createPrimitiveOutputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an PrimitiveOutputPort with the given id. Post create hook will be triggered.
   */
  public PrimitiveOutputPort createPrimitiveOutputPort(final InternalModelElementContainer parent) {
    return this.createPrimitiveOutputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an PrimitiveOutputPort with the given id. Post create hook will be triggered.
   */
  public PrimitiveOutputPort createPrimitiveOutputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createPrimitiveOutputPort(ID, null, parent, true);
  }
  
  public PrimitiveOutputPort createPrimitiveOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createPrimitiveOutputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an PrimitiveOutputPort with the given id. Post create hook won't be triggered.
   */
  public PrimitiveOutputPort createPrimitiveOutputPort(final InternalModelElement ime) {
    return this.createPrimitiveOutputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public PrimitiveOutputPort createPrimitiveOutputPort() {
    return this.createPrimitiveOutputPort(EcoreUtil.generateUUID());
  }
  
  public BranchConnector createBranchConnector(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    BranchConnector _createBranchConnector = super.createBranchConnector();
    final Procedure1<BranchConnector> _function = new Procedure1<BranchConnector>() {
      @Override
      public void apply(final BranchConnector it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalBranchConnector _createInternalBranchConnector = ProcessFactory.this._internalFactory.createInternalBranchConnector();
          _elvis = _createInternalBranchConnector;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            BranchConnectorEContentAdapter _branchConnectorEContentAdapter = new BranchConnectorEContentAdapter();
            _eAdapters.add(_branchConnectorEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<BranchConnector>operator_doubleArrow(_createBranchConnector, _function);
  }
  
  /**
   * This method creates an BranchConnector with the given id. Post create hook will be triggered.
   */
  public BranchConnector createBranchConnector(final String ID, final InternalNode source, final InternalNode target) {
    return this.createBranchConnector(ID, null, source, target, true);
  }
  
  /**
   * This method creates an BranchConnector with generated id. Post create hook will be triggered.
   */
  public BranchConnector createBranchConnector(final InternalNode source, final InternalNode target) {
    return this.createBranchConnector(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an BranchConnector with the given id. Post create hook won't be triggered.
   */
  public BranchConnector createBranchConnector(final String ID) {
    return this.createBranchConnector(ID, null, null, null, false);
  }
  
  /**
   * This method creates an BranchConnector with a generated id. Post create hook won't be triggered.
   */
  @Override
  public BranchConnector createBranchConnector() {
    return this.createBranchConnector(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an PrimitiveAttribute with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public PrimitiveAttribute createPrimitiveAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    PrimitiveAttribute _createPrimitiveAttribute = super.createPrimitiveAttribute();
    final Procedure1<PrimitiveAttribute> _function = new Procedure1<PrimitiveAttribute>() {
      @Override
      public void apply(final PrimitiveAttribute it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPrimitiveAttribute _createInternalPrimitiveAttribute = ProcessFactory.this._internalFactory.createInternalPrimitiveAttribute();
          _elvis = _createInternalPrimitiveAttribute;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            PrimitiveAttributeEContentAdapter _primitiveAttributeEContentAdapter = new PrimitiveAttributeEContentAdapter();
            _eAdapters.add(_primitiveAttributeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<PrimitiveAttribute>operator_doubleArrow(_createPrimitiveAttribute, _function);
  }
  
  /**
   * This method creates an PrimitiveAttribute with the given id. Post create hook won't be triggered.
   */
  public PrimitiveAttribute createPrimitiveAttribute(final String ID) {
    return this.createPrimitiveAttribute(ID, null, null, false);
  }
  
  /**
   * This method creates an PrimitiveAttribute with the given id. Post create hook will be triggered.
   */
  public PrimitiveAttribute createPrimitiveAttribute(final InternalModelElementContainer parent) {
    return this.createPrimitiveAttribute(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an PrimitiveAttribute with the given id. Post create hook will be triggered.
   */
  public PrimitiveAttribute createPrimitiveAttribute(final String ID, final InternalModelElementContainer parent) {
    return this.createPrimitiveAttribute(ID, null, parent, true);
  }
  
  public PrimitiveAttribute createPrimitiveAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createPrimitiveAttribute(ID, ime, parent, true);
  }
  
  /**
   * This method creates an PrimitiveAttribute with the given id. Post create hook won't be triggered.
   */
  public PrimitiveAttribute createPrimitiveAttribute(final InternalModelElement ime) {
    return this.createPrimitiveAttribute(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public PrimitiveAttribute createPrimitiveAttribute() {
    return this.createPrimitiveAttribute(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an IteratePrimitiveSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public IteratePrimitiveSIB createIteratePrimitiveSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    IteratePrimitiveSIB _createIteratePrimitiveSIB = super.createIteratePrimitiveSIB();
    final Procedure1<IteratePrimitiveSIB> _function = new Procedure1<IteratePrimitiveSIB>() {
      @Override
      public void apply(final IteratePrimitiveSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalIteratePrimitiveSIB _createInternalIteratePrimitiveSIB = ProcessFactory.this._internalFactory.createInternalIteratePrimitiveSIB();
          _elvis = _createInternalIteratePrimitiveSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            IteratePrimitiveSIBEContentAdapter _iteratePrimitiveSIBEContentAdapter = new IteratePrimitiveSIBEContentAdapter();
            _eAdapters.add(_iteratePrimitiveSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<IteratePrimitiveSIB>operator_doubleArrow(_createIteratePrimitiveSIB, _function);
  }
  
  /**
   * This method creates an IteratePrimitiveSIB with the given id. Post create hook won't be triggered.
   */
  public IteratePrimitiveSIB createIteratePrimitiveSIB(final String ID) {
    return this.createIteratePrimitiveSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an IteratePrimitiveSIB with the given id. Post create hook will be triggered.
   */
  public IteratePrimitiveSIB createIteratePrimitiveSIB(final InternalModelElementContainer parent) {
    return this.createIteratePrimitiveSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an IteratePrimitiveSIB with the given id. Post create hook will be triggered.
   */
  public IteratePrimitiveSIB createIteratePrimitiveSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createIteratePrimitiveSIB(ID, null, parent, true);
  }
  
  public IteratePrimitiveSIB createIteratePrimitiveSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createIteratePrimitiveSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an IteratePrimitiveSIB with the given id. Post create hook won't be triggered.
   */
  public IteratePrimitiveSIB createIteratePrimitiveSIB(final InternalModelElement ime) {
    return this.createIteratePrimitiveSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public IteratePrimitiveSIB createIteratePrimitiveSIB() {
    return this.createIteratePrimitiveSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an SearchSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public SearchSIB createSearchSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    SearchSIB _createSearchSIB = super.createSearchSIB();
    final Procedure1<SearchSIB> _function = new Procedure1<SearchSIB>() {
      @Override
      public void apply(final SearchSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalSearchSIB _createInternalSearchSIB = ProcessFactory.this._internalFactory.createInternalSearchSIB();
          _elvis = _createInternalSearchSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            SearchSIBEContentAdapter _searchSIBEContentAdapter = new SearchSIBEContentAdapter();
            _eAdapters.add(_searchSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<SearchSIB>operator_doubleArrow(_createSearchSIB, _function);
  }
  
  /**
   * This method creates an SearchSIB with the given id. Post create hook won't be triggered.
   */
  public SearchSIB createSearchSIB(final String ID) {
    return this.createSearchSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an SearchSIB with the given id. Post create hook will be triggered.
   */
  public SearchSIB createSearchSIB(final InternalModelElementContainer parent) {
    return this.createSearchSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an SearchSIB with the given id. Post create hook will be triggered.
   */
  public SearchSIB createSearchSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createSearchSIB(ID, null, parent, true);
  }
  
  public SearchSIB createSearchSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createSearchSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an SearchSIB with the given id. Post create hook won't be triggered.
   */
  public SearchSIB createSearchSIB(final InternalModelElement ime) {
    return this.createSearchSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public SearchSIB createSearchSIB() {
    return this.createSearchSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an LongRunningProcess with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public LongRunningProcess createLongRunningProcess(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    LongRunningProcess _createLongRunningProcess = super.createLongRunningProcess();
    final Procedure1<LongRunningProcess> _function = new Procedure1<LongRunningProcess>() {
      @Override
      public void apply(final LongRunningProcess it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalLongRunningProcess _createInternalLongRunningProcess = ProcessFactory.this._internalFactory.createInternalLongRunningProcess();
          _elvis = _createInternalLongRunningProcess;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            LongRunningProcessEContentAdapter _longRunningProcessEContentAdapter = new LongRunningProcessEContentAdapter();
            _eAdapters.add(_longRunningProcessEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<LongRunningProcess>operator_doubleArrow(_createLongRunningProcess, _function);
  }
  
  /**
   * This method creates an LongRunningProcess with the given id. Post create hook won't be triggered.
   */
  public LongRunningProcess createLongRunningProcess(final String ID) {
    return this.createLongRunningProcess(ID, null, null, false);
  }
  
  /**
   * This method creates an LongRunningProcess with the given id. Post create hook will be triggered.
   */
  public LongRunningProcess createLongRunningProcess(final InternalModelElementContainer parent) {
    return this.createLongRunningProcess(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an LongRunningProcess with the given id. Post create hook will be triggered.
   */
  public LongRunningProcess createLongRunningProcess(final String ID, final InternalModelElementContainer parent) {
    return this.createLongRunningProcess(ID, null, parent, true);
  }
  
  public LongRunningProcess createLongRunningProcess(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createLongRunningProcess(ID, ime, parent, true);
  }
  
  /**
   * This method creates an LongRunningProcess with the given id. Post create hook won't be triggered.
   */
  public LongRunningProcess createLongRunningProcess(final InternalModelElement ime) {
    return this.createLongRunningProcess(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public LongRunningProcess createLongRunningProcess() {
    return this.createLongRunningProcess(EcoreUtil.generateUUID());
  }
  
  public PrimitiveDirectDataFlow createPrimitiveDirectDataFlow(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    PrimitiveDirectDataFlow _createPrimitiveDirectDataFlow = super.createPrimitiveDirectDataFlow();
    final Procedure1<PrimitiveDirectDataFlow> _function = new Procedure1<PrimitiveDirectDataFlow>() {
      @Override
      public void apply(final PrimitiveDirectDataFlow it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPrimitiveDirectDataFlow _createInternalPrimitiveDirectDataFlow = ProcessFactory.this._internalFactory.createInternalPrimitiveDirectDataFlow();
          _elvis = _createInternalPrimitiveDirectDataFlow;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            PrimitiveDirectDataFlowEContentAdapter _primitiveDirectDataFlowEContentAdapter = new PrimitiveDirectDataFlowEContentAdapter();
            _eAdapters.add(_primitiveDirectDataFlowEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<PrimitiveDirectDataFlow>operator_doubleArrow(_createPrimitiveDirectDataFlow, _function);
  }
  
  /**
   * This method creates an PrimitiveDirectDataFlow with the given id. Post create hook will be triggered.
   */
  public PrimitiveDirectDataFlow createPrimitiveDirectDataFlow(final String ID, final InternalNode source, final InternalNode target) {
    return this.createPrimitiveDirectDataFlow(ID, null, source, target, true);
  }
  
  /**
   * This method creates an PrimitiveDirectDataFlow with generated id. Post create hook will be triggered.
   */
  public PrimitiveDirectDataFlow createPrimitiveDirectDataFlow(final InternalNode source, final InternalNode target) {
    return this.createPrimitiveDirectDataFlow(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an PrimitiveDirectDataFlow with the given id. Post create hook won't be triggered.
   */
  public PrimitiveDirectDataFlow createPrimitiveDirectDataFlow(final String ID) {
    return this.createPrimitiveDirectDataFlow(ID, null, null, null, false);
  }
  
  /**
   * This method creates an PrimitiveDirectDataFlow with a generated id. Post create hook won't be triggered.
   */
  @Override
  public PrimitiveDirectDataFlow createPrimitiveDirectDataFlow() {
    return this.createPrimitiveDirectDataFlow(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an CreateSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public CreateSIB createCreateSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    CreateSIB _createCreateSIB = super.createCreateSIB();
    final Procedure1<CreateSIB> _function = new Procedure1<CreateSIB>() {
      @Override
      public void apply(final CreateSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalCreateSIB _createInternalCreateSIB = ProcessFactory.this._internalFactory.createInternalCreateSIB();
          _elvis = _createInternalCreateSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            CreateSIBEContentAdapter _createSIBEContentAdapter = new CreateSIBEContentAdapter();
            _eAdapters.add(_createSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<CreateSIB>operator_doubleArrow(_createCreateSIB, _function);
  }
  
  /**
   * This method creates an CreateSIB with the given id. Post create hook won't be triggered.
   */
  public CreateSIB createCreateSIB(final String ID) {
    return this.createCreateSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an CreateSIB with the given id. Post create hook will be triggered.
   */
  public CreateSIB createCreateSIB(final InternalModelElementContainer parent) {
    return this.createCreateSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an CreateSIB with the given id. Post create hook will be triggered.
   */
  public CreateSIB createCreateSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createCreateSIB(ID, null, parent, true);
  }
  
  public CreateSIB createCreateSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createCreateSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an CreateSIB with the given id. Post create hook won't be triggered.
   */
  public CreateSIB createCreateSIB(final InternalModelElement ime) {
    return this.createCreateSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public CreateSIB createCreateSIB() {
    return this.createCreateSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an PutPrimitiveToContextSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public PutPrimitiveToContextSIB createPutPrimitiveToContextSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    PutPrimitiveToContextSIB _createPutPrimitiveToContextSIB = super.createPutPrimitiveToContextSIB();
    final Procedure1<PutPrimitiveToContextSIB> _function = new Procedure1<PutPrimitiveToContextSIB>() {
      @Override
      public void apply(final PutPrimitiveToContextSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPutPrimitiveToContextSIB _createInternalPutPrimitiveToContextSIB = ProcessFactory.this._internalFactory.createInternalPutPrimitiveToContextSIB();
          _elvis = _createInternalPutPrimitiveToContextSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            PutPrimitiveToContextSIBEContentAdapter _putPrimitiveToContextSIBEContentAdapter = new PutPrimitiveToContextSIBEContentAdapter();
            _eAdapters.add(_putPrimitiveToContextSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<PutPrimitiveToContextSIB>operator_doubleArrow(_createPutPrimitiveToContextSIB, _function);
  }
  
  /**
   * This method creates an PutPrimitiveToContextSIB with the given id. Post create hook won't be triggered.
   */
  public PutPrimitiveToContextSIB createPutPrimitiveToContextSIB(final String ID) {
    return this.createPutPrimitiveToContextSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an PutPrimitiveToContextSIB with the given id. Post create hook will be triggered.
   */
  public PutPrimitiveToContextSIB createPutPrimitiveToContextSIB(final InternalModelElementContainer parent) {
    return this.createPutPrimitiveToContextSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an PutPrimitiveToContextSIB with the given id. Post create hook will be triggered.
   */
  public PutPrimitiveToContextSIB createPutPrimitiveToContextSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createPutPrimitiveToContextSIB(ID, null, parent, true);
  }
  
  public PutPrimitiveToContextSIB createPutPrimitiveToContextSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createPutPrimitiveToContextSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an PutPrimitiveToContextSIB with the given id. Post create hook won't be triggered.
   */
  public PutPrimitiveToContextSIB createPutPrimitiveToContextSIB(final InternalModelElement ime) {
    return this.createPutPrimitiveToContextSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public PutPrimitiveToContextSIB createPutPrimitiveToContextSIB() {
    return this.createPutPrimitiveToContextSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an EventListener with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public EventListener createEventListener(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    EventListener _createEventListener = super.createEventListener();
    final Procedure1<EventListener> _function = new Procedure1<EventListener>() {
      @Override
      public void apply(final EventListener it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalEventListener _createInternalEventListener = ProcessFactory.this._internalFactory.createInternalEventListener();
          _elvis = _createInternalEventListener;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            EventListenerEContentAdapter _eventListenerEContentAdapter = new EventListenerEContentAdapter();
            _eAdapters.add(_eventListenerEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<EventListener>operator_doubleArrow(_createEventListener, _function);
  }
  
  /**
   * This method creates an EventListener with the given id. Post create hook won't be triggered.
   */
  public EventListener createEventListener(final String ID) {
    return this.createEventListener(ID, null, null, false);
  }
  
  /**
   * This method creates an EventListener with the given id. Post create hook will be triggered.
   */
  public EventListener createEventListener(final InternalModelElementContainer parent) {
    return this.createEventListener(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an EventListener with the given id. Post create hook will be triggered.
   */
  public EventListener createEventListener(final String ID, final InternalModelElementContainer parent) {
    return this.createEventListener(ID, null, parent, true);
  }
  
  public EventListener createEventListener(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createEventListener(ID, ime, parent, true);
  }
  
  /**
   * This method creates an EventListener with the given id. Post create hook won't be triggered.
   */
  public EventListener createEventListener(final InternalModelElement ime) {
    return this.createEventListener(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public EventListener createEventListener() {
    return this.createEventListener(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an GUISIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public GUISIB createGUISIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    GUISIB _createGUISIB = super.createGUISIB();
    final Procedure1<GUISIB> _function = new Procedure1<GUISIB>() {
      @Override
      public void apply(final GUISIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalGUISIB _createInternalGUISIB = ProcessFactory.this._internalFactory.createInternalGUISIB();
          _elvis = _createInternalGUISIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            GUISIBEContentAdapter _gUISIBEContentAdapter = new GUISIBEContentAdapter();
            _eAdapters.add(_gUISIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<GUISIB>operator_doubleArrow(_createGUISIB, _function);
  }
  
  /**
   * This method creates an GUISIB with the given id. Post create hook won't be triggered.
   */
  public GUISIB createGUISIB(final String ID) {
    return this.createGUISIB(ID, null, null, false);
  }
  
  /**
   * This method creates an GUISIB with the given id. Post create hook will be triggered.
   */
  public GUISIB createGUISIB(final InternalModelElementContainer parent) {
    return this.createGUISIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an GUISIB with the given id. Post create hook will be triggered.
   */
  public GUISIB createGUISIB(final String ID, final InternalModelElementContainer parent) {
    return this.createGUISIB(ID, null, parent, true);
  }
  
  public GUISIB createGUISIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createGUISIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an GUISIB with the given id. Post create hook won't be triggered.
   */
  public GUISIB createGUISIB(final InternalModelElement ime) {
    return this.createGUISIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public GUISIB createGUISIB() {
    return this.createGUISIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an PrimitiveVariable with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public PrimitiveVariable createPrimitiveVariable(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    PrimitiveVariable _createPrimitiveVariable = super.createPrimitiveVariable();
    final Procedure1<PrimitiveVariable> _function = new Procedure1<PrimitiveVariable>() {
      @Override
      public void apply(final PrimitiveVariable it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPrimitiveVariable _createInternalPrimitiveVariable = ProcessFactory.this._internalFactory.createInternalPrimitiveVariable();
          _elvis = _createInternalPrimitiveVariable;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            PrimitiveVariableEContentAdapter _primitiveVariableEContentAdapter = new PrimitiveVariableEContentAdapter();
            _eAdapters.add(_primitiveVariableEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<PrimitiveVariable>operator_doubleArrow(_createPrimitiveVariable, _function);
  }
  
  /**
   * This method creates an PrimitiveVariable with the given id. Post create hook won't be triggered.
   */
  public PrimitiveVariable createPrimitiveVariable(final String ID) {
    return this.createPrimitiveVariable(ID, null, null, false);
  }
  
  /**
   * This method creates an PrimitiveVariable with the given id. Post create hook will be triggered.
   */
  public PrimitiveVariable createPrimitiveVariable(final InternalModelElementContainer parent) {
    return this.createPrimitiveVariable(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an PrimitiveVariable with the given id. Post create hook will be triggered.
   */
  public PrimitiveVariable createPrimitiveVariable(final String ID, final InternalModelElementContainer parent) {
    return this.createPrimitiveVariable(ID, null, parent, true);
  }
  
  public PrimitiveVariable createPrimitiveVariable(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createPrimitiveVariable(ID, ime, parent, true);
  }
  
  /**
   * This method creates an PrimitiveVariable with the given id. Post create hook won't be triggered.
   */
  public PrimitiveVariable createPrimitiveVariable(final InternalModelElement ime) {
    return this.createPrimitiveVariable(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public PrimitiveVariable createPrimitiveVariable() {
    return this.createPrimitiveVariable(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an IsOfTypeSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public IsOfTypeSIB createIsOfTypeSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    IsOfTypeSIB _createIsOfTypeSIB = super.createIsOfTypeSIB();
    final Procedure1<IsOfTypeSIB> _function = new Procedure1<IsOfTypeSIB>() {
      @Override
      public void apply(final IsOfTypeSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalIsOfTypeSIB _createInternalIsOfTypeSIB = ProcessFactory.this._internalFactory.createInternalIsOfTypeSIB();
          _elvis = _createInternalIsOfTypeSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            IsOfTypeSIBEContentAdapter _isOfTypeSIBEContentAdapter = new IsOfTypeSIBEContentAdapter();
            _eAdapters.add(_isOfTypeSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<IsOfTypeSIB>operator_doubleArrow(_createIsOfTypeSIB, _function);
  }
  
  /**
   * This method creates an IsOfTypeSIB with the given id. Post create hook won't be triggered.
   */
  public IsOfTypeSIB createIsOfTypeSIB(final String ID) {
    return this.createIsOfTypeSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an IsOfTypeSIB with the given id. Post create hook will be triggered.
   */
  public IsOfTypeSIB createIsOfTypeSIB(final InternalModelElementContainer parent) {
    return this.createIsOfTypeSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an IsOfTypeSIB with the given id. Post create hook will be triggered.
   */
  public IsOfTypeSIB createIsOfTypeSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createIsOfTypeSIB(ID, null, parent, true);
  }
  
  public IsOfTypeSIB createIsOfTypeSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createIsOfTypeSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an IsOfTypeSIB with the given id. Post create hook won't be triggered.
   */
  public IsOfTypeSIB createIsOfTypeSIB(final InternalModelElement ime) {
    return this.createIsOfTypeSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public IsOfTypeSIB createIsOfTypeSIB() {
    return this.createIsOfTypeSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an PrimitiveListAttribute with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public PrimitiveListAttribute createPrimitiveListAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    PrimitiveListAttribute _createPrimitiveListAttribute = super.createPrimitiveListAttribute();
    final Procedure1<PrimitiveListAttribute> _function = new Procedure1<PrimitiveListAttribute>() {
      @Override
      public void apply(final PrimitiveListAttribute it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPrimitiveListAttribute _createInternalPrimitiveListAttribute = ProcessFactory.this._internalFactory.createInternalPrimitiveListAttribute();
          _elvis = _createInternalPrimitiveListAttribute;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            PrimitiveListAttributeEContentAdapter _primitiveListAttributeEContentAdapter = new PrimitiveListAttributeEContentAdapter();
            _eAdapters.add(_primitiveListAttributeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<PrimitiveListAttribute>operator_doubleArrow(_createPrimitiveListAttribute, _function);
  }
  
  /**
   * This method creates an PrimitiveListAttribute with the given id. Post create hook won't be triggered.
   */
  public PrimitiveListAttribute createPrimitiveListAttribute(final String ID) {
    return this.createPrimitiveListAttribute(ID, null, null, false);
  }
  
  /**
   * This method creates an PrimitiveListAttribute with the given id. Post create hook will be triggered.
   */
  public PrimitiveListAttribute createPrimitiveListAttribute(final InternalModelElementContainer parent) {
    return this.createPrimitiveListAttribute(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an PrimitiveListAttribute with the given id. Post create hook will be triggered.
   */
  public PrimitiveListAttribute createPrimitiveListAttribute(final String ID, final InternalModelElementContainer parent) {
    return this.createPrimitiveListAttribute(ID, null, parent, true);
  }
  
  public PrimitiveListAttribute createPrimitiveListAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createPrimitiveListAttribute(ID, ime, parent, true);
  }
  
  /**
   * This method creates an PrimitiveListAttribute with the given id. Post create hook won't be triggered.
   */
  public PrimitiveListAttribute createPrimitiveListAttribute(final InternalModelElement ime) {
    return this.createPrimitiveListAttribute(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public PrimitiveListAttribute createPrimitiveListAttribute() {
    return this.createPrimitiveListAttribute(EcoreUtil.generateUUID());
  }
  
  public JavaNativeDirectDataFlow createJavaNativeDirectDataFlow(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    JavaNativeDirectDataFlow _createJavaNativeDirectDataFlow = super.createJavaNativeDirectDataFlow();
    final Procedure1<JavaNativeDirectDataFlow> _function = new Procedure1<JavaNativeDirectDataFlow>() {
      @Override
      public void apply(final JavaNativeDirectDataFlow it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalJavaNativeDirectDataFlow _createInternalJavaNativeDirectDataFlow = ProcessFactory.this._internalFactory.createInternalJavaNativeDirectDataFlow();
          _elvis = _createInternalJavaNativeDirectDataFlow;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            JavaNativeDirectDataFlowEContentAdapter _javaNativeDirectDataFlowEContentAdapter = new JavaNativeDirectDataFlowEContentAdapter();
            _eAdapters.add(_javaNativeDirectDataFlowEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<JavaNativeDirectDataFlow>operator_doubleArrow(_createJavaNativeDirectDataFlow, _function);
  }
  
  /**
   * This method creates an JavaNativeDirectDataFlow with the given id. Post create hook will be triggered.
   */
  public JavaNativeDirectDataFlow createJavaNativeDirectDataFlow(final String ID, final InternalNode source, final InternalNode target) {
    return this.createJavaNativeDirectDataFlow(ID, null, source, target, true);
  }
  
  /**
   * This method creates an JavaNativeDirectDataFlow with generated id. Post create hook will be triggered.
   */
  public JavaNativeDirectDataFlow createJavaNativeDirectDataFlow(final InternalNode source, final InternalNode target) {
    return this.createJavaNativeDirectDataFlow(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an JavaNativeDirectDataFlow with the given id. Post create hook won't be triggered.
   */
  public JavaNativeDirectDataFlow createJavaNativeDirectDataFlow(final String ID) {
    return this.createJavaNativeDirectDataFlow(ID, null, null, null, false);
  }
  
  /**
   * This method creates an JavaNativeDirectDataFlow with a generated id. Post create hook won't be triggered.
   */
  @Override
  public JavaNativeDirectDataFlow createJavaNativeDirectDataFlow() {
    return this.createJavaNativeDirectDataFlow(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an PrimitiveExtensionAttribute with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public PrimitiveExtensionAttribute createPrimitiveExtensionAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    PrimitiveExtensionAttribute _createPrimitiveExtensionAttribute = super.createPrimitiveExtensionAttribute();
    final Procedure1<PrimitiveExtensionAttribute> _function = new Procedure1<PrimitiveExtensionAttribute>() {
      @Override
      public void apply(final PrimitiveExtensionAttribute it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPrimitiveExtensionAttribute _createInternalPrimitiveExtensionAttribute = ProcessFactory.this._internalFactory.createInternalPrimitiveExtensionAttribute();
          _elvis = _createInternalPrimitiveExtensionAttribute;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            PrimitiveExtensionAttributeEContentAdapter _primitiveExtensionAttributeEContentAdapter = new PrimitiveExtensionAttributeEContentAdapter();
            _eAdapters.add(_primitiveExtensionAttributeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<PrimitiveExtensionAttribute>operator_doubleArrow(_createPrimitiveExtensionAttribute, _function);
  }
  
  /**
   * This method creates an PrimitiveExtensionAttribute with the given id. Post create hook won't be triggered.
   */
  public PrimitiveExtensionAttribute createPrimitiveExtensionAttribute(final String ID) {
    return this.createPrimitiveExtensionAttribute(ID, null, null, false);
  }
  
  /**
   * This method creates an PrimitiveExtensionAttribute with the given id. Post create hook will be triggered.
   */
  public PrimitiveExtensionAttribute createPrimitiveExtensionAttribute(final InternalModelElementContainer parent) {
    return this.createPrimitiveExtensionAttribute(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an PrimitiveExtensionAttribute with the given id. Post create hook will be triggered.
   */
  public PrimitiveExtensionAttribute createPrimitiveExtensionAttribute(final String ID, final InternalModelElementContainer parent) {
    return this.createPrimitiveExtensionAttribute(ID, null, parent, true);
  }
  
  public PrimitiveExtensionAttribute createPrimitiveExtensionAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createPrimitiveExtensionAttribute(ID, ime, parent, true);
  }
  
  /**
   * This method creates an PrimitiveExtensionAttribute with the given id. Post create hook won't be triggered.
   */
  public PrimitiveExtensionAttribute createPrimitiveExtensionAttribute(final InternalModelElement ime) {
    return this.createPrimitiveExtensionAttribute(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public PrimitiveExtensionAttribute createPrimitiveExtensionAttribute() {
    return this.createPrimitiveExtensionAttribute(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ContainsPrimitiveSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ContainsPrimitiveSIB createContainsPrimitiveSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ContainsPrimitiveSIB _createContainsPrimitiveSIB = super.createContainsPrimitiveSIB();
    final Procedure1<ContainsPrimitiveSIB> _function = new Procedure1<ContainsPrimitiveSIB>() {
      @Override
      public void apply(final ContainsPrimitiveSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalContainsPrimitiveSIB _createInternalContainsPrimitiveSIB = ProcessFactory.this._internalFactory.createInternalContainsPrimitiveSIB();
          _elvis = _createInternalContainsPrimitiveSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ContainsPrimitiveSIBEContentAdapter _containsPrimitiveSIBEContentAdapter = new ContainsPrimitiveSIBEContentAdapter();
            _eAdapters.add(_containsPrimitiveSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ContainsPrimitiveSIB>operator_doubleArrow(_createContainsPrimitiveSIB, _function);
  }
  
  /**
   * This method creates an ContainsPrimitiveSIB with the given id. Post create hook won't be triggered.
   */
  public ContainsPrimitiveSIB createContainsPrimitiveSIB(final String ID) {
    return this.createContainsPrimitiveSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an ContainsPrimitiveSIB with the given id. Post create hook will be triggered.
   */
  public ContainsPrimitiveSIB createContainsPrimitiveSIB(final InternalModelElementContainer parent) {
    return this.createContainsPrimitiveSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ContainsPrimitiveSIB with the given id. Post create hook will be triggered.
   */
  public ContainsPrimitiveSIB createContainsPrimitiveSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createContainsPrimitiveSIB(ID, null, parent, true);
  }
  
  public ContainsPrimitiveSIB createContainsPrimitiveSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createContainsPrimitiveSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ContainsPrimitiveSIB with the given id. Post create hook won't be triggered.
   */
  public ContainsPrimitiveSIB createContainsPrimitiveSIB(final InternalModelElement ime) {
    return this.createContainsPrimitiveSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ContainsPrimitiveSIB createContainsPrimitiveSIB() {
    return this.createContainsPrimitiveSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an TriggerEventSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public TriggerEventSIB createTriggerEventSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    TriggerEventSIB _createTriggerEventSIB = super.createTriggerEventSIB();
    final Procedure1<TriggerEventSIB> _function = new Procedure1<TriggerEventSIB>() {
      @Override
      public void apply(final TriggerEventSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalTriggerEventSIB _createInternalTriggerEventSIB = ProcessFactory.this._internalFactory.createInternalTriggerEventSIB();
          _elvis = _createInternalTriggerEventSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            TriggerEventSIBEContentAdapter _triggerEventSIBEContentAdapter = new TriggerEventSIBEContentAdapter();
            _eAdapters.add(_triggerEventSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<TriggerEventSIB>operator_doubleArrow(_createTriggerEventSIB, _function);
  }
  
  /**
   * This method creates an TriggerEventSIB with the given id. Post create hook won't be triggered.
   */
  public TriggerEventSIB createTriggerEventSIB(final String ID) {
    return this.createTriggerEventSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an TriggerEventSIB with the given id. Post create hook will be triggered.
   */
  public TriggerEventSIB createTriggerEventSIB(final InternalModelElementContainer parent) {
    return this.createTriggerEventSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an TriggerEventSIB with the given id. Post create hook will be triggered.
   */
  public TriggerEventSIB createTriggerEventSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createTriggerEventSIB(ID, null, parent, true);
  }
  
  public TriggerEventSIB createTriggerEventSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createTriggerEventSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an TriggerEventSIB with the given id. Post create hook won't be triggered.
   */
  public TriggerEventSIB createTriggerEventSIB(final InternalModelElement ime) {
    return this.createTriggerEventSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public TriggerEventSIB createTriggerEventSIB() {
    return this.createTriggerEventSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an JavaNativeOutputPort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public JavaNativeOutputPort createJavaNativeOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    JavaNativeOutputPort _createJavaNativeOutputPort = super.createJavaNativeOutputPort();
    final Procedure1<JavaNativeOutputPort> _function = new Procedure1<JavaNativeOutputPort>() {
      @Override
      public void apply(final JavaNativeOutputPort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalJavaNativeOutputPort _createInternalJavaNativeOutputPort = ProcessFactory.this._internalFactory.createInternalJavaNativeOutputPort();
          _elvis = _createInternalJavaNativeOutputPort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            JavaNativeOutputPortEContentAdapter _javaNativeOutputPortEContentAdapter = new JavaNativeOutputPortEContentAdapter();
            _eAdapters.add(_javaNativeOutputPortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<JavaNativeOutputPort>operator_doubleArrow(_createJavaNativeOutputPort, _function);
  }
  
  /**
   * This method creates an JavaNativeOutputPort with the given id. Post create hook won't be triggered.
   */
  public JavaNativeOutputPort createJavaNativeOutputPort(final String ID) {
    return this.createJavaNativeOutputPort(ID, null, null, false);
  }
  
  /**
   * This method creates an JavaNativeOutputPort with the given id. Post create hook will be triggered.
   */
  public JavaNativeOutputPort createJavaNativeOutputPort(final InternalModelElementContainer parent) {
    return this.createJavaNativeOutputPort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an JavaNativeOutputPort with the given id. Post create hook will be triggered.
   */
  public JavaNativeOutputPort createJavaNativeOutputPort(final String ID, final InternalModelElementContainer parent) {
    return this.createJavaNativeOutputPort(ID, null, parent, true);
  }
  
  public JavaNativeOutputPort createJavaNativeOutputPort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createJavaNativeOutputPort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an JavaNativeOutputPort with the given id. Post create hook won't be triggered.
   */
  public JavaNativeOutputPort createJavaNativeOutputPort(final InternalModelElement ime) {
    return this.createJavaNativeOutputPort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public JavaNativeOutputPort createJavaNativeOutputPort() {
    return this.createJavaNativeOutputPort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an JavaNativeVariable with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public JavaNativeVariable createJavaNativeVariable(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    JavaNativeVariable _createJavaNativeVariable = super.createJavaNativeVariable();
    final Procedure1<JavaNativeVariable> _function = new Procedure1<JavaNativeVariable>() {
      @Override
      public void apply(final JavaNativeVariable it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalJavaNativeVariable _createInternalJavaNativeVariable = ProcessFactory.this._internalFactory.createInternalJavaNativeVariable();
          _elvis = _createInternalJavaNativeVariable;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            JavaNativeVariableEContentAdapter _javaNativeVariableEContentAdapter = new JavaNativeVariableEContentAdapter();
            _eAdapters.add(_javaNativeVariableEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<JavaNativeVariable>operator_doubleArrow(_createJavaNativeVariable, _function);
  }
  
  /**
   * This method creates an JavaNativeVariable with the given id. Post create hook won't be triggered.
   */
  public JavaNativeVariable createJavaNativeVariable(final String ID) {
    return this.createJavaNativeVariable(ID, null, null, false);
  }
  
  /**
   * This method creates an JavaNativeVariable with the given id. Post create hook will be triggered.
   */
  public JavaNativeVariable createJavaNativeVariable(final InternalModelElementContainer parent) {
    return this.createJavaNativeVariable(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an JavaNativeVariable with the given id. Post create hook will be triggered.
   */
  public JavaNativeVariable createJavaNativeVariable(final String ID, final InternalModelElementContainer parent) {
    return this.createJavaNativeVariable(ID, null, parent, true);
  }
  
  public JavaNativeVariable createJavaNativeVariable(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createJavaNativeVariable(ID, ime, parent, true);
  }
  
  /**
   * This method creates an JavaNativeVariable with the given id. Post create hook won't be triggered.
   */
  public JavaNativeVariable createJavaNativeVariable(final InternalModelElement ime) {
    return this.createJavaNativeVariable(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public JavaNativeVariable createJavaNativeVariable() {
    return this.createJavaNativeVariable(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an PrimitiveAttributePort with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public PrimitiveAttributePort createPrimitiveAttributePort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    PrimitiveAttributePort _createPrimitiveAttributePort = super.createPrimitiveAttributePort();
    final Procedure1<PrimitiveAttributePort> _function = new Procedure1<PrimitiveAttributePort>() {
      @Override
      public void apply(final PrimitiveAttributePort it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPrimitiveAttributePort _createInternalPrimitiveAttributePort = ProcessFactory.this._internalFactory.createInternalPrimitiveAttributePort();
          _elvis = _createInternalPrimitiveAttributePort;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            PrimitiveAttributePortEContentAdapter _primitiveAttributePortEContentAdapter = new PrimitiveAttributePortEContentAdapter();
            _eAdapters.add(_primitiveAttributePortEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<PrimitiveAttributePort>operator_doubleArrow(_createPrimitiveAttributePort, _function);
  }
  
  /**
   * This method creates an PrimitiveAttributePort with the given id. Post create hook won't be triggered.
   */
  public PrimitiveAttributePort createPrimitiveAttributePort(final String ID) {
    return this.createPrimitiveAttributePort(ID, null, null, false);
  }
  
  /**
   * This method creates an PrimitiveAttributePort with the given id. Post create hook will be triggered.
   */
  public PrimitiveAttributePort createPrimitiveAttributePort(final InternalModelElementContainer parent) {
    return this.createPrimitiveAttributePort(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an PrimitiveAttributePort with the given id. Post create hook will be triggered.
   */
  public PrimitiveAttributePort createPrimitiveAttributePort(final String ID, final InternalModelElementContainer parent) {
    return this.createPrimitiveAttributePort(ID, null, parent, true);
  }
  
  public PrimitiveAttributePort createPrimitiveAttributePort(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createPrimitiveAttributePort(ID, ime, parent, true);
  }
  
  /**
   * This method creates an PrimitiveAttributePort with the given id. Post create hook won't be triggered.
   */
  public PrimitiveAttributePort createPrimitiveAttributePort(final InternalModelElement ime) {
    return this.createPrimitiveAttributePort(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public PrimitiveAttributePort createPrimitiveAttributePort() {
    return this.createPrimitiveAttributePort(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an TransientCreateSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public TransientCreateSIB createTransientCreateSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    TransientCreateSIB _createTransientCreateSIB = super.createTransientCreateSIB();
    final Procedure1<TransientCreateSIB> _function = new Procedure1<TransientCreateSIB>() {
      @Override
      public void apply(final TransientCreateSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalTransientCreateSIB _createInternalTransientCreateSIB = ProcessFactory.this._internalFactory.createInternalTransientCreateSIB();
          _elvis = _createInternalTransientCreateSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            TransientCreateSIBEContentAdapter _transientCreateSIBEContentAdapter = new TransientCreateSIBEContentAdapter();
            _eAdapters.add(_transientCreateSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<TransientCreateSIB>operator_doubleArrow(_createTransientCreateSIB, _function);
  }
  
  /**
   * This method creates an TransientCreateSIB with the given id. Post create hook won't be triggered.
   */
  public TransientCreateSIB createTransientCreateSIB(final String ID) {
    return this.createTransientCreateSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an TransientCreateSIB with the given id. Post create hook will be triggered.
   */
  public TransientCreateSIB createTransientCreateSIB(final InternalModelElementContainer parent) {
    return this.createTransientCreateSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an TransientCreateSIB with the given id. Post create hook will be triggered.
   */
  public TransientCreateSIB createTransientCreateSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createTransientCreateSIB(ID, null, parent, true);
  }
  
  public TransientCreateSIB createTransientCreateSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createTransientCreateSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an TransientCreateSIB with the given id. Post create hook won't be triggered.
   */
  public TransientCreateSIB createTransientCreateSIB(final InternalModelElement ime) {
    return this.createTransientCreateSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public TransientCreateSIB createTransientCreateSIB() {
    return this.createTransientCreateSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an UnsetAttributeValueSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public UnsetAttributeValueSIB createUnsetAttributeValueSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    UnsetAttributeValueSIB _createUnsetAttributeValueSIB = super.createUnsetAttributeValueSIB();
    final Procedure1<UnsetAttributeValueSIB> _function = new Procedure1<UnsetAttributeValueSIB>() {
      @Override
      public void apply(final UnsetAttributeValueSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalUnsetAttributeValueSIB _createInternalUnsetAttributeValueSIB = ProcessFactory.this._internalFactory.createInternalUnsetAttributeValueSIB();
          _elvis = _createInternalUnsetAttributeValueSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            UnsetAttributeValueSIBEContentAdapter _unsetAttributeValueSIBEContentAdapter = new UnsetAttributeValueSIBEContentAdapter();
            _eAdapters.add(_unsetAttributeValueSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<UnsetAttributeValueSIB>operator_doubleArrow(_createUnsetAttributeValueSIB, _function);
  }
  
  /**
   * This method creates an UnsetAttributeValueSIB with the given id. Post create hook won't be triggered.
   */
  public UnsetAttributeValueSIB createUnsetAttributeValueSIB(final String ID) {
    return this.createUnsetAttributeValueSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an UnsetAttributeValueSIB with the given id. Post create hook will be triggered.
   */
  public UnsetAttributeValueSIB createUnsetAttributeValueSIB(final InternalModelElementContainer parent) {
    return this.createUnsetAttributeValueSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an UnsetAttributeValueSIB with the given id. Post create hook will be triggered.
   */
  public UnsetAttributeValueSIB createUnsetAttributeValueSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createUnsetAttributeValueSIB(ID, null, parent, true);
  }
  
  public UnsetAttributeValueSIB createUnsetAttributeValueSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createUnsetAttributeValueSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an UnsetAttributeValueSIB with the given id. Post create hook won't be triggered.
   */
  public UnsetAttributeValueSIB createUnsetAttributeValueSIB(final InternalModelElement ime) {
    return this.createUnsetAttributeValueSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public UnsetAttributeValueSIB createUnsetAttributeValueSIB() {
    return this.createUnsetAttributeValueSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an TextInputStatic with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public TextInputStatic createTextInputStatic(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    TextInputStatic _createTextInputStatic = super.createTextInputStatic();
    final Procedure1<TextInputStatic> _function = new Procedure1<TextInputStatic>() {
      @Override
      public void apply(final TextInputStatic it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalTextInputStatic _createInternalTextInputStatic = ProcessFactory.this._internalFactory.createInternalTextInputStatic();
          _elvis = _createInternalTextInputStatic;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            TextInputStaticEContentAdapter _textInputStaticEContentAdapter = new TextInputStaticEContentAdapter();
            _eAdapters.add(_textInputStaticEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<TextInputStatic>operator_doubleArrow(_createTextInputStatic, _function);
  }
  
  /**
   * This method creates an TextInputStatic with the given id. Post create hook won't be triggered.
   */
  public TextInputStatic createTextInputStatic(final String ID) {
    return this.createTextInputStatic(ID, null, null, false);
  }
  
  /**
   * This method creates an TextInputStatic with the given id. Post create hook will be triggered.
   */
  public TextInputStatic createTextInputStatic(final InternalModelElementContainer parent) {
    return this.createTextInputStatic(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an TextInputStatic with the given id. Post create hook will be triggered.
   */
  public TextInputStatic createTextInputStatic(final String ID, final InternalModelElementContainer parent) {
    return this.createTextInputStatic(ID, null, parent, true);
  }
  
  public TextInputStatic createTextInputStatic(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createTextInputStatic(ID, ime, parent, true);
  }
  
  /**
   * This method creates an TextInputStatic with the given id. Post create hook won't be triggered.
   */
  public TextInputStatic createTextInputStatic(final InternalModelElement ime) {
    return this.createTextInputStatic(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public TextInputStatic createTextInputStatic() {
    return this.createTextInputStatic(EcoreUtil.generateUUID());
  }
  
  public PrimitiveRead createPrimitiveRead(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    PrimitiveRead _createPrimitiveRead = super.createPrimitiveRead();
    final Procedure1<PrimitiveRead> _function = new Procedure1<PrimitiveRead>() {
      @Override
      public void apply(final PrimitiveRead it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPrimitiveRead _createInternalPrimitiveRead = ProcessFactory.this._internalFactory.createInternalPrimitiveRead();
          _elvis = _createInternalPrimitiveRead;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            PrimitiveReadEContentAdapter _primitiveReadEContentAdapter = new PrimitiveReadEContentAdapter();
            _eAdapters.add(_primitiveReadEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<PrimitiveRead>operator_doubleArrow(_createPrimitiveRead, _function);
  }
  
  /**
   * This method creates an PrimitiveRead with the given id. Post create hook will be triggered.
   */
  public PrimitiveRead createPrimitiveRead(final String ID, final InternalNode source, final InternalNode target) {
    return this.createPrimitiveRead(ID, null, source, target, true);
  }
  
  /**
   * This method creates an PrimitiveRead with generated id. Post create hook will be triggered.
   */
  public PrimitiveRead createPrimitiveRead(final InternalNode source, final InternalNode target) {
    return this.createPrimitiveRead(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an PrimitiveRead with the given id. Post create hook won't be triggered.
   */
  public PrimitiveRead createPrimitiveRead(final String ID) {
    return this.createPrimitiveRead(ID, null, null, null, false);
  }
  
  /**
   * This method creates an PrimitiveRead with a generated id. Post create hook won't be triggered.
   */
  @Override
  public PrimitiveRead createPrimitiveRead() {
    return this.createPrimitiveRead(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an GuardProcessSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public GuardProcessSIB createGuardProcessSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    GuardProcessSIB _createGuardProcessSIB = super.createGuardProcessSIB();
    final Procedure1<GuardProcessSIB> _function = new Procedure1<GuardProcessSIB>() {
      @Override
      public void apply(final GuardProcessSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalGuardProcessSIB _createInternalGuardProcessSIB = ProcessFactory.this._internalFactory.createInternalGuardProcessSIB();
          _elvis = _createInternalGuardProcessSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            GuardProcessSIBEContentAdapter _guardProcessSIBEContentAdapter = new GuardProcessSIBEContentAdapter();
            _eAdapters.add(_guardProcessSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<GuardProcessSIB>operator_doubleArrow(_createGuardProcessSIB, _function);
  }
  
  /**
   * This method creates an GuardProcessSIB with the given id. Post create hook won't be triggered.
   */
  public GuardProcessSIB createGuardProcessSIB(final String ID) {
    return this.createGuardProcessSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an GuardProcessSIB with the given id. Post create hook will be triggered.
   */
  public GuardProcessSIB createGuardProcessSIB(final InternalModelElementContainer parent) {
    return this.createGuardProcessSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an GuardProcessSIB with the given id. Post create hook will be triggered.
   */
  public GuardProcessSIB createGuardProcessSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createGuardProcessSIB(ID, null, parent, true);
  }
  
  public GuardProcessSIB createGuardProcessSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createGuardProcessSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an GuardProcessSIB with the given id. Post create hook won't be triggered.
   */
  public GuardProcessSIB createGuardProcessSIB(final InternalModelElement ime) {
    return this.createGuardProcessSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public GuardProcessSIB createGuardProcessSIB() {
    return this.createGuardProcessSIB(EcoreUtil.generateUUID());
  }
  
  public ControlFlow createControlFlow(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    ControlFlow _createControlFlow = super.createControlFlow();
    final Procedure1<ControlFlow> _function = new Procedure1<ControlFlow>() {
      @Override
      public void apply(final ControlFlow it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalControlFlow _createInternalControlFlow = ProcessFactory.this._internalFactory.createInternalControlFlow();
          _elvis = _createInternalControlFlow;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            ControlFlowEContentAdapter _controlFlowEContentAdapter = new ControlFlowEContentAdapter();
            _eAdapters.add(_controlFlowEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ControlFlow>operator_doubleArrow(_createControlFlow, _function);
  }
  
  /**
   * This method creates an ControlFlow with the given id. Post create hook will be triggered.
   */
  public ControlFlow createControlFlow(final String ID, final InternalNode source, final InternalNode target) {
    return this.createControlFlow(ID, null, source, target, true);
  }
  
  /**
   * This method creates an ControlFlow with generated id. Post create hook will be triggered.
   */
  public ControlFlow createControlFlow(final InternalNode source, final InternalNode target) {
    return this.createControlFlow(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an ControlFlow with the given id. Post create hook won't be triggered.
   */
  public ControlFlow createControlFlow(final String ID) {
    return this.createControlFlow(ID, null, null, null, false);
  }
  
  /**
   * This method creates an ControlFlow with a generated id. Post create hook won't be triggered.
   */
  @Override
  public ControlFlow createControlFlow() {
    return this.createControlFlow(EcoreUtil.generateUUID());
  }
  
  public ComplexRead createComplexRead(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    ComplexRead _createComplexRead = super.createComplexRead();
    final Procedure1<ComplexRead> _function = new Procedure1<ComplexRead>() {
      @Override
      public void apply(final ComplexRead it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalComplexRead _createInternalComplexRead = ProcessFactory.this._internalFactory.createInternalComplexRead();
          _elvis = _createInternalComplexRead;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            ComplexReadEContentAdapter _complexReadEContentAdapter = new ComplexReadEContentAdapter();
            _eAdapters.add(_complexReadEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ComplexRead>operator_doubleArrow(_createComplexRead, _function);
  }
  
  /**
   * This method creates an ComplexRead with the given id. Post create hook will be triggered.
   */
  public ComplexRead createComplexRead(final String ID, final InternalNode source, final InternalNode target) {
    return this.createComplexRead(ID, null, source, target, true);
  }
  
  /**
   * This method creates an ComplexRead with generated id. Post create hook will be triggered.
   */
  public ComplexRead createComplexRead(final InternalNode source, final InternalNode target) {
    return this.createComplexRead(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an ComplexRead with the given id. Post create hook won't be triggered.
   */
  public ComplexRead createComplexRead(final String ID) {
    return this.createComplexRead(ID, null, null, null, false);
  }
  
  /**
   * This method creates an ComplexRead with a generated id. Post create hook won't be triggered.
   */
  @Override
  public ComplexRead createComplexRead() {
    return this.createComplexRead(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an PutToContextSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public PutToContextSIB createPutToContextSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    PutToContextSIB _createPutToContextSIB = super.createPutToContextSIB();
    final Procedure1<PutToContextSIB> _function = new Procedure1<PutToContextSIB>() {
      @Override
      public void apply(final PutToContextSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPutToContextSIB _createInternalPutToContextSIB = ProcessFactory.this._internalFactory.createInternalPutToContextSIB();
          _elvis = _createInternalPutToContextSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            PutToContextSIBEContentAdapter _putToContextSIBEContentAdapter = new PutToContextSIBEContentAdapter();
            _eAdapters.add(_putToContextSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<PutToContextSIB>operator_doubleArrow(_createPutToContextSIB, _function);
  }
  
  /**
   * This method creates an PutToContextSIB with the given id. Post create hook won't be triggered.
   */
  public PutToContextSIB createPutToContextSIB(final String ID) {
    return this.createPutToContextSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an PutToContextSIB with the given id. Post create hook will be triggered.
   */
  public PutToContextSIB createPutToContextSIB(final InternalModelElementContainer parent) {
    return this.createPutToContextSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an PutToContextSIB with the given id. Post create hook will be triggered.
   */
  public PutToContextSIB createPutToContextSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createPutToContextSIB(ID, null, parent, true);
  }
  
  public PutToContextSIB createPutToContextSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createPutToContextSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an PutToContextSIB with the given id. Post create hook won't be triggered.
   */
  public PutToContextSIB createPutToContextSIB(final InternalModelElement ime) {
    return this.createPutToContextSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public PutToContextSIB createPutToContextSIB() {
    return this.createPutToContextSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ProcessInputStatic with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ProcessInputStatic createProcessInputStatic(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ProcessInputStatic _createProcessInputStatic = super.createProcessInputStatic();
    final Procedure1<ProcessInputStatic> _function = new Procedure1<ProcessInputStatic>() {
      @Override
      public void apply(final ProcessInputStatic it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalProcessInputStatic _createInternalProcessInputStatic = ProcessFactory.this._internalFactory.createInternalProcessInputStatic();
          _elvis = _createInternalProcessInputStatic;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ProcessInputStaticEContentAdapter _processInputStaticEContentAdapter = new ProcessInputStaticEContentAdapter();
            _eAdapters.add(_processInputStaticEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ProcessInputStatic>operator_doubleArrow(_createProcessInputStatic, _function);
  }
  
  /**
   * This method creates an ProcessInputStatic with the given id. Post create hook won't be triggered.
   */
  public ProcessInputStatic createProcessInputStatic(final String ID) {
    return this.createProcessInputStatic(ID, null, null, false);
  }
  
  /**
   * This method creates an ProcessInputStatic with the given id. Post create hook will be triggered.
   */
  public ProcessInputStatic createProcessInputStatic(final InternalModelElementContainer parent) {
    return this.createProcessInputStatic(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ProcessInputStatic with the given id. Post create hook will be triggered.
   */
  public ProcessInputStatic createProcessInputStatic(final String ID, final InternalModelElementContainer parent) {
    return this.createProcessInputStatic(ID, null, parent, true);
  }
  
  public ProcessInputStatic createProcessInputStatic(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createProcessInputStatic(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ProcessInputStatic with the given id. Post create hook won't be triggered.
   */
  public ProcessInputStatic createProcessInputStatic(final InternalModelElement ime) {
    return this.createProcessInputStatic(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ProcessInputStatic createProcessInputStatic() {
    return this.createProcessInputStatic(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an IterateJavaNativeSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public IterateJavaNativeSIB createIterateJavaNativeSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    IterateJavaNativeSIB _createIterateJavaNativeSIB = super.createIterateJavaNativeSIB();
    final Procedure1<IterateJavaNativeSIB> _function = new Procedure1<IterateJavaNativeSIB>() {
      @Override
      public void apply(final IterateJavaNativeSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalIterateJavaNativeSIB _createInternalIterateJavaNativeSIB = ProcessFactory.this._internalFactory.createInternalIterateJavaNativeSIB();
          _elvis = _createInternalIterateJavaNativeSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            IterateJavaNativeSIBEContentAdapter _iterateJavaNativeSIBEContentAdapter = new IterateJavaNativeSIBEContentAdapter();
            _eAdapters.add(_iterateJavaNativeSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<IterateJavaNativeSIB>operator_doubleArrow(_createIterateJavaNativeSIB, _function);
  }
  
  /**
   * This method creates an IterateJavaNativeSIB with the given id. Post create hook won't be triggered.
   */
  public IterateJavaNativeSIB createIterateJavaNativeSIB(final String ID) {
    return this.createIterateJavaNativeSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an IterateJavaNativeSIB with the given id. Post create hook will be triggered.
   */
  public IterateJavaNativeSIB createIterateJavaNativeSIB(final InternalModelElementContainer parent) {
    return this.createIterateJavaNativeSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an IterateJavaNativeSIB with the given id. Post create hook will be triggered.
   */
  public IterateJavaNativeSIB createIterateJavaNativeSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createIterateJavaNativeSIB(ID, null, parent, true);
  }
  
  public IterateJavaNativeSIB createIterateJavaNativeSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createIterateJavaNativeSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an IterateJavaNativeSIB with the given id. Post create hook won't be triggered.
   */
  public IterateJavaNativeSIB createIterateJavaNativeSIB(final InternalModelElement ime) {
    return this.createIterateJavaNativeSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public IterateJavaNativeSIB createIterateJavaNativeSIB() {
    return this.createIterateJavaNativeSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an SetAttributeValueSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public SetAttributeValueSIB createSetAttributeValueSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    SetAttributeValueSIB _createSetAttributeValueSIB = super.createSetAttributeValueSIB();
    final Procedure1<SetAttributeValueSIB> _function = new Procedure1<SetAttributeValueSIB>() {
      @Override
      public void apply(final SetAttributeValueSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalSetAttributeValueSIB _createInternalSetAttributeValueSIB = ProcessFactory.this._internalFactory.createInternalSetAttributeValueSIB();
          _elvis = _createInternalSetAttributeValueSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            SetAttributeValueSIBEContentAdapter _setAttributeValueSIBEContentAdapter = new SetAttributeValueSIBEContentAdapter();
            _eAdapters.add(_setAttributeValueSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<SetAttributeValueSIB>operator_doubleArrow(_createSetAttributeValueSIB, _function);
  }
  
  /**
   * This method creates an SetAttributeValueSIB with the given id. Post create hook won't be triggered.
   */
  public SetAttributeValueSIB createSetAttributeValueSIB(final String ID) {
    return this.createSetAttributeValueSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an SetAttributeValueSIB with the given id. Post create hook will be triggered.
   */
  public SetAttributeValueSIB createSetAttributeValueSIB(final InternalModelElementContainer parent) {
    return this.createSetAttributeValueSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an SetAttributeValueSIB with the given id. Post create hook will be triggered.
   */
  public SetAttributeValueSIB createSetAttributeValueSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createSetAttributeValueSIB(ID, null, parent, true);
  }
  
  public SetAttributeValueSIB createSetAttributeValueSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createSetAttributeValueSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an SetAttributeValueSIB with the given id. Post create hook won't be triggered.
   */
  public SetAttributeValueSIB createSetAttributeValueSIB(final InternalModelElement ime) {
    return this.createSetAttributeValueSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public SetAttributeValueSIB createSetAttributeValueSIB() {
    return this.createSetAttributeValueSIB(EcoreUtil.generateUUID());
  }
  
  public PrimitiveUpdate createPrimitiveUpdate(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    PrimitiveUpdate _createPrimitiveUpdate = super.createPrimitiveUpdate();
    final Procedure1<PrimitiveUpdate> _function = new Procedure1<PrimitiveUpdate>() {
      @Override
      public void apply(final PrimitiveUpdate it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalPrimitiveUpdate _createInternalPrimitiveUpdate = ProcessFactory.this._internalFactory.createInternalPrimitiveUpdate();
          _elvis = _createInternalPrimitiveUpdate;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            PrimitiveUpdateEContentAdapter _primitiveUpdateEContentAdapter = new PrimitiveUpdateEContentAdapter();
            _eAdapters.add(_primitiveUpdateEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<PrimitiveUpdate>operator_doubleArrow(_createPrimitiveUpdate, _function);
  }
  
  /**
   * This method creates an PrimitiveUpdate with the given id. Post create hook will be triggered.
   */
  public PrimitiveUpdate createPrimitiveUpdate(final String ID, final InternalNode source, final InternalNode target) {
    return this.createPrimitiveUpdate(ID, null, source, target, true);
  }
  
  /**
   * This method creates an PrimitiveUpdate with generated id. Post create hook will be triggered.
   */
  public PrimitiveUpdate createPrimitiveUpdate(final InternalNode source, final InternalNode target) {
    return this.createPrimitiveUpdate(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an PrimitiveUpdate with the given id. Post create hook won't be triggered.
   */
  public PrimitiveUpdate createPrimitiveUpdate(final String ID) {
    return this.createPrimitiveUpdate(ID, null, null, null, false);
  }
  
  /**
   * This method creates an PrimitiveUpdate with a generated id. Post create hook won't be triggered.
   */
  @Override
  public PrimitiveUpdate createPrimitiveUpdate() {
    return this.createPrimitiveUpdate(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ContainsJavaNativeSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ContainsJavaNativeSIB createContainsJavaNativeSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ContainsJavaNativeSIB _createContainsJavaNativeSIB = super.createContainsJavaNativeSIB();
    final Procedure1<ContainsJavaNativeSIB> _function = new Procedure1<ContainsJavaNativeSIB>() {
      @Override
      public void apply(final ContainsJavaNativeSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalContainsJavaNativeSIB _createInternalContainsJavaNativeSIB = ProcessFactory.this._internalFactory.createInternalContainsJavaNativeSIB();
          _elvis = _createInternalContainsJavaNativeSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ContainsJavaNativeSIBEContentAdapter _containsJavaNativeSIBEContentAdapter = new ContainsJavaNativeSIBEContentAdapter();
            _eAdapters.add(_containsJavaNativeSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ContainsJavaNativeSIB>operator_doubleArrow(_createContainsJavaNativeSIB, _function);
  }
  
  /**
   * This method creates an ContainsJavaNativeSIB with the given id. Post create hook won't be triggered.
   */
  public ContainsJavaNativeSIB createContainsJavaNativeSIB(final String ID) {
    return this.createContainsJavaNativeSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an ContainsJavaNativeSIB with the given id. Post create hook will be triggered.
   */
  public ContainsJavaNativeSIB createContainsJavaNativeSIB(final InternalModelElementContainer parent) {
    return this.createContainsJavaNativeSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ContainsJavaNativeSIB with the given id. Post create hook will be triggered.
   */
  public ContainsJavaNativeSIB createContainsJavaNativeSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createContainsJavaNativeSIB(ID, null, parent, true);
  }
  
  public ContainsJavaNativeSIB createContainsJavaNativeSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createContainsJavaNativeSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ContainsJavaNativeSIB with the given id. Post create hook won't be triggered.
   */
  public ContainsJavaNativeSIB createContainsJavaNativeSIB(final InternalModelElement ime) {
    return this.createContainsJavaNativeSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ContainsJavaNativeSIB createContainsJavaNativeSIB() {
    return this.createContainsJavaNativeSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an EnumSwitchSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public EnumSwitchSIB createEnumSwitchSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    EnumSwitchSIB _createEnumSwitchSIB = super.createEnumSwitchSIB();
    final Procedure1<EnumSwitchSIB> _function = new Procedure1<EnumSwitchSIB>() {
      @Override
      public void apply(final EnumSwitchSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalEnumSwitchSIB _createInternalEnumSwitchSIB = ProcessFactory.this._internalFactory.createInternalEnumSwitchSIB();
          _elvis = _createInternalEnumSwitchSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            EnumSwitchSIBEContentAdapter _enumSwitchSIBEContentAdapter = new EnumSwitchSIBEContentAdapter();
            _eAdapters.add(_enumSwitchSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<EnumSwitchSIB>operator_doubleArrow(_createEnumSwitchSIB, _function);
  }
  
  /**
   * This method creates an EnumSwitchSIB with the given id. Post create hook won't be triggered.
   */
  public EnumSwitchSIB createEnumSwitchSIB(final String ID) {
    return this.createEnumSwitchSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an EnumSwitchSIB with the given id. Post create hook will be triggered.
   */
  public EnumSwitchSIB createEnumSwitchSIB(final InternalModelElementContainer parent) {
    return this.createEnumSwitchSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an EnumSwitchSIB with the given id. Post create hook will be triggered.
   */
  public EnumSwitchSIB createEnumSwitchSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createEnumSwitchSIB(ID, null, parent, true);
  }
  
  public EnumSwitchSIB createEnumSwitchSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createEnumSwitchSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an EnumSwitchSIB with the given id. Post create hook won't be triggered.
   */
  public EnumSwitchSIB createEnumSwitchSIB(final InternalModelElement ime) {
    return this.createEnumSwitchSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public EnumSwitchSIB createEnumSwitchSIB() {
    return this.createEnumSwitchSIB(EcoreUtil.generateUUID());
  }
  
  public EventConnector createEventConnector(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    EventConnector _createEventConnector = super.createEventConnector();
    final Procedure1<EventConnector> _function = new Procedure1<EventConnector>() {
      @Override
      public void apply(final EventConnector it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalEventConnector _createInternalEventConnector = ProcessFactory.this._internalFactory.createInternalEventConnector();
          _elvis = _createInternalEventConnector;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            EventConnectorEContentAdapter _eventConnectorEContentAdapter = new EventConnectorEContentAdapter();
            _eAdapters.add(_eventConnectorEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<EventConnector>operator_doubleArrow(_createEventConnector, _function);
  }
  
  /**
   * This method creates an EventConnector with the given id. Post create hook will be triggered.
   */
  public EventConnector createEventConnector(final String ID, final InternalNode source, final InternalNode target) {
    return this.createEventConnector(ID, null, source, target, true);
  }
  
  /**
   * This method creates an EventConnector with generated id. Post create hook will be triggered.
   */
  public EventConnector createEventConnector(final InternalNode source, final InternalNode target) {
    return this.createEventConnector(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an EventConnector with the given id. Post create hook won't be triggered.
   */
  public EventConnector createEventConnector(final String ID) {
    return this.createEventConnector(ID, null, null, null, false);
  }
  
  /**
   * This method creates an EventConnector with a generated id. Post create hook won't be triggered.
   */
  @Override
  public EventConnector createEventConnector() {
    return this.createEventConnector(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an EntryPointProcessSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public EntryPointProcessSIB createEntryPointProcessSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    EntryPointProcessSIB _createEntryPointProcessSIB = super.createEntryPointProcessSIB();
    final Procedure1<EntryPointProcessSIB> _function = new Procedure1<EntryPointProcessSIB>() {
      @Override
      public void apply(final EntryPointProcessSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalEntryPointProcessSIB _createInternalEntryPointProcessSIB = ProcessFactory.this._internalFactory.createInternalEntryPointProcessSIB();
          _elvis = _createInternalEntryPointProcessSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            EntryPointProcessSIBEContentAdapter _entryPointProcessSIBEContentAdapter = new EntryPointProcessSIBEContentAdapter();
            _eAdapters.add(_entryPointProcessSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<EntryPointProcessSIB>operator_doubleArrow(_createEntryPointProcessSIB, _function);
  }
  
  /**
   * This method creates an EntryPointProcessSIB with the given id. Post create hook won't be triggered.
   */
  public EntryPointProcessSIB createEntryPointProcessSIB(final String ID) {
    return this.createEntryPointProcessSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an EntryPointProcessSIB with the given id. Post create hook will be triggered.
   */
  public EntryPointProcessSIB createEntryPointProcessSIB(final InternalModelElementContainer parent) {
    return this.createEntryPointProcessSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an EntryPointProcessSIB with the given id. Post create hook will be triggered.
   */
  public EntryPointProcessSIB createEntryPointProcessSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createEntryPointProcessSIB(ID, null, parent, true);
  }
  
  public EntryPointProcessSIB createEntryPointProcessSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createEntryPointProcessSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an EntryPointProcessSIB with the given id. Post create hook won't be triggered.
   */
  public EntryPointProcessSIB createEntryPointProcessSIB(final InternalModelElement ime) {
    return this.createEntryPointProcessSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public EntryPointProcessSIB createEntryPointProcessSIB() {
    return this.createEntryPointProcessSIB(EcoreUtil.generateUUID());
  }
  
  public JavaNativeUpdate createJavaNativeUpdate(final String ID, final InternalModelElement ime, final InternalNode source, final InternalNode target, final boolean hook) {
    JavaNativeUpdate _createJavaNativeUpdate = super.createJavaNativeUpdate();
    final Procedure1<JavaNativeUpdate> _function = new Procedure1<JavaNativeUpdate>() {
      @Override
      public void apply(final JavaNativeUpdate it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalJavaNativeUpdate _createInternalJavaNativeUpdate = ProcessFactory.this._internalFactory.createInternalJavaNativeUpdate();
          _elvis = _createInternalJavaNativeUpdate;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            ((InternalEdge) it).set_sourceElement(source);
            ((InternalEdge) it).set_targetElement(target);
            InternalGraphModel _elvis = null;
            InternalGraphModel _rootElement = null;
            if (source!=null) {
              _rootElement=source.getRootElement();
            }
            if (_rootElement != null) {
              _elvis = _rootElement;
            } else {
              InternalGraphModel _rootElement_1 = null;
              if (target!=null) {
                _rootElement_1=target.getRootElement();
              }
              _elvis = _rootElement_1;
            }
            it.setContainer(_elvis);
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            JavaNativeUpdateEContentAdapter _javaNativeUpdateEContentAdapter = new JavaNativeUpdateEContentAdapter();
            _eAdapters.add(_javaNativeUpdateEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<JavaNativeUpdate>operator_doubleArrow(_createJavaNativeUpdate, _function);
  }
  
  /**
   * This method creates an JavaNativeUpdate with the given id. Post create hook will be triggered.
   */
  public JavaNativeUpdate createJavaNativeUpdate(final String ID, final InternalNode source, final InternalNode target) {
    return this.createJavaNativeUpdate(ID, null, source, target, true);
  }
  
  /**
   * This method creates an JavaNativeUpdate with generated id. Post create hook will be triggered.
   */
  public JavaNativeUpdate createJavaNativeUpdate(final InternalNode source, final InternalNode target) {
    return this.createJavaNativeUpdate(EcoreUtil.generateUUID(), null, source, target, true);
  }
  
  /**
   * This method creates an JavaNativeUpdate with the given id. Post create hook won't be triggered.
   */
  public JavaNativeUpdate createJavaNativeUpdate(final String ID) {
    return this.createJavaNativeUpdate(ID, null, null, null, false);
  }
  
  /**
   * This method creates an JavaNativeUpdate with a generated id. Post create hook won't be triggered.
   */
  @Override
  public JavaNativeUpdate createJavaNativeUpdate() {
    return this.createJavaNativeUpdate(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an RetrieveOfTypeSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public RetrieveOfTypeSIB createRetrieveOfTypeSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    RetrieveOfTypeSIB _createRetrieveOfTypeSIB = super.createRetrieveOfTypeSIB();
    final Procedure1<RetrieveOfTypeSIB> _function = new Procedure1<RetrieveOfTypeSIB>() {
      @Override
      public void apply(final RetrieveOfTypeSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalRetrieveOfTypeSIB _createInternalRetrieveOfTypeSIB = ProcessFactory.this._internalFactory.createInternalRetrieveOfTypeSIB();
          _elvis = _createInternalRetrieveOfTypeSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            RetrieveOfTypeSIBEContentAdapter _retrieveOfTypeSIBEContentAdapter = new RetrieveOfTypeSIBEContentAdapter();
            _eAdapters.add(_retrieveOfTypeSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<RetrieveOfTypeSIB>operator_doubleArrow(_createRetrieveOfTypeSIB, _function);
  }
  
  /**
   * This method creates an RetrieveOfTypeSIB with the given id. Post create hook won't be triggered.
   */
  public RetrieveOfTypeSIB createRetrieveOfTypeSIB(final String ID) {
    return this.createRetrieveOfTypeSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an RetrieveOfTypeSIB with the given id. Post create hook will be triggered.
   */
  public RetrieveOfTypeSIB createRetrieveOfTypeSIB(final InternalModelElementContainer parent) {
    return this.createRetrieveOfTypeSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an RetrieveOfTypeSIB with the given id. Post create hook will be triggered.
   */
  public RetrieveOfTypeSIB createRetrieveOfTypeSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createRetrieveOfTypeSIB(ID, null, parent, true);
  }
  
  public RetrieveOfTypeSIB createRetrieveOfTypeSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createRetrieveOfTypeSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an RetrieveOfTypeSIB with the given id. Post create hook won't be triggered.
   */
  public RetrieveOfTypeSIB createRetrieveOfTypeSIB(final InternalModelElement ime) {
    return this.createRetrieveOfTypeSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public RetrieveOfTypeSIB createRetrieveOfTypeSIB() {
    return this.createRetrieveOfTypeSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an AtomicSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public AtomicSIB createAtomicSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    AtomicSIB _createAtomicSIB = super.createAtomicSIB();
    final Procedure1<AtomicSIB> _function = new Procedure1<AtomicSIB>() {
      @Override
      public void apply(final AtomicSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalAtomicSIB _createInternalAtomicSIB = ProcessFactory.this._internalFactory.createInternalAtomicSIB();
          _elvis = _createInternalAtomicSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            AtomicSIBEContentAdapter _atomicSIBEContentAdapter = new AtomicSIBEContentAdapter();
            _eAdapters.add(_atomicSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<AtomicSIB>operator_doubleArrow(_createAtomicSIB, _function);
  }
  
  /**
   * This method creates an AtomicSIB with the given id. Post create hook won't be triggered.
   */
  public AtomicSIB createAtomicSIB(final String ID) {
    return this.createAtomicSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an AtomicSIB with the given id. Post create hook will be triggered.
   */
  public AtomicSIB createAtomicSIB(final InternalModelElementContainer parent) {
    return this.createAtomicSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an AtomicSIB with the given id. Post create hook will be triggered.
   */
  public AtomicSIB createAtomicSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createAtomicSIB(ID, null, parent, true);
  }
  
  public AtomicSIB createAtomicSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createAtomicSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an AtomicSIB with the given id. Post create hook won't be triggered.
   */
  public AtomicSIB createAtomicSIB(final InternalModelElement ime) {
    return this.createAtomicSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public AtomicSIB createAtomicSIB() {
    return this.createAtomicSIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an BooleanInputStatic with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public BooleanInputStatic createBooleanInputStatic(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    BooleanInputStatic _createBooleanInputStatic = super.createBooleanInputStatic();
    final Procedure1<BooleanInputStatic> _function = new Procedure1<BooleanInputStatic>() {
      @Override
      public void apply(final BooleanInputStatic it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalBooleanInputStatic _createInternalBooleanInputStatic = ProcessFactory.this._internalFactory.createInternalBooleanInputStatic();
          _elvis = _createInternalBooleanInputStatic;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            BooleanInputStaticEContentAdapter _booleanInputStaticEContentAdapter = new BooleanInputStaticEContentAdapter();
            _eAdapters.add(_booleanInputStaticEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<BooleanInputStatic>operator_doubleArrow(_createBooleanInputStatic, _function);
  }
  
  /**
   * This method creates an BooleanInputStatic with the given id. Post create hook won't be triggered.
   */
  public BooleanInputStatic createBooleanInputStatic(final String ID) {
    return this.createBooleanInputStatic(ID, null, null, false);
  }
  
  /**
   * This method creates an BooleanInputStatic with the given id. Post create hook will be triggered.
   */
  public BooleanInputStatic createBooleanInputStatic(final InternalModelElementContainer parent) {
    return this.createBooleanInputStatic(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an BooleanInputStatic with the given id. Post create hook will be triggered.
   */
  public BooleanInputStatic createBooleanInputStatic(final String ID, final InternalModelElementContainer parent) {
    return this.createBooleanInputStatic(ID, null, parent, true);
  }
  
  public BooleanInputStatic createBooleanInputStatic(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createBooleanInputStatic(ID, ime, parent, true);
  }
  
  /**
   * This method creates an BooleanInputStatic with the given id. Post create hook won't be triggered.
   */
  public BooleanInputStatic createBooleanInputStatic(final InternalModelElement ime) {
    return this.createBooleanInputStatic(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public BooleanInputStatic createBooleanInputStatic() {
    return this.createBooleanInputStatic(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ExtensionAttribute with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ExtensionAttribute createExtensionAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ExtensionAttribute _createExtensionAttribute = super.createExtensionAttribute();
    final Procedure1<ExtensionAttribute> _function = new Procedure1<ExtensionAttribute>() {
      @Override
      public void apply(final ExtensionAttribute it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalExtensionAttribute _createInternalExtensionAttribute = ProcessFactory.this._internalFactory.createInternalExtensionAttribute();
          _elvis = _createInternalExtensionAttribute;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ExtensionAttributeEContentAdapter _extensionAttributeEContentAdapter = new ExtensionAttributeEContentAdapter();
            _eAdapters.add(_extensionAttributeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ExtensionAttribute>operator_doubleArrow(_createExtensionAttribute, _function);
  }
  
  /**
   * This method creates an ExtensionAttribute with the given id. Post create hook won't be triggered.
   */
  public ExtensionAttribute createExtensionAttribute(final String ID) {
    return this.createExtensionAttribute(ID, null, null, false);
  }
  
  /**
   * This method creates an ExtensionAttribute with the given id. Post create hook will be triggered.
   */
  public ExtensionAttribute createExtensionAttribute(final InternalModelElementContainer parent) {
    return this.createExtensionAttribute(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ExtensionAttribute with the given id. Post create hook will be triggered.
   */
  public ExtensionAttribute createExtensionAttribute(final String ID, final InternalModelElementContainer parent) {
    return this.createExtensionAttribute(ID, null, parent, true);
  }
  
  public ExtensionAttribute createExtensionAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createExtensionAttribute(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ExtensionAttribute with the given id. Post create hook won't be triggered.
   */
  public ExtensionAttribute createExtensionAttribute(final InternalModelElement ime) {
    return this.createExtensionAttribute(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ExtensionAttribute createExtensionAttribute() {
    return this.createExtensionAttribute(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an GuardContainer with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public GuardContainer createGuardContainer(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    GuardContainer _createGuardContainer = super.createGuardContainer();
    final Procedure1<GuardContainer> _function = new Procedure1<GuardContainer>() {
      @Override
      public void apply(final GuardContainer it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalGuardContainer _createInternalGuardContainer = ProcessFactory.this._internalFactory.createInternalGuardContainer();
          _elvis = _createInternalGuardContainer;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            GuardContainerEContentAdapter _guardContainerEContentAdapter = new GuardContainerEContentAdapter();
            _eAdapters.add(_guardContainerEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<GuardContainer>operator_doubleArrow(_createGuardContainer, _function);
  }
  
  /**
   * This method creates an GuardContainer with the given id. Post create hook won't be triggered.
   */
  public GuardContainer createGuardContainer(final String ID) {
    return this.createGuardContainer(ID, null, null, false);
  }
  
  /**
   * This method creates an GuardContainer with the given id. Post create hook will be triggered.
   */
  public GuardContainer createGuardContainer(final InternalModelElementContainer parent) {
    return this.createGuardContainer(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an GuardContainer with the given id. Post create hook will be triggered.
   */
  public GuardContainer createGuardContainer(final String ID, final InternalModelElementContainer parent) {
    return this.createGuardContainer(ID, null, parent, true);
  }
  
  public GuardContainer createGuardContainer(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createGuardContainer(ID, ime, parent, true);
  }
  
  /**
   * This method creates an GuardContainer with the given id. Post create hook won't be triggered.
   */
  public GuardContainer createGuardContainer(final InternalModelElement ime) {
    return this.createGuardContainer(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public GuardContainer createGuardContainer() {
    return this.createGuardContainer(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an CreateUserSIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public CreateUserSIB createCreateUserSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    CreateUserSIB _createCreateUserSIB = super.createCreateUserSIB();
    final Procedure1<CreateUserSIB> _function = new Procedure1<CreateUserSIB>() {
      @Override
      public void apply(final CreateUserSIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalCreateUserSIB _createInternalCreateUserSIB = ProcessFactory.this._internalFactory.createInternalCreateUserSIB();
          _elvis = _createInternalCreateUserSIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            CreateUserSIBEContentAdapter _createUserSIBEContentAdapter = new CreateUserSIBEContentAdapter();
            _eAdapters.add(_createUserSIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        ProcessFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          ProcessFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<CreateUserSIB>operator_doubleArrow(_createCreateUserSIB, _function);
  }
  
  /**
   * This method creates an CreateUserSIB with the given id. Post create hook won't be triggered.
   */
  public CreateUserSIB createCreateUserSIB(final String ID) {
    return this.createCreateUserSIB(ID, null, null, false);
  }
  
  /**
   * This method creates an CreateUserSIB with the given id. Post create hook will be triggered.
   */
  public CreateUserSIB createCreateUserSIB(final InternalModelElementContainer parent) {
    return this.createCreateUserSIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an CreateUserSIB with the given id. Post create hook will be triggered.
   */
  public CreateUserSIB createCreateUserSIB(final String ID, final InternalModelElementContainer parent) {
    return this.createCreateUserSIB(ID, null, parent, true);
  }
  
  public CreateUserSIB createCreateUserSIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createCreateUserSIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an CreateUserSIB with the given id. Post create hook won't be triggered.
   */
  public CreateUserSIB createCreateUserSIB(final InternalModelElement ime) {
    return this.createCreateUserSIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public CreateUserSIB createCreateUserSIB() {
    return this.createCreateUserSIB(EcoreUtil.generateUUID());
  }
  
  private <T extends IdentifiableElement> T setInternal(final T elm, final InternalIdentifiableElement internal) {
    final Procedure1<T> _function = new Procedure1<T>() {
      @Override
      public void apply(final T it) {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(it.getId());
        if (_isNullOrEmpty) {
          EcoreUtil.setID(it, EcoreUtil.generateUUID());
        }
        boolean _matched = false;
        if (elm instanceof GraphModel) {
          _matched=true;
          ((GraphModel)elm).setInternalElement_(((InternalGraphModel) internal));
        }
        if (!_matched) {
          if (elm instanceof ModelElement) {
            _matched=true;
            ((ModelElement)elm).setInternalElement_(((InternalModelElement) internal));
          }
        }
        if (!_matched) {
          if (elm instanceof Type) {
            _matched=true;
            ((Type)elm).setInternalElement_(((InternalType) internal));
          }
        }
      }
    };
    return ObjectExtensions.<T>operator_doubleArrow(elm, _function);
  }
  
  /**
   * This method creates a new Process object with an underlying org.eclipse.emf.ecore.resource.Resource. Thus you can
   * simply call the Process's save method to save your changes.
   */
  public info.scce.dime.process.process.Process createProcess(final String path, final String fileName) {
    IPath filePath = new Path(path).append(fileName).addFileExtension("process");
    URI uri = URI.createPlatformResourceURI(filePath.toOSString(), true);
    Resource res = new ResourceSetImpl().createResource(uri);
    info.scce.dime.process.process.Process graph = ProcessFactory.eINSTANCE.createProcess();
    EcoreUtil.setID(graph, EcoreUtil.generateUUID());
    res.getContents().add(graph.getInternalElement_());
    this.postCreates(graph);
    try {
      res.save(null);
    } catch (final Throwable _t) {
      if (_t instanceof IOException) {
        final IOException e = (IOException)_t;
        e.printStackTrace();
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
    return graph;
  }
  
  public void postCreates(final StartSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new ProcessNodePostCreate<StartSIB>().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final EndSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new ProcessNodePostCreate<EndSIB>().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final Branch me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new ProcessNodePostCreate<Branch>().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final SearchSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new SearchSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final CreateSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new CreateSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final TransientCreateSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new TransientCreateSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final CreateUserSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new CreateUserSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ContainsSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new ContainsSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ContainsJavaNativeSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new ContainsJavaNativeSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ContainsPrimitiveSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new ContainsPrimitiveSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final IsOfTypeSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new IsOfTypeSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final IterateSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new IterateSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final IterateJavaNativeSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new IterateJavaNativeSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final IteratePrimitiveSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new IteratePrimitiveSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final PutComplexToContextSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new PutComplexToContextSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final PutToContextSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new PutToContextSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final TriggerEventSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new TriggerEventSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final RetrieveOfTypeSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new RetrieveOfTypeSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final RetrieveCurrentUserSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new RetrieveCurrentUserSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final SwitchToUserSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new SwitchToUserSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final GetOriginalUserSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new GetOriginalUserSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final SwitchToOriginalUserSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new SwitchToOriginalUserSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final DeleteSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new DeleteSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final RemoveFromListSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new RemoveFromListSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final PutPrimitiveToContextSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new PutPrimitiveToContextSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final LinkProcessSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new LinkProcessSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final EnumSwitchSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new EnumSwitchSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final RetrieveEnumLiteralSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new RetrieveEnumLiteralSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final SetAttributeValueSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new SetAttributeValueSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final UnsetAttributeValueSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new UnsetAttributeValueSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final AtomicSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new AtomicSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ProcessSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new ProcessSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final GenericSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new GenericSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ProcessPlaceholderSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new ProcessSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final GUISIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new GUISIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final GuardedProcessSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new GuardedProcessSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final EntryPointProcessSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new ProcessSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final GuardProcessSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new GuardProcessSIBHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ProcessBlueprintSIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new ProcessNodePostCreate<ProcessBlueprintSIB>().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final BranchBlueprint me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new ProcessNodePostCreate<BranchBlueprint>().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ComplexInputPort me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new InputHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ComplexAttributePort me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new ComplexAttributePortHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final PrimitiveAttributePort me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new PrimitiveAttributePortHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final PrimitiveInputPort me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new InputHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final JavaNativeInputPort me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new InputHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ProcessInputStatic me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new InputHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
    final Runnable _function_1 = new Runnable() {
      @Override
      public void run() {
        new ProcessInputStaticHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function_1);
  }
  
  public void postCreates(final PrimitiveOutputPort me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new OutputPortHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ComplexOutputPort me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new OutputPortHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final JavaNativeOutputPort me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new OutputPortHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final PrimitiveVariable me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new Variable_PostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final JavaNativeVariable me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new Variable_PostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ComplexVariable me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new ComplexVariablePostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final NativeFrontendSIBReference me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new CreateNativeFrontendSIBReference().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ComplexDirectDataFlow me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new DirectDataFlowPostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final PrimitiveDirectDataFlow me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new DirectDataFlowPostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final JavaNativeDirectDataFlow me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new DirectDataFlowPostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final info.scce.dime.process.process.Process me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new ProcessInit().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
}
