/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.checks;

import graphmodel.Node;
import info.scce.dime.checks.ProcessCheck;
import info.scce.dime.gui.gui.Placeholder;
import info.scce.dime.process.process.AbstractBranch;
import info.scce.dime.process.process.BranchConnector;
import info.scce.dime.process.process.GUIBlueprintSIB;
import info.scce.dime.process.process.GUISIB;
import info.scce.dime.process.process.GUISIBOptions;
import info.scce.dime.process.process.GenericSIB;
import info.scce.dime.process.process.SIB;
import java.util.function.Consumer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class MajorMinorGUISIBCheck extends ProcessCheck {
  @Override
  public void check(final info.scce.dime.process.process.Process model) {
    final Consumer<SIB> _function = new Consumer<SIB>() {
      @Override
      public void accept(final SIB it) {
        boolean _matched = false;
        if (it instanceof GUISIB) {
          _matched=true;
          boolean _isMajorPage = ((GUISIB)it).isMajorPage();
          if (_isMajorPage) {
            MajorMinorGUISIBCheck.this.checkMajorGUI(it);
          } else {
            MajorMinorGUISIBCheck.this.checkMinorGUI(it);
          }
        }
        if (!_matched) {
          if (it instanceof GUIBlueprintSIB) {
            _matched=true;
            boolean _isMajorPage = ((GUIBlueprintSIB)it).isMajorPage();
            if (_isMajorPage) {
              MajorMinorGUISIBCheck.this.checkMajorGUI(it);
            } else {
              MajorMinorGUISIBCheck.this.checkMinorGUI(it);
            }
          }
        }
        if (!_matched) {
          if (it instanceof GenericSIB) {
            _matched=true;
            if (((((GenericSIB)it).getGuiOptions() != null) && ((GenericSIB)it).getGuiOptions().isMajorPage())) {
              MajorMinorGUISIBCheck.this.checkMajorGUI(it);
            } else {
              GUISIBOptions _guiOptions = ((GenericSIB)it).getGuiOptions();
              boolean _tripleNotEquals = (_guiOptions != null);
              if (_tripleNotEquals) {
                MajorMinorGUISIBCheck.this.checkMinorGUI(it);
              }
            }
          }
        }
      }
    };
    this._graphModelExtension.<SIB>find(model, SIB.class).forEach(_function);
  }
  
  public void checkMajorGUI(final SIB it) {
    AbstractBranch _majorBranch = this._processExtension.getMajorBranch(it);
    boolean _tripleNotEquals = (_majorBranch != null);
    if (_tripleNotEquals) {
      this.addWarning(it, "major branch has no effect on major GUISIBs");
    }
    final SIB defaultContent = this.getDefaultContent(it);
    if ((defaultContent != null)) {
      boolean _matched = false;
      if (defaultContent instanceof GUISIB) {
        _matched=true;
        final Function1<SIB, Boolean> _function = new Function1<SIB, Boolean>() {
          @Override
          public Boolean apply(final SIB it) {
            boolean _isMajor = MajorMinorGUISIBCheck.this._processExtension.isMajor(defaultContent);
            return Boolean.valueOf((!_isMajor));
          }
        };
        this.<SIB>check(it, _function).elseError("default content cannot be major GUISIB");
        this.checkPlaceholder(it);
      }
      if (!_matched) {
        if (defaultContent instanceof GUIBlueprintSIB) {
          _matched=true;
          final Function1<SIB, Boolean> _function = new Function1<SIB, Boolean>() {
            @Override
            public Boolean apply(final SIB it) {
              boolean _isMajor = MajorMinorGUISIBCheck.this._processExtension.isMajor(defaultContent);
              return Boolean.valueOf((!_isMajor));
            }
          };
          this.<SIB>check(it, _function).elseError("default content cannot be major GUISIB");
          this.checkPlaceholder(it);
        }
      }
      if (!_matched) {
        this.addError(it, "default content must be minor Interaction SIB or minor GUISIB");
      }
    }
  }
  
  public SIB getDefaultContent(final SIB it) {
    SIB _switchResult = null;
    boolean _matched = false;
    if (it instanceof GUISIB) {
      _matched=true;
      _switchResult = ((GUISIB)it).getDefaultContent();
    }
    if (!_matched) {
      if (it instanceof GUIBlueprintSIB) {
        _matched=true;
        _switchResult = ((GUIBlueprintSIB)it).getDefaultContent();
      }
    }
    if (!_matched) {
      if (it instanceof GenericSIB) {
        _matched=true;
        _switchResult = ((GenericSIB)it).getGuiOptions().getDefaultContent();
      }
    }
    return _switchResult;
  }
  
  public void checkMinorGUI(final SIB it) {
    this.checkPlaceholder(it);
    final Function1<SIB, Boolean> _function = new Function1<SIB, Boolean>() {
      @Override
      public Boolean apply(final SIB it) {
        SIB _defaultContent = MajorMinorGUISIBCheck.this.getDefaultContent(it);
        return Boolean.valueOf((_defaultContent == null));
      }
    };
    this.<SIB>check(it, _function).elseWarning("default content has no effect on minor GUISIBs");
    AbstractBranch _majorBranch = this._processExtension.getMajorBranch(it);
    boolean _tripleEquals = (_majorBranch == null);
    if (_tripleEquals) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Major branch not set");
      this.addError(it, _builder.toString());
    }
  }
  
  public void checkPlaceholder(final SIB it) {
    AbstractBranch _majorBranch = this._processExtension.getMajorBranch(it);
    boolean _tripleEquals = (_majorBranch == null);
    if (_tripleEquals) {
      return;
    }
    AbstractBranch _majorBranch_1 = this._processExtension.getMajorBranch(it);
    Node _findSourceOf = null;
    if (_majorBranch_1!=null) {
      _findSourceOf=this._graphModelExtension.<BranchConnector>findSourceOf(_majorBranch_1, BranchConnector.class);
    }
    final Node major = _findSourceOf;
    if ((major instanceof GUISIB)) {
      int _size = IterableExtensions.size(this._graphModelExtension.<Placeholder>find(((GUISIB)major).getGui(), Placeholder.class));
      final int size = _size;
      boolean _matched = false;
      if ((size < 1)) {
        _matched=true;
        this.addError(it, "no placeholder present");
      }
      if (!_matched) {
        if ((size > 1)) {
          _matched=true;
          this.addError(it, "multiple placeholders present");
        }
      }
    } else {
      if ((major instanceof GenericSIB)) {
      } else {
        if ((!(major instanceof GUIBlueprintSIB))) {
          this.addError(it, "only branches of GUISIBs and GUIBlueprintSIBs can be major branches");
        }
      }
    }
  }
}
