/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.checks;

import info.scce.dime.process.mcam.modules.checks.ProcessCheck;
import info.scce.dime.process.process.Branch;
import info.scce.dime.process.process.InputPort;
import info.scce.dime.process.process.IsOfTypeSIB;
import info.scce.dime.process.process.OutputPort;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * The no list check for the is of type sib tests, whether the input parameter and output parameter are both or none lists.
 */
@SuppressWarnings("all")
public class IsOfTypeNoListCheck extends ProcessCheck {
  @Override
  public void check(final info.scce.dime.process.process.Process model) {
    final Consumer<IsOfTypeSIB> _function = new Consumer<IsOfTypeSIB>() {
      @Override
      public void accept(final IsOfTypeSIB it) {
        boolean _isIsList = IterableExtensions.<InputPort>head(it.getInputPorts()).isIsList();
        final Function1<Branch, Boolean> _function = new Function1<Branch, Boolean>() {
          @Override
          public Boolean apply(final Branch it) {
            final Function1<OutputPort, Boolean> _function = new Function1<OutputPort, Boolean>() {
              @Override
              public Boolean apply(final OutputPort it) {
                return Boolean.valueOf(it.isIsList());
              }
            };
            return Boolean.valueOf(IterableExtensions.<OutputPort>exists(it.getOutputPorts(), _function));
          }
        };
        boolean _exists = IterableExtensions.<Branch>exists(it.getBranchSuccessors(), _function);
        boolean _notEquals = (_isIsList != _exists);
        if (_notEquals) {
          IsOfTypeNoListCheck.this.addError(it, "Either both input and output have to be of list type or none.");
        }
      }
    };
    model.getIsOfTypeSIBs().forEach(_function);
  }
}
