/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.checks;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.runtime.xapi.CodingExtension;
import graphmodel.Container;
import graphmodel.Edge;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElementContainer;
import graphmodel.Node;
import info.scce.dime.data.data.Type;
import info.scce.dime.process.mcam.modules.checks.ProcessCheck;
import info.scce.dime.process.process.AbstractBranch;
import info.scce.dime.process.process.BranchConnector;
import info.scce.dime.process.process.ComplexOutputPort;
import info.scce.dime.process.process.EndSIB;
import info.scce.dime.process.process.IO;
import info.scce.dime.process.process.InputPort;
import info.scce.dime.process.process.OutputPort;
import info.scce.dime.process.process.PrimitiveOutputPort;
import info.scce.dime.process.process.PrimitiveType;
import info.scce.dime.process.process.ProcessInputStatic;
import info.scce.dime.process.process.ProcessPlaceholderSIB;
import info.scce.dime.process.process.ProcessSIB;
import info.scce.dime.process.process.ProcessType;
import info.scce.dime.process.process.SIB;
import info.scce.dime.process.process.StartSIB;
import info.scce.dime.process.process.Variable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple2;

/**
 * The extension check is used to validate the signature
 * of the current process model, if it extends another process model.
 */
@SuppressWarnings("all")
public class ExtensionCheck extends ProcessCheck {
  @Extension
  private CodingExtension _codingExtension = new CodingExtension();
  
  @Override
  public void check(final info.scce.dime.process.process.Process it) {
    final Consumer<ProcessSIB> _function = new Consumer<ProcessSIB>() {
      @Override
      public void accept(final ProcessSIB p) {
        ExtensionCheck.this.checkContainer(p);
        final Function1<ProcessInputStatic, ProcessInputStatic> _function = new Function1<ProcessInputStatic, ProcessInputStatic>() {
          @Override
          public ProcessInputStatic apply(final ProcessInputStatic it) {
            return it;
          }
        };
        final Function1<ProcessInputStatic, info.scce.dime.process.process.Process> _function_1 = new Function1<ProcessInputStatic, info.scce.dime.process.process.Process>() {
          @Override
          public info.scce.dime.process.process.Process apply(final ProcessInputStatic v) {
            final Function1<ProcessPlaceholderSIB, Boolean> _function = new Function1<ProcessPlaceholderSIB, Boolean>() {
              @Override
              public Boolean apply(final ProcessPlaceholderSIB it) {
                String _label = it.getLabel();
                String _name = v.getName();
                return Boolean.valueOf(Objects.equal(_label, _name));
              }
            };
            return IterableExtensions.<ProcessPlaceholderSIB>findFirst(p.getProMod().getProcessPlaceholderSIBs(), _function).getProMod();
          }
        };
        final Predicate<Tuple2<ProcessInputStatic, info.scce.dime.process.process.Process>> _function_2 = new Predicate<Tuple2<ProcessInputStatic, info.scce.dime.process.process.Process>>() {
          @Override
          public boolean test(final Tuple2<ProcessInputStatic, info.scce.dime.process.process.Process> it) {
            boolean _xifexpression = false;
            info.scce.dime.process.process.Process _value = it.v1.getValue();
            boolean _equals = ExtensionCheck.this._graphModelExtension.operator_equals(_value, it.v2);
            if (_equals) {
              _xifexpression = false;
            }
            return _xifexpression;
          }
        };
        final Function<Tuple2<ProcessInputStatic, info.scce.dime.process.process.Process>, ProcessInputStatic> _function_3 = new Function<Tuple2<ProcessInputStatic, info.scce.dime.process.process.Process>, ProcessInputStatic>() {
          @Override
          public ProcessInputStatic apply(final Tuple2<ProcessInputStatic, info.scce.dime.process.process.Process> it) {
            return it.v1;
          }
        };
        final Consumer<ProcessInputStatic> _function_4 = new Consumer<ProcessInputStatic>() {
          @Override
          public void accept(final ProcessInputStatic it) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("The chosen process is not an extension of the placeholder process.");
            ExtensionCheck.this.addError(it, _builder.toString());
          }
        };
        ExtensionCheck.this._collectionExtension.<ProcessInputStatic, ProcessInputStatic, info.scce.dime.process.process.Process>mapValue(ExtensionCheck.this._collectionExtension.<ProcessInputStatic, ProcessInputStatic>associateWithKey(p.getProcessInputStatics(), _function), _function_1).filter(_function_2).<ProcessInputStatic>map(_function_3).forEach(_function_4);
      }
    };
    final Consumer<ProcessPlaceholderSIB> _function_1 = new Consumer<ProcessPlaceholderSIB>() {
      @Override
      public void accept(final ProcessPlaceholderSIB it) {
        ProcessType _processType = it.getRootElement().getProcessType();
        boolean _notEquals = (!Objects.equal(_processType, ProcessType.BASIC));
        if (_notEquals) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("Only basic processes support process placeholders.");
          ExtensionCheck.this.addError(it, _builder.toString());
        }
      }
    };
    final Consumer<ProcessPlaceholderSIB> _function_2 = new Consumer<ProcessPlaceholderSIB>() {
      @Override
      public void accept(final ProcessPlaceholderSIB it) {
        int _size = it.getInputs().size();
        boolean _greaterThan = (_size > 16);
        if (_greaterThan) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("Placeholder SIBs may have at most 16 inputs. Found: ");
          int _size_1 = it.getInputs().size();
          _builder.append(_size_1);
          ExtensionCheck.this.addError(it, _builder.toString());
        }
      }
    };
    final Function<ProcessPlaceholderSIB, String> _function_3 = new Function<ProcessPlaceholderSIB, String>() {
      @Override
      public String apply(final ProcessPlaceholderSIB it) {
        return it.getLabel();
      }
    };
    final Function<Tuple2<String, Seq<ProcessPlaceholderSIB>>, Seq<ProcessPlaceholderSIB>> _function_4 = new Function<Tuple2<String, Seq<ProcessPlaceholderSIB>>, Seq<ProcessPlaceholderSIB>>() {
      @Override
      public Seq<ProcessPlaceholderSIB> apply(final Tuple2<String, Seq<ProcessPlaceholderSIB>> it) {
        return it.v2;
      }
    };
    final Predicate<Seq<ProcessPlaceholderSIB>> _function_5 = new Predicate<Seq<ProcessPlaceholderSIB>>() {
      @Override
      public boolean test(final Seq<ProcessPlaceholderSIB> it) {
        int _size = IterableExtensions.size(it);
        return (_size > 1);
      }
    };
    final Predicate<Seq<ProcessPlaceholderSIB>> _function_6 = new Predicate<Seq<ProcessPlaceholderSIB>>() {
      @Override
      public boolean test(final Seq<ProcessPlaceholderSIB> it) {
        final Function<ProcessPlaceholderSIB, info.scce.dime.process.process.Process> _function = new Function<ProcessPlaceholderSIB, info.scce.dime.process.process.Process>() {
          @Override
          public info.scce.dime.process.process.Process apply(final ProcessPlaceholderSIB it) {
            return it.getProMod();
          }
        };
        int _size = it.<info.scce.dime.process.process.Process>map(_function).toSet().size();
        return (_size > 1);
      }
    };
    final Consumer<ProcessPlaceholderSIB> _function_7 = new Consumer<ProcessPlaceholderSIB>() {
      @Override
      public void accept(final ProcessPlaceholderSIB it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Different base process for same placeholder label ");
        String _label = it.getLabel();
        _builder.append(_label);
        _builder.append(".");
        ExtensionCheck.this.addError(it, _builder.toString());
      }
    };
    Iterables.<ProcessPlaceholderSIB>concat(Seq.<ProcessPlaceholderSIB>seq(Iterables.<ProcessPlaceholderSIB>filter(Seq.<ProcessSIB>seq(it.getProcessSIBs()).peek(_function), ProcessPlaceholderSIB.class)).peek(_function_1).peek(_function_2).<String>grouped(_function_3).<Seq<ProcessPlaceholderSIB>>map(_function_4).filter(_function_5).filter(_function_6)).forEach(_function_7);
  }
  
  private void checkNoConnections(final Node it) {
    boolean _noEdges = this.getNoEdges(it);
    boolean _not = (!_noEdges);
    if (_not) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("No edges allowed on extension");
      this.addError(it, _builder.toString());
    }
    if ((it instanceof Container)) {
      final Consumer<Node> _function = new Consumer<Node>() {
        @Override
        public void accept(final Node it) {
          ExtensionCheck.this.checkNoConnections(it);
        }
      };
      Iterables.<Node>filter(((Container)it).getModelElements(), Node.class).forEach(_function);
    }
    if ((it instanceof SIB)) {
      final Consumer<AbstractBranch> _function_1 = new Consumer<AbstractBranch>() {
        @Override
        public void accept(final AbstractBranch it) {
          ExtensionCheck.this.checkNoConnections(it);
        }
      };
      ((SIB)it).getAbstractBranchSuccessors().forEach(_function_1);
    }
  }
  
  private void checkNoSelfExtension(final ProcessSIB it) {
    info.scce.dime.process.process.Process _proMod = it.getProMod();
    info.scce.dime.process.process.Process _rootElement = it.getRootElement();
    boolean _equals = this._graphModelExtension.operator_equals(_proMod, _rootElement);
    if (_equals) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("No self extension allowed");
      this.addError(it, _builder.toString());
    }
  }
  
  private boolean getNoEdges(final Node it) {
    return ((it.<Edge>getIncoming().isEmpty() || IterableExtensions.<Edge>forall(it.<Edge>getIncoming(), new Function1<Edge, Boolean>() {
      @Override
      public Boolean apply(final Edge it) {
        return Boolean.valueOf((it instanceof BranchConnector));
      }
    })) && (it.<Edge>getOutgoing().isEmpty() || IterableExtensions.<Edge>forall(it.<Edge>getOutgoing(), new Function1<Edge, Boolean>() {
      @Override
      public Boolean apply(final Edge it) {
        return Boolean.valueOf((it instanceof BranchConnector));
      }
    })));
  }
  
  private List<Tuple2<InputPort, InputPort>> checkSignature(final ProcessSIB parentProcessSIB) {
    List<Tuple2<InputPort, InputPort>> _xblockexpression = null;
    {
      final info.scce.dime.process.process.Process processModel = parentProcessSIB.getRootElement();
      final info.scce.dime.process.process.Process parentProcess = parentProcessSIB.getProMod();
      StartSIB _head = IterableExtensions.<StartSIB>head(parentProcess.getStartSIBs());
      EList<OutputPort> _outputPorts = null;
      if (_head!=null) {
        _outputPorts=_head.getOutputPorts();
      }
      final Function1<OutputPort, String> _function = new Function1<OutputPort, String>() {
        @Override
        public String apply(final OutputPort it) {
          return it.getName();
        }
      };
      final Map<String, OutputPort> requiredInputs = Seq.<Object, String, OutputPort>toMap(this._collectionExtension.<String, OutputPort>associateWithKey(_outputPorts, _function));
      StartSIB _head_1 = IterableExtensions.<StartSIB>head(processModel.getStartSIBs());
      EList<OutputPort> _outputPorts_1 = null;
      if (_head_1!=null) {
        _outputPorts_1=_head_1.getOutputPorts();
      }
      final EList<OutputPort> presentInputs = _outputPorts_1;
      final Function1<OutputPort, OutputPort> _function_1 = new Function1<OutputPort, OutputPort>() {
        @Override
        public OutputPort apply(final OutputPort it) {
          return requiredInputs.get(it.getName());
        }
      };
      final Predicate<Tuple2<OutputPort, OutputPort>> _function_2 = new Predicate<Tuple2<OutputPort, OutputPort>>() {
        @Override
        public boolean test(final Tuple2<OutputPort, OutputPort> it) {
          boolean _xifexpression = false;
          boolean _equals = ExtensionCheck.this._graphModelExtension.operator_equals(it.v1, null);
          if (_equals) {
            boolean _xblockexpression = false;
            {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("Input \"");
              String _name = it.v2.getName();
              _builder.append(_name);
              _builder.append("\" is not present in the implemented interface.");
              ExtensionCheck.this.addError(it.v2, _builder.toString());
              _xblockexpression = false;
            }
            _xifexpression = _xblockexpression;
          } else {
            _xifexpression = true;
          }
          return _xifexpression;
        }
      };
      final Predicate<Tuple2<OutputPort, OutputPort>> _function_3 = new Predicate<Tuple2<OutputPort, OutputPort>>() {
        @Override
        public boolean test(final Tuple2<OutputPort, OutputPort> it) {
          return ExtensionCheck.this.checkListStateEq(parentProcessSIB, it.v1, it.v2);
        }
      };
      final Predicate<Tuple2<OutputPort, OutputPort>> _function_4 = new Predicate<Tuple2<OutputPort, OutputPort>>() {
        @Override
        public boolean test(final Tuple2<OutputPort, OutputPort> it) {
          return ExtensionCheck.this.checkType(parentProcessSIB, it.v1, it.v2);
        }
      };
      this._collectionExtension.<OutputPort, OutputPort>associateWithKey(presentInputs, _function_1).filter(_function_2).filter(_function_3).filter(_function_4).toList();
      final Function1<EndSIB, String> _function_5 = new Function1<EndSIB, String>() {
        @Override
        public String apply(final EndSIB it) {
          return it.getBranchName();
        }
      };
      final Function1<EndSIB, Map<String, InputPort>> _function_6 = new Function1<EndSIB, Map<String, InputPort>>() {
        @Override
        public Map<String, InputPort> apply(final EndSIB it) {
          final Function1<InputPort, String> _function = new Function1<InputPort, String>() {
            @Override
            public String apply(final InputPort it) {
              return it.getName();
            }
          };
          return Seq.<Object, String, InputPort>toMap(ExtensionCheck.this._collectionExtension.<String, InputPort>associateWithKey(it.getInputPorts(), _function));
        }
      };
      final Map<String, Map<String, InputPort>> requiredOutputs = Seq.<Object, String, Map<String, InputPort>>toMap(this._collectionExtension.<String, EndSIB, Map<String, InputPort>>mapValue(this._collectionExtension.<String, EndSIB>associateWithKey(parentProcess.getEndSIBs(), _function_5), _function_6));
      final Function1<EndSIB, String> _function_7 = new Function1<EndSIB, String>() {
        @Override
        public String apply(final EndSIB it) {
          String _xifexpression = null;
          boolean _containsKey = requiredOutputs.containsKey(it.getBranchName());
          if (_containsKey) {
            _xifexpression = it.getBranchName();
          } else {
            _xifexpression = null;
          }
          return _xifexpression;
        }
      };
      final Predicate<Tuple2<String, EndSIB>> _function_8 = new Predicate<Tuple2<String, EndSIB>>() {
        @Override
        public boolean test(final Tuple2<String, EndSIB> it) {
          boolean _xifexpression = false;
          boolean _equals = Objects.equal(it.v1, null);
          if (_equals) {
            boolean _xblockexpression = false;
            {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("Branch \"");
              String _branchName = it.v2.getBranchName();
              _builder.append(_branchName);
              _builder.append("\" is not present in the implemented interface.");
              ExtensionCheck.this.addError(it.v2, _builder.toString());
              _xblockexpression = false;
            }
            _xifexpression = _xblockexpression;
          } else {
            _xifexpression = true;
          }
          return _xifexpression;
        }
      };
      final Function<Tuple2<String, EndSIB>, EList<InputPort>> _function_9 = new Function<Tuple2<String, EndSIB>, EList<InputPort>>() {
        @Override
        public EList<InputPort> apply(final Tuple2<String, EndSIB> it) {
          return it.v2.getInputPorts();
        }
      };
      final Function1<InputPort, InputPort> _function_10 = new Function1<InputPort, InputPort>() {
        @Override
        public InputPort apply(final InputPort it) {
          ModelElementContainer _container = it.getContainer();
          Map<String, InputPort> _get = requiredOutputs.get(((EndSIB) _container).getBranchName());
          InputPort _get_1 = null;
          if (_get!=null) {
            _get_1=_get.get(it.getName());
          }
          return _get_1;
        }
      };
      final Predicate<Tuple2<InputPort, InputPort>> _function_11 = new Predicate<Tuple2<InputPort, InputPort>>() {
        @Override
        public boolean test(final Tuple2<InputPort, InputPort> it) {
          boolean _xifexpression = false;
          boolean _equals = ExtensionCheck.this._graphModelExtension.operator_equals(it.v1, null);
          if (_equals) {
            boolean _xblockexpression = false;
            {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("Output \"");
              String _name = it.v2.getName();
              _builder.append(_name);
              _builder.append("\" is not present in the implemented interface.");
              ExtensionCheck.this.addError(it.v2, _builder.toString());
              _xblockexpression = false;
            }
            _xifexpression = _xblockexpression;
          } else {
            _xifexpression = true;
          }
          return _xifexpression;
        }
      };
      final Predicate<Tuple2<InputPort, InputPort>> _function_12 = new Predicate<Tuple2<InputPort, InputPort>>() {
        @Override
        public boolean test(final Tuple2<InputPort, InputPort> it) {
          return ExtensionCheck.this.checkListStateEq(parentProcessSIB, it.v1, it.v2);
        }
      };
      final Predicate<Tuple2<InputPort, InputPort>> _function_13 = new Predicate<Tuple2<InputPort, InputPort>>() {
        @Override
        public boolean test(final Tuple2<InputPort, InputPort> it) {
          return ExtensionCheck.this.checkType(parentProcessSIB, it.v1, it.v2);
        }
      };
      _xblockexpression = this._collectionExtension.<InputPort, InputPort>associateWithKey(Iterables.<InputPort>concat(this._collectionExtension.<String, EndSIB>associateWithKey(processModel.getEndSIBs(), _function_7).filter(_function_8).<EList<InputPort>>map(_function_9)), _function_10).filter(_function_11).filter(_function_12).filter(_function_13).toList();
    }
    return _xblockexpression;
  }
  
  private void checkContainer(final ProcessSIB parentProcessSIB) {
    final Function1<AbstractBranch, Boolean> _function = new Function1<AbstractBranch, Boolean>() {
      @Override
      public Boolean apply(final AbstractBranch it) {
        ModelElementContainer _container = it.getContainer();
        ModelElementContainer _container_1 = parentProcessSIB.getContainer();
        return Boolean.valueOf(ExtensionCheck.this._graphModelExtension.operator_notEquals(_container, _container_1));
      }
    };
    final Consumer<AbstractBranch> _function_1 = new Consumer<AbstractBranch>() {
      @Override
      public void accept(final AbstractBranch it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Container of branch ");
        String _name = it.getName();
        _builder.append(_name);
        _builder.append(" is different from its SIBs container");
        ExtensionCheck.this.addError(it, _builder.toString());
      }
    };
    IterableExtensions.<AbstractBranch>filter(parentProcessSIB.getAbstractBranchSuccessors(), _function).forEach(_function_1);
  }
  
  private boolean _checkType(final IdentifiableElement it, final Variable v1, final Variable v2) {
    return false;
  }
  
  private boolean _checkType(final IdentifiableElement it, final ComplexOutputPort v1, final ComplexOutputPort v2) {
    boolean _xifexpression = false;
    Type _dataType = v2.getDataType();
    Type _dataType_1 = v1.getDataType();
    boolean _equals = this._graphModelExtension.operator_equals(_dataType, _dataType_1);
    if (_equals) {
      _xifexpression = true;
    } else {
      boolean _xblockexpression = false;
      {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("The type of overridden input \"");
        String _name = v1.getName();
        _builder.append(_name);
        _builder.append(" is not a sub type of the overriden input\'s type.\"");
        this.addError(it, _builder.toString());
        _xblockexpression = false;
      }
      _xifexpression = _xblockexpression;
    }
    return _xifexpression;
  }
  
  private boolean _checkType(final IdentifiableElement it, final ComplexOutputPort v1, final OutputPort v2) {
    boolean _xblockexpression = false;
    {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Overridden input \"");
      String _name = v1.getName();
      _builder.append(_name);
      _builder.append("\" represents a complex type, but overriding input not.");
      this.addError(it, _builder.toString());
      _xblockexpression = false;
    }
    return _xblockexpression;
  }
  
  private boolean _checkType(final IdentifiableElement it, final OutputPort v1, final ComplexOutputPort v2) {
    boolean _xblockexpression = false;
    {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Overriding input \"");
      String _name = v2.getName();
      _builder.append(_name);
      _builder.append("\" represents a complex type, but overridden input not.");
      this.addError(it, _builder.toString());
      _xblockexpression = false;
    }
    return _xblockexpression;
  }
  
  private boolean _checkType(final IdentifiableElement it, final PrimitiveOutputPort v1, final PrimitiveOutputPort v2) {
    boolean _xblockexpression = false;
    {
      PrimitiveType _dataType = v1.getDataType();
      PrimitiveType _dataType_1 = v2.getDataType();
      boolean _notEquals = (!Objects.equal(_dataType, _dataType_1));
      if (_notEquals) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Overridden input \"");
        String _name = v1.getName();
        _builder.append(_name);
        _builder.append("\" has not same primitive type as overriding input.");
        this.addError(it, _builder.toString());
      }
      _xblockexpression = false;
    }
    return _xblockexpression;
  }
  
  private boolean _checkType(final IdentifiableElement it, final PrimitiveOutputPort v1, final OutputPort v2) {
    boolean _xblockexpression = false;
    {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Overridden input \"");
      String _name = v1.getName();
      _builder.append(_name);
      _builder.append("\" represents a primitive type, but overriding input not.");
      this.addError(it, _builder.toString());
      _xblockexpression = false;
    }
    return _xblockexpression;
  }
  
  private boolean _checkType(final IdentifiableElement it, final OutputPort v1, final PrimitiveOutputPort v2) {
    boolean _xblockexpression = false;
    {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Overriding input \"");
      String _name = v2.getName();
      _builder.append(_name);
      _builder.append("\" represents a primitive type, but overridden input not.");
      this.addError(it, _builder.toString());
      _xblockexpression = false;
    }
    return _xblockexpression;
  }
  
  private boolean _checkListStateEq(final IdentifiableElement it, final InputPort v1, final InputPort v2) {
    boolean _isIsList = v1.isIsList();
    boolean _isIsList_1 = v2.isIsList();
    boolean _notEquals = (_isIsList != _isIsList_1);
    if (_notEquals) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("List type status for overriding input \"");
      String _name = v2.getName();
      _builder.append(_name);
      _builder.append("\" and its overridden input differ.");
      this.addError(it, _builder.toString());
      return false;
    }
    return true;
  }
  
  private boolean _checkListStateEq(final IdentifiableElement it, final OutputPort v1, final OutputPort v2) {
    boolean _isIsList = v1.isIsList();
    boolean _isIsList_1 = v2.isIsList();
    boolean _notEquals = (_isIsList != _isIsList_1);
    if (_notEquals) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("List type status for overriding input \"");
      String _name = v2.getName();
      _builder.append(_name);
      _builder.append("\" and its overridden input differ.");
      this.addError(it, _builder.toString());
      return false;
    }
    return true;
  }
  
  private boolean checkType(final IdentifiableElement it, final Container v1, final Container v2) {
    if (v1 instanceof ComplexOutputPort
         && v2 instanceof ComplexOutputPort) {
      return _checkType(it, (ComplexOutputPort)v1, (ComplexOutputPort)v2);
    } else if (v1 instanceof PrimitiveOutputPort
         && v2 instanceof PrimitiveOutputPort) {
      return _checkType(it, (PrimitiveOutputPort)v1, (PrimitiveOutputPort)v2);
    } else if (v1 instanceof ComplexOutputPort
         && v2 instanceof OutputPort) {
      return _checkType(it, (ComplexOutputPort)v1, (OutputPort)v2);
    } else if (v1 instanceof PrimitiveOutputPort
         && v2 instanceof OutputPort) {
      return _checkType(it, (PrimitiveOutputPort)v1, (OutputPort)v2);
    } else if (v1 instanceof OutputPort
         && v2 instanceof ComplexOutputPort) {
      return _checkType(it, (OutputPort)v1, (ComplexOutputPort)v2);
    } else if (v1 instanceof OutputPort
         && v2 instanceof PrimitiveOutputPort) {
      return _checkType(it, (OutputPort)v1, (PrimitiveOutputPort)v2);
    } else if (v1 instanceof Variable
         && v2 instanceof Variable) {
      return _checkType(it, (Variable)v1, (Variable)v2);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, v1, v2).toString());
    }
  }
  
  private boolean checkListStateEq(final IdentifiableElement it, final IO v1, final IO v2) {
    if (v1 instanceof InputPort
         && v2 instanceof InputPort) {
      return _checkListStateEq(it, (InputPort)v1, (InputPort)v2);
    } else if (v1 instanceof OutputPort
         && v2 instanceof OutputPort) {
      return _checkListStateEq(it, (OutputPort)v1, (OutputPort)v2);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, v1, v2).toString());
    }
  }
}
