/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.checks;

import com.google.common.base.Objects;
import de.jabc.cinco.meta.plugin.mcam.runtime.core.CincoCheckModule;
import graphmodel.Edge;
import graphmodel.Node;
import info.scce.dime.checks.ProcessCheck;
import info.scce.dime.data.data.PrimitiveType;
import info.scce.dime.data.data.Type;
import info.scce.dime.process.process.Attribute;
import info.scce.dime.process.process.ComplexDirectDataFlow;
import info.scce.dime.process.process.ComplexRead;
import info.scce.dime.process.process.ComplexUpdate;
import info.scce.dime.process.process.DataFlow;
import info.scce.dime.process.process.JavaNativeDirectDataFlow;
import info.scce.dime.process.process.JavaNativeRead;
import info.scce.dime.process.process.JavaNativeUpdate;
import info.scce.dime.process.process.PrimitiveDirectDataFlow;
import info.scce.dime.process.process.PrimitiveRead;
import info.scce.dime.process.process.PrimitiveUpdate;
import info.scce.dime.process.process.Variable;
import java.util.function.Consumer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;

@SuppressWarnings("all")
public class DataFlowTypeCheck extends ProcessCheck {
  @Override
  public void check(final info.scce.dime.process.process.Process model) {
    final Consumer<DataFlow> _function = new Consumer<DataFlow>() {
      @Override
      public void accept(final DataFlow it) {
        boolean _matched = false;
        if (it instanceof PrimitiveRead) {
          _matched=true;
        }
        if (!_matched) {
          if (it instanceof PrimitiveUpdate) {
            _matched=true;
          }
        }
        if (!_matched) {
          if (it instanceof PrimitiveDirectDataFlow) {
            _matched=true;
          }
        }
        if (_matched) {
          DataFlowTypeCheck.this.checkPrimitive(it);
        }
        if (!_matched) {
          if (it instanceof ComplexRead) {
            _matched=true;
          }
          if (!_matched) {
            if (it instanceof ComplexUpdate) {
              _matched=true;
            }
          }
          if (!_matched) {
            if (it instanceof ComplexDirectDataFlow) {
              _matched=true;
            }
          }
          if (_matched) {
            DataFlowTypeCheck.this.checkComplex(it);
          }
        }
        if (!_matched) {
          if (it instanceof JavaNativeRead) {
            _matched=true;
          }
          if (!_matched) {
            if (it instanceof JavaNativeUpdate) {
              _matched=true;
            }
          }
          if (!_matched) {
            if (it instanceof JavaNativeDirectDataFlow) {
              _matched=true;
            }
          }
          if (_matched) {
            DataFlowTypeCheck.this.checkNative(it);
          }
        }
        if (!_matched) {
          throw new ProcessCheck.SwitchException();
        }
      }
    };
    this._graphModelExtension.<DataFlow>find(model, DataFlow.class).forEach(_function);
  }
  
  public void checkPrimitive(final Edge it) {
    final PrimitiveType srcType = this._processExtension.getPrimitiveType(it.getSourceElement());
    final PrimitiveType tgtType = this._processExtension.getPrimitiveType(it.getTargetElement());
    final Function1<Edge, Boolean> _function = new Function1<Edge, Boolean>() {
      @Override
      public Boolean apply(final Edge it) {
        return Boolean.valueOf(Objects.equal(srcType, tgtType));
      }
    };
    CincoCheckModule.Check<Edge> _check = this.<Edge>check(it, _function);
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(srcType);
    _builder.append(" != ");
    _builder.append(tgtType);
    _check.elseError(_builder.toString());
    this.checkListState(it);
  }
  
  public void checkComplex(final Edge it) {
    final Type srcType = this._processExtension.getComplexType(it.getSourceElement());
    final Type tgtType = this._processExtension.getComplexType(it.getTargetElement());
    if (((srcType != null) && (tgtType != null))) {
      final Function1<Edge, Boolean> _function = new Function1<Edge, Boolean>() {
        @Override
        public Boolean apply(final Edge it) {
          return Boolean.valueOf(DataFlowTypeCheck.this._dataExtension.isTypeOf(srcType, tgtType));
        }
      };
      CincoCheckModule.Check<Edge> _check = this.<Edge>check(it, _function);
      StringConcatenation _builder = new StringConcatenation();
      String _name = srcType.getName();
      _builder.append(_name);
      _builder.append(" != ");
      String _name_1 = tgtType.getName();
      _builder.append(_name_1);
      _check.elseError(_builder.toString());
    }
    this.checkListState(it);
  }
  
  public void checkNative(final Edge it) {
    final info.scce.dime.siblibrary.Type srcType = this._processExtension.getNativeType(it.getSourceElement());
    final info.scce.dime.siblibrary.Type tgtType = this._processExtension.getNativeType(it.getTargetElement());
    final Function1<Edge, Boolean> _function = new Function1<Edge, Boolean>() {
      @Override
      public Boolean apply(final Edge it) {
        String _name = srcType.getName();
        String _name_1 = tgtType.getName();
        return Boolean.valueOf(Objects.equal(_name, _name_1));
      }
    };
    CincoCheckModule.Check<Edge> _check = this.<Edge>check(it, _function);
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(srcType);
    _builder.append(" != ");
    _builder.append(tgtType);
    _check.elseError(_builder.toString());
    this.checkListState(it);
  }
  
  private void checkListState(final Edge it) {
    final Node source = it.getSourceElement();
    final Node target = it.getTargetElement();
    if (((target instanceof Variable) || (target instanceof Attribute))) {
      final Function1<Edge, Boolean> _function = new Function1<Edge, Boolean>() {
        @Override
        public Boolean apply(final Edge it) {
          return Boolean.valueOf((DataFlowTypeCheck.this._processExtension.isListType(target) || (!DataFlowTypeCheck.this._processExtension.isListType(source))));
        }
      };
      CincoCheckModule.Check<Edge> _check = this.<Edge>check(it, _function);
      String _xifexpression = null;
      boolean _isListType = this._processExtension.isListType(source);
      if (_isListType) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("target should be list");
        _xifexpression = _builder.toString();
      } else {
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("target should not be list");
        _xifexpression = _builder_1.toString();
      }
      _check.elseError(_xifexpression);
    } else {
      final Function1<Edge, Boolean> _function_1 = new Function1<Edge, Boolean>() {
        @Override
        public Boolean apply(final Edge it) {
          boolean _isListType = DataFlowTypeCheck.this._processExtension.isListType(it.getSourceElement());
          boolean _isListType_1 = DataFlowTypeCheck.this._processExtension.isListType(it.getTargetElement());
          return Boolean.valueOf((_isListType == _isListType_1));
        }
      };
      this.<Edge>check(it, _function_1).elseError(
        "source and target should be lists, or none of them");
    }
  }
}
