/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.checks;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import info.scce.dime.process.mcam.modules.checks.ProcessCheck;
import info.scce.dime.process.process.ComplexOutputPort;
import info.scce.dime.process.process.EndSIB;
import info.scce.dime.process.process.InputPort;
import info.scce.dime.process.process.ProcessType;
import info.scce.dime.process.process.StartSIB;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

/**
 * The async interface check tests, whether it is a valid asynchronous process
 * (i.e., has no complex inputs, at most one end sib with branchname "success", and no outputs).
 */
@SuppressWarnings("all")
public class AsyncInterfaceCheck extends ProcessCheck {
  @Override
  public void check(final info.scce.dime.process.process.Process it) {
    ProcessType _processType = it.getProcessType();
    boolean _notEquals = (!Objects.equal(_processType, ProcessType.ASYNCHRONOUS));
    if (_notEquals) {
      return;
    }
    final Function1<StartSIB, EList<ComplexOutputPort>> _function = new Function1<StartSIB, EList<ComplexOutputPort>>() {
      @Override
      public EList<ComplexOutputPort> apply(final StartSIB it) {
        return it.getComplexOutputPorts();
      }
    };
    final Consumer<ComplexOutputPort> _function_1 = new Consumer<ComplexOutputPort>() {
      @Override
      public void accept(final ComplexOutputPort it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Async processes are not allowed to have complex types in their interface.");
        AsyncInterfaceCheck.this.addError(it, _builder.toString());
      }
    };
    Iterables.<ComplexOutputPort>concat(ListExtensions.<StartSIB, EList<ComplexOutputPort>>map(it.getStartSIBs(), _function)).forEach(_function_1);
    int _size = it.getEndSIBs().size();
    boolean _greaterThan = (_size > 1);
    if (_greaterThan) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Async processes are allowed to have at most one end sib.");
      this.addError(it, _builder.toString());
    }
    final Function1<EndSIB, Boolean> _function_2 = new Function1<EndSIB, Boolean>() {
      @Override
      public Boolean apply(final EndSIB it) {
        String _branchName = it.getBranchName();
        return Boolean.valueOf((!Objects.equal(_branchName, "success")));
      }
    };
    final Consumer<EndSIB> _function_3 = new Consumer<EndSIB>() {
      @Override
      public void accept(final EndSIB it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Async processes\' branch has to be named \"success\". Found: ");
        String _branchName = it.getBranchName();
        _builder.append(_branchName);
        AsyncInterfaceCheck.this.addError(it, _builder.toString());
      }
    };
    IterableExtensions.<EndSIB>filter(it.getEndSIBs(), _function_2).forEach(_function_3);
    final Function1<EndSIB, EList<InputPort>> _function_4 = new Function1<EndSIB, EList<InputPort>>() {
      @Override
      public EList<InputPort> apply(final EndSIB it) {
        return it.getInputPorts();
      }
    };
    final Consumer<InputPort> _function_5 = new Consumer<InputPort>() {
      @Override
      public void accept(final InputPort it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Async processes are not allowed to have outputs");
        AsyncInterfaceCheck.this.addError(it, _builder.toString());
      }
    };
    Iterables.<InputPort>concat(ListExtensions.<EndSIB, EList<InputPort>>map(it.getEndSIBs(), _function_4)).forEach(_function_5);
  }
}
