/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.build;

import info.scce.dime.process.build.BranchCreator;
import info.scce.dime.process.process.Branch;
import info.scce.dime.process.process.SIB;

@SuppressWarnings("all")
public class UpdateBranchCreator implements BranchCreator {
  private SIB sib;
  
  private info.scce.dime.process.process.Process model;
  
  protected int marginY = 10;
  
  protected int branchOffsetX = 20;
  
  protected int branchOffsetY = (-20);
  
  public UpdateBranchCreator(final SIB sib) {
    this.sib = sib;
    this.model = sib.getRootElement();
  }
  
  @Override
  public Branch getNewBranch() {
    int _x = this.sib.getX();
    int _width = this.sib.getWidth();
    int _plus = (_x + _width);
    int _plus_1 = (_plus + this.branchOffsetX);
    int _y = this.sib.getY();
    int _plus_2 = (_y + this.branchOffsetY);
    final Branch branch = this.model.newBranch(_plus_1, _plus_2);
    this.sib.newBranchConnector(branch);
    int _branchOffsetY = this.branchOffsetY;
    int _height = branch.getHeight();
    this.branchOffsetY = (_branchOffsetY + _height);
    return branch;
  }
}
