/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.build;

import com.google.common.base.Objects;
import info.scce.dime.process.build.PrimeSIBBuild;
import info.scce.dime.process.process.Branch;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.Output;
import info.scce.dime.process.process.PutToContextSIB;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

@SuppressWarnings("all")
public class PutToContextSIBBuild extends PrimeSIBBuild<PutToContextSIB, Input, String, Input> {
  public static boolean initialize(final PutToContextSIB sib) {
    return new PutToContextSIBBuild(sib).initialize();
  }
  
  public static void update(final PutToContextSIB sib) {
    new PutToContextSIBBuild(sib).update();
  }
  
  public PutToContextSIBBuild(final PutToContextSIB sib) {
    super(sib);
  }
  
  @Override
  public EObject getSIBReference(final PutToContextSIB sib) {
    return sib;
  }
  
  @Override
  public boolean isSIBReferenceValid(final PutToContextSIB sib) {
    boolean _isEmpty = sib.getInputs().isEmpty();
    return (!_isEmpty);
  }
  
  @Override
  public Iterable<Input> getSIBPortReferences(final PutToContextSIB sib) {
    return sib.getInputs();
  }
  
  @Override
  public boolean isSIBPortReference(final Input port, final Input portRef) {
    return this._gUIExtension.operator_equals(port, portRef);
  }
  
  @Override
  public Iterable<String> getBranchReferences(final PutToContextSIB sib) {
    return CollectionLiterals.<String>newArrayList("success");
  }
  
  @Override
  public boolean isBranchReference(final Branch branch, final String staticBranchName) {
    String _name = branch.getName();
    return Objects.equal(_name, staticBranchName);
  }
  
  @Override
  public String getBranchName(final String staticBranchName) {
    return staticBranchName;
  }
  
  @Override
  public Iterable<Input> getBranchPortReferences(final String branchRef) {
    return this.sib.getInputs();
  }
  
  @Override
  public boolean isBranchPortReference(final Output branchPort, final Input sibPort) {
    String _name = branchPort.getName();
    String _name_1 = sibPort.getName();
    return Objects.equal(_name, _name_1);
  }
}
