/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.build;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.runtime.xapi.CollectionExtension;
import graphmodel.ModelElement;
import info.scce.dime.process.build.PrimeSIBBuild;
import info.scce.dime.process.process.Branch;
import info.scce.dime.process.process.EndSIB;
import info.scce.dime.process.process.IgnoreBranch;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.Output;
import info.scce.dime.process.process.ProcessPlaceholderSIB;
import info.scce.dime.process.process.ProcessSIB;
import info.scce.dime.process.process.StartSIB;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class ProcessSIBBuild<T extends ProcessSIB> extends PrimeSIBBuild<T, ModelElement, EndSIB, Input> {
  @Extension
  private CollectionExtension _collectionExtension = new CollectionExtension();
  
  public static boolean initialize(final ProcessSIB sib) {
    return new ProcessSIBBuild<ProcessSIB>(sib).initialize();
  }
  
  public static void update(final ProcessSIB sib) {
    new ProcessSIBBuild<ProcessSIB>(sib).update();
  }
  
  public ProcessSIBBuild(final T sib) {
    super(sib);
  }
  
  @Override
  public EObject getSIBReference(final T sib) {
    return sib.getProMod();
  }
  
  @Override
  public boolean isSIBReferenceValid(final T sib) {
    boolean _hasErrors = this.hasErrors(sib.getProMod());
    return (!_hasErrors);
  }
  
  @Override
  public Iterable<ModelElement> getSIBPortReferences(final T sib) {
    List<ModelElement> _xblockexpression = null;
    {
      final List<ModelElement> references = CollectionLiterals.<ModelElement>newArrayList();
      final StartSIB startSIB = this.getStartSIB(sib.getProMod());
      final Procedure1<List<ModelElement>> _function = new Procedure1<List<ModelElement>>() {
        @Override
        public void apply(final List<ModelElement> it) {
          List<Output> _elvis = null;
          EList<Output> _outputs = null;
          if (startSIB!=null) {
            _outputs=startSIB.getOutputs();
          }
          if (_outputs != null) {
            _elvis = _outputs;
          } else {
            _elvis = Collections.<Output>unmodifiableList(CollectionLiterals.<Output>newArrayList());
          }
          it.addAll(_elvis);
          final Function1<ProcessPlaceholderSIB, String> _function = new Function1<ProcessPlaceholderSIB, String>() {
            @Override
            public String apply(final ProcessPlaceholderSIB it) {
              return it.getLabel();
            }
          };
          Iterables.<ModelElement>addAll(it, ProcessSIBBuild.this._collectionExtension.<ProcessPlaceholderSIB, String>distinctByKey(sib.getProMod().getProcessPlaceholderSIBs(), _function));
        }
      };
      _xblockexpression = ObjectExtensions.<List<ModelElement>>operator_doubleArrow(references, _function);
    }
    return _xblockexpression;
  }
  
  @Override
  public boolean isSIBPortReference(final Input sibPort, final ModelElement element) {
    String _name = sibPort.getName();
    String _switchResult = null;
    boolean _matched = false;
    if (element instanceof Output) {
      _matched=true;
      _switchResult = ((Output)element).getName();
    }
    if (!_matched) {
      if (element instanceof ProcessPlaceholderSIB) {
        _matched=true;
        _switchResult = ((ProcessPlaceholderSIB)element).getLabel();
      }
    }
    return Objects.equal(_name, _switchResult);
  }
  
  @Override
  public String getBranchName(final EndSIB endSib) {
    return endSib.getBranchName();
  }
  
  @Override
  public Iterable<EndSIB> getBranchReferences(final T sib) {
    final Function1<EndSIB, Boolean> _function = new Function1<EndSIB, Boolean>() {
      @Override
      public Boolean apply(final EndSIB b) {
        final Function1<IgnoreBranch, String> _function = new Function1<IgnoreBranch, String>() {
          @Override
          public String apply(final IgnoreBranch it) {
            return it.getName();
          }
        };
        final Function1<String, Boolean> _function_1 = new Function1<String, Boolean>() {
          @Override
          public Boolean apply(final String it) {
            return Boolean.valueOf((it != null));
          }
        };
        final Function1<String, Boolean> _function_2 = new Function1<String, Boolean>() {
          @Override
          public Boolean apply(final String it) {
            return Boolean.valueOf(it.equals(b.getBranchName()));
          }
        };
        String _findFirst = IterableExtensions.<String>findFirst(IterableExtensions.<String>filter(ListExtensions.<IgnoreBranch, String>map(sib.getIgnoredBranch(), _function), _function_1), _function_2);
        return Boolean.valueOf((_findFirst == null));
      }
    };
    return IterableExtensions.<EndSIB>filter(sib.getProMod().getEndSIBs(), _function);
  }
  
  @Override
  public boolean isBranchReference(final Branch branch, final EndSIB endSib) {
    String _name = branch.getName();
    String _branchName = endSib.getBranchName();
    return Objects.equal(_name, _branchName);
  }
  
  @Override
  public Iterable<Input> getBranchPortReferences(final EndSIB endSib) {
    return endSib.getInputs();
  }
  
  @Override
  public boolean isBranchPortReference(final Output branchPort, final Input endSibPort) {
    String _name = branchPort.getName();
    String _name_1 = endSibPort.getName();
    return Objects.equal(_name, _name_1);
  }
}
