/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.build;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.runtime.xapi.ResourceExtension;
import de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension;
import graphmodel.ModelElement;
import info.scce.dime.gui.helper.GUIExtension;
import info.scce.dime.process.build.BranchCreator;
import info.scce.dime.process.build.GuiSIBBuild;
import info.scce.dime.process.build.InitializationBranchCreator;
import info.scce.dime.process.build.UpdateBranchCreator;
import info.scce.dime.process.helper.PortUtils;
import info.scce.dime.process.mcam.adapter.ProcessAdapter;
import info.scce.dime.process.mcam.adapter.ProcessId;
import info.scce.dime.process.mcam.cli.ProcessExecution;
import info.scce.dime.process.process.Branch;
import info.scce.dime.process.process.DataFlow;
import info.scce.dime.process.process.GUISIB;
import info.scce.dime.process.process.IO;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.InputStatic;
import info.scce.dime.process.process.Output;
import info.scce.dime.process.process.OutputPort;
import info.scce.dime.process.process.PrimitiveType;
import info.scce.dime.process.process.SIB;
import info.scce.dime.process.process.StartSIB;
import info.scce.dime.siblibrary.Port;
import info.scce.mcam.framework.processes.CheckProcess;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function2;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure2;

@SuppressWarnings("all")
public abstract class PrimeSIBBuild<SIBType extends SIB, SIBPortRef extends Object, BranchRef extends Object, BranchPortRef extends Object> {
  private final int OFFSET = 30;
  
  @Extension
  protected WorkbenchExtension _workbenchExtension = new WorkbenchExtension();
  
  @Extension
  protected ResourceExtension _resourceExtension = new ResourceExtension();
  
  @Extension
  protected GUIExtension _gUIExtension = new GUIExtension();
  
  @Extension
  protected PortUtils _portUtils = new PortUtils();
  
  protected SIBType sib;
  
  protected SIB cSib;
  
  protected info.scce.dime.process.process.Process cModel;
  
  protected BranchCreator branchCreator;
  
  public static <S extends SIB> PrimeSIBBuild getBuild(final S sib) {
    PrimeSIBBuild _switchResult = null;
    boolean _matched = false;
    if (sib instanceof GUISIB) {
      _matched=true;
      GuiSIBBuild _guiSIBBuild = new GuiSIBBuild(((GUISIB)sib));
      _switchResult = ((PrimeSIBBuild) _guiSIBBuild);
    }
    return _switchResult;
  }
  
  public PrimeSIBBuild(final SIBType sib) {
    this.sib = sib;
  }
  
  public abstract EObject getSIBReference(final SIBType sib);
  
  public abstract boolean isSIBReferenceValid(final SIBType sib);
  
  public abstract Iterable<SIBPortRef> getSIBPortReferences(final SIBType sib);
  
  public abstract boolean isSIBPortReference(final Input port, final SIBPortRef portRef);
  
  public abstract Iterable<BranchRef> getBranchReferences(final SIBType sib);
  
  public abstract boolean isBranchReference(final Branch branch, final BranchRef branchRef);
  
  public abstract String getBranchName(final BranchRef branchRef);
  
  public abstract Iterable<BranchPortRef> getBranchPortReferences(final BranchRef branchRef);
  
  public abstract boolean isBranchPortReference(final Output branchPort, final BranchPortRef portRef);
  
  public boolean initialize() {
    boolean _xblockexpression = false;
    {
      boolean _initializeInternal = this.initializeInternal();
      if (_initializeInternal) {
        this.initializeSIBInternal();
        this.initializeBranchesInternal();
        return true;
      }
      _xblockexpression = false;
    }
    return _xblockexpression;
  }
  
  public boolean initializeSIB() {
    boolean _xblockexpression = false;
    {
      boolean _initializeInternal = this.initializeInternal();
      if (_initializeInternal) {
        this.initializeSIBInternal();
        return true;
      }
      _xblockexpression = false;
    }
    return _xblockexpression;
  }
  
  private boolean initializeInternal() {
    this.cModel = this.sib.getRootElement();
    this.cSib = this.sib;
    InitializationBranchCreator _initializationBranchCreator = new InitializationBranchCreator(this.cSib);
    this.branchCreator = _initializationBranchCreator;
    EObject _sIBReference = this.getSIBReference(this.sib);
    boolean _equals = Objects.equal(_sIBReference, null);
    if (_equals) {
      this.letUserKnow("Reference is null", "Initialization failed. Reference not found!");
      this.cSib.delete();
      return false;
    }
    return true;
  }
  
  public void update() {
    this.cModel = this.sib.getRootElement();
    this.cSib = this.sib;
    UpdateBranchCreator _updateBranchCreator = new UpdateBranchCreator(this.cSib);
    this.branchCreator = _updateBranchCreator;
    EObject _sIBReference = this.getSIBReference(this.sib);
    boolean _equals = Objects.equal(_sIBReference, null);
    if (_equals) {
      this.letUserKnow("Reference is null", "Update failed. Reference not found!");
      return;
    }
    this.updateSIB();
    this.updateBranches();
  }
  
  private void initializeSIBInternal() {
    PortUtils.Sync<Input, SIBPortRef> _sync = new PortUtils.Sync<Input, SIBPortRef>();
    final Procedure1<PortUtils.Sync<Input, SIBPortRef>> _function = new Procedure1<PortUtils.Sync<Input, SIBPortRef>>() {
      @Override
      public void apply(final PortUtils.Sync<Input, SIBPortRef> it) {
        final Procedure1<SIBPortRef> _function = new Procedure1<SIBPortRef>() {
          @Override
          public void apply(final SIBPortRef ref) {
            PrimeSIBBuild.this.addInput(ref);
          }
        };
        it.add = _function;
      }
    };
    final PortUtils.Sync<Input, SIBPortRef> sync = ObjectExtensions.<PortUtils.Sync<Input, SIBPortRef>>operator_doubleArrow(_sync, _function);
    sync.apply(this.sib.getInputs(), this.getSIBPortReferences(this.sib));
  }
  
  public void updateSIB() {
    PortUtils.Sync<Input, SIBPortRef> _sync = new PortUtils.Sync<Input, SIBPortRef>();
    final Procedure1<PortUtils.Sync<Input, SIBPortRef>> _function = new Procedure1<PortUtils.Sync<Input, SIBPortRef>>() {
      @Override
      public void apply(final PortUtils.Sync<Input, SIBPortRef> it) {
        final Function2<Input, SIBPortRef, Boolean> _function = new Function2<Input, SIBPortRef, Boolean>() {
          @Override
          public Boolean apply(final Input input, final SIBPortRef ref) {
            return Boolean.valueOf(PrimeSIBBuild.this.isSIBPortReference(input, ref));
          }
        };
        it.equals = _function;
        final Procedure1<SIBPortRef> _function_1 = new Procedure1<SIBPortRef>() {
          @Override
          public void apply(final SIBPortRef ref) {
            PrimeSIBBuild.this.addInput(ref);
          }
        };
        it.add = _function_1;
        final Procedure2<Input, SIBPortRef> _function_2 = new Procedure2<Input, SIBPortRef>() {
          @Override
          public void apply(final Input input, final SIBPortRef ref) {
            PrimeSIBBuild.this.updateInput(input, ref);
          }
        };
        it.update = _function_2;
        final Procedure1<Input> _function_3 = new Procedure1<Input>() {
          @Override
          public void apply(final Input input) {
            input.delete();
          }
        };
        it.delete = _function_3;
      }
    };
    final PortUtils.Sync<Input, SIBPortRef> sync = ObjectExtensions.<PortUtils.Sync<Input, SIBPortRef>>operator_doubleArrow(_sync, _function);
    sync.apply(this.sib.getInputs(), this.getSIBPortReferences(this.sib));
  }
  
  public void addInput(final SIBPortRef ref) {
    IO _addInput = PortUtils.addInput(this.cSib, ref);
    if (_addInput!=null) {
      this.postProcessNewSIBPort(_addInput, ref);
    }
  }
  
  public void updateInput(final Input input, final SIBPortRef ref) {
    this.update(input, ref);
    this.postProcessUpdateSIBPort(input, ref);
  }
  
  protected void _update(final Input sibPort, final Object ref) {
    final Input cInput = sibPort;
    final IO cInputNew = PortUtils.addInput(this.cSib, ref);
    ArrayList<? extends DataFlow> _newList = this.toNewList(cInput.getIncoming());
    for (final DataFlow cEdge : _newList) {
      cEdge.reconnectTarget(cInputNew);
    }
    cInput.delete();
    EcoreUtil.setID(cInputNew, sibPort.getId());
  }
  
  protected void _update(final InputStatic input, final Object ref) {
    Class<? extends InputStatic> _switchResult = null;
    final Object it = ref;
    boolean _matched = false;
    if (it instanceof ModelElement) {
      _matched=true;
      PrimitiveType _primitiveType = PortUtils.getPrimitiveType(((ModelElement)it));
      Class<? extends InputStatic> _staticInputType = null;
      if (_primitiveType!=null) {
        _staticInputType=PortUtils.toStaticInputType(_primitiveType);
      }
      _switchResult = _staticInputType;
    }
    if (!_matched) {
      if (it instanceof Port) {
        _matched=true;
        PrimitiveType _primitiveType = PortUtils.getPrimitiveType(((Port)it));
        Class<? extends InputStatic> _staticInputType = null;
        if (_primitiveType!=null) {
          _staticInputType=PortUtils.toStaticInputType(_primitiveType);
        }
        _switchResult = _staticInputType;
      }
    }
    final Class<? extends InputStatic> staticInputType = _switchResult;
    boolean _isInstance = false;
    if (staticInputType!=null) {
      _isInstance=staticInputType.isInstance(input);
    }
    if (_isInstance) {
      final InputStatic inputClone = PortUtils.cloneStaticPort(this.cSib, input);
      EcoreUtil.setID(inputClone, input.getId());
    } else {
      PortUtils.addInput(this.cSib, ref);
    }
    input.delete();
  }
  
  public void postProcessNewSIBPort(final IO port, final Object ref) {
  }
  
  public void postProcessUpdateSIBPort(final IO port, final Object ref) {
  }
  
  void initializeBranchesInternal() {
    PortUtils.Sync<Branch, BranchRef> _sync = new PortUtils.Sync<Branch, BranchRef>();
    final Procedure1<PortUtils.Sync<Branch, BranchRef>> _function = new Procedure1<PortUtils.Sync<Branch, BranchRef>>() {
      @Override
      public void apply(final PortUtils.Sync<Branch, BranchRef> it) {
        final Procedure1<BranchRef> _function = new Procedure1<BranchRef>() {
          @Override
          public void apply(final BranchRef ref) {
            PrimeSIBBuild.this.addAndUpdateBranch(ref);
          }
        };
        it.add = _function;
      }
    };
    final PortUtils.Sync<Branch, BranchRef> sync = ObjectExtensions.<PortUtils.Sync<Branch, BranchRef>>operator_doubleArrow(_sync, _function);
    sync.apply(this.sib.<Branch>getSuccessors(Branch.class), this.getBranchReferences(this.sib));
  }
  
  public void updateBranches() {
    PortUtils.Sync<Branch, BranchRef> _sync = new PortUtils.Sync<Branch, BranchRef>();
    final Procedure1<PortUtils.Sync<Branch, BranchRef>> _function = new Procedure1<PortUtils.Sync<Branch, BranchRef>>() {
      @Override
      public void apply(final PortUtils.Sync<Branch, BranchRef> it) {
        final Function2<Branch, BranchRef, Boolean> _function = new Function2<Branch, BranchRef, Boolean>() {
          @Override
          public Boolean apply(final Branch branch, final BranchRef ref) {
            return Boolean.valueOf(PrimeSIBBuild.this.isBranchReference(branch, ref));
          }
        };
        it.equals = _function;
        final Procedure1<BranchRef> _function_1 = new Procedure1<BranchRef>() {
          @Override
          public void apply(final BranchRef ref) {
            PrimeSIBBuild.this.addAndUpdateBranch(ref);
          }
        };
        it.add = _function_1;
        final Procedure2<Branch, BranchRef> _function_2 = new Procedure2<Branch, BranchRef>() {
          @Override
          public void apply(final Branch branch, final BranchRef ref) {
            PrimeSIBBuild.this.update(branch, ref);
          }
        };
        it.update = _function_2;
        final Procedure1<Branch> _function_3 = new Procedure1<Branch>() {
          @Override
          public void apply(final Branch branch) {
            branch.delete();
          }
        };
        it.delete = _function_3;
      }
    };
    final PortUtils.Sync<Branch, BranchRef> sync = ObjectExtensions.<PortUtils.Sync<Branch, BranchRef>>operator_doubleArrow(_sync, _function);
    sync.apply(this.sib.<Branch>getSuccessors(Branch.class), this.getBranchReferences(this.sib));
  }
  
  public void addAndUpdateBranch(final BranchRef ref) {
    this.update(this.addBranch(this.getBranchName(ref)), ref);
  }
  
  public Branch addBranch(final String branchName) {
    final Branch newBranch = this.branchCreator.getNewBranch();
    newBranch.setName(branchName);
    return ((Branch) newBranch);
  }
  
  public void update(final Branch branch, final BranchRef branchRef) {
    PortUtils.Sync<Output, BranchPortRef> _sync = new PortUtils.Sync<Output, BranchPortRef>();
    final Procedure1<PortUtils.Sync<Output, BranchPortRef>> _function = new Procedure1<PortUtils.Sync<Output, BranchPortRef>>() {
      @Override
      public void apply(final PortUtils.Sync<Output, BranchPortRef> it) {
        final Function2<Output, BranchPortRef, Boolean> _function = new Function2<Output, BranchPortRef, Boolean>() {
          @Override
          public Boolean apply(final Output port, final BranchPortRef ref) {
            return Boolean.valueOf(PrimeSIBBuild.this.isBranchPortReference(port, ref));
          }
        };
        it.equals = _function;
        final Procedure1<BranchPortRef> _function_1 = new Procedure1<BranchPortRef>() {
          @Override
          public void apply(final BranchPortRef ref) {
            PrimeSIBBuild.this.addOutputPort(branch, ref);
          }
        };
        it.add = _function_1;
        final Procedure2<Output, BranchPortRef> _function_2 = new Procedure2<Output, BranchPortRef>() {
          @Override
          public void apply(final Output port, final BranchPortRef ref) {
            PrimeSIBBuild.this.update(port, ref, branch);
          }
        };
        it.update = _function_2;
        final Procedure1<Output> _function_3 = new Procedure1<Output>() {
          @Override
          public void apply(final Output port) {
            port.delete();
          }
        };
        it.delete = _function_3;
      }
    };
    final PortUtils.Sync<Output, BranchPortRef> sync = ObjectExtensions.<PortUtils.Sync<Output, BranchPortRef>>operator_doubleArrow(_sync, _function);
    sync.apply(branch.getOutputs(), this.getBranchPortReferences(branchRef));
  }
  
  public OutputPort addOutputPort(final Branch branch, final BranchPortRef ref) {
    return this._portUtils.addOutput(branch, ref);
  }
  
  public void update(final Output branchPort, final Object portRef, final Branch branch) {
    final Output cOutput = branchPort;
    final OutputPort cOutputNew = this._portUtils.addOutput(branch, portRef);
    ArrayList<? extends DataFlow> _newList = this.toNewList(cOutput.getOutgoing());
    for (final DataFlow cEdge : _newList) {
      PortUtils.reconnect(((DataFlow) cEdge), cOutputNew, null);
    }
    cOutput.delete();
    EcoreUtil.setID(cOutputNew, branchPort.getId());
  }
  
  public void delete(final Input input) {
    if (input!=null) {
      input.delete();
    }
  }
  
  public void delete(final Branch branch) {
    if (branch!=null) {
      branch.delete();
    }
  }
  
  public void delete(final Output output) {
    if (output!=null) {
      output.delete();
    }
  }
  
  public boolean hasErrors(final info.scce.dime.process.process.Process model) {
    final File file = this._resourceExtension.getFile(model.eResource()).getRawLocation().toFile();
    final ProcessExecution fe = new ProcessExecution();
    final ProcessAdapter adapter = fe.initApiAdapter(file);
    final CheckProcess<ProcessId, ProcessAdapter> check = fe.executeCheckPhase(adapter);
    if ((check.hasErrors() || check.hasWarnings())) {
      InputOutput.<CheckProcess<ProcessId, ProcessAdapter>>println(check);
    }
    return check.hasErrors();
  }
  
  public void letUserKnow(final String title, final String msg) {
    this._workbenchExtension.showInfoDialog(title, msg);
  }
  
  public boolean letUserConfirm(final String title, final String msg) {
    return this._workbenchExtension.showConfirmDialog(title, msg);
  }
  
  public <X extends Object> ArrayList<X> toNewList(final Iterable<X> list) {
    final ArrayList<X> newList = CollectionLiterals.<X>newArrayList();
    boolean _notEquals = (!Objects.equal(list, null));
    if (_notEquals) {
      Iterables.<X>addAll(newList, list);
    }
    return newList;
  }
  
  public StartSIB getStartSIB(final info.scce.dime.process.process.Process process) {
    StartSIB _xblockexpression = null;
    {
      boolean _isEmpty = process.getStartSIBs().isEmpty();
      if (_isEmpty) {
        this.showError("Referenced process model does not contain a Start SIB");
        return null;
      }
      int _size = process.getStartSIBs().size();
      boolean _greaterThan = (_size > 1);
      if (_greaterThan) {
        this.showError("Referenced process model contains multiple Start SIBs");
      }
      _xblockexpression = IterableExtensions.<StartSIB>head(process.getStartSIBs());
    }
    return _xblockexpression;
  }
  
  public void showError(final String message) {
    this._workbenchExtension.showErrorDialog("Operation canceled", message);
  }
  
  public void update(final Input input, final Object ref) {
    if (input instanceof InputStatic) {
      _update((InputStatic)input, ref);
      return;
    } else if (input != null) {
      _update(input, ref);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(input, ref).toString());
    }
  }
}
