/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.build;

import com.google.common.base.Objects;
import info.scce.dime.process.build.PrimeSIBBuild;
import info.scce.dime.process.process.Branch;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.InputPort;
import info.scce.dime.process.process.NativeFrontendBranch;
import info.scce.dime.process.process.NativeFrontendSIBReference;
import info.scce.dime.process.process.Output;
import info.scce.dime.process.process.OutputPort;
import org.eclipse.emf.ecore.EObject;

@SuppressWarnings("all")
public class NativeFrontendSIBReferenceBuild extends PrimeSIBBuild<NativeFrontendSIBReference, InputPort, NativeFrontendBranch, OutputPort> {
  public NativeFrontendSIBReferenceBuild(final NativeFrontendSIBReference sib) {
    super(sib);
  }
  
  @Override
  public EObject getSIBReference(final NativeFrontendSIBReference sib) {
    return sib.getReferencedSib();
  }
  
  @Override
  public boolean isSIBReferenceValid(final NativeFrontendSIBReference sib) {
    return true;
  }
  
  @Override
  public Iterable<InputPort> getSIBPortReferences(final NativeFrontendSIBReference sib) {
    return sib.getReferencedSib().getInputPorts();
  }
  
  @Override
  public boolean isSIBPortReference(final Input port, final InputPort portRef) {
    String _name = port.getName();
    String _name_1 = portRef.getName();
    return Objects.equal(_name, _name_1);
  }
  
  @Override
  public Iterable<NativeFrontendBranch> getBranchReferences(final NativeFrontendSIBReference sib) {
    return sib.getReferencedSib().getNativeFrontendBranchSuccessors();
  }
  
  @Override
  public boolean isBranchReference(final Branch branch, final NativeFrontendBranch branchRef) {
    String _name = branch.getName();
    String _name_1 = branchRef.getName();
    return Objects.equal(_name, _name_1);
  }
  
  @Override
  public String getBranchName(final NativeFrontendBranch branchRef) {
    return branchRef.getName();
  }
  
  @Override
  public Iterable<OutputPort> getBranchPortReferences(final NativeFrontendBranch branchRef) {
    return branchRef.getOutputPorts();
  }
  
  @Override
  public boolean isBranchPortReference(final Output branchPort, final OutputPort portRef) {
    String _name = branchPort.getName();
    String _name_1 = portRef.getName();
    return Objects.equal(_name, _name_1);
  }
  
  public static boolean initialize(final NativeFrontendSIBReference sib) {
    return new NativeFrontendSIBReferenceBuild(sib).initialize();
  }
  
  public static void update(final NativeFrontendSIBReference sib) {
    new NativeFrontendSIBReferenceBuild(sib).update();
  }
}
