/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.build;

import com.google.common.base.Objects;
import info.scce.dime.dad.dad.ProcessComponent;
import info.scce.dime.dad.dad.ProcessEntryPointComponent;
import info.scce.dime.dad.dad.URLProcess;
import info.scce.dime.process.build.InitializationBranchCreator;
import info.scce.dime.process.build.PrimeSIBBuild;
import info.scce.dime.process.build.UpdateBranchCreator;
import info.scce.dime.process.process.Branch;
import info.scce.dime.process.process.EndSIB;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.LinkProcessSIB;
import info.scce.dime.process.process.Output;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

@SuppressWarnings("all")
public class LinkProcessSIBBuild extends PrimeSIBBuild<LinkProcessSIB, Output, EndSIB, Input> {
  public static boolean initialize(final LinkProcessSIB sib) {
    return new LinkProcessSIBBuild(sib).initialize();
  }
  
  public static void update(final LinkProcessSIB sib) {
    new LinkProcessSIBBuild(sib).update();
  }
  
  public LinkProcessSIBBuild(final LinkProcessSIB sib) {
    super(sib);
  }
  
  @Override
  public EObject getSIBReference(final LinkProcessSIB sib) {
    return sib.getProMod();
  }
  
  @Override
  public boolean isSIBReferenceValid(final LinkProcessSIB sib) {
    boolean _xblockexpression = false;
    {
      URLProcess _proMod = sib.getProMod();
      if ((_proMod instanceof URLProcess)) {
        URLProcess _proMod_1 = sib.getProMod();
        final URLProcess url = ((URLProcess) _proMod_1);
        if ((url instanceof ProcessComponent)) {
          boolean _hasErrors = this.hasErrors(((ProcessComponent)url).getModel());
          return (!_hasErrors);
        }
        if ((url instanceof ProcessEntryPointComponent)) {
          boolean _hasErrors_1 = this.hasErrors(((ProcessEntryPointComponent)url).getEntryPoint().getProMod());
          return (!_hasErrors_1);
        }
      }
      _xblockexpression = false;
    }
    return _xblockexpression;
  }
  
  @Override
  public Iterable<Output> getSIBPortReferences(final LinkProcessSIB sib) {
    URLProcess _proMod = sib.getProMod();
    if ((_proMod instanceof URLProcess)) {
      URLProcess _proMod_1 = sib.getProMod();
      final URLProcess url = ((URLProcess) _proMod_1);
      if ((url instanceof ProcessComponent)) {
        return this.getStartSIB(((ProcessComponent)url).getModel()).getOutputs();
      }
      if ((url instanceof ProcessEntryPointComponent)) {
        return this.getStartSIB(((ProcessEntryPointComponent)url).getEntryPoint().getProMod()).getOutputs();
      }
    }
    return Collections.<Output>unmodifiableList(CollectionLiterals.<Output>newArrayList());
  }
  
  @Override
  public boolean isSIBPortReference(final Input sibPort, final Output output) {
    String _name = sibPort.getName();
    String _name_1 = output.getName();
    return Objects.equal(_name, _name_1);
  }
  
  @Override
  public Iterable<EndSIB> getBranchReferences(final LinkProcessSIB sib) {
    return Collections.EMPTY_LIST;
  }
  
  @Override
  public boolean isBranchReference(final Branch branch, final EndSIB endSib) {
    return false;
  }
  
  @Override
  public String getBranchName(final EndSIB endSib) {
    return null;
  }
  
  @Override
  public Iterable<Input> getBranchPortReferences(final EndSIB endSib) {
    return Collections.EMPTY_LIST;
  }
  
  @Override
  public boolean isBranchPortReference(final Output branchPort, final Input endSibPort) {
    return false;
  }
  
  @Override
  public boolean initialize() {
    boolean _xblockexpression = false;
    {
      boolean _initialize = super.initialize();
      if (_initialize) {
        InitializationBranchCreator _initializationBranchCreator = new InitializationBranchCreator(this.cSib);
        this.branchCreator = _initializationBranchCreator;
        return true;
      }
      _xblockexpression = false;
    }
    return _xblockexpression;
  }
  
  @Override
  public void update() {
    super.update();
    UpdateBranchCreator _updateBranchCreator = new UpdateBranchCreator(this.cSib);
    this.branchCreator = _updateBranchCreator;
  }
  
  @Override
  void initializeBranchesInternal() {
    InitializationBranchCreator _initializationBranchCreator = new InitializationBranchCreator(this.cSib);
    this.branchCreator = _initializationBranchCreator;
    super.initializeBranchesInternal();
  }
  
  @Override
  public void updateBranches() {
  }
}
