/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.build;

import info.scce.dime.process.build.BranchCreator;
import info.scce.dime.process.helper.LayoutConstants;
import info.scce.dime.process.process.Branch;
import info.scce.dime.process.process.BranchConnector;
import info.scce.dime.process.process.SIB;
import info.scce.dime.process.process.internal.InternalBranch;
import org.eclipse.emf.common.util.EList;

@SuppressWarnings("all")
public class InitializationBranchCreator implements BranchCreator {
  private SIB sib;
  
  private info.scce.dime.process.process.Process model;
  
  private int branchX;
  
  public InitializationBranchCreator(final SIB sib) {
    this.sib = sib;
    this.model = sib.getRootElement();
    this.branchX = this.calcBranchX();
  }
  
  @Override
  public Branch getNewBranch() {
    final EList<Branch> branches = this.sib.getBranchSuccessors();
    final int numBranches = branches.size();
    if ((numBranches < LayoutConstants.BRANCH_THRESHOLD)) {
      for (final Branch branch : branches) {
        InternalBranch _internalBranch = branch.getInternalBranch();
        int _x = branch.getX();
        int _minus = (_x - (LayoutConstants.BRANCH_WIDTH / 2));
        int _minus_1 = (_minus - (LayoutConstants.BRANCH_H_SPACE / 2));
        _internalBranch.setX(_minus_1);
      }
    }
    final Branch branch_1 = this.model.newBranch(this.branchX, this.calcBranchY());
    branch_1.resize(LayoutConstants.BRANCH_WIDTH, branch_1.getHeight());
    final BranchConnector connector = this.sib.newBranchConnector(branch_1);
    if ((numBranches >= LayoutConstants.BRANCH_THRESHOLD)) {
      int _x_1 = branch_1.getX();
      int _width = branch_1.getWidth();
      int _divide = (_width / 2);
      int _plus = (_x_1 + _divide);
      int _y = this.sib.getY();
      int _height = this.sib.getHeight();
      int _divide_1 = (_height / 2);
      int _plus_1 = (_y + _divide_1);
      connector.addBendpoint(_plus, _plus_1);
    }
    if (((numBranches + 1) < LayoutConstants.BRANCH_THRESHOLD)) {
      int _branchX = this.branchX;
      this.branchX = (_branchX + ((LayoutConstants.BRANCH_WIDTH / 2) + (LayoutConstants.BRANCH_H_SPACE / 2)));
    } else {
      int _branchX_1 = this.branchX;
      this.branchX = (_branchX_1 + (LayoutConstants.BRANCH_WIDTH + LayoutConstants.BRANCH_H_SPACE));
    }
    return branch_1;
  }
  
  public int calcBranchX() {
    int _x = this.sib.getX();
    int _plus = (_x + (LayoutConstants.SIB_WIDTH / 2));
    return (_plus - (LayoutConstants.BRANCH_WIDTH / 2));
  }
  
  public int calcBranchY() {
    int _y = this.sib.getY();
    int _height = this.sib.getHeight();
    int _plus = (_y + _height);
    return (_plus + LayoutConstants.BRANCH_V_DISTANCE);
  }
}
