/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.build;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.utils.messages.CincoMessageHandler;
import graphmodel.ModelElement;
import info.scce.dime.data.helper.DataExtension;
import info.scce.dime.gui.gui.ComplexOutputPort;
import info.scce.dime.gui.gui.DataContext;
import info.scce.dime.gui.gui.Event;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.gui.gui.ListenerContext;
import info.scce.dime.gui.gui.OutputPort;
import info.scce.dime.gui.gui.PrimitiveAttribute;
import info.scce.dime.gui.gui.PrimitiveOutputPort;
import info.scce.dime.gui.gui.Variable;
import info.scce.dime.gui.helper.GUIBranch;
import info.scce.dime.gui.helper.GUIBranchPort;
import info.scce.dime.gui.helper.GUIExtension;
import info.scce.dime.gui.mcam.adapter.GUIAdapter;
import info.scce.dime.gui.mcam.adapter.GUIId;
import info.scce.dime.gui.mcam.cli.GUIExecution;
import info.scce.dime.process.build.PrimeSIBBuild;
import info.scce.dime.process.process.Branch;
import info.scce.dime.process.process.ComplexAttributeConnector;
import info.scce.dime.process.process.ComplexInputPort;
import info.scce.dime.process.process.ComplexListAttributeConnector;
import info.scce.dime.process.process.EventListener;
import info.scce.dime.process.process.GUISIB;
import info.scce.dime.process.process.IgnoreBranch;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.Output;
import info.scce.dime.process.process.PrimitiveInputPort;
import info.scce.mcam.framework.processes.CheckProcess;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class GuiSIBBuild extends PrimeSIBBuild<GUISIB, ModelElement, GUIBranch, GUIBranchPort> {
  @Extension
  protected GUIExtension _gUIExtension = new GUIExtension();
  
  @Extension
  protected DataExtension _dataExtension = DataExtension.getInstance();
  
  public static boolean initialize(final GUISIB sib) {
    return new GuiSIBBuild(sib).initialize();
  }
  
  public static void update(final GUISIB sib) {
    new GuiSIBBuild(sib).update();
  }
  
  public GuiSIBBuild(final GUISIB sib) {
    super(sib);
  }
  
  @Override
  public EObject getSIBReference(final GUISIB sib) {
    return sib.getGui();
  }
  
  @Override
  public boolean isSIBReferenceValid(final GUISIB sib) {
    boolean _hasErrors = this.hasErrors(sib.getGui());
    return (!_hasErrors);
  }
  
  @Override
  public Iterable<ModelElement> getSIBPortReferences(final GUISIB sib) {
    final List<ModelElement> refs = CollectionLiterals.<ModelElement>newArrayList();
    final Function1<DataContext, EList<Variable>> _function = new Function1<DataContext, EList<Variable>>() {
      @Override
      public EList<Variable> apply(final DataContext it) {
        return it.getVariables();
      }
    };
    final Function1<Variable, Boolean> _function_1 = new Function1<Variable, Boolean>() {
      @Override
      public Boolean apply(final Variable it) {
        return Boolean.valueOf(it.isIsInput());
      }
    };
    final Function1<Variable, Boolean> _function_2 = new Function1<Variable, Boolean>() {
      @Override
      public Boolean apply(final Variable it) {
        return Boolean.valueOf(it.<ComplexAttributeConnector>getIncoming(ComplexAttributeConnector.class).isEmpty());
      }
    };
    final Function1<Variable, Boolean> _function_3 = new Function1<Variable, Boolean>() {
      @Override
      public Boolean apply(final Variable it) {
        return Boolean.valueOf(it.<ComplexListAttributeConnector>getIncoming(ComplexListAttributeConnector.class).isEmpty());
      }
    };
    Iterables.<ModelElement>addAll(refs, 
      IterableExtensions.<Variable>filter(IterableExtensions.<Variable>filter(IterableExtensions.<Variable>filter(Iterables.<Variable>concat(ListExtensions.<DataContext, EList<Variable>>map(sib.getGui().getDataContexts(), _function)), _function_1), _function_2), _function_3));
    return refs;
  }
  
  @Override
  public boolean isSIBPortReference(final Input port, final ModelElement portRef) {
    String _name = port.getName();
    String _switchResult = null;
    boolean _matched = false;
    if (portRef instanceof Input) {
      _matched=true;
      _switchResult = ((Input)portRef).getName();
    }
    if (!_matched) {
      if (portRef instanceof Output) {
        _matched=true;
        _switchResult = ((Output)portRef).getName();
      }
    }
    if (!_matched) {
      if (portRef instanceof Variable) {
        _matched=true;
        _switchResult = ((Variable)portRef).getName();
      }
    }
    if (!_matched) {
      if (portRef instanceof PrimitiveAttribute) {
        _matched=true;
        _switchResult = ((PrimitiveAttribute)portRef).getAttribute().getName();
      }
    }
    return Objects.equal(_name, _switchResult);
  }
  
  @Override
  public Iterable<GUIBranch> getBranchReferences(final GUISIB sib) {
    final Collection<GUIBranch> gbm = this._gUIExtension.getGUIBranchesMerged(sib.getGui());
    final Function1<GUIBranch, Boolean> _function = new Function1<GUIBranch, Boolean>() {
      @Override
      public Boolean apply(final GUIBranch b) {
        final Function1<IgnoreBranch, String> _function = new Function1<IgnoreBranch, String>() {
          @Override
          public String apply(final IgnoreBranch it) {
            return it.getName();
          }
        };
        final Function1<String, Boolean> _function_1 = new Function1<String, Boolean>() {
          @Override
          public Boolean apply(final String it) {
            return Boolean.valueOf((it != null));
          }
        };
        final Function1<String, Boolean> _function_2 = new Function1<String, Boolean>() {
          @Override
          public Boolean apply(final String it) {
            return Boolean.valueOf(it.equals(b.getName()));
          }
        };
        String _findFirst = IterableExtensions.<String>findFirst(IterableExtensions.<String>filter(ListExtensions.<IgnoreBranch, String>map(sib.getIgnoredBranch(), _function), _function_1), _function_2);
        return Boolean.valueOf((_findFirst == null));
      }
    };
    return IterableExtensions.<GUIBranch>filter(gbm, _function);
  }
  
  @Override
  public boolean isBranchReference(final Branch branch, final GUIBranch branchRef) {
    String _name = branch.getName();
    String _name_1 = branchRef.getName();
    return Objects.equal(_name, _name_1);
  }
  
  @Override
  public String getBranchName(final GUIBranch branchRef) {
    return branchRef.getName();
  }
  
  @Override
  public Iterable<GUIBranchPort> getBranchPortReferences(final GUIBranch branchRef) {
    return this._gUIExtension.notEquallyNamedPorts(branchRef.getPorts());
  }
  
  @Override
  public boolean isBranchPortReference(final Output branchPort, final GUIBranchPort branchPortRef) {
    String _name = branchPort.getName();
    String _name_1 = branchPortRef.getName();
    return Objects.equal(_name, _name_1);
  }
  
  public boolean hasErrors(final GUI model) {
    final File file = this._resourceExtension.getFile(model.eResource()).getRawLocation().toFile();
    final GUIExecution fe = new GUIExecution();
    final GUIAdapter adapter = fe.initApiAdapter(file);
    final CheckProcess<GUIId, GUIAdapter> check = fe.executeCheckPhase(adapter);
    if ((check.hasErrors() || check.hasWarnings())) {
      InputOutput.<CheckProcess<GUIId, GUIAdapter>>println(check);
    }
    return check.hasErrors();
  }
  
  public void createEventListeners(final GUISIB guiSib) {
    GUI gui = guiSib.getGui();
    if ((gui == null)) {
      this.showDialog("Reference is null", "Reference is null!");
      return;
    }
    final Function1<ListenerContext, EList<Event>> _function = new Function1<ListenerContext, EList<Event>>() {
      @Override
      public EList<Event> apply(final ListenerContext it) {
        return it.getEvents();
      }
    };
    Iterable<Event> events = Iterables.<Event>concat(ListExtensions.<ListenerContext, EList<Event>>map(gui.getListenerContexts(), _function));
    int _x = guiSib.getX();
    int _width = guiSib.getWidth();
    int _plus = (_x + _width);
    int x = (_plus + 20);
    int _y = guiSib.getY();
    int y = (_y - 50);
    for (final Event evt : events) {
      final Function1<EventListener, Boolean> _function_1 = new Function1<EventListener, Boolean>() {
        @Override
        public Boolean apply(final EventListener it) {
          return Boolean.valueOf(it.getName().equals(evt.getName()));
        }
      };
      boolean _isEmpty = IterableExtensions.isEmpty(IterableExtensions.<EventListener>filter(guiSib.getEventListenerSuccessors(), _function_1));
      if (_isEmpty) {
        EventListener el = guiSib.getRootElement().newEventListener(x, y);
        el.setName(evt.getName());
        EList<OutputPort> _outputPorts = evt.getOutputPorts();
        for (final OutputPort port : _outputPorts) {
          {
            if ((port instanceof ComplexOutputPort)) {
              ComplexInputPort p = el.newComplexInputPort(((ComplexOutputPort)port).getDataType(), 0, 0);
              p.setIsList(((ComplexOutputPort)port).isIsList());
              p.setName(((ComplexOutputPort)port).getName());
            }
            if ((port instanceof PrimitiveOutputPort)) {
              PrimitiveInputPort p_1 = el.newPrimitiveInputPort(0, 0);
              p_1.setName(((PrimitiveOutputPort)port).getName());
              p_1.setIsList(((PrimitiveOutputPort)port).isIsList());
              p_1.setDataType(this._gUIExtension.toProcess(this._dataExtension.toData(((PrimitiveOutputPort)port).getDataType())));
            }
          }
        }
        int _x_1 = x;
        x = (_x_1 + 140);
        guiSib.newEventConnector(el);
      }
    }
  }
  
  private boolean showDialog(final String title, final String msg) {
    return CincoMessageHandler.showQuestion(msg, title, true);
  }
}
