/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.build;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import graphmodel.ModelElementContainer;
import info.scce.dime.process.build.InitializationBranchCreator;
import info.scce.dime.process.build.PrimeSIBBuild;
import info.scce.dime.process.build.UpdateBranchCreator;
import info.scce.dime.process.helper.PortUtils;
import info.scce.dime.process.process.Branch;
import info.scce.dime.process.process.BranchConnector;
import info.scce.dime.process.process.EndSIB;
import info.scce.dime.process.process.GuardContainer;
import info.scce.dime.process.process.GuardedProcessSIB;
import info.scce.dime.process.process.IO;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.Output;
import info.scce.dime.process.process.PrimitiveOutputPort;
import info.scce.dime.process.process.PrimitiveType;
import info.scce.dime.process.process.ProcessFactory;
import info.scce.dime.process.process.ProcessType;
import info.scce.dime.process.process.StartSIB;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function2;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure2;

@SuppressWarnings("all")
public class GuardedProcessSIBBuild extends PrimeSIBBuild<GuardedProcessSIB, IO, EndSIB, Input> {
  public static boolean initialize(final GuardedProcessSIB sib) {
    return new GuardedProcessSIBBuild(sib).initialize();
  }
  
  public static void update(final GuardedProcessSIB sib) {
    new GuardedProcessSIBBuild(sib).update();
  }
  
  public GuardedProcessSIBBuild(final GuardedProcessSIB sib) {
    super(sib);
  }
  
  @Override
  public EObject getSIBReference(final GuardedProcessSIB sib) {
    return sib.getProMod();
  }
  
  @Override
  public boolean isSIBReferenceValid(final GuardedProcessSIB sib) {
    return ((sib.getContainer() instanceof GuardContainer) && (!this.hasErrors(sib.getProMod())));
  }
  
  @Override
  public Iterable<IO> getSIBPortReferences(final GuardedProcessSIB sib) {
    final List<IO> outputs = new LinkedList<IO>();
    ProcessType _processType = sib.getRootElement().getProcessType();
    boolean _equals = Objects.equal(_processType, ProcessType.LONG_RUNNING);
    if (_equals) {
      PrimitiveOutputPort _createPrimitiveOutputPort = ProcessFactory.eINSTANCE.createPrimitiveOutputPort();
      final Procedure1<PrimitiveOutputPort> _function = new Procedure1<PrimitiveOutputPort>() {
        @Override
        public void apply(final PrimitiveOutputPort it) {
          it.setDataType(PrimitiveType.INTEGER);
          it.setIsList(false);
          it.setName("maxUsageCount");
        }
      };
      final PrimitiveOutputPort maxUsage = ObjectExtensions.<PrimitiveOutputPort>operator_doubleArrow(_createPrimitiveOutputPort, _function);
      ArrayList<IO> _newArrayList = CollectionLiterals.<IO>newArrayList(maxUsage);
      Iterables.<IO>addAll(outputs, _newArrayList);
    }
    final StartSIB startSIB = this.getStartSIB(sib.getProMod());
    List<Output> _elvis = null;
    EList<Output> _outputs = null;
    if (startSIB!=null) {
      _outputs=startSIB.getOutputs();
    }
    if (_outputs != null) {
      _elvis = _outputs;
    } else {
      ArrayList<Output> _newArrayList_1 = CollectionLiterals.<Output>newArrayList();
      _elvis = _newArrayList_1;
    }
    outputs.addAll(_elvis);
    return outputs;
  }
  
  @Override
  public boolean isSIBPortReference(final Input sibPort, final IO output) {
    boolean _xifexpression = false;
    if ((output instanceof Output)) {
      String _name = sibPort.getName();
      String _name_1 = ((Output)output).getName();
      _xifexpression = Objects.equal(_name, _name_1);
    } else {
      _xifexpression = false;
    }
    return _xifexpression;
  }
  
  @Override
  public Iterable<EndSIB> getBranchReferences(final GuardedProcessSIB sib) {
    return sib.getProMod().getEndSIBs();
  }
  
  @Override
  public boolean isBranchReference(final Branch branch, final EndSIB endSib) {
    String _name = branch.getName();
    String _branchName = endSib.getBranchName();
    return Objects.equal(_name, _branchName);
  }
  
  @Override
  public String getBranchName(final EndSIB endSib) {
    return endSib.getBranchName();
  }
  
  @Override
  public Iterable<Input> getBranchPortReferences(final EndSIB endSib) {
    return endSib.getInputs();
  }
  
  @Override
  public boolean isBranchPortReference(final Output branchPort, final Input endSibPort) {
    String _name = branchPort.getName();
    String _name_1 = endSibPort.getName();
    return Objects.equal(_name, _name_1);
  }
  
  @Override
  public boolean initialize() {
    boolean _xblockexpression = false;
    {
      boolean _initialize = super.initialize();
      if (_initialize) {
        ModelElementContainer _container = this.cSib.getContainer();
        InitializationBranchCreator _initializationBranchCreator = new InitializationBranchCreator(((GuardContainer) _container));
        this.branchCreator = _initializationBranchCreator;
        return true;
      }
      _xblockexpression = false;
    }
    return _xblockexpression;
  }
  
  @Override
  public void update() {
    super.update();
    ModelElementContainer _container = this.cSib.getContainer();
    UpdateBranchCreator _updateBranchCreator = new UpdateBranchCreator(((GuardContainer) _container));
    this.branchCreator = _updateBranchCreator;
  }
  
  @Override
  void initializeBranchesInternal() {
    ModelElementContainer _container = this.cSib.getContainer();
    InitializationBranchCreator _initializationBranchCreator = new InitializationBranchCreator(((GuardContainer) _container));
    this.branchCreator = _initializationBranchCreator;
    super.initializeBranchesInternal();
  }
  
  @Override
  public void updateBranches() {
    ModelElementContainer _container = this.cSib.getContainer();
    UpdateBranchCreator _updateBranchCreator = new UpdateBranchCreator(((GuardContainer) _container));
    this.branchCreator = _updateBranchCreator;
    PortUtils.Sync<Branch, EndSIB> _sync = new PortUtils.Sync<Branch, EndSIB>();
    final Procedure1<PortUtils.Sync<Branch, EndSIB>> _function = new Procedure1<PortUtils.Sync<Branch, EndSIB>>() {
      @Override
      public void apply(final PortUtils.Sync<Branch, EndSIB> it) {
        final Function2<Branch, EndSIB, Boolean> _function = new Function2<Branch, EndSIB, Boolean>() {
          @Override
          public Boolean apply(final Branch branch, final EndSIB ref) {
            return Boolean.valueOf(GuardedProcessSIBBuild.this.isBranchReference(branch, ref));
          }
        };
        it.equals = _function;
        final Procedure1<EndSIB> _function_1 = new Procedure1<EndSIB>() {
          @Override
          public void apply(final EndSIB ref) {
            GuardedProcessSIBBuild.this.addAndUpdateBranch(ref);
          }
        };
        it.add = _function_1;
        final Procedure2<Branch, EndSIB> _function_2 = new Procedure2<Branch, EndSIB>() {
          @Override
          public void apply(final Branch branch, final EndSIB ref) {
            GuardedProcessSIBBuild.this.update(branch, ref);
          }
        };
        it.update = _function_2;
        final Procedure1<Branch> _function_3 = new Procedure1<Branch>() {
          @Override
          public void apply(final Branch branch) {
            branch.delete();
          }
        };
        it.delete = _function_3;
      }
    };
    final PortUtils.Sync<Branch, EndSIB> sync = ObjectExtensions.<PortUtils.Sync<Branch, EndSIB>>operator_doubleArrow(_sync, _function);
    ModelElementContainer _container_1 = this.sib.getContainer();
    final GuardContainer gc = ((GuardContainer) _container_1);
    sync.apply(gc.<Branch>getSuccessors(Branch.class), this.getBranchReferences(this.sib));
    if (((!gc.getGuardProcessSIBs().isEmpty()) && Objects.equal(gc.getRootElement().getProcessType(), ProcessType.BASIC))) {
      this.addBranch("denied");
    }
  }
  
  /**
   * override because
   *  - SIB is inside guard container, not the process model
   *  - branches are connected with the container, not the SIB
   */
  @Override
  public Branch addBranch(final String branchName) {
    ModelElementContainer _container = this.cSib.getContainer();
    boolean _equals = ((_container instanceof GuardContainer) == false);
    if (_equals) {
      throw new IllegalStateException("unknown container of sib");
    }
    ModelElementContainer _container_1 = this.cSib.getContainer();
    final GuardContainer guardCont = ((GuardContainer) _container_1);
    final info.scce.dime.process.process.Process container = guardCont.getContainer();
    if ((container instanceof info.scce.dime.process.process.Process)) {
      final Branch newBranch = this.branchCreator.getNewBranch();
      newBranch.setName(branchName);
      newBranch.<BranchConnector>getIncoming(BranchConnector.class).get(0).reconnectSource(guardCont);
      return ((Branch) newBranch);
    } else {
      throw new IllegalStateException("unknown container of branch");
    }
  }
}
