/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.build;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import info.scce.dime.process.build.PrimeSIBBuild;
import info.scce.dime.process.process.Branch;
import info.scce.dime.process.process.EndSIB;
import info.scce.dime.process.process.GuardProcessSIB;
import info.scce.dime.process.process.IO;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.Output;
import info.scce.dime.process.process.StartSIB;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class GuardProcessSIBBuild extends PrimeSIBBuild<GuardProcessSIB, IO, EndSIB, Input> {
  public static boolean initialize(final GuardProcessSIB sib) {
    return new GuardProcessSIBBuild(sib).initialize();
  }
  
  public static void update(final GuardProcessSIB sib) {
    new GuardProcessSIBBuild(sib).update();
  }
  
  public GuardProcessSIBBuild(final GuardProcessSIB sib) {
    super(sib);
  }
  
  @Override
  public EObject getSIBReference(final GuardProcessSIB sib) {
    return sib.getSecurityProcess();
  }
  
  @Override
  public boolean isSIBReferenceValid(final GuardProcessSIB sib) {
    boolean _hasErrors = this.hasErrors(sib.getSecurityProcess());
    return (!_hasErrors);
  }
  
  @Override
  public Iterable<IO> getSIBPortReferences(final GuardProcessSIB sib) {
    final List<IO> outputs = CollectionLiterals.<IO>newArrayList();
    final StartSIB startSIB = this.getStartSIB(sib.getSecurityProcess());
    Iterable<Output> _elvis = null;
    EList<Output> _outputs = null;
    if (startSIB!=null) {
      _outputs=startSIB.getOutputs();
    }
    Iterable<Output> _filter = null;
    if (_outputs!=null) {
      final Function1<Output, Boolean> _function = new Function1<Output, Boolean>() {
        @Override
        public Boolean apply(final Output it) {
          String _name = it.getName();
          return Boolean.valueOf((!Objects.equal(_name, "currentUser")));
        }
      };
      _filter=IterableExtensions.<Output>filter(_outputs, _function);
    }
    if (_filter != null) {
      _elvis = _filter;
    } else {
      ArrayList<Output> _newArrayList = CollectionLiterals.<Output>newArrayList();
      _elvis = _newArrayList;
    }
    Iterables.<IO>addAll(outputs, _elvis);
    return outputs;
  }
  
  @Override
  public boolean isSIBPortReference(final Input port, final IO output) {
    boolean _xifexpression = false;
    if ((output instanceof Output)) {
      String _name = port.getName();
      String _name_1 = ((Output)output).getName();
      _xifexpression = Objects.equal(_name, _name_1);
    } else {
      _xifexpression = false;
    }
    return _xifexpression;
  }
  
  @Override
  public Iterable<EndSIB> getBranchReferences(final GuardProcessSIB sib) {
    return null;
  }
  
  @Override
  public boolean isBranchReference(final Branch branch, final EndSIB branchRef) {
    return false;
  }
  
  @Override
  public String getBranchName(final EndSIB branchRef) {
    return null;
  }
  
  @Override
  public Iterable<Input> getBranchPortReferences(final EndSIB branchRef) {
    return null;
  }
  
  @Override
  public boolean isBranchPortReference(final Output branchPort, final Input portRef) {
    return false;
  }
}
