/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.build;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import info.scce.dime.data.data.EnumLiteral;
import info.scce.dime.data.data.EnumType;
import info.scce.dime.process.build.InitializationBranchCreator;
import info.scce.dime.process.build.PrimeSIBBuild;
import info.scce.dime.process.process.Branch;
import info.scce.dime.process.process.EnumSwitchSIB;
import info.scce.dime.process.process.IO;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.Output;
import info.scce.dime.process.process.SIB;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class EnumSwitchSIBBuild extends PrimeSIBBuild<EnumSwitchSIB, EnumType, String, EObject> {
  private String portName;
  
  public static boolean initialize(final EnumSwitchSIB sib) {
    return new EnumSwitchSIBBuild(sib).initialize();
  }
  
  public static void update(final EnumSwitchSIB sib) {
    new EnumSwitchSIBBuild(sib).update();
  }
  
  public EnumSwitchSIBBuild(final EnumSwitchSIB sib) {
    super(sib);
    String _elvis = null;
    EList<Input> _inputs = sib.getInputs();
    Input _head = null;
    if (_inputs!=null) {
      _head=IterableExtensions.<Input>head(_inputs);
    }
    String _name = null;
    if (_head!=null) {
      _name=_head.getName();
    }
    if (_name != null) {
      _elvis = _name;
    } else {
      _elvis = "enum";
    }
    this.portName = _elvis;
  }
  
  @Override
  public EObject getSIBReference(final EnumSwitchSIB sib) {
    return sib.getSwitchedType();
  }
  
  @Override
  public boolean isSIBReferenceValid(final EnumSwitchSIB sib) {
    return true;
  }
  
  @Override
  public Iterable<EnumType> getSIBPortReferences(final EnumSwitchSIB sib) {
    return CollectionLiterals.<EnumType>newArrayList(sib.getSwitchedType());
  }
  
  @Override
  public boolean isSIBPortReference(final Input port, final EnumType portRef) {
    return true;
  }
  
  @Override
  public void postProcessNewSIBPort(final IO port, final Object ref) {
    super.postProcessNewSIBPort(port, ref);
    ((Input) port).setName(this.portName);
  }
  
  @Override
  public void postProcessUpdateSIBPort(final IO port, final Object ref) {
    super.postProcessUpdateSIBPort(port, ref);
    ((Input) port).setName(this.portName);
  }
  
  @Override
  public Iterable<String> getBranchReferences(final EnumSwitchSIB sib) {
    final Function1<EnumLiteral, String> _function = new Function1<EnumLiteral, String>() {
      @Override
      public String apply(final EnumLiteral it) {
        return it.getName();
      }
    };
    List<String> _map = ListExtensions.<EnumLiteral, String>map(sib.getSwitchedType().getEnumLiterals(), _function);
    return Iterables.<String>concat(_map, Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("else")));
  }
  
  @Override
  public boolean isBranchReference(final Branch branch, final String branchRef) {
    String _name = branch.getName();
    return Objects.equal(_name, branchRef);
  }
  
  @Override
  public String getBranchName(final String branchRef) {
    return branchRef;
  }
  
  @Override
  public Iterable<EObject> getBranchPortReferences(final String branchRef) {
    return null;
  }
  
  @Override
  public boolean isBranchPortReference(final Output branchPort, final EObject portRef) {
    return false;
  }
  
  public Branch addElseBranch(final SIB sib) {
    Branch _xblockexpression = null;
    {
      InitializationBranchCreator _initializationBranchCreator = new InitializationBranchCreator(sib);
      super.branchCreator = _initializationBranchCreator;
      _xblockexpression = super.addBranch("else");
    }
    return _xblockexpression;
  }
  
  public Branch addBranches(final String branchName) {
    Branch _xblockexpression = null;
    {
      InitializationBranchCreator _initializationBranchCreator = new InitializationBranchCreator(this.sib);
      super.branchCreator = _initializationBranchCreator;
      _xblockexpression = super.addBranch(branchName);
    }
    return _xblockexpression;
  }
}
