/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.build;

import com.google.common.base.Objects;
import info.scce.dime.process.build.PrimeSIBBuild;
import info.scce.dime.process.process.AtomicSIB;
import info.scce.dime.process.process.IgnoreBranch;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.Output;
import info.scce.dime.process.process.ProcessFactory;
import info.scce.dime.siblibrary.Branch;
import info.scce.dime.siblibrary.Port;
import info.scce.dime.siblibrary.SIB;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class AtomicSIBBuild extends PrimeSIBBuild<AtomicSIB, Port, Branch, Port> {
  public AtomicSIBBuild(final AtomicSIB sib) {
    super(sib);
  }
  
  public static boolean initialize(final AtomicSIB sib) {
    boolean _xblockexpression = false;
    {
      EObject _sib = sib.getSib();
      final Function1<Branch, Boolean> _function = new Function1<Branch, Boolean>() {
        @Override
        public Boolean apply(final Branch it) {
          return Boolean.valueOf(it.getName().equals("noresult"));
        }
      };
      boolean _exists = IterableExtensions.<Branch>exists(((SIB) _sib).getBranches(), _function);
      if (_exists) {
        final IgnoreBranch ib = ProcessFactory.eINSTANCE.createIgnoreBranch();
        ib.setName("noresult");
        sib.getIgnoredBranch().add(ib);
      }
      EObject _sib_1 = sib.getSib();
      final Function1<Branch, Boolean> _function_1 = new Function1<Branch, Boolean>() {
        @Override
        public Boolean apply(final Branch it) {
          return Boolean.valueOf(it.getName().equals("failure"));
        }
      };
      boolean _exists_1 = IterableExtensions.<Branch>exists(((SIB) _sib_1).getBranches(), _function_1);
      if (_exists_1) {
        final IgnoreBranch ib_1 = ProcessFactory.eINSTANCE.createIgnoreBranch();
        ib_1.setName("failure");
        sib.getIgnoredBranch().add(ib_1);
      }
      _xblockexpression = new AtomicSIBBuild(sib).initialize();
    }
    return _xblockexpression;
  }
  
  public static void update(final AtomicSIB sib) {
    new AtomicSIBBuild(sib).update();
  }
  
  @Override
  public EObject getSIBReference(final AtomicSIB sib) {
    return sib.getSib();
  }
  
  @Override
  public boolean isSIBReferenceValid(final AtomicSIB sib) {
    return true;
  }
  
  @Override
  public Iterable<Port> getSIBPortReferences(final AtomicSIB sib) {
    EObject _sib = sib.getSib();
    return ((SIB) _sib).getInputPorts();
  }
  
  @Override
  public boolean isSIBPortReference(final Input port, final Port portRef) {
    String _name = port.getName();
    String _name_1 = portRef.getName();
    return Objects.equal(_name, _name_1);
  }
  
  @Override
  public Iterable<Branch> getBranchReferences(final AtomicSIB sib) {
    EObject _sib = sib.getSib();
    final Function1<Branch, Boolean> _function = new Function1<Branch, Boolean>() {
      @Override
      public Boolean apply(final Branch b) {
        final Function1<IgnoreBranch, String> _function = new Function1<IgnoreBranch, String>() {
          @Override
          public String apply(final IgnoreBranch it) {
            return it.getName();
          }
        };
        final Function1<String, Boolean> _function_1 = new Function1<String, Boolean>() {
          @Override
          public Boolean apply(final String it) {
            return Boolean.valueOf((it != null));
          }
        };
        final Function1<String, Boolean> _function_2 = new Function1<String, Boolean>() {
          @Override
          public Boolean apply(final String it) {
            return Boolean.valueOf(it.equals(b.getName()));
          }
        };
        String _findFirst = IterableExtensions.<String>findFirst(IterableExtensions.<String>filter(ListExtensions.<IgnoreBranch, String>map(sib.getIgnoredBranch(), _function), _function_1), _function_2);
        return Boolean.valueOf((_findFirst == null));
      }
    };
    return IterableExtensions.<Branch>filter(((SIB) _sib).getBranches(), _function);
  }
  
  @Override
  public boolean isBranchReference(final info.scce.dime.process.process.Branch branch, final Branch branchRef) {
    String _name = branch.getName();
    String _name_1 = branchRef.getName();
    return Objects.equal(_name, _name_1);
  }
  
  @Override
  public String getBranchName(final Branch branchRef) {
    return branchRef.getName();
  }
  
  @Override
  public Iterable<Port> getBranchPortReferences(final Branch branchRef) {
    return branchRef.getOutputPorts();
  }
  
  @Override
  public boolean isBranchPortReference(final Output branchPort, final Port portRef) {
    String _name = branchPort.getName();
    String _name_1 = portRef.getName();
    return Objects.equal(_name, _name_1);
  }
}
