/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.aps;

import de.jabc.cinco.meta.core.ge.style.generator.runtime.appearance.StyleAppearanceProvider;
import info.scce.dime.modeltrafo.extensionpoint.ModeltrafoExtensionProvider;
import info.scce.dime.modeltrafo.extensionpoint.trafosupport.IModeltrafoSupporter;
import info.scce.dime.modeltrafo.extensionpoint.transformation.GenericSIBGenerationProvider;
import info.scce.dime.process.process.GenericSIB;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import style.Appearance;
import style.StyleFactory;

@SuppressWarnings("all")
public class GenericSIBAppearance implements StyleAppearanceProvider<GenericSIB> {
  @Extension
  private StyleFactory _styleFactory = StyleFactory.eINSTANCE;
  
  @Override
  public Appearance getAppearance(final GenericSIB genericSIB, final String attribute) {
    Appearance _xifexpression = null;
    EObject _referencedObject = genericSIB.getReferencedObject();
    boolean _tripleNotEquals = (_referencedObject != null);
    if (_tripleNotEquals) {
      Appearance _xblockexpression = null;
      {
        IModeltrafoSupporter<EObject> trafoSupporter = ModeltrafoExtensionProvider.<EObject>getSupportedModelElement(genericSIB.getReferencedObject());
        Appearance _xifexpression_1 = null;
        if ((trafoSupporter != null)) {
          Appearance _xblockexpression_1 = null;
          {
            final String iconPath = trafoSupporter.getIconPath();
            Appearance _xifexpression_2 = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(iconPath);
            boolean _not = (!_isNullOrEmpty);
            if (_not) {
              Appearance _xifexpression_3 = null;
              boolean _equals = attribute.equals("icon");
              if (_equals) {
                Appearance _createAppearance = this._styleFactory.createAppearance();
                final Procedure1<Appearance> _function = new Procedure1<Appearance>() {
                  @Override
                  public void apply(final Appearance it) {
                    it.setImagePath(iconPath);
                  }
                };
                _xifexpression_3 = ObjectExtensions.<Appearance>operator_doubleArrow(_createAppearance, _function);
              }
              _xifexpression_2 = _xifexpression_3;
            } else {
              Appearance _xifexpression_4 = null;
              boolean _isGUI = GenericSIBGenerationProvider.<EObject>isGUI(genericSIB.getReferencedObject());
              if (_isGUI) {
                Appearance _createAppearance_1 = this._styleFactory.createAppearance();
                final Procedure1<Appearance> _function_1 = new Procedure1<Appearance>() {
                  @Override
                  public void apply(final Appearance it) {
                    it.setImagePath("icons/guiSIB.png");
                  }
                };
                _xifexpression_4 = ObjectExtensions.<Appearance>operator_doubleArrow(_createAppearance_1, _function_1);
              }
              _xifexpression_2 = _xifexpression_4;
            }
            _xblockexpression_1 = _xifexpression_2;
          }
          _xifexpression_1 = _xblockexpression_1;
        }
        _xblockexpression = _xifexpression_1;
      }
      _xifexpression = _xblockexpression;
    }
    return _xifexpression;
  }
}
