/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.aps;

import com.google.common.base.Objects;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.appearance.StyleAppearanceProvider;
import info.scce.dime.process.process.AbstractBranch;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import style.Appearance;
import style.Color;
import style.StyleFactory;

@SuppressWarnings("all")
public class BranchHLineAppearance implements StyleAppearanceProvider<AbstractBranch> {
  @Extension
  private StyleFactory _styleFactory = StyleFactory.eINSTANCE;
  
  private final Color visible = ObjectExtensions.<Color>operator_doubleArrow(this._styleFactory.createColor(), new Procedure1<Color>() {
    @Override
    public void apply(final Color it) {
      it.setR(0);
      it.setG(0);
      it.setB(0);
    }
  });
  
  private final Color invisible = ObjectExtensions.<Color>operator_doubleArrow(this._styleFactory.createColor(), new Procedure1<Color>() {
    @Override
    public void apply(final Color it) {
      it.setR(245);
      it.setG(245);
      it.setB(245);
    }
  });
  
  @Override
  public Appearance getAppearance(final AbstractBranch branch, final String elementName) {
    Appearance _xifexpression = null;
    boolean _equals = Objects.equal(elementName, "hline");
    if (_equals) {
      Appearance _createAppearance = this._styleFactory.createAppearance();
      final Procedure1<Appearance> _function = new Procedure1<Appearance>() {
        @Override
        public void apply(final Appearance it) {
          Color _xifexpression = null;
          if (((!branch.getRootElement().isDataFlowView()) || branch.getOutputPorts().isEmpty())) {
            _xifexpression = BranchHLineAppearance.this.invisible;
          } else {
            _xifexpression = BranchHLineAppearance.this.getHLineColor();
          }
          it.setForeground(_xifexpression);
        }
      };
      _xifexpression = ObjectExtensions.<Appearance>operator_doubleArrow(_createAppearance, _function);
    }
    return _xifexpression;
  }
  
  public Color getHLineColor() {
    return this.visible;
  }
}
