/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.aps;

import com.google.common.base.Objects;
import de.jabc.cinco.meta.core.ge.style.generator.runtime.appearance.StyleAppearanceProvider;
import info.scce.dime.process.process.AtomicSIB;
import info.scce.dime.siblibrary.SIB;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import style.Appearance;
import style.StyleFactory;

@SuppressWarnings("all")
public class AtomicSIBAppearance implements StyleAppearanceProvider<AtomicSIB> {
  @Extension
  private StyleFactory _styleFactory = StyleFactory.eINSTANCE;
  
  @Override
  public Appearance getAppearance(final AtomicSIB sib, final String elementName) {
    Appearance _xblockexpression = null;
    {
      EObject _sib = sib.getSib();
      final String iconPath = ((SIB) _sib).getIconPath();
      Appearance _xifexpression = null;
      if ((Objects.equal(elementName, "icon") && (!StringExtensions.isNullOrEmpty(iconPath)))) {
        Appearance _createAppearance = this._styleFactory.createAppearance();
        final Procedure1<Appearance> _function = new Procedure1<Appearance>() {
          @Override
          public void apply(final Appearance it) {
            it.setImagePath(iconPath);
          }
        };
        _xifexpression = ObjectExtensions.<Appearance>operator_doubleArrow(_createAppearance, _function);
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
}
