/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.actions;

import com.google.common.collect.Iterables;
import graphmodel.Container;
import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.process.helper.NodeLayout;
import info.scce.dime.process.process.AbstractBranch;
import info.scce.dime.process.process.Attribute;
import info.scce.dime.process.process.ComplexVariable;
import info.scce.dime.process.process.DataContext;
import info.scce.dime.process.process.DataFlow;
import info.scce.dime.process.process.DataFlowSource;
import info.scce.dime.process.process.DataFlowTarget;
import info.scce.dime.process.process.GuardContainer;
import info.scce.dime.process.process.GuardProcessSIB;
import info.scce.dime.process.process.GuardedProcessSIB;
import info.scce.dime.process.process.Variable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class ToggleDataFlowView extends DIMECustomAction<info.scce.dime.process.process.Process> {
  @Override
  public String getName() {
    return "Toggle DataFlow View";
  }
  
  @Override
  public void execute(final info.scce.dime.process.process.Process processModel) {
    try {
      boolean _isDataFlowView = processModel.isDataFlowView();
      boolean df = (!_isDataFlowView);
      processModel.setDataFlowView(df);
      EList<Container> _allContainers = processModel.getAllContainers();
      for (final Container container : _allContainers) {
        if ((container instanceof GuardContainer)) {
          GuardContainer guardContainer = ((GuardContainer) container);
          EList<GuardProcessSIB> _guardProcessSIBs = guardContainer.getGuardProcessSIBs();
          for (final GuardProcessSIB guardProcess : _guardProcessSIBs) {
            int _xifexpression = (int) 0;
            if (df) {
              _xifexpression = guardProcess.getInputs().size();
            } else {
              _xifexpression = 0;
            }
            guardProcess.resize(guardProcess.getWidth(), 
              NodeLayout.getSIBHeight(_xifexpression));
          }
          EList<GuardedProcessSIB> _guardedProcessSIBs = guardContainer.getGuardedProcessSIBs();
          for (final GuardedProcessSIB guardedProcess : _guardedProcessSIBs) {
            int _xifexpression_1 = (int) 0;
            if (df) {
              _xifexpression_1 = guardedProcess.getInputs().size();
            } else {
              _xifexpression_1 = 0;
            }
            guardedProcess.resize(guardedProcess.getWidth(), 
              NodeLayout.getSIBHeight(_xifexpression_1));
          }
        } else {
          if ((container instanceof DataFlowTarget)) {
            DataFlowTarget dft = ((DataFlowTarget) container);
            int _xifexpression_2 = (int) 0;
            if (df) {
              _xifexpression_2 = dft.getInputs().size();
            } else {
              _xifexpression_2 = 0;
            }
            dft.resize(dft.getWidth(), NodeLayout.getSIBHeight(_xifexpression_2));
          } else {
            if ((container instanceof DataFlowSource)) {
              DataFlowSource dfs = ((DataFlowSource) container);
              if ((container instanceof AbstractBranch)) {
                int _xifexpression_3 = (int) 0;
                if (df) {
                  _xifexpression_3 = dfs.getOutputs().size();
                } else {
                  _xifexpression_3 = 0;
                }
                dfs.resize(dfs.getWidth(), NodeLayout.getBranchHeight(_xifexpression_3));
              } else {
                int _xifexpression_4 = (int) 0;
                if (df) {
                  _xifexpression_4 = dfs.getOutputs().size();
                } else {
                  _xifexpression_4 = 0;
                }
                dfs.resize(dfs.getWidth(), NodeLayout.getSIBHeight(_xifexpression_4));
              }
            }
          }
        }
      }
      Iterable<DataFlow> _filter = Iterables.<DataFlow>filter(processModel.getAllNodes(), DataFlow.class);
      for (final DataFlow edge : _filter) {
        boolean _isDfViewWorkaround = edge.isDfViewWorkaround();
        boolean _not = (!_isDfViewWorkaround);
        edge.setDfViewWorkaround(_not);
      }
      EList<DataContext> _dataContexts = processModel.getDataContexts();
      for (final DataContext context : _dataContexts) {
        {
          boolean _isDfViewWorkaround_1 = context.isDfViewWorkaround();
          boolean _not_1 = (!_isDfViewWorkaround_1);
          context.setDfViewWorkaround(_not_1);
          EList<Variable> _variables = context.getVariables();
          for (final Variable variable : _variables) {
            {
              boolean _isDfViewWorkaround_2 = variable.isDfViewWorkaround();
              boolean _not_2 = (!_isDfViewWorkaround_2);
              variable.setDfViewWorkaround(_not_2);
              if ((variable instanceof ComplexVariable)) {
                ComplexVariable complexVariable = ((ComplexVariable) variable);
                EList<Attribute> _attributes = complexVariable.getAttributes();
                for (final Attribute attribute : _attributes) {
                  boolean _isDfViewWorkaround_3 = attribute.isDfViewWorkaround();
                  boolean _not_3 = (!_isDfViewWorkaround_3);
                  attribute.setDfViewWorkaround(_not_3);
                }
              }
            }
          }
        }
      }
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        final Exception e = (Exception)_t;
        e.printStackTrace();
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
}
