/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.actions;

import graphmodel.Node;
import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.process.helper.AttributeExpandUtils;
import info.scce.dime.process.process.ComplexVariable;
import info.scce.dime.process.process.DataContext;
import org.eclipse.emf.common.util.EList;

@SuppressWarnings("all")
public class ToggleAttributeExpand extends DIMECustomAction<ComplexVariable> {
  private final int OFFSET = 30;
  
  @Override
  public String getName() {
    return "Toggle Attribute Expand";
  }
  
  @Override
  public void execute(final ComplexVariable variable) {
    boolean _isExpanded = variable.isExpanded();
    boolean _not = (!_isExpanded);
    if (_not) {
      AttributeExpandUtils.expand(variable);
      this.layout(variable);
    } else {
      AttributeExpandUtils.collapse(variable);
      this.layout(variable);
    }
  }
  
  public void layout(final ComplexVariable node) {
    DataContext _container = node.getContainer();
    if ((_container instanceof DataContext)) {
      DataContext _container_1 = node.getContainer();
      DataContext dataContext = ((DataContext) _container_1);
      int _height = dataContext.getHeight();
      int dataCtxLowerBound = (_height - this.OFFSET);
      int _y = node.getY();
      int _height_1 = node.getHeight();
      int nodeLowerBoundX = (_y + _height_1);
      if ((dataCtxLowerBound < nodeLowerBoundX)) {
        int diff = (nodeLowerBoundX - dataCtxLowerBound);
        int _height_2 = dataContext.getHeight();
        int _plus = (_height_2 + diff);
        dataContext.setHeight(_plus);
      }
      int maxHeight = this.maxHeight(dataContext);
      dataContext.setHeight((maxHeight + this.OFFSET));
    }
  }
  
  public int maxHeight(final DataContext context) {
    int maxLowerBound = 50;
    EList<? extends Node> _nodes = context.getNodes();
    for (final Node node : _nodes) {
      int _y = node.getY();
      int _height = node.getHeight();
      int _plus = (_y + _height);
      boolean _greaterThan = (_plus > maxLowerBound);
      if (_greaterThan) {
        int _y_1 = node.getY();
        int _height_1 = node.getHeight();
        int _plus_1 = (_y_1 + _height_1);
        maxLowerBound = _plus_1;
      }
    }
    return maxLowerBound;
  }
}
