/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.actions;

import graphmodel.Container;
import graphmodel.ModelElementContainer;
import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.process.helper.PortUtils;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.InputStatic;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class StaticToPrimitivePort<T extends InputStatic> extends DIMECustomAction<InputStatic> {
  @Override
  public String getName() {
    return "Convert Static Value to Input";
  }
  
  @Override
  public void execute(final InputStatic inputStatic) {
    try {
      ModelElementContainer _container = inputStatic.getContainer();
      final Container container = ((Container) _container);
      final Consumer<Input> _function = new Consumer<Input>() {
        @Override
        public void accept(final Input oldPort) {
          if ((oldPort == inputStatic)) {
            PortUtils.addInput(container, inputStatic);
          } else {
            PortUtils.reconnectIncoming(oldPort, 
              oldPort.<Input>clone(oldPort.getContainer()));
          }
          oldPort.delete();
        }
      };
      container.<Input>getNodes(Input.class).forEach(_function);
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        final Exception e = (Exception)_t;
        e.printStackTrace();
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
}
