/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.actions;

import graphmodel.Node;
import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.process.process.StartSIB;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class StartSIBNewPrimitiveInput extends DIMECustomAction<StartSIB> {
  private final int OFFSET = 30;
  
  @Override
  public String getName() {
    return "New Primitive Input";
  }
  
  @Override
  public void execute(final StartSIB sib) {
    try {
      sib.newPrimitiveOutputPort(1, 1);
      this.layout(sib);
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        final Exception e = (Exception)_t;
        e.printStackTrace();
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  public void layout(final StartSIB sib) {
    int _y = sib.getY();
    int _height = sib.getHeight();
    int _plus = (_y + _height);
    int newY = (_plus + this.OFFSET);
    EList<? extends Node> _successors = sib.getSuccessors();
    for (final Node branch : _successors) {
      branch.moveTo(sib.getRootElement(), branch.getX(), newY);
    }
  }
}
