/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.actions;

import de.jabc.cinco.meta.core.utils.messages.CincoMessageHandler;
import graphmodel.Edge;
import graphmodel.ModelElementContainer;
import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.process.actions.PublishBasic;
import info.scce.dime.process.process.AbstractBranch;
import info.scce.dime.process.process.BranchConnector;
import info.scce.dime.process.process.ComplexDirectDataFlow;
import info.scce.dime.process.process.ComplexInputPort;
import info.scce.dime.process.process.ComplexRead;
import info.scce.dime.process.process.ControlFlow;
import info.scce.dime.process.process.DataFlow;
import info.scce.dime.process.process.GuardContainer;
import info.scce.dime.process.process.GuardedProcessSIB;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.InputPort;
import info.scce.dime.process.process.PrimitiveDirectDataFlow;
import info.scce.dime.process.process.PrimitiveInputPort;
import info.scce.dime.process.process.PrimitiveRead;
import info.scce.dime.process.process.ProcessSIB;
import info.scce.dime.process.process.ProcessType;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;

@SuppressWarnings("all")
public class SecureBasic extends DIMECustomAction<ProcessSIB> {
  @Override
  public String getName() {
    return "Secure Process";
  }
  
  @Override
  public boolean canExecute(final ProcessSIB processSib) throws ClassCastException {
    ProcessType _processType = processSib.getRootElement().getProcessType();
    boolean _tripleNotEquals = (_processType != ProcessType.BASIC);
    if (_tripleNotEquals) {
      return false;
    }
    ModelElementContainer _container = processSib.getContainer();
    if ((_container instanceof GuardContainer)) {
      return false;
    }
    info.scce.dime.process.process.Process eObj = processSib.getProMod();
    if ((eObj == null)) {
      return false;
    }
    ProcessType _processType_1 = eObj.getProcessType();
    boolean _tripleNotEquals_1 = (_processType_1 != ProcessType.BASIC);
    if (_tripleNotEquals_1) {
      return false;
    }
    return true;
  }
  
  @Override
  public void execute(final ProcessSIB processSib) {
    System.out.println("Secure Basic Process SIB");
    final info.scce.dime.process.process.Process eObj = processSib.getProMod();
    if ((eObj == null)) {
      this.showDialog("Reference is null", "Secure failed. Reference is null!");
      return;
    }
    final info.scce.dime.process.process.Process root = processSib.getRootElement();
    int _x = processSib.getX();
    int _minus = (_x - 5);
    int _y = processSib.getY();
    int _minus_1 = (_y - 5);
    int _width = processSib.getWidth();
    int _plus = (_width + 10);
    int _height = processSib.getHeight();
    int _plus_1 = (_height + 10);
    final GuardContainer cgc = root.newGuardContainer(_minus, _minus_1, _plus, _plus_1);
    GuardedProcessSIB newPSib = cgc.newGuardedProcessSIB(eObj, 5, 5);
    newPSib.setLabel(processSib.getLabel());
    final Predicate<Input> _function = new Predicate<Input>() {
      @Override
      public boolean test(final Input n) {
        return (n instanceof InputPort);
      }
    };
    final Function<Input, InputPort> _function_1 = new Function<Input, InputPort>() {
      @Override
      public InputPort apply(final Input n) {
        return ((InputPort) n);
      }
    };
    List<InputPort> _collect = processSib.getInputs().stream().filter(_function).<InputPort>map(_function_1).collect(Collectors.<InputPort>toList());
    for (final InputPort n : _collect) {
      EList<? extends DataFlow> _incoming = n.getIncoming();
      for (final Edge e : _incoming) {
        {
          final Predicate<Input> _function_2 = new Predicate<Input>() {
            @Override
            public boolean test(final Input f) {
              return (f instanceof InputPort);
            }
          };
          final Predicate<Input> _function_3 = new Predicate<Input>() {
            @Override
            public boolean test(final Input f) {
              return f.getName().equals(n.getName());
            }
          };
          Optional<Input> newPortOpt = newPSib.getInputs().stream().filter(_function_2).filter(_function_3).findFirst();
          boolean _isPresent = newPortOpt.isPresent();
          if (_isPresent) {
            Input _get = newPortOpt.get();
            InputPort newPort = ((InputPort) _get);
            if ((e instanceof PrimitiveRead)) {
              PrimitiveRead cr = ((PrimitiveRead) e);
              cr.reconnectTarget(((PrimitiveInputPort) newPort));
            }
            if ((e instanceof ComplexRead)) {
              ComplexRead cr_1 = ((ComplexRead) e);
              cr_1.reconnectTarget(((ComplexInputPort) newPort));
            }
            if ((e instanceof ComplexDirectDataFlow)) {
              ComplexDirectDataFlow cr_2 = ((ComplexDirectDataFlow) e);
              cr_2.reconnectTarget(((ComplexInputPort) newPort));
            }
            if ((e instanceof PrimitiveDirectDataFlow)) {
              PrimitiveDirectDataFlow cr_3 = ((PrimitiveDirectDataFlow) e);
              cr_3.reconnectTarget(((PrimitiveInputPort) newPort));
            }
          }
        }
      }
    }
    final Predicate<Input> _function_2 = new Predicate<Input>() {
      @Override
      public boolean test(final Input n) {
        return n.getName().equals("maxUsageCount");
      }
    };
    final Consumer<Input> _function_3 = new Consumer<Input>() {
      @Override
      public void accept(final Input it) {
        it.delete();
      }
    };
    newPSib.getInputs().stream().filter(_function_2).findFirst().ifPresent(_function_3);
    final Consumer<AbstractBranch> _function_4 = new Consumer<AbstractBranch>() {
      @Override
      public void accept(final AbstractBranch n) {
        n.delete();
      }
    };
    cgc.getAbstractBranchSuccessors().forEach(_function_4);
    List<BranchConnector> branches = processSib.<BranchConnector>getOutgoing(BranchConnector.class);
    final Consumer<BranchConnector> _function_5 = new Consumer<BranchConnector>() {
      @Override
      public void accept(final BranchConnector n) {
        n.reconnectSource(cgc);
      }
    };
    branches.stream().forEach(_function_5);
    final Consumer<ControlFlow> _function_6 = new Consumer<ControlFlow>() {
      @Override
      public void accept(final ControlFlow n) {
        n.reconnectTarget(cgc);
      }
    };
    processSib.<ControlFlow>getIncoming(ControlFlow.class).stream().forEach(_function_6);
    processSib.delete();
    PublishBasic.removeDublicatedBranches(((GuardContainer) cgc));
  }
  
  private boolean showDialog(final String title, final String msg) {
    return CincoMessageHandler.showQuestion(msg, title, true);
  }
}
