/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.actions;

import de.jabc.cinco.meta.core.utils.messages.CincoMessageHandler;
import graphmodel.ModelElementContainer;
import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.process.process.AbstractBranch;
import info.scce.dime.process.process.BranchConnector;
import info.scce.dime.process.process.ControlFlow;
import info.scce.dime.process.process.GuardContainer;
import info.scce.dime.process.process.GuardedProcessSIB;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.Output;
import info.scce.dime.process.process.ProcessSIB;
import info.scce.dime.process.process.ProcessType;
import info.scce.dime.process.process.SIB;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;

@SuppressWarnings("all")
public class PublishBasic extends DIMECustomAction<GuardedProcessSIB> {
  @Override
  public String getName() {
    return "Publish Process";
  }
  
  @Override
  public boolean canExecute(final GuardedProcessSIB processSib) throws ClassCastException {
    ProcessType _processType = processSib.getRootElement().getProcessType();
    boolean _tripleNotEquals = (_processType != ProcessType.BASIC);
    if (_tripleNotEquals) {
      return false;
    }
    ModelElementContainer _container = processSib.getContainer();
    boolean _not = (!(_container instanceof GuardContainer));
    if (_not) {
      return false;
    }
    final info.scce.dime.process.process.Process eObj = processSib.getProMod();
    if ((eObj == null)) {
      return false;
    }
    ProcessType _processType_1 = eObj.getProcessType();
    boolean _tripleNotEquals_1 = (_processType_1 != ProcessType.BASIC);
    if (_tripleNotEquals_1) {
      return false;
    }
    return true;
  }
  
  @Override
  public void execute(final GuardedProcessSIB processSib) {
    final info.scce.dime.process.process.Process eObj = processSib.getProMod();
    if ((eObj == null)) {
      this.showDialog("Reference is null", "Secure failed. Reference is null!");
      return;
    }
    final info.scce.dime.process.process.Process root = processSib.getRootElement();
    ModelElementContainer _container = processSib.getContainer();
    final GuardContainer cgc = ((GuardContainer) _container);
    info.scce.dime.process.process.Process _proMod = processSib.getProMod();
    int _x = cgc.getX();
    int _plus = (_x + 5);
    int _y = cgc.getY();
    int _plus_1 = (_y + 5);
    final ProcessSIB newCProcess = root.newProcessSIB(_proMod, _plus, _plus_1);
    final Consumer<Input> _function = new Consumer<Input>() {
      @Override
      public void accept(final Input n) {
        n.moveTo(newCProcess, n.getX(), n.getY());
      }
    };
    processSib.getInputs().forEach(_function);
    final Consumer<ControlFlow> _function_1 = new Consumer<ControlFlow>() {
      @Override
      public void accept(final ControlFlow n) {
        n.reconnectTarget(newCProcess);
      }
    };
    cgc.<ControlFlow>getIncoming(ControlFlow.class).forEach(_function_1);
    final Consumer<BranchConnector> _function_2 = new Consumer<BranchConnector>() {
      @Override
      public void accept(final BranchConnector n) {
        n.reconnectSource(newCProcess);
      }
    };
    cgc.<BranchConnector>getOutgoing(BranchConnector.class).forEach(_function_2);
    cgc.delete();
    PublishBasic.removeDublicatedBranches(newCProcess);
    final Predicate<AbstractBranch> _function_3 = new Predicate<AbstractBranch>() {
      @Override
      public boolean test(final AbstractBranch n) {
        return n.getName().equals("denied");
      }
    };
    final Consumer<AbstractBranch> _function_4 = new Consumer<AbstractBranch>() {
      @Override
      public void accept(final AbstractBranch n) {
        n.delete();
      }
    };
    newCProcess.getAbstractBranchSuccessors().stream().filter(_function_3).forEach(_function_4);
  }
  
  private boolean showDialog(final String title, final String msg) {
    return CincoMessageHandler.showQuestion(msg, title, true);
  }
  
  public static void removeDublicatedBranches(final SIB sib) {
    final Map<String, AbstractBranch> knownBranchNames = new HashMap<String, AbstractBranch>();
    final Consumer<AbstractBranch> _function = new Consumer<AbstractBranch>() {
      @Override
      public void accept(final AbstractBranch n) {
        boolean _isEmpty = n.<ControlFlow>getOutgoing(ControlFlow.class).isEmpty();
        boolean _not = (!_isEmpty);
        if (_not) {
          knownBranchNames.put(n.getName(), n);
        } else {
          final Predicate<Output> _function = new Predicate<Output>() {
            @Override
            public boolean test(final Output e) {
              boolean _isEmpty = e.getOutgoing().isEmpty();
              return (!_isEmpty);
            }
          };
          boolean _isPresent = n.getOutputs().stream().filter(_function).findAny().isPresent();
          if (_isPresent) {
            knownBranchNames.put(n.getName(), n);
          }
        }
      }
    };
    sib.getAbstractBranchSuccessors().forEach(_function);
    final Consumer<AbstractBranch> _function_1 = new Consumer<AbstractBranch>() {
      @Override
      public void accept(final AbstractBranch n) {
        boolean _containsKey = knownBranchNames.containsKey(n.getName());
        if (_containsKey) {
          boolean _equals = knownBranchNames.get(n.getName()).equals(n);
          boolean _not = (!_equals);
          if (_not) {
            n.delete();
          }
        } else {
          knownBranchNames.put(n.getName(), n);
        }
      }
    };
    sib.getAbstractBranchSuccessors().forEach(_function_1);
  }
}
