/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.actions;

import com.google.common.collect.Iterables;
import graphmodel.Container;
import graphmodel.ModelElementContainer;
import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.process.helper.PortUtils;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.PrimitiveInputPort;
import info.scce.dime.process.process.PrimitiveType;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class PrimitivePortToStatic extends DIMECustomAction<PrimitiveInputPort> {
  @Override
  public String getName() {
    return "Convert Input to Static Value";
  }
  
  @Override
  public boolean canExecute(final PrimitiveInputPort port) {
    PrimitiveType _dataType = port.getDataType();
    return (PrimitiveType.FILE != _dataType);
  }
  
  @Override
  public void execute(final PrimitiveInputPort port) {
    try {
      ModelElementContainer _container = port.getContainer();
      final Container container = ((Container) _container);
      final ArrayList<Input> oldPorts = CollectionLiterals.<Input>newArrayList();
      final Consumer<Input> _function = new Consumer<Input>() {
        @Override
        public void accept(final Input oldPort) {
          if ((oldPort == port)) {
            PortUtils.addStaticPort(container, port);
          } else {
            Input oldClone = oldPort.<Input>clone(container);
            PortUtils.reconnectIncoming(oldPort, oldClone);
          }
          oldPorts.add(oldPort);
        }
      };
      Iterables.<Input>filter(container.getAllNodes(), Input.class).forEach(_function);
      final Consumer<Input> _function_1 = new Consumer<Input>() {
        @Override
        public void accept(final Input it) {
          it.delete();
        }
      };
      oldPorts.forEach(_function_1);
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        final Exception e = (Exception)_t;
        e.printStackTrace();
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
}
