/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.actions;

import graphmodel.Node;
import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.process.helper.BranchUtils;
import info.scce.dime.process.helper.SIBUtils;
import info.scce.dime.process.process.Branch;
import info.scce.dime.process.process.ProcessInputStatic;
import info.scce.dime.process.process.SIB;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.InputOutput;

@SuppressWarnings("all")
public class OpenModel extends DIMECustomAction<Node> {
  @Override
  public void execute(final Node it) {
    String _name = it.eClass().getName();
    String _plus = ("Opening submodel for " + _name);
    InputOutput.<String>println(_plus);
    EObject _switchResult = null;
    boolean _matched = false;
    if (it instanceof SIB) {
      _matched=true;
      _switchResult = SIBUtils.getReferencedComponent(((SIB)it));
    }
    if (!_matched) {
      if (it instanceof Branch) {
        _matched=true;
        _switchResult = BranchUtils.getReferencedComponent(((Branch)it));
      }
    }
    if (!_matched) {
      if (it instanceof ProcessInputStatic) {
        _matched=true;
        _switchResult = ((ProcessInputStatic)it).getValue();
      }
    }
    this._workbenchExtension.openEditor(_switchResult);
  }
  
  @Override
  public boolean hasDoneChanges() {
    return false;
  }
}
