/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.actions;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.process.actions.StaticToPrimitivePort;
import info.scce.dime.process.process.DataFlowTarget;
import info.scce.dime.process.process.InputStatic;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Context menu action, which converts all static ports to
 * input ports
 * @author zweihoff
 */
@SuppressWarnings("all")
public class MultiStaticToInput<T extends DataFlowTarget> extends DIMECustomAction<DataFlowTarget> {
  /**
   * Returns the name of the context menu entry
   */
  @Override
  public String getName() {
    return "Convert to input ports";
  }
  
  /**
   * Checks if the r GUI SIB is not already dispatched
   */
  @Override
  public boolean canExecute(final DataFlowTarget guiSib) {
    boolean _isEmpty = guiSib.getInputStatics().isEmpty();
    return (!_isEmpty);
  }
  
  @Override
  public void execute(final DataFlowTarget guiSib) {
    final Function1<InputStatic, String> _function = new Function1<InputStatic, String>() {
      @Override
      public String apply(final InputStatic it) {
        return it.getId();
      }
    };
    final List<String> allToBeReplaced = IterableExtensions.<String>toList(IterableExtensions.<InputStatic, String>map(Iterables.<InputStatic>filter(guiSib.getInputs(), InputStatic.class), _function));
    final StaticToPrimitivePort<InputStatic> staticToPrimitiveConverter = new StaticToPrimitivePort<InputStatic>();
    for (final String toBeReplaced : allToBeReplaced) {
      final Function1<InputStatic, Boolean> _function_1 = new Function1<InputStatic, Boolean>() {
        @Override
        public Boolean apply(final InputStatic it) {
          String _id = it.getId();
          return Boolean.valueOf(Objects.equal(_id, toBeReplaced));
        }
      };
      final Consumer<InputStatic> _function_2 = new Consumer<InputStatic>() {
        @Override
        public void accept(final InputStatic n) {
          staticToPrimitiveConverter.execute(n);
        }
      };
      IterableExtensions.<InputStatic>filter(Iterables.<InputStatic>filter(guiSib.getInputs(), InputStatic.class), _function_1).forEach(_function_2);
    }
  }
}
