/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.actions;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.process.actions.PrimitivePortToStatic;
import info.scce.dime.process.process.DataFlowTarget;
import info.scce.dime.process.process.PrimitiveInputPort;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Context menu action, which converts all primitive
 * input ports, which are not connected by data flow, to a static input
 * @author zweihoff
 */
@SuppressWarnings("all")
public class MultiInputToStatic<T extends DataFlowTarget> extends DIMECustomAction<T> {
  /**
   * Returns the name of the context menu entry
   */
  @Override
  public String getName() {
    return "Convert to static inputs";
  }
  
  /**
   * Checks if the r GUI SIB is not already dispatched
   */
  @Override
  public boolean canExecute(final DataFlowTarget guiSib) {
    final Function1<PrimitiveInputPort, Boolean> _function = new Function1<PrimitiveInputPort, Boolean>() {
      @Override
      public Boolean apply(final PrimitiveInputPort it) {
        boolean _isIsList = it.isIsList();
        return Boolean.valueOf((!_isIsList));
      }
    };
    final Function1<PrimitiveInputPort, Boolean> _function_1 = new Function1<PrimitiveInputPort, Boolean>() {
      @Override
      public Boolean apply(final PrimitiveInputPort it) {
        return Boolean.valueOf(it.getIncoming().isEmpty());
      }
    };
    boolean _isEmpty = IterableExtensions.isEmpty(IterableExtensions.<PrimitiveInputPort>filter(IterableExtensions.<PrimitiveInputPort>filter(Iterables.<PrimitiveInputPort>filter(guiSib.getInputs(), PrimitiveInputPort.class), _function), _function_1));
    return (!_isEmpty);
  }
  
  @Override
  public void execute(final DataFlowTarget guiSib) {
    final Function1<PrimitiveInputPort, Boolean> _function = new Function1<PrimitiveInputPort, Boolean>() {
      @Override
      public Boolean apply(final PrimitiveInputPort it) {
        boolean _isIsList = it.isIsList();
        return Boolean.valueOf((!_isIsList));
      }
    };
    final Function1<PrimitiveInputPort, Boolean> _function_1 = new Function1<PrimitiveInputPort, Boolean>() {
      @Override
      public Boolean apply(final PrimitiveInputPort it) {
        return Boolean.valueOf(it.getIncoming().isEmpty());
      }
    };
    final Function1<PrimitiveInputPort, String> _function_2 = new Function1<PrimitiveInputPort, String>() {
      @Override
      public String apply(final PrimitiveInputPort it) {
        return it.getId();
      }
    };
    final List<String> allToBeReplaced = IterableExtensions.<String>toList(IterableExtensions.<PrimitiveInputPort, String>map(IterableExtensions.<PrimitiveInputPort>filter(IterableExtensions.<PrimitiveInputPort>filter(Iterables.<PrimitiveInputPort>filter(guiSib.getInputs(), PrimitiveInputPort.class), _function), _function_1), _function_2));
    final PrimitivePortToStatic primitiveToStaticConverter = new PrimitivePortToStatic();
    for (final String toBeReplaced : allToBeReplaced) {
      final Function1<PrimitiveInputPort, Boolean> _function_3 = new Function1<PrimitiveInputPort, Boolean>() {
        @Override
        public Boolean apply(final PrimitiveInputPort it) {
          String _id = it.getId();
          return Boolean.valueOf(Objects.equal(_id, toBeReplaced));
        }
      };
      final Consumer<PrimitiveInputPort> _function_4 = new Consumer<PrimitiveInputPort>() {
        @Override
        public void accept(final PrimitiveInputPort n) {
          primitiveToStaticConverter.execute(n);
        }
      };
      IterableExtensions.<PrimitiveInputPort>filter(Iterables.<PrimitiveInputPort>filter(guiSib.getInputs(), PrimitiveInputPort.class), _function_3).forEach(_function_4);
    }
  }
}
