/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.actions;

import com.google.common.base.Objects;
import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.process.process.ComplexInputPort;
import info.scce.dime.process.process.ComplexOutputPort;
import info.scce.dime.process.process.Documentation;
import info.scce.dime.process.process.EndSIB;
import info.scce.dime.process.process.GUISIB;
import info.scce.dime.process.process.GuardContainer;
import info.scce.dime.process.process.GuardProcessSIB;
import info.scce.dime.process.process.InputPort;
import info.scce.dime.process.process.InputStatic;
import info.scce.dime.process.process.OutputPort;
import info.scce.dime.process.process.PrimitiveInputPort;
import info.scce.dime.process.process.PrimitiveOutputPort;
import info.scce.dime.process.process.ProcessSIB;
import info.scce.dime.process.process.ProcessType;
import info.scce.dime.process.process.StartSIB;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class GenerateMarkdownDocumentation<T extends info.scce.dime.process.process.Process> extends DIMECustomAction<T> {
  @Override
  public String getName() {
    return "Create Documentation";
  }
  
  @Override
  public boolean canExecute(final info.scce.dime.process.process.Process d) {
    return true;
  }
  
  @Override
  public boolean hasDoneChanges() {
    return false;
  }
  
  @Override
  public void execute(final info.scce.dime.process.process.Process d) {
    try {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("../documentation/process/");
      String _modelName = d.getModelName();
      _builder.append(_modelName);
      _builder.append(".md");
      final String filePath = this._workspaceExtension.getFile(d).getProject().getLocation().append(_builder.toString()).toString();
      this.createFile(this.createDoc(d).toString(), filePath);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  /**
   * Helper method to create a file with the given content on the given path.
   * @param content
   * @param path
   * @throws IOException
   */
  public void createFile(final String content, final String path) throws IOException {
    final File f = new File(path);
    f.getParentFile().mkdirs();
    f.createNewFile();
    FileUtils.writeStringToFile(f, content);
  }
  
  public CharSequence createDoc(final info.scce.dime.process.process.Process d) {
    CharSequence _xblockexpression = null;
    {
      final StartSIB start = this._processExtension.getStartSIB(d);
      final EList<EndSIB> endsibs = d.getEndSIBs();
      final EList<GUISIB> containedGuiSibs = d.getGUISIBs();
      final Function1<ProcessSIB, Boolean> _function = new Function1<ProcessSIB, Boolean>() {
        @Override
        public Boolean apply(final ProcessSIB it) {
          ProcessType _processType = it.getProMod().getProcessType();
          return Boolean.valueOf(Objects.equal(_processType, ProcessType.BASIC));
        }
      };
      final Iterable<ProcessSIB> containedBasicSibs = IterableExtensions.<ProcessSIB>filter(d.getProcessSIBs(), _function);
      final Function1<ProcessSIB, Boolean> _function_1 = new Function1<ProcessSIB, Boolean>() {
        @Override
        public Boolean apply(final ProcessSIB it) {
          ProcessType _processType = it.getProMod().getProcessType();
          return Boolean.valueOf(Objects.equal(_processType, ProcessType.SECURITY));
        }
      };
      final Iterable<ProcessSIB> containedSecuritySibs = IterableExtensions.<ProcessSIB>filter(d.getProcessSIBs(), _function_1);
      final Function1<ProcessSIB, Boolean> _function_2 = new Function1<ProcessSIB, Boolean>() {
        @Override
        public Boolean apply(final ProcessSIB it) {
          ProcessType _processType = it.getProMod().getProcessType();
          return Boolean.valueOf(Objects.equal(_processType, ProcessType.FILE_DOWNLOAD_SECURITY));
        }
      };
      final Iterable<ProcessSIB> containedFileDownloadSibs = IterableExtensions.<ProcessSIB>filter(d.getProcessSIBs(), _function_2);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("# ");
      String _modelName = d.getModelName();
      _builder.append(_modelName);
      _builder.append(" *");
      String _literal = d.getProcessType().getLiteral();
      _builder.append(_literal);
      _builder.append("*");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.newLine();
      String _doc = this.doc(d.getDocumentation());
      _builder.append(_doc);
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.newLine();
      _builder.append("### Notes");
      _builder.newLine();
      _builder.append(" ");
      _builder.newLine();
      final Function1<Documentation, String> _function_3 = new Function1<Documentation, String>() {
        @Override
        public String apply(final Documentation it) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("* ");
          String _content = it.getContent();
          _builder.append(_content);
          return _builder.toString();
        }
      };
      String _join = IterableExtensions.join(ListExtensions.<Documentation, String>map(d.getDocumentations(), _function_3), "\n");
      _builder.append(_join);
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.newLine();
      _builder.append("### Input Ports");
      _builder.newLine();
      _builder.append(" ");
      _builder.newLine();
      final Function1<OutputPort, String> _function_4 = new Function1<OutputPort, String>() {
        @Override
        public String apply(final OutputPort it) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("* *");
          String _name = it.getName();
          _builder.append(_name);
          _builder.append("* : ");
          {
            boolean _isIsList = it.isIsList();
            if (_isIsList) {
              _builder.append("List<");
            }
          }
          CharSequence _typeName = GenerateMarkdownDocumentation.this.typeName(it);
          _builder.append(_typeName);
          {
            boolean _isIsList_1 = it.isIsList();
            if (_isIsList_1) {
              _builder.append(">");
            }
          }
          return _builder.toString();
        }
      };
      String _join_1 = IterableExtensions.join(ListExtensions.<OutputPort, String>map(start.getOutputPorts(), _function_4), "\n");
      _builder.append(_join_1);
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.newLine();
      _builder.append("### End SIBs");
      _builder.newLine();
      _builder.append(" ");
      _builder.newLine();
      final Function1<EndSIB, CharSequence> _function_5 = new Function1<EndSIB, CharSequence>() {
        @Override
        public CharSequence apply(final EndSIB it) {
          return GenerateMarkdownDocumentation.this.branch(it);
        }
      };
      String _join_2 = IterableExtensions.join(ListExtensions.<EndSIB, CharSequence>map(endsibs, _function_5), "\n");
      _builder.append(_join_2);
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.newLine();
      _builder.append("### Used GUI SIBs");
      _builder.newLine();
      _builder.append(" ");
      _builder.newLine();
      final Function1<GUISIB, String> _function_6 = new Function1<GUISIB, String>() {
        @Override
        public String apply(final GUISIB it) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("* [");
          String _title = it.getGui().getTitle();
          _builder.append(_title);
          _builder.append("](../gui/");
          String _title_1 = it.getGui().getTitle();
          _builder.append(_title_1);
          _builder.append(".md)");
          return _builder.toString();
        }
      };
      String _join_3 = IterableExtensions.join(ListExtensions.<GUISIB, String>map(containedGuiSibs, _function_6), "\n");
      _builder.append(_join_3);
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.newLine();
      _builder.append("### Used Guarded Processes");
      _builder.newLine();
      _builder.append(" ");
      _builder.newLine();
      final Function1<GuardContainer, Boolean> _function_7 = new Function1<GuardContainer, Boolean>() {
        @Override
        public Boolean apply(final GuardContainer it) {
          boolean _isEmpty = it.getGuardedProcessSIBs().isEmpty();
          return Boolean.valueOf((!_isEmpty));
        }
      };
      final Function1<GuardContainer, String> _function_8 = new Function1<GuardContainer, String>() {
        @Override
        public String apply(final GuardContainer it) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("* [");
          String _modelName = it.getGuardedProcessSIBs().get(0).getProMod().getModelName();
          _builder.append(_modelName);
          _builder.append("](./");
          String _modelName_1 = it.getGuardedProcessSIBs().get(0).getProMod().getModelName();
          _builder.append(_modelName_1);
          _builder.append(".md)");
          {
            boolean _isEmpty = it.getGuardProcessSIBs().isEmpty();
            boolean _not = (!_isEmpty);
            if (_not) {
              _builder.append(" guarded by ");
              final Function1<GuardProcessSIB, String> _function = new Function1<GuardProcessSIB, String>() {
                @Override
                public String apply(final GuardProcessSIB it) {
                  StringConcatenation _builder = new StringConcatenation();
                  _builder.append("[");
                  String _modelName = it.getSecurityProcess().getModelName();
                  _builder.append(_modelName);
                  _builder.append("](./");
                  String _modelName_1 = it.getSecurityProcess().getModelName();
                  _builder.append(_modelName_1);
                  _builder.append(".md)");
                  return _builder.toString();
                }
              };
              String _join = IterableExtensions.join(ListExtensions.<GuardProcessSIB, String>map(it.getGuardProcessSIBs(), _function), ", ");
              _builder.append(_join);
            }
          }
          return _builder.toString();
        }
      };
      String _join_4 = IterableExtensions.join(IterableExtensions.<GuardContainer, String>map(IterableExtensions.<GuardContainer>filter(d.getGuardContainers(), _function_7), _function_8), "\n");
      _builder.append(_join_4);
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.newLine();
      _builder.append("### Used Basic Processes");
      _builder.newLine();
      _builder.append(" ");
      _builder.newLine();
      final Function1<ProcessSIB, String> _function_9 = new Function1<ProcessSIB, String>() {
        @Override
        public String apply(final ProcessSIB it) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("* [");
          String _modelName = it.getProMod().getModelName();
          _builder.append(_modelName);
          _builder.append("](./");
          String _modelName_1 = it.getProMod().getModelName();
          _builder.append(_modelName_1);
          _builder.append(".md)");
          return _builder.toString();
        }
      };
      String _join_5 = IterableExtensions.join(IterableExtensions.<ProcessSIB, String>map(containedBasicSibs, _function_9), "\n");
      _builder.append(_join_5);
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.newLine();
      _builder.append("### Used Security Processes");
      _builder.newLine();
      _builder.append(" ");
      _builder.newLine();
      final Function1<ProcessSIB, String> _function_10 = new Function1<ProcessSIB, String>() {
        @Override
        public String apply(final ProcessSIB it) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("* [");
          String _modelName = it.getProMod().getModelName();
          _builder.append(_modelName);
          _builder.append("](./");
          String _modelName_1 = it.getProMod().getModelName();
          _builder.append(_modelName_1);
          _builder.append(".md)");
          return _builder.toString();
        }
      };
      String _join_6 = IterableExtensions.join(IterableExtensions.<ProcessSIB, String>map(containedSecuritySibs, _function_10), "\n");
      _builder.append(_join_6);
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.newLine();
      _builder.append("### Used File Download Security Processes");
      _builder.newLine();
      _builder.append(" ");
      _builder.newLine();
      final Function1<ProcessSIB, String> _function_11 = new Function1<ProcessSIB, String>() {
        @Override
        public String apply(final ProcessSIB it) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("* [");
          String _name = it.getName();
          _builder.append(_name);
          _builder.append("](./");
          String _name_1 = it.getName();
          _builder.append(_name_1);
          _builder.append(".md)");
          return _builder.toString();
        }
      };
      String _join_7 = IterableExtensions.join(IterableExtensions.<ProcessSIB, String>map(containedFileDownloadSibs, _function_11), "\n");
      _builder.append(_join_7);
      _builder.newLineIfNotEmpty();
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  public CharSequence branch(final EndSIB e) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("* *");
    String _branchName = e.getBranchName();
    _builder.append(_branchName);
    _builder.append("*");
    _builder.newLineIfNotEmpty();
    {
      EList<InputPort> _inputPorts = e.getInputPorts();
      for(final InputPort p : _inputPorts) {
        _builder.append(" ");
        _builder.append("* ");
        String _name = p.getName();
        _builder.append(_name);
        _builder.append(": ");
        {
          boolean _isIsList = p.isIsList();
          if (_isIsList) {
            _builder.append("List<");
          }
        }
        {
          if ((p instanceof ComplexInputPort)) {
            String _name_1 = ((ComplexInputPort)p).getDataType().getName();
            _builder.append(_name_1);
          } else {
            String _literal = ((PrimitiveInputPort) p).getDataType().getLiteral();
            _builder.append(_literal);
          }
        }
        {
          boolean _isIsList_1 = p.isIsList();
          if (_isIsList_1) {
            _builder.append(">");
          }
        }
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<InputStatic> _inputStatics = e.getInputStatics();
      for(final InputStatic p_1 : _inputStatics) {
        _builder.append(" ");
        _builder.append("* ");
        String _name_2 = p_1.getName();
        _builder.append(_name_2);
        _builder.append(": ```");
        String _staticValue = this._gUIExtension.staticValue(p_1);
        _builder.append(_staticValue);
        _builder.append("```");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  protected CharSequence _typeName(final ComplexOutputPort t) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("[");
    String _name = t.getDataType().getName();
    _builder.append(_name);
    _builder.append("](../data/");
    String _modelName = t.getDataType().getRootElement().getModelName();
    _builder.append(_modelName);
    _builder.append("/");
    String _name_1 = t.getDataType().getName();
    _builder.append(_name_1);
    _builder.append(".md)");
    return _builder;
  }
  
  protected CharSequence _typeName(final PrimitiveOutputPort t) {
    return t.getDataType().getLiteral();
  }
  
  public String doc(final String s) {
    String _xblockexpression = null;
    {
      boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(s);
      boolean _not = (!_isNullOrEmpty);
      if (_not) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(">>>");
        _builder.newLine();
        _builder.append(s);
        _builder.newLineIfNotEmpty();
        _builder.append("<<<");
        _builder.newLine();
        return _builder.toString();
      }
      _xblockexpression = "";
    }
    return _xblockexpression;
  }
  
  public CharSequence typeName(final OutputPort t) {
    if (t instanceof ComplexOutputPort) {
      return _typeName((ComplexOutputPort)t);
    } else if (t instanceof PrimitiveOutputPort) {
      return _typeName((PrimitiveOutputPort)t);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(t).toString());
    }
  }
}
