/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.actions;

import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.process.helper.EdgeLayoutUtils;
import info.scce.dime.process.process.DirectDataFlow;
import java.util.List;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;

@SuppressWarnings("all")
public class DirectDataFlowToLeft<T extends DirectDataFlow> extends DIMECustomAction<DirectDataFlow> {
  @Override
  public String getName() {
    return "Move left";
  }
  
  @Override
  public boolean canExecute(final DirectDataFlow edge) {
    boolean _isEmpty = EdgeLayoutUtils.getBendpoints(edge).isEmpty();
    return (!_isEmpty);
  }
  
  @Override
  public void execute(final DirectDataFlow edge) {
    final List<Point> bps = EdgeLayoutUtils.getBendpoints(edge);
    int _size = bps.size();
    ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
    for (final Integer i : _doubleDotLessThan) {
      {
        final Point bp = bps.get((i).intValue());
        int _x = bp.getX();
        int _minus = (_x - 10);
        EdgeLayoutUtils.moveBendpoint(edge, (i).intValue(), _minus, bp.getY());
      }
    }
  }
}
