/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.actions;

import de.jabc.cinco.meta.core.utils.messages.CincoMessageHandler;
import graphmodel.Edge;
import graphmodel.ModelElementContainer;
import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.process.process.AbstractBranch;
import info.scce.dime.process.process.BooleanInputStatic;
import info.scce.dime.process.process.Branch;
import info.scce.dime.process.process.BranchBlueprint;
import info.scce.dime.process.process.ComplexInputPort;
import info.scce.dime.process.process.ComplexOutputPort;
import info.scce.dime.process.process.ControlFlow;
import info.scce.dime.process.process.DataContext;
import info.scce.dime.process.process.DataFlow;
import info.scce.dime.process.process.EndSIB;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.InputStatic;
import info.scce.dime.process.process.IntegerInputStatic;
import info.scce.dime.process.process.JavaNativeInputPort;
import info.scce.dime.process.process.JavaNativeOutputPort;
import info.scce.dime.process.process.Output;
import info.scce.dime.process.process.PrimitiveInputPort;
import info.scce.dime.process.process.PrimitiveOutputPort;
import info.scce.dime.process.process.PrimitiveType;
import info.scce.dime.process.process.ProcessBlueprintSIB;
import info.scce.dime.process.process.ProcessSIB;
import info.scce.dime.process.process.ProcessType;
import info.scce.dime.process.process.RealInputStatic;
import info.scce.dime.process.process.StartSIB;
import info.scce.dime.process.process.TextInputStatic;
import info.scce.dime.process.process.TimestampInputStatic;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class CreateSubmodel extends DIMECustomAction<ProcessBlueprintSIB> {
  private info.scce.dime.process.process.Process process;
  
  private File newFile;
  
  private info.scce.dime.process.process.Process newProcess;
  
  private ProcessSIB newProcessSib;
  
  private ProcessBlueprintSIB sib;
  
  private ProcessType cSibProcessType;
  
  private int actualEndSibX = 350;
  
  @Override
  public String getName() {
    return "Create SubModel from BluePrint";
  }
  
  private void init(final ProcessBlueprintSIB bluePrintSib) {
    this.sib = bluePrintSib;
    this.process = this.sib.getRootElement();
  }
  
  @Override
  public void execute(final ProcessBlueprintSIB bluePrintSib) {
    this.init(bluePrintSib);
    this.createFilePathForNewModel(this.sib);
    boolean overwriteAndContinue = true;
    if (((this.newFile != null) && this.newFile.exists())) {
      overwriteAndContinue = this.showDialog("Target model already exitst", 
        "The file for the target model already exists. Do you want overwrite it?");
    }
    if ((!overwriteAndContinue)) {
      return;
    }
    this.createSubModel(this.sib.getLabel(), this.cSibProcessType);
    this.addStartSib();
    this.addEndSibs();
    if ((this.newProcess != null)) {
      try {
        this.newProcess.eResource().save(null);
      } catch (final Throwable _t) {
        if (_t instanceof IOException) {
          final IOException e = (IOException)_t;
          e.printStackTrace();
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    } else {
      throw new IllegalStateException("could not create new process");
    }
    this.createProcessSib();
    if ((this.newProcessSib != null)) {
      this.copyProcessSibPorts();
      this.createBranches();
      this.deleteBluePrint();
    } else {
      throw new IllegalStateException("could not create ProcessSIB");
    }
  }
  
  private void deleteBluePrint() {
    EList<Branch> _successors = this.sib.<Branch>getSuccessors(Branch.class);
    for (final Branch branch : _successors) {
      branch.delete();
    }
    this.sib.delete();
  }
  
  private void copyProcessSibBranchPorts(final AbstractBranch branch, final Branch cBranch) {
    EList<Output> _outputs = branch.getOutputs();
    for (final Output output : _outputs) {
      {
        Output cOutput = this.addOutput(cBranch, output);
        EList<? extends DataFlow> _outgoing = output.getOutgoing();
        List<Edge> outEdges = new ArrayList<Edge>(_outgoing);
        for (final Edge edge : outEdges) {
          edge.reconnectSource(cOutput);
        }
      }
    }
  }
  
  private Output addOutput(final Branch cBranch, final Output output) {
    if ((output instanceof ComplexOutputPort)) {
      ComplexOutputPort outputPort = ((ComplexOutputPort) output);
      ComplexOutputPort port = cBranch.newComplexOutputPort(outputPort.getDataType(), 0, 0);
      port.setName(outputPort.getName());
      port.setIsList(outputPort.isIsList());
      return port;
    } else {
      if ((output instanceof PrimitiveOutputPort)) {
        PrimitiveOutputPort outputPort_1 = ((PrimitiveOutputPort) output);
        PrimitiveOutputPort port_1 = cBranch.newPrimitiveOutputPort(0, 0);
        port_1.setDataType(outputPort_1.getDataType());
        port_1.setName(outputPort_1.getName());
        port_1.setIsList(outputPort_1.isIsList());
        return port_1;
      } else {
        if ((output instanceof JavaNativeOutputPort)) {
          JavaNativeOutputPort outputPort_2 = ((JavaNativeOutputPort) output);
          JavaNativeOutputPort port_2 = cBranch.newJavaNativeOutputPort(outputPort_2.getDataType(), 0, 0);
          port_2.setName(outputPort_2.getName());
          port_2.setIsList(outputPort_2.isIsList());
          return port_2;
        } else {
          throw new IllegalStateException("unknown port type of output");
        }
      }
    }
  }
  
  private void createBranches() {
    EList<AbstractBranch> _successors = this.sib.<AbstractBranch>getSuccessors(AbstractBranch.class);
    for (final AbstractBranch branch : _successors) {
      {
        ModelElementContainer mec = branch.getContainer();
        if ((mec instanceof info.scce.dime.process.process.Process)) {
          info.scce.dime.process.process.Process container = ((info.scce.dime.process.process.Process) mec);
          Branch newbranch = container.newBranch(branch.getX(), branch.getY());
          newbranch.setName(branch.getName());
          this.newProcessSib.newBranchConnector(newbranch);
          this.copyProcessSibBranchPorts(branch, newbranch);
          EList<ControlFlow> _outgoing = branch.<ControlFlow>getOutgoing(ControlFlow.class);
          for (final ControlFlow cf : _outgoing) {
            cf.reconnectSource(newbranch);
          }
        }
      }
    }
  }
  
  private void copyProcessSibPorts() {
    EList<Input> _inputs = this.sib.getInputs();
    for (final Input input : _inputs) {
      {
        Input cInput = this.addInput(input);
        EList<? extends DataFlow> _incoming = input.getIncoming();
        List<Edge> inEdges = new ArrayList<Edge>(_incoming);
        for (final Edge edge : inEdges) {
          edge.reconnectTarget(cInput);
        }
      }
    }
  }
  
  private Input addInput(final Input input) {
    if ((input instanceof ComplexInputPort)) {
      ComplexInputPort inputPort = ((ComplexInputPort) input);
      ComplexInputPort port = this.newProcessSib.newComplexInputPort(inputPort.getDataType(), 0, 0);
      port.setName(inputPort.getName());
      port.setIsList(inputPort.isIsList());
      return port;
    } else {
      if ((input instanceof PrimitiveInputPort)) {
        PrimitiveInputPort inputPort_1 = ((PrimitiveInputPort) input);
        PrimitiveInputPort port_1 = this.newProcessSib.newPrimitiveInputPort(0, 0);
        port_1.setDataType(inputPort_1.getDataType());
        port_1.setName(inputPort_1.getName());
        port_1.setIsList(inputPort_1.isIsList());
        return port_1;
      } else {
        if ((input instanceof InputStatic)) {
          if ((input instanceof IntegerInputStatic)) {
            IntegerInputStatic inputPort_2 = ((IntegerInputStatic) input);
            IntegerInputStatic port_2 = this.newProcessSib.newIntegerInputStatic(0, 0);
            port_2.setName(inputPort_2.getName());
            port_2.setValue(inputPort_2.getValue());
            return port_2;
          } else {
            if ((input instanceof BooleanInputStatic)) {
              BooleanInputStatic inputPort_3 = ((BooleanInputStatic) input);
              BooleanInputStatic port_3 = this.newProcessSib.newBooleanInputStatic(0, 0);
              port_3.setName(inputPort_3.getName());
              port_3.setValue(inputPort_3.isValue());
              return port_3;
            } else {
              if ((input instanceof TextInputStatic)) {
                TextInputStatic inputPort_4 = ((TextInputStatic) input);
                TextInputStatic port_4 = this.newProcessSib.newTextInputStatic(0, 0);
                port_4.setName(inputPort_4.getName());
                port_4.setValue(inputPort_4.getValue());
                return port_4;
              } else {
                if ((input instanceof RealInputStatic)) {
                  RealInputStatic inputPort_5 = ((RealInputStatic) input);
                  RealInputStatic port_5 = this.newProcessSib.newRealInputStatic(0, 0);
                  port_5.setName(inputPort_5.getName());
                  port_5.setValue(inputPort_5.getValue());
                  return port_5;
                } else {
                  if ((input instanceof TimestampInputStatic)) {
                    TimestampInputStatic inputPort_6 = ((TimestampInputStatic) input);
                    TimestampInputStatic port_6 = this.newProcessSib.newTimestampInputStatic(0, 0);
                    port_6.setName(inputPort_6.getName());
                    port_6.setValue(inputPort_6.getValue());
                    return port_6;
                  }
                }
              }
            }
          }
        } else {
          if ((input instanceof JavaNativeInputPort)) {
            JavaNativeInputPort inputPort_7 = ((JavaNativeInputPort) input);
            JavaNativeInputPort port_7 = this.newProcessSib.newJavaNativeInputPort(inputPort_7.getDataType(), 0, 0);
            port_7.setName(inputPort_7.getName());
            port_7.setIsList(inputPort_7.isIsList());
            return port_7;
          }
        }
      }
    }
    throw new IllegalStateException("unknown port type of input");
  }
  
  private void createProcessSib() {
    ModelElementContainer cMEC = this.sib.getContainer();
    if ((cMEC instanceof info.scce.dime.process.process.Process)) {
      info.scce.dime.process.process.Process cContainer = ((info.scce.dime.process.process.Process) cMEC);
      this.newProcessSib = cContainer.newProcessSIB(this.newProcess, this.sib.getX(), this.sib.getY());
      this.newProcessSib.setLabel(this.sib.getLabel());
      this.init(this.sib);
      EList<Input> _inputs = this.newProcessSib.getInputs();
      for (final Input cInput : _inputs) {
        cInput.delete();
      }
      EList<Branch> _successors = this.newProcessSib.<Branch>getSuccessors(Branch.class);
      for (final Branch cBranch : _successors) {
        cBranch.delete();
      }
      EList<ControlFlow> _incoming = this.sib.<ControlFlow>getIncoming(ControlFlow.class);
      for (final ControlFlow cf : _incoming) {
        cf.reconnectTarget(this.newProcessSib);
      }
    }
  }
  
  private void addEndSibs() {
    EList<BranchBlueprint> _successors = this.sib.<BranchBlueprint>getSuccessors(BranchBlueprint.class);
    for (final BranchBlueprint branch : _successors) {
      {
        EndSIB cEnd = this.newProcess.newEndSIB(this.actualEndSibX, 700);
        cEnd.setBranchName(branch.getName());
        int _actualEndSibX = this.actualEndSibX;
        this.actualEndSibX = (_actualEndSibX + 150);
        EList<Output> _outputs = branch.getOutputs();
        for (final Output output : _outputs) {
          if ((output instanceof ComplexOutputPort)) {
            ComplexOutputPort outputPort = ((ComplexOutputPort) output);
            ComplexInputPort inputPort = cEnd.newComplexInputPort(outputPort.getDataType(), 0, 0);
            inputPort.setName(outputPort.getName());
            inputPort.setIsList(outputPort.isIsList());
          } else {
            if ((output instanceof PrimitiveOutputPort)) {
              PrimitiveOutputPort outputPort_1 = ((PrimitiveOutputPort) output);
              PrimitiveInputPort inputPort_1 = cEnd.newPrimitiveInputPort(0, 0);
              inputPort_1.setDataType(outputPort_1.getDataType());
              inputPort_1.setName(outputPort_1.getName());
              inputPort_1.setIsList(outputPort_1.isIsList());
            } else {
              if ((output instanceof JavaNativeOutputPort)) {
                JavaNativeOutputPort outputPort_2 = ((JavaNativeOutputPort) output);
                JavaNativeInputPort inputPort_2 = cEnd.newJavaNativeInputPort(outputPort_2.getDataType(), 0, 0);
                inputPort_2.setName(outputPort_2.getName());
                inputPort_2.setIsList(outputPort_2.isIsList());
              } else {
                throw new IllegalStateException("unknown port type of output");
              }
            }
          }
        }
      }
    }
  }
  
  private void addStartSib() {
    StartSIB start = this.newProcess.newStartSIB(350, 50);
    EList<Input> _inputs = this.sib.getInputs();
    for (final Input input : _inputs) {
      if ((input instanceof ComplexInputPort)) {
        ComplexInputPort inputPort = ((ComplexInputPort) input);
        ComplexOutputPort outputPort = start.newComplexOutputPort(inputPort.getDataType(), 0, 0);
        outputPort.setName(inputPort.getName());
        outputPort.setIsList(inputPort.isIsList());
      } else {
        if ((input instanceof PrimitiveInputPort)) {
          PrimitiveInputPort inputPort_1 = ((PrimitiveInputPort) input);
          PrimitiveOutputPort outputPort_1 = start.newPrimitiveOutputPort(0, 0);
          outputPort_1.setName(inputPort_1.getName());
          outputPort_1.setIsList(inputPort_1.isIsList());
          outputPort_1.setDataType(inputPort_1.getDataType());
        } else {
          if ((input instanceof InputStatic)) {
            InputStatic inputPort_2 = ((InputStatic) input);
            PrimitiveOutputPort outputPort_2 = start.newPrimitiveOutputPort(0, 0);
            outputPort_2.setName(inputPort_2.getName());
            outputPort_2.setIsList(false);
            if ((inputPort_2 instanceof IntegerInputStatic)) {
              outputPort_2.setDataType(
                PrimitiveType.INTEGER);
            } else {
              if ((inputPort_2 instanceof BooleanInputStatic)) {
                outputPort_2.setDataType(
                  PrimitiveType.BOOLEAN);
              } else {
                if ((inputPort_2 instanceof TextInputStatic)) {
                  outputPort_2.setDataType(
                    PrimitiveType.TEXT);
                } else {
                  if ((inputPort_2 instanceof RealInputStatic)) {
                    outputPort_2.setDataType(
                      PrimitiveType.REAL);
                  } else {
                    if ((inputPort_2 instanceof TimestampInputStatic)) {
                      outputPort_2.setDataType(
                        PrimitiveType.TIMESTAMP);
                    }
                  }
                }
              }
            }
          } else {
            if ((input instanceof JavaNativeInputPort)) {
              JavaNativeInputPort inputPort_3 = ((JavaNativeInputPort) input);
              JavaNativeOutputPort outputPort_3 = start.newJavaNativeOutputPort(inputPort_3.getDataType(), 0, 0);
              outputPort_3.setName(inputPort_3.getName());
              outputPort_3.setIsList(inputPort_3.isIsList());
            } else {
              throw new IllegalStateException("unknown port type of input");
            }
          }
        }
      }
    }
  }
  
  private void createFilePathForNewModel(final ProcessBlueprintSIB sib) {
    URI resolvedFile = CommonPlugin.resolve(EcoreUtil.getURI(sib.getRootElement()));
    IFile file = this._workspaceExtension.getFile(resolvedFile);
    IPath newPath = file.getParent().getFullPath().append(sib.getLabel()).addFileExtension("process");
    String _string = this._workspaceExtension.getWorkspaceRoot().getLocation().append(newPath).toString();
    File _file = new File(_string);
    this.newFile = _file;
  }
  
  private void createSubModel(final String name, final ProcessType type) {
    final Consumer<StartSIB> _function = new Consumer<StartSIB>() {
      @Override
      public void accept(final StartSIB s) {
        s.delete();
      }
    };
    this.newProcess.getStartSIBs().forEach(_function);
    final Consumer<EndSIB> _function_1 = new Consumer<EndSIB>() {
      @Override
      public void accept(final EndSIB e) {
        e.delete();
      }
    };
    this.newProcess.getEndSIBs().forEach(_function_1);
    final Consumer<DataContext> _function_2 = new Consumer<DataContext>() {
      @Override
      public void accept(final DataContext c) {
        c.delete();
      }
    };
    this.newProcess.getDataContexts().forEach(_function_2);
    this.newProcess.setProcessType(type);
    this.newProcess.newDataContext(50, 50, 180, 800);
  }
  
  private boolean showDialog(final String title, final String msg) {
    return CincoMessageHandler.showQuestion(msg, title, true);
  }
}
