/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.actions;

import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.runtime.action.CincoCustomAction;
import graphmodel.ModelElementContainer;
import graphmodel.Node;
import info.scce.dime.process.process.Branch;
import info.scce.dime.process.process.ComplexInputPort;
import info.scce.dime.process.process.ComplexOutputPort;
import info.scce.dime.process.process.ComplexVariable;
import info.scce.dime.process.process.DataContext;
import info.scce.dime.process.process.DataFlow;
import info.scce.dime.process.process.DataFlowTarget;
import info.scce.dime.process.process.EventListener;
import info.scce.dime.process.process.InputPort;
import info.scce.dime.process.process.JavaNativeInputPort;
import info.scce.dime.process.process.JavaNativeOutputPort;
import info.scce.dime.process.process.JavaNativeVariable;
import info.scce.dime.process.process.OutputPort;
import info.scce.dime.process.process.PrimitiveInputPort;
import info.scce.dime.process.process.PrimitiveOutputPort;
import info.scce.dime.process.process.PrimitiveVariable;
import info.scce.dime.process.process.Read;
import info.scce.dime.process.process.Update;
import info.scce.dime.process.process.Variable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class CreateInputDataContext extends CincoCustomAction<Node> {
  @Override
  public String getName() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Create/Update input data context");
    return _builder.toString();
  }
  
  @Override
  public boolean canExecute(final Node node) {
    return ((node.getContainer() instanceof info.scce.dime.process.process.Process) && IterableExtensions.<InputPort>exists(this.getInputPorts(node), new Function1<InputPort, Boolean>() {
      @Override
      public Boolean apply(final InputPort it) {
        final Function1<Node, Boolean> _function = new Function1<Node, Boolean>() {
          @Override
          public Boolean apply(final Node it) {
            return Boolean.valueOf((it instanceof Variable));
          }
        };
        boolean _exists = IterableExtensions.exists(it.getPredecessors(), _function);
        return Boolean.valueOf((!_exists));
      }
    }));
  }
  
  @Override
  public void execute(final Node sib) {
    ModelElementContainer _container = sib.getContainer();
    final info.scce.dime.process.process.Process container = ((info.scce.dime.process.process.Process) _container);
    final Function1<InputPort, Boolean> _function = new Function1<InputPort, Boolean>() {
      @Override
      public Boolean apply(final InputPort it) {
        final Function1<Node, Boolean> _function = new Function1<Node, Boolean>() {
          @Override
          public Boolean apply(final Node it) {
            return Boolean.valueOf((it instanceof Variable));
          }
        };
        boolean _exists = IterableExtensions.exists(it.getPredecessors(), _function);
        return Boolean.valueOf((!_exists));
      }
    };
    final Function1<InputPort, Integer> _function_1 = new Function1<InputPort, Integer>() {
      @Override
      public Integer apply(final InputPort it) {
        return Integer.valueOf(it.getY());
      }
    };
    final List<InputPort> ports = IterableExtensions.<InputPort, Integer>sortBy(IterableExtensions.<InputPort>filter(this.getInputPorts(sib), _function), _function_1);
    DataContext _elvis = null;
    DataContext _inputDataContext = this.getInputDataContext(this.getInputPorts(sib));
    if (_inputDataContext != null) {
      _elvis = _inputDataContext;
    } else {
      int _x = sib.getX();
      int _minus = (_x - 30);
      DataContext _newDataContext = container.newDataContext(_minus, sib.getY(), 30, sib.getHeight());
      _elvis = _newDataContext;
    }
    final DataContext dataContext = _elvis;
    for (final InputPort port : ports) {
      {
        Variable _newVariable = this.newVariable(dataContext, port);
        final Procedure1<Variable> _function_2 = new Procedure1<Variable>() {
          @Override
          public void apply(final Variable it) {
            it.resize(10, 10);
            String _name = port.getName();
            String _id = port.getId();
            String _plus = (_name + _id);
            it.setName(_plus);
            it.setIsList(port.isIsList());
          }
        };
        final Variable variable = ObjectExtensions.<Variable>operator_doubleArrow(_newVariable, _function_2);
        DataFlow _head = IterableExtensions.head(port.getIncoming());
        Node _sourceElement = null;
        if (_head!=null) {
          _sourceElement=_head.getSourceElement();
        }
        final Node source = _sourceElement;
        if ((source instanceof OutputPort)) {
          IterableExtensions.head(port.getIncoming()).delete();
          this.newUpdate(((OutputPort)source), variable);
        }
        this.newRead(variable, port);
      }
    }
    int xOffset = 10;
    List<InputPort> _inputPorts = this.getInputPorts(sib);
    for (final InputPort port_1 : _inputPorts) {
      {
        final Variable variable = this.getInputVariable(port_1);
        boolean _isGenerated = false;
        if (variable!=null) {
          _isGenerated=this.isGenerated(variable);
        }
        if (_isGenerated) {
          variable.move(xOffset, this.getAlignedY(port_1));
          int _xOffset = xOffset;
          xOffset = (_xOffset + 10);
        }
      }
    }
    int _size = dataContext.getVariables().size();
    int _multiply = (_size * 10);
    final int width = (20 + _multiply);
    int _x_1 = sib.getX();
    int _minus_1 = (_x_1 - width);
    dataContext.move(_minus_1, sib.getY());
    dataContext.resize(width, sib.getHeight());
  }
  
  public List<InputPort> getInputPorts(final Node node) {
    List<InputPort> _switchResult = null;
    boolean _matched = false;
    if (node instanceof DataFlowTarget) {
      _matched=true;
      _switchResult = ((DataFlowTarget)node).getInputPorts();
    }
    if (!_matched) {
      if (node instanceof EventListener) {
        _matched=true;
        _switchResult = ((EventListener)node).getInputPorts();
      }
    }
    if (!_matched) {
      _switchResult = Collections.<InputPort>unmodifiableList(CollectionLiterals.<InputPort>newArrayList());
    }
    return _switchResult;
  }
  
  public DataContext getInputDataContext(final Iterable<InputPort> inputPorts) {
    for (final InputPort port : inputPorts) {
      {
        final Variable variable = this.getInputVariable(port);
        boolean _isGenerated = false;
        if (variable!=null) {
          _isGenerated=this.isGenerated(variable);
        }
        if (_isGenerated) {
          return variable.getContainer();
        }
      }
    }
    return null;
  }
  
  public Variable getInputVariable(final InputPort port) {
    return IterableExtensions.<Variable>head(Iterables.<Variable>filter(port.getPredecessors(), Variable.class));
  }
  
  public boolean isGenerated(final Variable variable) {
    return ((variable.getWidth() == 10) && (variable.getHeight() == 10));
  }
  
  public void layout(final List<Branch> branches, final int newY) {
    for (final Branch branch : branches) {
      branch.moveTo(branch.getRootElement(), branch.getX(), newY);
    }
  }
  
  protected Variable _newVariable(final DataContext dataContext, final ComplexInputPort port) {
    return dataContext.newComplexVariable(port.getDataType(), 10, this.getAlignedY(port));
  }
  
  protected Variable _newVariable(final DataContext dataContext, final PrimitiveInputPort port) {
    PrimitiveVariable _newPrimitiveVariable = dataContext.newPrimitiveVariable(10, this.getAlignedY(port));
    final Procedure1<PrimitiveVariable> _function = new Procedure1<PrimitiveVariable>() {
      @Override
      public void apply(final PrimitiveVariable it) {
        it.setDataType(port.getDataType());
      }
    };
    return ObjectExtensions.<PrimitiveVariable>operator_doubleArrow(_newPrimitiveVariable, _function);
  }
  
  protected Variable _newVariable(final DataContext dataContext, final JavaNativeInputPort port) {
    JavaNativeVariable _newJavaNativeVariable = dataContext.newJavaNativeVariable(port.getDataType(), 10, this.getAlignedY(port));
    final Procedure1<JavaNativeVariable> _function = new Procedure1<JavaNativeVariable>() {
      @Override
      public void apply(final JavaNativeVariable it) {
      }
    };
    return ObjectExtensions.<JavaNativeVariable>operator_doubleArrow(_newJavaNativeVariable, _function);
  }
  
  protected Variable _newVariable(final DataContext dataContext, final InputPort port) {
    this._codingExtension.warn(this, ("Unmatched input port: " + port));
    return null;
  }
  
  protected Update _newUpdate(final ComplexOutputPort source, final ComplexVariable target) {
    return source.newComplexUpdate(target);
  }
  
  protected Update _newUpdate(final PrimitiveOutputPort source, final PrimitiveVariable target) {
    return source.newPrimitiveUpdate(target);
  }
  
  protected Update _newUpdate(final JavaNativeOutputPort source, final JavaNativeVariable target) {
    return source.newJavaNativeUpdate(target);
  }
  
  protected Update _newUpdate(final OutputPort source, final Variable target) {
    Class<? extends OutputPort> _class = source.getClass();
    String _plus = ("Unmatched types: " + _class);
    String _plus_1 = (_plus + " and ");
    Class<? extends Variable> _class_1 = target.getClass();
    String _plus_2 = (_plus_1 + _class_1);
    this._codingExtension.warn(this, _plus_2);
    return null;
  }
  
  protected Read _newRead(final ComplexVariable source, final ComplexInputPort target) {
    return source.newComplexRead(target);
  }
  
  protected Read _newRead(final PrimitiveVariable source, final PrimitiveInputPort target) {
    return source.newPrimitiveRead(target);
  }
  
  protected Read _newRead(final JavaNativeVariable source, final JavaNativeInputPort target) {
    return source.newJavaNativeRead(target);
  }
  
  protected Read _newRead(final Variable source, final InputPort target) {
    Class<? extends Variable> _class = source.getClass();
    String _plus = ("Unmatched types: " + _class);
    String _plus_1 = (_plus + " and ");
    Class<? extends InputPort> _class_1 = target.getClass();
    String _plus_2 = (_plus_1 + _class_1);
    this._codingExtension.warn(this, _plus_2);
    return null;
  }
  
  public int getAlignedY(final Node node) {
    int _y = node.getY();
    int _height = node.getHeight();
    int _divide = (_height / 2);
    int _plus = (_y + _divide);
    return (_plus - 5);
  }
  
  public Variable newVariable(final DataContext dataContext, final InputPort port) {
    if (port instanceof ComplexInputPort) {
      return _newVariable(dataContext, (ComplexInputPort)port);
    } else if (port instanceof JavaNativeInputPort) {
      return _newVariable(dataContext, (JavaNativeInputPort)port);
    } else if (port instanceof PrimitiveInputPort) {
      return _newVariable(dataContext, (PrimitiveInputPort)port);
    } else if (port != null) {
      return _newVariable(dataContext, port);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(dataContext, port).toString());
    }
  }
  
  public Update newUpdate(final OutputPort source, final Variable target) {
    if (source instanceof ComplexOutputPort
         && target instanceof ComplexVariable) {
      return _newUpdate((ComplexOutputPort)source, (ComplexVariable)target);
    } else if (source instanceof JavaNativeOutputPort
         && target instanceof JavaNativeVariable) {
      return _newUpdate((JavaNativeOutputPort)source, (JavaNativeVariable)target);
    } else if (source instanceof PrimitiveOutputPort
         && target instanceof PrimitiveVariable) {
      return _newUpdate((PrimitiveOutputPort)source, (PrimitiveVariable)target);
    } else if (source != null
         && target != null) {
      return _newUpdate(source, target);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(source, target).toString());
    }
  }
  
  public Read newRead(final Variable source, final InputPort target) {
    if (source instanceof ComplexVariable
         && target instanceof ComplexInputPort) {
      return _newRead((ComplexVariable)source, (ComplexInputPort)target);
    } else if (source instanceof JavaNativeVariable
         && target instanceof JavaNativeInputPort) {
      return _newRead((JavaNativeVariable)source, (JavaNativeInputPort)target);
    } else if (source instanceof PrimitiveVariable
         && target instanceof PrimitiveInputPort) {
      return _newRead((PrimitiveVariable)source, (PrimitiveInputPort)target);
    } else if (source != null
         && target != null) {
      return _newRead(source, target);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(source, target).toString());
    }
  }
}
