/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.actions;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.utils.messages.CincoMessageHandler;
import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.data.data.PrimitiveType;
import info.scce.dime.gui.gui.ComplexOutputPort;
import info.scce.dime.gui.gui.Event;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.gui.gui.ListenerContext;
import info.scce.dime.gui.gui.OutputPort;
import info.scce.dime.gui.gui.PrimitiveOutputPort;
import info.scce.dime.gui.gui.RealInputStatic;
import info.scce.dime.process.process.BooleanInputStatic;
import info.scce.dime.process.process.ComplexInputPort;
import info.scce.dime.process.process.EventListener;
import info.scce.dime.process.process.GUISIB;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.InputPort;
import info.scce.dime.process.process.InputStatic;
import info.scce.dime.process.process.IntegerInputStatic;
import info.scce.dime.process.process.PrimitiveInputPort;
import info.scce.dime.process.process.ProcessType;
import info.scce.dime.process.process.TextInputStatic;
import info.scce.dime.process.process.TimestampInputStatic;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class CreateGUIEventListener extends DIMECustomAction<GUISIB> {
  @Override
  public String getName() {
    return "Update Event Listeners";
  }
  
  @Override
  public boolean canExecute(final GUISIB guiSib) throws ClassCastException {
    ProcessType _processType = guiSib.getRootElement().getProcessType();
    boolean _tripleNotEquals = (_processType != ProcessType.BASIC);
    if (_tripleNotEquals) {
      return false;
    }
    GUI gui = guiSib.getGui();
    if ((IterableExtensions.isEmpty(Iterables.<Event>concat(ListExtensions.<ListenerContext, EList<Event>>map(gui.getListenerContexts(), new Function1<ListenerContext, EList<Event>>() {
      @Override
      public EList<Event> apply(final ListenerContext it) {
        return it.getEvents();
      }
    }))) && guiSib.getEventListenerSuccessors().isEmpty())) {
      return false;
    }
    return true;
  }
  
  @Override
  public void execute(final GUISIB guiSib) {
    GUI gui = guiSib.getGui();
    if ((gui == null)) {
      this.showDialog("Reference is null", "Reference is null!");
      return;
    }
    final Function1<ListenerContext, EList<Event>> _function = new Function1<ListenerContext, EList<Event>>() {
      @Override
      public EList<Event> apply(final ListenerContext it) {
        return it.getEvents();
      }
    };
    final Iterable<Event> events = Iterables.<Event>concat(ListExtensions.<ListenerContext, EList<Event>>map(gui.getListenerContexts(), _function));
    int _maxX = this.maxX(guiSib.getEventListenerSuccessors());
    int x = (_maxX + 140);
    int y = this.maxY(guiSib.getEventListenerSuccessors());
    for (final Event evt : events) {
      {
        final Function1<EventListener, Boolean> _function_1 = new Function1<EventListener, Boolean>() {
          @Override
          public Boolean apply(final EventListener it) {
            return Boolean.valueOf(it.getName().equals(evt.getName()));
          }
        };
        final EventListener guiListener = IterableExtensions.<EventListener>findFirst(guiSib.getEventListenerSuccessors(), _function_1);
        if ((guiListener == null)) {
          EventListener el = guiSib.getRootElement().newEventListener(x, y);
          el.setName(evt.getName());
          EList<OutputPort> _outputPorts = evt.getOutputPorts();
          for (final OutputPort port : _outputPorts) {
            {
              if ((port instanceof ComplexOutputPort)) {
                ComplexInputPort p = el.newComplexInputPort(((ComplexOutputPort)port).getDataType(), 0, 0);
                p.setIsList(((ComplexOutputPort)port).isIsList());
                p.setName(((ComplexOutputPort)port).getName());
              }
              if ((port instanceof PrimitiveOutputPort)) {
                PrimitiveInputPort p_1 = el.newPrimitiveInputPort(0, 0);
                p_1.setName(((PrimitiveOutputPort)port).getName());
                p_1.setIsList(((PrimitiveOutputPort)port).isIsList());
                p_1.setDataType(this._gUIExtension.toProcess(this._dataExtension.toData(((PrimitiveOutputPort)port).getDataType())));
              }
            }
          }
          int _x = x;
          x = (_x + 140);
          guiSib.newEventConnector(el);
        } else {
          EList<OutputPort> _outputPorts_1 = evt.getOutputPorts();
          for (final OutputPort guiPort : _outputPorts_1) {
            {
              final Function1<Input, Boolean> _function_2 = new Function1<Input, Boolean>() {
                @Override
                public Boolean apply(final Input it) {
                  return Boolean.valueOf(it.getName().equals(guiPort.getName()));
                }
              };
              final Input evtPort = IterableExtensions.<Input>findFirst(guiListener.getInputs(), _function_2);
              if ((evtPort == null)) {
                if ((guiPort instanceof ComplexOutputPort)) {
                  ComplexInputPort p = guiListener.newComplexInputPort(((ComplexOutputPort)guiPort).getDataType(), 0, 0);
                  p.setIsList(((ComplexOutputPort)guiPort).isIsList());
                  p.setName(((ComplexOutputPort)guiPort).getName());
                }
                if ((guiPort instanceof PrimitiveOutputPort)) {
                  PrimitiveInputPort p_1 = guiListener.newPrimitiveInputPort(0, 0);
                  p_1.setName(((PrimitiveOutputPort)guiPort).getName());
                  p_1.setIsList(((PrimitiveOutputPort)guiPort).isIsList());
                  p_1.setDataType(this._gUIExtension.toProcess(this._dataExtension.toData(((PrimitiveOutputPort)guiPort).getDataType())));
                }
              } else {
                if (((guiPort instanceof ComplexOutputPort) && (!(evtPort instanceof ComplexInputPort)))) {
                  evtPort.delete();
                  ComplexInputPort p_2 = guiListener.newComplexInputPort(((ComplexOutputPort) guiPort).getDataType(), 0, 0);
                  p_2.setIsList(guiPort.isIsList());
                  p_2.setName(guiPort.getName());
                }
                if (((guiPort instanceof PrimitiveOutputPort) && (evtPort instanceof ComplexInputPort))) {
                  evtPort.delete();
                  PrimitiveInputPort p_3 = guiListener.newPrimitiveInputPort(0, 0);
                  p_3.setName(guiPort.getName());
                  p_3.setIsList(guiPort.isIsList());
                  p_3.setDataType(this._gUIExtension.toProcess(this._dataExtension.toData(((PrimitiveOutputPort) guiPort).getDataType())));
                }
                if ((evtPort instanceof InputStatic)) {
                  final PrimitiveOutputPort pop = ((PrimitiveOutputPort) guiPort);
                  boolean _switchResult = false;
                  boolean _matched = false;
                  if (evtPort instanceof IntegerInputStatic) {
                    _matched=true;
                    PrimitiveType _data = this._dataExtension.toData(pop.getDataType());
                    _switchResult = (!Objects.equal(_data, PrimitiveType.INTEGER));
                  }
                  if (!_matched) {
                    if (evtPort instanceof TextInputStatic) {
                      _matched=true;
                      PrimitiveType _data = this._dataExtension.toData(pop.getDataType());
                      _switchResult = (!Objects.equal(_data, PrimitiveType.TEXT));
                    }
                  }
                  if (!_matched) {
                    if (evtPort instanceof RealInputStatic) {
                      _matched=true;
                      PrimitiveType _data = this._dataExtension.toData(pop.getDataType());
                      _switchResult = (!Objects.equal(_data, PrimitiveType.REAL));
                    }
                  }
                  if (!_matched) {
                    if (evtPort instanceof TimestampInputStatic) {
                      _matched=true;
                      PrimitiveType _data = this._dataExtension.toData(pop.getDataType());
                      _switchResult = (!Objects.equal(_data, PrimitiveType.TIMESTAMP));
                    }
                  }
                  if (!_matched) {
                    if (evtPort instanceof BooleanInputStatic) {
                      _matched=true;
                      PrimitiveType _data = this._dataExtension.toData(pop.getDataType());
                      _switchResult = (!Objects.equal(_data, PrimitiveType.BOOLEAN));
                    }
                  }
                  final boolean needsRebuild = _switchResult;
                  if (needsRebuild) {
                    ((InputStatic)evtPort).delete();
                    PrimitiveInputPort p_4 = guiListener.newPrimitiveInputPort(0, 0);
                    p_4.setName(pop.getName());
                    p_4.setIsList(pop.isIsList());
                    p_4.setDataType(this._gUIExtension.toProcess(this._dataExtension.toData(pop.getDataType())));
                  }
                }
                if ((evtPort instanceof InputPort)) {
                  ((InputPort)evtPort).setIsList(guiPort.isIsList());
                  if (((evtPort instanceof ComplexInputPort) && (this._dataExtension.getOriginalType(((ComplexInputPort) evtPort).getDataType()) != this._dataExtension.getOriginalType(((ComplexOutputPort) guiPort).getDataType())))) {
                    ((InputPort)evtPort).delete();
                    ComplexInputPort p_5 = guiListener.newComplexInputPort(((ComplexOutputPort) guiPort).getDataType(), 0, 0);
                    p_5.setIsList(guiPort.isIsList());
                    p_5.setName(guiPort.getName());
                  }
                  if (((evtPort instanceof PrimitiveInputPort) && (this._dataExtension.toData(((PrimitiveInputPort) evtPort).getDataType()) != this._dataExtension.toData(((PrimitiveOutputPort) guiPort).getDataType())))) {
                    ((InputPort)evtPort).delete();
                    PrimitiveInputPort p_6 = guiListener.newPrimitiveInputPort(0, 0);
                    p_6.setName(guiPort.getName());
                    p_6.setIsList(guiPort.isIsList());
                    p_6.setDataType(this._gUIExtension.toProcess(this._dataExtension.toData(((PrimitiveOutputPort) guiPort).getDataType())));
                  }
                }
              }
            }
          }
          final Function1<Input, Boolean> _function_2 = new Function1<Input, Boolean>() {
            @Override
            public Boolean apply(final Input i) {
              final Function1<OutputPort, Boolean> _function = new Function1<OutputPort, Boolean>() {
                @Override
                public Boolean apply(final OutputPort it) {
                  return Boolean.valueOf(it.getName().equals(i.getName()));
                }
              };
              boolean _exists = IterableExtensions.<OutputPort>exists(evt.getOutputPorts(), _function);
              return Boolean.valueOf((!_exists));
            }
          };
          final Consumer<Input> _function_3 = new Consumer<Input>() {
            @Override
            public void accept(final Input it) {
              it.delete();
            }
          };
          IterableExtensions.<Input>filter(guiListener.getInputs(), _function_2).forEach(_function_3);
        }
      }
    }
    final Function1<EventListener, Boolean> _function_1 = new Function1<EventListener, Boolean>() {
      @Override
      public Boolean apply(final EventListener l) {
        final Function1<Event, Boolean> _function = new Function1<Event, Boolean>() {
          @Override
          public Boolean apply(final Event it) {
            return Boolean.valueOf(it.getName().equals(l.getName()));
          }
        };
        boolean _exists = IterableExtensions.<Event>exists(events, _function);
        return Boolean.valueOf((!_exists));
      }
    };
    final Consumer<EventListener> _function_2 = new Consumer<EventListener>() {
      @Override
      public void accept(final EventListener it) {
        it.delete();
      }
    };
    IterableExtensions.<EventListener>filter(guiSib.getEventListenerSuccessors(), _function_1).forEach(_function_2);
  }
  
  public int maxY(final List<EventListener> list) {
    int maxY = 0;
    for (final EventListener event : list) {
      int _y = event.getY();
      boolean _greaterThan = (_y > maxY);
      if (_greaterThan) {
        maxY = event.getY();
      }
    }
    return maxY;
  }
  
  public int maxX(final List<EventListener> list) {
    int maxX = 0;
    for (final EventListener event : list) {
      int _x = event.getX();
      boolean _greaterThan = (_x > maxX);
      if (_greaterThan) {
        maxX = event.getX();
      }
    }
    return maxX;
  }
  
  private boolean showDialog(final String title, final String msg) {
    return CincoMessageHandler.showQuestion(msg, title, true);
  }
}
