/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.actions;

import de.jabc.cinco.meta.core.utils.messages.CincoMessageHandler;
import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.data.data.Type;
import info.scce.dime.data.helper.JavaIdentifierUtils;
import info.scce.dime.process.process.AbstractBranch;
import info.scce.dime.process.process.BooleanInputStatic;
import info.scce.dime.process.process.ComplexInputPort;
import info.scce.dime.process.process.ComplexOutputPort;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.InputPort;
import info.scce.dime.process.process.IntegerInputStatic;
import info.scce.dime.process.process.NativeFrontendSIB;
import info.scce.dime.process.process.NativeFrontendSIBLibrary;
import info.scce.dime.process.process.NativeFrontendSibType;
import info.scce.dime.process.process.Output;
import info.scce.dime.process.process.OutputPort;
import info.scce.dime.process.process.PrimitiveInputPort;
import info.scce.dime.process.process.PrimitiveOutputPort;
import info.scce.dime.process.process.PrimitiveType;
import info.scce.dime.process.process.RealInputStatic;
import info.scce.dime.process.process.TextInputStatic;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class CreateDartTemplate extends DIMECustomAction<NativeFrontendSIBLibrary> {
  private NativeFrontendSIBLibrary sib;
  
  private Set<String> imports = new HashSet<String>();
  
  @Override
  public String getName() {
    return "Create Dart template from Model";
  }
  
  @Override
  public boolean canExecute(final NativeFrontendSIBLibrary s) {
    int _size = s.getModelElements().size();
    return (_size > 0);
  }
  
  private void init(final NativeFrontendSIBLibrary nfsl) {
    this.sib = nfsl;
  }
  
  @Override
  public void execute(final NativeFrontendSIBLibrary nfsl) {
    this.init(nfsl);
    boolean overwriteAndContinue = true;
    boolean _exists = this._workspaceExtension.getProject(this.sib).exists(this._workspaceExtension.toPath(this.sib.getClassName()));
    if (_exists) {
      overwriteAndContinue = this.showDialog("Target already exitst", 
        "The file for the target source code already exists. Do you want overwrite it?");
    }
    if ((!overwriteAndContinue)) {
      return;
    }
    String _className = this.sib.getClassName();
    final String className = new File(_className).getName();
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("class ");
    String _escapeDart = JavaIdentifierUtils.escapeDart(className.replace(".dart", ""));
    _builder.append(_escapeDart);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    {
      EList<NativeFrontendSIB> _nativeFrontendSIBs = this.sib.getNativeFrontendSIBs();
      for(final NativeFrontendSIB it : _nativeFrontendSIBs) {
        String _switchResult = null;
        NativeFrontendSibType _sibType = it.getSibType();
        if (_sibType != null) {
          switch (_sibType) {
            case BOOL:
              _switchResult = "bool";
              break;
            case VOID:
              _switchResult = "void";
              break;
            case COMPLEX:
              final Function1<AbstractBranch, Boolean> _function = new Function1<AbstractBranch, Boolean>() {
                @Override
                public Boolean apply(final AbstractBranch it) {
                  int _compareToIgnoreCase = it.getName().compareToIgnoreCase("success");
                  return Boolean.valueOf((_compareToIgnoreCase == 0));
                }
              };
              _switchResult = CreateDartTemplate.getVariableTypeFromOutput(IterableExtensions.<Output>head(IterableExtensions.<AbstractBranch>findFirst(it.getAbstractBranchSuccessors(), _function).getOutputs()), this.imports);
              break;
            default:
              break;
          }
        }
        _builder.append(_switchResult);
        _builder.append(" ");
        String _escapeDart_1 = JavaIdentifierUtils.escapeDart(it.getMethodName());
        _builder.append(_escapeDart_1);
        _builder.append("(");
        {
          EList<Input> _inputs = it.getInputs();
          boolean _hasElements = false;
          for(final Input input : _inputs) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate(",", "");
            }
            String _parameterType = CreateDartTemplate.getParameterType(input, this.imports);
            _builder.append(_parameterType);
            _builder.append(" ");
            String _name = input.getName();
            _builder.append(_name);
          }
          if (_hasElements) {
            _builder.append("");
          }
        }
        _builder.append("){");
        _builder.newLineIfNotEmpty();
        _builder.append("                ");
        _builder.append("// implement here");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    final String template = _builder.toString();
    StringConcatenation _builder_1 = new StringConcatenation();
    _builder_1.append("import \'package:angular2/core.dart\';");
    _builder_1.newLine();
    {
      boolean _hasElements_1 = false;
      for(final String imp : this.imports) {
        if (!_hasElements_1) {
          _hasElements_1 = true;
        } else {
          _builder_1.appendImmediate("\n", "");
        }
        _builder_1.append("import \'package:app/models/");
        String _escapeDart_2 = JavaIdentifierUtils.escapeDart(imp);
        _builder_1.append(_escapeDart_2);
        _builder_1.append(".dart\';");
      }
    }
    final String importText = _builder_1.toString();
    this._workspaceExtension.createFile(this._workspaceExtension.getProject(this.sib), this.sib.getClassName(), ((importText + "\n") + template), true);
  }
  
  public static String getVariableTypeFromOutput(final Output output, final Set<String> imports) {
    String type = "var";
    if ((output instanceof PrimitiveOutputPort)) {
      PrimitiveType _dataType = ((PrimitiveOutputPort)output).getDataType();
      if (_dataType != null) {
        switch (_dataType) {
          case BOOLEAN:
            type = "bool";
            break;
          case INTEGER:
            type = "int";
            break;
          case REAL:
            type = "double";
            break;
          case TEXT:
            type = "String";
            break;
          case TIMESTAMP:
          case FILE:
          default:
            throw new IllegalArgumentException("currently not supported type");
        }
      } else {
        throw new IllegalArgumentException("currently not supported type");
      }
    } else {
      if ((output instanceof ComplexOutputPort)) {
        final Type dataType = ((ComplexOutputPort)output).getDataType();
        imports.add(dataType.getRootElement().getModelName());
        type = JavaIdentifierUtils.escapeDart(dataType.getName());
      }
    }
    if ((output instanceof OutputPort)) {
      boolean _isIsList = ((OutputPort)output).isIsList();
      if (_isIsList) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("List<");
        _builder.append(type);
        _builder.append(">");
        type = _builder.toString();
      }
    }
    return type;
  }
  
  public static String getParameterType(final Input input, final Set<String> imports) {
    String type = "ERROR";
    if ((input instanceof PrimitiveInputPort)) {
      PrimitiveType _dataType = ((PrimitiveInputPort)input).getDataType();
      if (_dataType != null) {
        switch (_dataType) {
          case BOOLEAN:
            type = "bool";
            break;
          case INTEGER:
            type = "int";
            break;
          case REAL:
            type = "double";
            break;
          case TEXT:
            type = "String";
            break;
          case TIMESTAMP:
          case FILE:
          default:
            throw new IllegalArgumentException("currently not supported type");
        }
      } else {
        throw new IllegalArgumentException("currently not supported type");
      }
    } else {
      if ((input instanceof BooleanInputStatic)) {
        type = "bool";
      } else {
        if ((input instanceof IntegerInputStatic)) {
          type = "int";
        } else {
          if ((input instanceof RealInputStatic)) {
            type = "double";
          } else {
            if ((input instanceof TextInputStatic)) {
              type = "String";
            } else {
              if ((input instanceof ComplexInputPort)) {
                final Type dataType = ((ComplexInputPort)input).getDataType();
                imports.add(dataType.getRootElement().getModelName());
                type = JavaIdentifierUtils.escapeDart(dataType.getName());
              }
            }
          }
        }
      }
    }
    if ((input instanceof InputPort)) {
      boolean _isIsList = ((InputPort)input).isIsList();
      if (_isIsList) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("List<");
        _builder.append(type);
        _builder.append(">");
        type = _builder.toString();
      }
    }
    return type;
  }
  
  private boolean showDialog(final String title, final String msg) {
    return CincoMessageHandler.showQuestion(msg, title, true);
  }
}
