/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.actions;

import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.process.process.Branch;
import info.scce.dime.process.process.TriggerEventSIB;

@SuppressWarnings("all")
public class CreateBranch extends DIMECustomAction<TriggerEventSIB> {
  @Override
  public String getName() {
    return "Create Branches";
  }
  
  @Override
  public boolean canExecute(final TriggerEventSIB sib) {
    return sib.getBranchSuccessors().isEmpty();
  }
  
  @Override
  public void execute(final TriggerEventSIB sib) {
    boolean _isEmpty = sib.getBranchSuccessors().isEmpty();
    if (_isEmpty) {
      info.scce.dime.process.process.Process _rootElement = sib.getRootElement();
      final info.scce.dime.process.process.Process cProcess = ((info.scce.dime.process.process.Process) _rootElement);
      int _x = sib.getX();
      int _plus = (_x + 80);
      int _y = sib.getY();
      int _plus_1 = (_y + 80);
      final Branch branch = cProcess.newBranch(_plus, _plus_1);
      branch.setName("success");
      sib.newBranchConnector(branch);
    }
  }
}
