/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.actions;

import com.google.common.base.Objects;
import info.scce.dime.process.actions.ConvertSIBCustomAction;
import info.scce.dime.process.process.ProcessPlaceholderSIB;
import info.scce.dime.process.process.ProcessSIB;
import info.scce.dime.process.process.ProcessType;
import org.eclipse.xtext.xbase.lib.Functions.Function0;

/**
 * Context menu action, which converts a process sib to
 * a process placeholder sib.
 * 
 * @author neubauer
 */
@SuppressWarnings("all")
public class ConvertToProcessPlaceholderSIB extends ConvertSIBCustomAction<ProcessSIB> {
  /**
   * Returns the name of the context menu entry.
   */
  @Override
  public String getName() {
    return "Convert to placeholder";
  }
  
  /**
   * Guarantees that the Process SIB is not already a placeholder.
   */
  @Override
  public boolean canExecute(final ProcessSIB sib) {
    return ((!Objects.equal(sib.getRootElement().getProcessType(), ProcessType.NATIVE_FRONTEND_SIB_LIBRARY)) && 
      (!(sib instanceof ProcessPlaceholderSIB)));
  }
  
  @Override
  public void execute(final ProcessSIB sib) {
    final info.scce.dime.process.process.Process cProcess = sib.getRootElement();
    final Function0<ProcessPlaceholderSIB> _function = new Function0<ProcessPlaceholderSIB>() {
      @Override
      public ProcessPlaceholderSIB apply() {
        return cProcess.newProcessPlaceholderSIB(sib.getProMod(), sib.getX(), sib.getY());
      }
    };
    this.<ProcessPlaceholderSIB>convertSIB(sib, _function);
  }
}
