/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.actions;

import info.scce.dime.process.actions.ConvertToBlueprintSIB;
import info.scce.dime.process.process.BlueprintSIB;
import info.scce.dime.process.process.ProcessBlueprintSIB;
import info.scce.dime.process.process.ProcessSIB;
import info.scce.dime.process.process.ProcessType;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * Action that converts a Process SIB to a Process Blueprint SIB.
 */
@SuppressWarnings("all")
public class ConvertToProcessBlueprintSIB extends ConvertToBlueprintSIB<ProcessSIB> {
  @Override
  public BlueprintSIB createBlueprintSIB(final ProcessSIB sib) {
    ProcessBlueprintSIB _newProcessBlueprintSIB = sib.getRootElement().newProcessBlueprintSIB(sib.getX(), sib.getY(), sib.getWidth(), sib.getHeight());
    final Procedure1<ProcessBlueprintSIB> _function = new Procedure1<ProcessBlueprintSIB>() {
      @Override
      public void apply(final ProcessBlueprintSIB it) {
        ProcessType _elvis = null;
        info.scce.dime.process.process.Process _proMod = sib.getProMod();
        ProcessType _processType = null;
        if (_proMod!=null) {
          _processType=_proMod.getProcessType();
        }
        if (_processType != null) {
          _elvis = _processType;
        } else {
          _elvis = ProcessType.UNSPECIFIED;
        }
        it.setProcessType(_elvis);
        it.setLabel(sib.getLabel());
        it.setName(sib.getName());
      }
    };
    return ObjectExtensions.<ProcessBlueprintSIB>operator_doubleArrow(_newProcessBlueprintSIB, _function);
  }
}
