/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.actions;

import info.scce.dime.process.actions.ConvertToBlueprintSIB;
import info.scce.dime.process.process.BlueprintSIB;
import info.scce.dime.process.process.GUIBlueprintSIB;
import info.scce.dime.process.process.GUISIB;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * Action that converts a GUI SIB to a GUI Blueprint SIB.
 */
@SuppressWarnings("all")
public class ConvertToGUIBlueprintSIB extends ConvertToBlueprintSIB<GUISIB> {
  @Override
  public BlueprintSIB createBlueprintSIB(final GUISIB sib) {
    GUIBlueprintSIB _newGUIBlueprintSIB = sib.getRootElement().newGUIBlueprintSIB(sib.getX(), sib.getY(), sib.getWidth(), sib.getHeight());
    final Procedure1<GUIBlueprintSIB> _function = new Procedure1<GUIBlueprintSIB>() {
      @Override
      public void apply(final GUIBlueprintSIB it) {
        it.setLabel(sib.getLabel());
        it.setName(sib.getName());
        it.setMajorBranch(sib.getMajorBranch());
        it.setMajorPage(sib.isMajorPage());
        it.setDefaultContent(sib.getDefaultContent());
      }
    };
    return ObjectExtensions.<GUIBlueprintSIB>operator_doubleArrow(_newGUIBlueprintSIB, _function);
  }
}
