/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.process.actions;

import com.google.common.base.Objects;
import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.data.data.Attribute;
import info.scce.dime.data.data.ConcreteType;
import info.scce.dime.data.data.ExtensionAttribute;
import info.scce.dime.process.helper.PortUtils;
import info.scce.dime.process.process.Branch;
import info.scce.dime.process.process.CreateSIB;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.SIB;
import info.scce.dime.process.process.TransientCreateSIB;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.Functions.Function2;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * Context menu action, which adds all attributes of the created type as input
 * ports, so that a "full constructor" can automatically be initialized.
 * 
 * @author naujokat
 */
@SuppressWarnings("all")
public class AllAttributesAsInput<T extends SIB> extends DIMECustomAction<SIB> {
  private final int OFFSET = 30;
  
  /**
   * Returns the name of the context menu entry
   */
  @Override
  public String getName() {
    return "Add All Attributes as Input";
  }
  
  @Override
  public boolean canExecute(final SIB sib) {
    boolean _xblockexpression = false;
    {
      final Function1<Input, String> _function = new Function1<Input, String>() {
        @Override
        public String apply(final Input it) {
          return it.getName();
        }
      };
      final List<String> sibPortNames = ListExtensions.<Input, String>map(sib.getInputs(), _function);
      final ConcreteType type = this.getCreatedType(sib);
      _xblockexpression = (this._gUIExtension.operator_notEquals(type, null) && IterableExtensions.<String>exists(ListExtensions.<Attribute, String>map(this._dataExtension.getInheritedAttributes(type), new Function1<Attribute, String>() {
        @Override
        public String apply(final Attribute it) {
          return it.getName();
        }
      }), new Function1<String, Boolean>() {
        @Override
        public Boolean apply(final String it) {
          boolean _contains = sibPortNames.contains(it);
          return Boolean.valueOf((!_contains));
        }
      }));
    }
    return _xblockexpression;
  }
  
  @Override
  public void execute(final SIB sib) {
    PortUtils.Sync<Input, Attribute> _sync = new PortUtils.Sync<Input, Attribute>();
    final Procedure1<PortUtils.Sync<Input, Attribute>> _function = new Procedure1<PortUtils.Sync<Input, Attribute>>() {
      @Override
      public void apply(final PortUtils.Sync<Input, Attribute> it) {
        final Function2<Input, Attribute, Boolean> _function = new Function2<Input, Attribute, Boolean>() {
          @Override
          public Boolean apply(final Input input, final Attribute attr) {
            String _name = input.getName();
            String _name_1 = attr.getName();
            return Boolean.valueOf(Objects.equal(_name, _name_1));
          }
        };
        it.equals = _function;
        final Procedure1<Attribute> _function_1 = new Procedure1<Attribute>() {
          @Override
          public void apply(final Attribute attr) {
            PortUtils.addInput(sib, attr);
          }
        };
        it.add = _function_1;
      }
    };
    final PortUtils.Sync<Input, Attribute> sync = ObjectExtensions.<PortUtils.Sync<Input, Attribute>>operator_doubleArrow(_sync, _function);
    final Function1<Attribute, Boolean> _function_1 = new Function1<Attribute, Boolean>() {
      @Override
      public Boolean apply(final Attribute it) {
        return Boolean.valueOf((!(it instanceof ExtensionAttribute)));
      }
    };
    sync.apply(sib.getInputs(), IterableExtensions.<Attribute>filter(this._dataExtension.getInheritedAttributes(this.getCreatedType(sib)), _function_1));
    this.layoutBranch(sib);
  }
  
  public void layoutBranch(final SIB sib) {
    int _y = sib.getY();
    int _height = sib.getHeight();
    int _plus = (_y + _height);
    int newY = (_plus + this.OFFSET);
    EList<Branch> _branchSuccessors = sib.getBranchSuccessors();
    for (final Branch branch : _branchSuccessors) {
      branch.moveTo(sib.getRootElement(), branch.getX(), newY);
    }
  }
  
  public ConcreteType getCreatedType(final SIB it) {
    ConcreteType _switchResult = null;
    boolean _matched = false;
    if (it instanceof CreateSIB) {
      _matched=true;
      _switchResult = ((CreateSIB)it).getCreatedType();
    }
    if (!_matched) {
      if (it instanceof TransientCreateSIB) {
        _matched=true;
        _switchResult = ((TransientCreateSIB)it).getCreatedType();
      }
    }
    return _switchResult;
  }
}
