/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.vp;

import de.jabc.cinco.meta.runtime.provider.CincoValuesProvider;
import graphmodel.ModelElement;
import graphmodel.ModelElementContainer;
import graphmodel.internal.InternalNode;
import info.scce.dime.gui.gui.ModalCloseButton;
import info.scce.dime.gui.helper.GUIBranch;
import info.scce.dime.gui.helper.GUIExtension;
import info.scce.dime.gui.helper.GUIExtensionProvider;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class ModalCloseButtonValuesProvider extends CincoValuesProvider<ModalCloseButton, String> {
  @Extension
  private GUIExtension _gUIExtension = GUIExtensionProvider.guiextension();
  
  @Override
  public Map<String, String> getPossibleValues(final ModalCloseButton ib) {
    Map<String, String> _xblockexpression = null;
    {
      EObject _eContainer = ib.eContainer().eContainer().eContainer();
      ModelElement _element = ((InternalNode) _eContainer).getElement();
      final ModelElementContainer container = ((ModelElementContainer) _element);
      final Function1<GUIBranch, String> _function = new Function1<GUIBranch, String>() {
        @Override
        public String apply(final GUIBranch it) {
          return it.getName();
        }
      };
      final Function1<GUIBranch, String> _function_1 = new Function1<GUIBranch, String>() {
        @Override
        public String apply(final GUIBranch it) {
          return it.getName();
        }
      };
      _xblockexpression = IterableExtensions.<GUIBranch, String, String>toMap(this._gUIExtension.getGUIBranchesMerged(container), _function, _function_1);
    }
    return _xblockexpression;
  }
}
