/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.vp;

import de.jabc.cinco.meta.core.referenceregistry.ReferenceRegistry;
import de.jabc.cinco.meta.runtime.provider.CincoValuesProvider;
import info.scce.dime.gui.gui.DropTarget;
import info.scce.dime.gui.gui.Table;
import java.util.Map;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class DropTargetPossibleValuesProvider extends CincoValuesProvider<DropTarget, String> {
  @Override
  public Map<String, String> getPossibleValues(final DropTarget arg0) {
    final Function1<Table, String> _function = new Function1<Table, String>() {
      @Override
      public String apply(final Table it) {
        return it.getId();
      }
    };
    final Function1<Table, String> _function_1 = new Function1<Table, String>() {
      @Override
      public String apply(final Table it) {
        return it.getName();
      }
    };
    return IterableExtensions.<Table, String, String>toMap(ReferenceRegistry.getInstance().<Table>lookup(Table.class), _function, _function_1);
  }
}
