/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.vp;

import graphmodel.Node;
import info.scce.dime.api.DIMEValuesProvider;
import info.scce.dime.data.data.EnumLiteral;
import info.scce.dime.data.data.EnumType;
import info.scce.dime.data.data.Type;
import info.scce.dime.gui.gui.ComplexAttribute;
import info.scce.dime.gui.gui.ComplexVariable;
import info.scce.dime.gui.gui.IS;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class ComplexSubTypePossibleValuesProvider extends DIMEValuesProvider<IS, String> {
  @Override
  public Map<String, String> getPossibleValues(final IS conditionIs) {
    Map<String, String> _xblockexpression = null;
    {
      Type _switchResult = null;
      Node _sourceElement = conditionIs.getSourceElement();
      final Node it = _sourceElement;
      boolean _matched = false;
      if (it instanceof ComplexVariable) {
        _matched=true;
        _switchResult = this._dataExtension.getOriginalType(((ComplexVariable)it).getDataType());
      }
      if (!_matched) {
        if (it instanceof ComplexAttribute) {
          _matched=true;
          _switchResult = this._dataExtension.getOriginalType(((ComplexAttribute)it).getAttribute().getDataType());
        }
      }
      final Type dataType = _switchResult;
      Map<String, String> _xifexpression = null;
      if ((dataType instanceof EnumType)) {
        final Function1<EnumLiteral, String> _function = new Function1<EnumLiteral, String>() {
          @Override
          public String apply(final EnumLiteral it) {
            return it.getId();
          }
        };
        final Function1<EnumLiteral, String> _function_1 = new Function1<EnumLiteral, String>() {
          @Override
          public String apply(final EnumLiteral it) {
            return it.getName();
          }
        };
        _xifexpression = IterableExtensions.<EnumLiteral, String, String>toMap(((EnumType)dataType).getEnumLiterals(), _function, _function_1);
      } else {
        final Function<Type, String> _function_2 = new Function<Type, String>() {
          @Override
          public String apply(final Type it) {
            return it.getId();
          }
        };
        final Function<Type, String> _function_3 = new Function<Type, String>() {
          @Override
          public String apply(final Type it) {
            return it.getName();
          }
        };
        _xifexpression = this._dataExtension.getKnownSubTypes(dataType).<String, String>toMap(_function_2, _function_3);
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
}
